<?php

Class Jwt{

    public static function encode($payload, $key, $algo = 'HS256')
	{
        

        $header = array('typ' => 'Jwt', 'alg' => $algo);
		$segments = array();
		$segments[] = Jwt::urlsafeB64Encode(Jwt::jsonEncode($header));
		$segments[] = Jwt::urlsafeB64Encode(Jwt::jsonEncode($payload));
		$signing_input = implode('.', $segments);
		$signature = Jwt::sign($signing_input, $key, $algo);
		$segments[] = Jwt::urlsafeB64Encode($signature);
		return implode('.', $segments);
    }

    public static function jsonEncode($input)
	{
		$json = json_encode($input);
		if (function_exists('json_last_error') && $errno = json_last_error()) {
			JWT::_handleJsonError($errno);
		} else if ($json === 'null' && $input !== null) {
			throw new DomainException('Null result with non-null input');
		}
		return $json;
	}
    
    public static function sign($msg, $key, $method = 'HS256')
	{
		$methods = array(
			'HS256' => 'sha256',
			'HS384' => 'sha384',
			'HS512' => 'sha512',
		);
		if (empty($methods[$method])) {
			throw new DomainException('Algorithm not supported');
		}
		return hash_hmac($methods[$method], $msg, $key, true);
    }
    
    public static function urlsafeB64Decode($input)
	{
		$remainder = strlen($input) % 4;
		if ($remainder) {
			$padlen = 4 - $remainder;
			$input .= str_repeat('=', $padlen);
		}
		return base64_decode(strtr($input, '-_', '+/'));
    }
    
    public static function urlsafeB64Encode($input)
	{
		return str_replace('=', '', strtr(base64_encode($input), '+/', '-_'));
	}

}