$(document).ready(function() {

	 if (userLevel == 'CC') {
		  getContractArea(getLoneWorkersId) ;
	 } else if(userLevel == 'CA') {
		 getOfficeList(getLoneWorkersId);
	 } else {
		// Do nothing for office.
	 }


	 getAmberAlertData('none', getLoneWorkersId) ;

	 // Get Constract Area via Cost Centre id
	 $(document).on('change','#costCenter',function(){

	   var selectedVal = $(this).val();

	   $('#stepup4').addClass('faded-crumb');
	   $('#stepup4').removeClass('light-blue-crumb');

	   if( selectedVal != 0 )
	   {
			$('#userType').val('costcenter');
			$('#userLevel').text('Cost Centre');
			$('#costcentrename').val( $(this).find(':selected').data('costcentre') );


			$('#officesList').empty();
			$('#officesList').html('<option value="0">Please select Offices</option>');
			$('#officesList').prop('disabled', true);


			getContractArea(selectedVal);
	   }
	   else {
		 $('#contractArea').empty();
		 $('#costcentrename').empty();
		 $('#contractArea').attr('disabled','disabled');
		 $('#contractArea').html('<option value="0">Please select Contract Area</option>');

		 $('#officesList').empty();
		 $('#officesList').attr('disabled','disabled');
		 $('#officesList').html('<option value="0">Please select Office</option>');
	   }
	 });



	  $(document).on('change','#contractArea',function(){
		  $('#stepup3').addClass('faded-crumb');
		  $('#stepup3').removeClass('light-blue-crumb');
		  $('#stepup4').addClass('faded-crumb');
		  $('#stepup4').removeClass('light-blue-crumb');


		  var id = $(this).find(':selected').val();
			setTimeout(function(){
			   if( id != 0 )
				{
				  getOfficeList(id);


				}
				else
				{

				  $('#stepup3').addClass('faded-crumb');
				  $('#stepup3').removeClass('light-blue-crumb');
				  $('#officesList').empty();
				  $('#officesList').html('<option value="0">Please select Offices</option>');
				  $('#officesList').attr('disabled','disabled');

				}
			},1000);
    });

});




// Function to get Contract Area
function getContractArea(id)
{


 $.ajax({
	 url: base_url+'contractarea/getContractArea/'+id,
	 dataType: 'json',
	 type: 'get',
	 beforeSend: function(){
		 $('#contractArea').html('<option value="0">Loading..</option>');
		  $('#contractArea').prop('disabled', true);
	 },
	 success:function(response){
	   $('#contractArea').empty();
	   if( response.status == 0 )
	   {
			$('#contractArea').removeAttr('disabled');
		   var contractAreaAppend = '<option value="0">Please select Contract Area</option>';
		   for( var i=0; i<response.data.length; i++ )
		   {
			   if((response.data[i].LINKNO == $('#checkContractArea').data('contract_area_id')) || (response.data[i].LINKNO == $('#requestedContract').val() )  )
			   {
				 contractAreaAppend += '<option selected data-contractarea="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
				 $('#contractArea').attr('disabled','disabled');
			   }
			   else
			   {
				   contractAreaAppend += '<option data-contractarea="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
			   }

		   }
		   $('#contractArea').html(contractAreaAppend);
		   $('#contractArea').prop('disabled', false);
	   }
	   if( response.status == 1 )
	   {
		 $('#contractArea').attr('disabled','disabled');
		 $('#contractArea').html('<option value="0">No record found</option>');
	   }
	 }
 });
}

// Function to get Office list
function getOfficeList(id)
{
 $.ajax({
	 url: base_url+'office/getOfficeList/'+id,
	 dataType: 'json',
	 type: 'get',
	 beforeSend: function(){
		 $('#officesList').html('<option value="0">Loading..</option>');
		 $('#officesList').prop('disabled', true);
	 },
	 success:function(response){
	   $('#officesList').empty();
	   if( response.status == 0 )
	   {
		  $('#officesList').removeAttr('disabled');
		   var OfficeListAppend = '<option value="0">Please select Office</option>';
		   for( var i=0; i<response.data.length; i++ )
		   {
			  if( (response.data[i].LINKNO == $('#checkOffice').data('office_id')) || (response.data[i].LINKNO == $('#requestedOffice').val() ) )
			  {
				OfficeListAppend += '<option selected data-officename="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
				$('#officesList').attr('disabled','disabled');
			  }
			  else {
				OfficeListAppend += '<option data-officename="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
			  }


		   }
		   $('#officesList').html(OfficeListAppend);
		   $('#officesList').prop('disabled', false);
	   }
	   if( response.status == 1 )
	   {
		 $('#officesList').attr('disabled','disabled');
		 $('#officesList').html('<option value="0">No record found</option>');
	   }
	 }
 });
}

function getAmberAlertData(typeClicked, userLevelId){

	$("#__setTodayData, #__setCalenarData").parent().addClass("__disableWeekCalendarBtn");
	$("#__nextWeek").prop('disabled', true) ;
	$("#__prevWeek").prop('disabled', true) ;
	$("#__setTodayData").prop('disabled', true) ;
	$("#__setCalenarData").prop('disabled', true) ;

	var endDate = $("#__endDate").val() ;
	var clicked = typeClicked ;
	var groupID = userLevelId ;

	var signalType 	   = $("#__signalType").val() ;
	var signalTypeName = $( "#__signalType option:selected" ).text();

	$.ajax({
		  url: base_url + 'systems/getAmberAlertsData' ,
		  type: 'post',
		  dataType: 'json',
		  data: { 'endDate': endDate, 'clicked': clicked, groupID: groupID, signalType: signalType} ,
		  beforeSend:function(){
			  $("#__pageShow").hide() ;
			  $("#_pageload").show() ;
		  },
		  success:function(response){

			  if ( response.error ==  0 ) {

					  $("#__signalTypeSelectedName").text(signalTypeName) ;

					  $("#__setTodayData, #__setCalenarData").parent().removeClass("__disableWeekCalendarBtn");
					  $("#__statshubDataHeading").html(response.headingData);
					  $("#__statshubDataBody").html(response.bodyData);

					  $("#__endDate").val(response.endDate) ;

					  if (response.disableNextWeek == 0) {
						$("#__nextWeek").prop('disabled', false) ;
						$("#__setTodayData").prop('disabled', false) ;
					  } else {
						$("#__nextWeek").prop('disabled', true) ;
						$("#__setTodayData").prop('disabled', true) ;
					  }

					  $("#__prevWeek").prop('disabled', false) ;

					  if ( $(".end-day").text() != "..." ) {
						  $("#__setCalenarData").prop('disabled', false) ;
					  }


					  if ( checkDataTableModal == "notFirstTime" ) {
							$("#__amberAlertsDataTable").dataTable().fnDestroy() ;
					  }

					  checkDataTableModal  = "notFirstTime" ;


					  $("#__amberAlertsDataTableHeading").html(response.headingData) ;
					  $("#__amberAlertsDataTableBody").html(response.bodyData) ;

					  $('#__amberAlertsDataTable').DataTable({
							language: {
							 search: "",
							 searchPlaceholder: "Search" },
							  "aLengthMenu": [[100, 500, 900, -1], [100, 500, 900, "ALL"]],
							  'pageLength': 100,
							  "aaSorting": [],
							  dom: 'Bfrtip',
							  buttons: [
									{
                extend:    'excelHtml5',
                text:      '<i class="fa fa-file-excel-o"></i> <span class="txtExcel">EXPORT AS XLS </span>',
                titleAttr: 'Excel',
                filename: 'Amber_Alert_Utilization',
                title: 'Amber Alert Utilization Report (' + signalTypeName + ')'
            }
							  ]
					  });


					  $("#_pageload").hide() ;
					  $("#__pageShow").show() ;
			}


			if ( response.error ==  1 ) {
				alert(response.msg) ;
			}

		  }, error: function (jqXHR, exception) {
				 $("#__setTodayData, #__setCalenarData").parent().removeClass("__disableWeekCalendarBtn");
			     $(".__Loader").css('display', 'none') ;
			     $("#__nextWeek").prop('disabled', false) ;
				 $("#__prevWeek").prop('disabled', false) ;
				 $("#__setTodayData").prop('disabled', false) ;
				 if ( $(".end-day").text() != "..." ) {
					$("#__setCalenarData").prop('disabled', false) ;
				 }

				alert( "Network error, please try again later.") ;

				//$("#_pageload").hide() ;
		  }
	 });



}
