<?php

Class Twofactorauthentication extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users');
		$this->load->library('sms');
	}


	public function sendSms() {

		if( $this->session->userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}

		$number = $this->input->post('number') ;

		if (!$number) {
			echo json_encode([ 'error' => '1', 'msg' => 'Number is required']);
			exit ;
		}

		if ( $number[0] != "+" ) {
			$number = "+".$number ;
		}

		$otp_code = rand(1000,9999);
		//$otp_code = "1234";

		$msg_id = $this->sms->send_sms($number,$otp_code);
		$msg_report = $this->sms->check_sms_report($msg_id);

		//$msg_report = "Sent" ;

		if ( $msg_report != "Failed" ) {

			$insertOtp  = $this->users->insertTwoFactorOTP($otp_code) ;

			if ( $insertOtp ) {
				echo json_encode([ 'error' => '0', 'msg' => 'Otp send and added to database', 'otp' => $otp_code]);
				exit ;
			} else {
				echo json_encode([ 'error' => '1', 'msg' => 'Some error occured, please try again']);
				exit ;
			}


		} else {
			echo json_encode([ 'error' => '1', 'msg' => 'Please enter a valid number']);
			exit ;
		}



	}


	public function verifyOTP() {

		if( $this->session->userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => '1', 'msg' => 'Unauthorized, please log in again.']);
			exit ;
		}

		$otp 	= $this->input->post('otp') ;
		$number = $this->input->post('number') ;

		if (!$otp || !$number) {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters']);
			exit ;
		}


		if ( $number[0] != "+" ) {
			$number = "+".$number ;
		}

		$verifyOtp = $this->users->verifyTwoFactorOTP($otp) ;

		if ($verifyOtp) {

			$insertData = $this->users->inserVerifiedTwoFactoNumber($number) ;

			if ( $insertData ) {
				echo json_encode([ 'error' => '0', 'msg' => 'OTP has been verified successfully', 'number' => $number]);
				exit ;
			} else {
				echo json_encode([ 'error' => '1', 'msg' => 'Some error occured, please try again']);
				exit ;
			}


		} else {
			echo json_encode([ 'error' => '1', 'msg' => 'Incorrect OTP entered']);
			exit ;
		}

	}

	public function enableDisableTwoFactorAuthentication() {

		if( $this->session->userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => '1', 'msg' => 'Unauthorized, please log in again.']);
			exit ;
		}

		$status 	= $this->input->post('status') ;

		$insertData = $this->users->enableDisableTwoFactorAuthentication($status) ;

		if ( $insertData ) {
			echo json_encode([ 'error' => '0', 'msg' => 'Status updated successfully']);
			exit ;
		} else {
			echo json_encode([ 'error' => '1', 'msg' => 'Some error occured, please try again']);
			exit ;
		}


	}


	public function sendSmsLogin() {

		$number 	= $this->input->post('number') ;
		$userId 	= $this->input->post('userId') ;

		if (!$number || !$userId) {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required fields']);
			exit ;
		}

		if ( $number[0] != "+" ) {
			$number = "+".$number ;
		}

		$otp_code = rand(1000,9999);
		//$otp_code = "4321";

		$msg_id = $this->sms->send_sms_login($number,$otp_code);
		$msg_report = $this->sms->check_sms_report($msg_id);

		//$msg_report = "Sent" ;

		if ( $msg_report != "Failed" ) {

			$insertOtp  = $this->users->insertTwoFactorOTPLogin($otp_code, $userId) ;

			if ( $insertOtp ) {
				echo json_encode([ 'error' => '0', 'msg' => 'Otp send and added to database', 'otp' => $otp_code]);
				exit ;
			} else {
				echo json_encode([ 'error' => '1', 'msg' => 'Some error occured, please try again']);
				exit ;
			}


		} else {
			echo json_encode([ 'error' => '1', 'msg' => 'There is some problem, please contact admin']);
			exit ;
		}



	}


	public function lostEnrolledNumber() {

		$userName = "" ;

		if ( $this->session->has_userdata('setSessionUsernameLostEnrolledNumber') && $this->session->userdata('setSessionUsernameLostEnrolledNumber') != "" ) {

			$userName = $this->session->userdata('setSessionUsernameLostEnrolledNumber') ;

		}

		

		if (!$userName) {
			redirect('/', 'refresh');
			exit ;
		}

		$data['userName'] = $userName ;
		$this->load->view('two_factor_authentication/lost_enrolled_number',$data);

	}



	public function reportUnrecognizedActivity() {
		$this->load->view('two_factor_authentication/report_unrecognized_activity');
	}



	function lostOrUnrecognizedEmail() {

		$type 		= $this->input->post('type') ;
		$arrayType  = ["lost", "unrecognized"] ;
		$msg 		= "" ;


		if (!in_array($type,$arrayType)) {
			echo json_encode([ 'error' => '1', 'msg' => 'Unrecognized Request']);
			exit ;
		}

		$userName = $this->input->post('userName') ;

		//$type 		= "lost" ;
		//$userName	= "ravi1" ;

		$userData  = "" ;

		if ($type == "lost") {
			$userData   = $this->users->lostEnrolledNumberTwoFaUserData($userName) ;
			$msg 		= "Your username do not match. Please retry." ;
		}

		if ($type == "unrecognized") {
			$password  = $this->input->post('password') ;
			$userData  = $this->users->unrecognizedTwoFaUserData($userName, $password) ;
			$msg 	   = "Your email and password do not match. Please retry." ;
		}

		if (!$userData) {
			echo json_encode([ 'error' => '1', 'msg' => $msg ]);
			exit ;
		}


		$getSuperAdminEmail = $this->users->getSuperAdminEmail() ;

		if(!$getSuperAdminEmail){
			$email	 = "jack.singh@orbisprotect.com" ;
		} else {
			$email  = [] ;
			foreach($getSuperAdminEmail as $multipleEmail){
				if ($multipleEmail['email']) {
					$email[] = trim($multipleEmail['email']) ;
				}
			}
		}




		if ($type == "lost") {

			$emailSubject  = "2FA reset request from " . $userName  ;

			$emailMessage  = "Dear Admin,<br><br>The user <b>" . $userName . "</b> has requested to reset the 2FA for his/her sentry account. Please verify the request.<br><br>User details:<br>Username: " . $userName . "<br>Phone number: " . $userData['two_factor_verified_number'] . " (currently enrolled for 2FA)<br><br>You can disable the 2FA for this account using the admin login and then resetting the 2FA from the portal user account settings.<br><br>Thanks." ;

			$msg = "An email to reset your 2FA has been sent to the administrator. You will be contacted shortly to verify this request." ;
		}


		if ($type == "unrecognized") {

			$emailSubject  = "Reporting unrecognized login activity from " . $userName  ;

			$emailMessage  = "Dear Admin,<br><br>The user <b>" . $userName . "</b> has reported unrecognized login activity for his/her account on sentry at ".date("d-F-Y h:i:sa").".  Please contact the user and verify.<br><br>Contact details:<br>Username: " . $userName . "<br>First Name: " . $userData['first_name'] . " <br>Last Name: " . $userData['sur_name'] . "<br>Contact Number: " . $userData['telephone'] . "<br><br>Thanks." ;

			$msg = "Thank you for reporting the unrecognized activity. We will contact you shortly." ;

		}



		$config = Array(
		  'protocol' 	 => 'smtp',
		  'smtp_host'	 => 'smtp.office365.com',
		  'smtp_port' 	 =>  587,
		  'smtp_user'	 => 'orbisreports@orbisprotect.com',
		  'smtp_pass'	 => 'Haqa5302',
		  'smtp_crypto'  => 'tls',
		  'mailtype' 	 => 'html',
		);

	    $this->load->library('email', $config);
	    $this->email->set_newline("\r\n");
	    $this->email->set_crlf( "\r\n" );
	    $this->email->from('orbisreports@orbisprotect.com', 'Orbis');
	    $this->email->to($email);

	    $this->email->subject($emailSubject);
	    $this->email->message($emailMessage);

	    if($this->email->send())
	    {
			echo json_encode([ 'error' => '0', 'msg' => $msg]);
			exit ;
		}
	    else
	    {
		    echo json_encode([ 'error' => '1', 'msg' => 'Problem in sending email']);
			exit ;
	    }

	}


	public function setSessionUsernameLostEnrolledNumber() {

		$userName = $this->input->post('user_email') ;

		if ( !$userName ) {
			echo json_encode([ 'error' => '1', 'msg' => 'There is some problem, please try again later']);
			exit ;
		}

		session_start();
		$setSessionData = $this->session->set_userdata('setSessionUsernameLostEnrolledNumber',$userName);
		session_write_close();


		if ( $this->session->has_userdata('setSessionUsernameLostEnrolledNumber') && $this->session->userdata('setSessionUsernameLostEnrolledNumber') != "" ) {
			echo json_encode([ 'error' => '0', 'msg' => 'Success']);
			exit ;
		} else {
			echo json_encode([ 'error' => '1', 'msg' => 'There is some problem, please try again later']);
			exit ;
		}

	}


}
