$(document).ready(function() {

	 getReports() ;  // to get the listing of reports at page load

	 if (userLevel == 'CC') {
		  getContractArea(getLoneWorkersId, 'no') ;
	 } else if(userLevel == 'CA') {
		 getOfficeList(getLoneWorkersId, 'no');
	 } else {
		// Do nothing for office.
	 }

	
	
	$(document).on('change','#contractArea',function(){
		  $('#stepup3').addClass('faded-crumb');
		  $('#stepup3').removeClass('light-blue-crumb');
		  $('#stepup4').addClass('faded-crumb');
		  $('#stepup4').removeClass('light-blue-crumb');


		  var id = $(this).find(':selected').val();
			setTimeout(function(){
			   if( id != 0 )
				{
				  getOfficeList(id, 'no');


				}
				else
				{

				  $('#stepup3').addClass('faded-crumb');
				  $('#stepup3').removeClass('light-blue-crumb');
				  $('#officesList').empty();
				  $('#officesList').html('<option value="0">Please select Offices</option>');
				  $('#officesList').attr('disabled','disabled');

				}
			},1000);
    });


	  // Functionality on the click of add button
	  
	  $(document).on("click", "#__addButtonAutoReporting", function() {
		  
			var selectedFrequency       =   $('input:radio[name="reportingFrequency"]:checked').val() ;
			var selectedReportName   	=   $('select#__reportsSelect').val() ;
			var multiple_email_cc		=   $('input[name="email_cc"]').val() ;
			var checkEmailError			=   false;
			
			
			if ( !selectedReportName || selectedReportName == "0" ) {
					$('select#__reportsSelect').addClass("errorSelect") ;
					return false ;
			} else {
					$('select#__reportsSelect').removeClass("errorSelect") ;
			}
			
			if (multiple_email_cc) {	
				
				var splitMultipleEmails = multiple_email_cc.split(",") ;
				
				for (var i =0; i<splitMultipleEmails.length; i++) {
				
					if ( !isEmail(splitMultipleEmails[i]) ) {
						
						checkEmailError = true ;
					}
				}
			} 
			
			if (checkEmailError) {
				$('input[name="email_cc"]').addClass("errorSelect") ;
				$('.__validEmailErrorText').show() ;
				return false ;
			} else {
				$('input[name="email_cc"]').removeClass("errorSelect") ;
				$('.__validEmailErrorText').hide() ;
			}
			
			if ( $("#officesList").val() != '0') {
				var linkaccountnumber 	 =  $("#officesList").val() ;
				var userType 			 =  "OF";
				var linkaccountname		 =  $('#officesList option:selected').text() ;
				var linkaccountparent    =  $("#contractArea").val() + ',' + $("#costCenter").val() ; // both cost center and contract area values are saved
				var linkaccountparentName    =  $("#contractArea option:selected").text() + ',' + $("#costCenter option:selected").text() ; 
			} else if ($("#contractArea").val() != '0') {
				var linkaccountnumber	 = $("#contractArea").val() ;
				var userType 			 = "CA";
				var linkaccountname		 =  $('#contractArea option:selected').text() ;
				var linkaccountparent    =  $("#costCenter").val() ;
				var linkaccountparentName    = $("#costCenter option:selected").text() ; 
			} else {
				var linkaccountnumber 	 = $("#costCenter").val() ;
				var userType 			 = "CC";
				var linkaccountname		 =  $('#costCenter option:selected').text() ;
				var linkaccountparent    =  "" ;
				var linkaccountparentName    =  "" ;
			}
			
			var signalType = '' ;
			
			if ( selectedReportName == "amber_alert_utilisation_report") {
				signalType = $('#__signalType').val()  ;
			}
			
			$.ajax({
			  url: base_url + 'autoreporting/addReports' ,
			  type: 'post',
			  dataType: 'json',
			  data: { selectedFrequency: selectedFrequency, selectedReportName: selectedReportName, linkaccountnumber: linkaccountnumber, userType: userType, signalType: signalType, user_level: userLevel, user_level_id: getLoneWorkersId, linkaccountname: linkaccountname, linkaccountparent: linkaccountparent, linkaccountparentName: linkaccountparentName, multiple_email_cc: multiple_email_cc  } ,
			  beforeSend:function(){
				  $("#__addButtonAutoReporting").prop('disabled', true);
				  $("#__addButtonAutoReporting").text('Adding...');
			  },
			  success:function(response){
				  
				 if ( response.error == "0") {
				 
					$("#ConfigureModal").modal('hide') ;
				    $("#__addButtonAutoReporting").prop('disabled', false);
				    $("#__addButtonAutoReporting").text('Add');
				    
				    getReports() ; // Called to get the latest record.
					
					swal({
					  
					   title: "Success",
					   text: response.message,
					   icon: "success",
					   button: "Ok"
					  
					}) ;
				 
				 }
				 
				 
				 if ( response.error == "1") {
				 
				   $("#__addButtonAutoReporting").prop('disabled', false);
				   $("#__addButtonAutoReporting").text('Add');
				 
					swal({
					  
					   title: "Error",
					   text: response.message,
					   icon: "warning",
					   button: "Ok"
					  
					}) ;
				 
				 }
				 
				 
				  
			  }, error: function (jqXHR, exception) {
				  swal({
					   
					   title: "Error",
					   text: "Network error, please try again later.",
					   icon: "warning",
					   button: "Ok"
					  
				  }) ;
			  }
		 });
		
	});
	
	// Functionality on the click of add button
	
	
	
	// Functionality on the change of select for report name 
	
	$(document).on("change", "select#__reportsSelect", function() {
	
		var selectedReportName   	=   $(this).val() ;
	
		if ( !selectedReportName || selectedReportName == "0" ) {
			$("#__addButtonAutoReporting").prop('disabled', true);
			$("#__signalTypeLi").hide() ;
		} else {
			$("#__addButtonAutoReporting").prop('disabled', false); 
			
			if ( selectedReportName == "amber_alert_utilisation_report") {
				//$('#__signalType').val('0');
				$("#__signalTypeLi").show() ;
			} else {
				$("#__signalTypeLi").hide() ;
			}	
		}
	
	}) ;
	
	
	// Functionality on the change of select for report name 
	
	
	// Functionality to open modal when add new is clicked
	
	$(document).on("click", "#__openAddModal", function() {
		  
		   /*if (userLevel == 'CC') {
				getContractArea(getLoneWorkersId) ;
		   } else if(userLevel == 'CA') {
				getOfficeList(getLoneWorkersId);
		   } else {
				// Do nothing for office.
		   }*/
		   
		   
		   $("#__reportsSelect").val('0') ;
		   $('select#__reportsSelect').removeClass("errorSelect") ;
		   
		   $('#__signalType').val('amber_alert_start'); 
		   $('#__signalType').trigger('change');
		   $("#__signalTypeLi").hide() ; 
		   
		   $('input:radio[name="reportingFrequency"][value="daily"]').prop('checked', true);
		   
		   
		   $("#__addButtonAutoReporting").prop('disabled', true);
		   $("#__addButtonAutoReporting").text('Add');
		   $("#__editButtonAutoReporting").hide();
		   $("#__addButtonAutoReporting").show();
		   
		   
		   $('input[name="email_cc"]').val('');
		   $('input[name="email_cc"]').removeClass("errorSelect") ;
		   $('.__validEmailErrorText').hide() ;
		   
		   
		   
		   $("#ConfigureModal").modal('show') ;
	});
	// Functionality to open modal when add new is clicked
	
	
	// Functionality on click of delete button
	
	$(document).on("click", ".__deleteAutoReport", function() {
		
		var reportId  = $(this).data('reportid') ;
		
		swal({
			 title: 'Are you sure ?',
			 text: 'You want to delete this report',
			 icon: base_url + "/img/exclamation-mark-move.png",
			 buttons: true,
			 dangerMode: true,
			 //~ closeOnEsc : false,
			 closeOnClickOutside: false
		  }).then(function(result) {
			   if (result) {
					$.ajax({
						  url: base_url + 'autoreporting/deleteSingleReport' ,
						  type: 'post',
						  dataType: 'json',
						  data: { reportId: reportId } ,
						  beforeSend:function(){
								// Fade the grid
						  },
						  success:function(response){
							  
							 if ( response.error == "0") {
							 
								getReports() ; // Called to get the latest record.
								
								swal({
								  
								   title: "Success",
								   text: response.message,
								   icon: "success",
								   button: "Ok"
								  
								}) ;
							 
							 }
							 
							 
							 if ( response.error == "1") {
							 
								swal({
								  
								   title: "Error",
								   text: response.message,
								   icon: "warning",
								   button: "Ok"
								  
								}) ;
							 
							 }
							 
						  }, error: function (jqXHR, exception) {
							  swal({
								   
								   title: "Error",
								   text: "Network error, please try again later.",
								   icon: "warning",
								   button: "Ok"
								  
							  }) ;
						  }
				 });
		
              } else {
				  // if cancel clicked do nothing
              }
		  })
		
		
	});
	
	
	// Functionality on click of delete button
	
	
	// Functionality on click of update button to open modal and set the inserted values
	
	
	$(document).on('click', ".__updateReportData", function() {
		
		var report_link_account_number = $(this).closest('tr').data('number') ;
		var report_link_account_type   = $(this).closest('tr').data('type') ;
		var selected_frequency		   = $(this).closest('tr').data('frequency') ;
		var signal_type                = $(this).closest('tr').data('signaltype') ;
		var selected_report_name       = $(this).closest('tr').data('reportname') ;
		var reportIdForUpdate      	   = $(this).closest('tr').data('reportid') ;
		var report_link_account_parent = $(this).closest('tr').data('linkaccountparent') ;
		var multiple_email_cc 		   = $(this).closest('tr').data('multiplemailcc') ;
		
		
		$('input[name="email_cc"]').val(multiple_email_cc);
		$('input[name="email_cc"]').removeClass("errorSelect") ;
		$('.__validEmailErrorText').hide() ;
		
		$("#__reportIdForUpdate").val(reportIdForUpdate) ;
		
		
	   $("#__reportsSelect").val(selected_report_name) ;
	   $('select#__reportsSelect').removeClass("errorSelect") ;
	   
	   
	   if ( selected_report_name == "amber_alert_utilisation_report") {
		   
		    $('#__signalType').val(signal_type); 
			$('#__signalType').trigger('change'); 
		    $("#__signalTypeLi").show() ;
			   
	   } else {
		   $('#__signalType').val('amber_alert_start'); 
		   $('#__signalType').trigger('change'); 
		   $("#__signalTypeLi").hide() ;
	   }
	   
	   $('input:radio[name="reportingFrequency"][value="'+selected_frequency+'"]').prop('checked', true);
	   
	    $("#__addButtonAutoReporting").hide();
	    $("#__editButtonAutoReporting").prop('disabled', false);
		$("#__editButtonAutoReporting").show();
		$("#__editButtonAutoReporting").text('Update');
		
		
		
		if (report_link_account_type == 'CC') {
				getContractArea(report_link_account_number, 'no') ;
				
				// Disable the office list drop down if the value is set previously
				
				$('#officesList').attr('disabled','disabled');
				$('#officesList').html('<option value="0">Please select Contract Area</option>');
				
				
		} else if(report_link_account_type == 'CA') {
				getContractArea(report_link_account_parent, report_link_account_number) ;
				getOfficeList(report_link_account_number, 'no');
		} else if(report_link_account_type == 'OF') {
			
			/*IF office we have to explode the report_link_account_parent as we saving the value of ofice's CA and CC in the hierarchy*/
			
			var strArray = report_link_account_parent.split(",");
			
	       // strArray[0]) for CA and strArray[1] for CC
	       
		   getContractArea(strArray[1], strArray[0]) ;
		   getOfficeList(strArray[0], report_link_account_number);
		   
		}
		
		
		
		
		$("#ConfigureModal").modal('show') ;
		
		
	});
	
	// Functionality on click of update button to open modal and set the inserted values
	
	
	
	// Functionality on click of update button to update report
	  
	  $(document).on("click", "#__editButtonAutoReporting", function() {
		  
			var reportId				=   $("#__reportIdForUpdate").val() ;
		  
			var selectedFrequency       =   $('input:radio[name="reportingFrequency"]:checked').val() ;
			var selectedReportName   	=   $('select#__reportsSelect').val() ;
			var multiple_email_cc		=   $('input[name="email_cc"]').val() ;
			var checkEmailError			=   false;
			
			if ( !selectedReportName || selectedReportName == "0" ) {
					$('select#__reportsSelect').addClass("errorSelect") ;
					return false ;
			} else {
					$('select#__reportsSelect').removeClass("errorSelect") ;
			}
			
			
			if (multiple_email_cc) {	
				
				var splitMultipleEmails = multiple_email_cc.split(",") ;
				
				for (var i =0; i<splitMultipleEmails.length; i++) {
				
					if ( !isEmail(splitMultipleEmails[i]) ) {
						
						checkEmailError = true ;
					}
				}
			} 
			
			if (checkEmailError) {
				$('input[name="email_cc"]').addClass("errorSelect") ;
				$('.__validEmailErrorText').show() ;
				return false ;
			} else {
				$('input[name="email_cc"]').removeClass("errorSelect") ;
				$('.__validEmailErrorText').hide() ;
			}
			
			
			
			if ( $("#officesList").val() != '0') {
				var linkaccountnumber 	 =  $("#officesList").val() ;
				var userType 			 =  "OF";
				var linkaccountname		 =  $('#officesList option:selected').text() ;
				var linkaccountparent    =  $("#contractArea").val() + ',' + $("#costCenter").val() ; // both cost center and contract area values are saved
				var linkaccountparentName    =  $("#contractArea option:selected").text() + ',' + $("#costCenter option:selected").text() ;
			} else if ($("#contractArea").val() != '0') {
				var linkaccountnumber	 = $("#contractArea").val() ;
				var userType 			 = "CA";
				var linkaccountname		 =  $('#contractArea option:selected').text() ;
				var linkaccountparent    =  $("#costCenter").val() ;
				var linkaccountparentName    = $("#costCenter option:selected").text() ; 
			} else {
				var linkaccountnumber 	 = $("#costCenter").val() ;
				var userType 			 = "CC";
				var linkaccountname		 =  $('#costCenter option:selected').text() ;
				var linkaccountparent    =  "" ;
				var linkaccountparentName    =  "" ;
			}
			
			var signalType = '' ;
			
			if ( selectedReportName == "amber_alert_utilisation_report") {
				signalType = $('#__signalType').val()  ;
			}
			
			$.ajax({
			  url: base_url + 'autoreporting/updateReports' ,
			  type: 'post',
			  dataType: 'json',
			  data: { selectedFrequency: selectedFrequency, selectedReportName: selectedReportName, linkaccountnumber: linkaccountnumber, userType: userType, signalType: signalType, user_level: userLevel, user_level_id: getLoneWorkersId, linkaccountname: linkaccountname, reportId: reportId, linkaccountparent: linkaccountparent, linkaccountparentName: linkaccountparentName, multiple_email_cc: multiple_email_cc } ,
			  beforeSend:function(){
				  $("#__editButtonAutoReporting").prop('disabled', true);
				  $("#__editButtonAutoReporting").text('Updating...');
			  },
			  success:function(response){
				  
				 if ( response.error == "0") {
				 
					//$("#ConfigureModal").modal('hide') ;
				    $("#__editButtonAutoReporting").prop('disabled', false);
				    $("#__editButtonAutoReporting").text('Update');
				    
				    getReports() ; // Called to get the latest record.
					
					swal({
					  
					   title: "Success",
					   text: response.message,
					   icon: "success",
					   button: "Ok"
					  
					}) ;
				 
				 }
				 
				 
				 if ( response.error == "1") {
				 
				   $("#__editButtonAutoReporting").prop('disabled', false);
				   $("#__editButtonAutoReporting").text('Update');
				 
					swal({
					  
					   title: "Error",
					   text: response.message,
					   icon: "warning",
					   button: "Ok"
					  
					}) ;
				 
				 }
				 
				 
				  
			  }, error: function (jqXHR, exception) {
				  swal({
					   
					   title: "Error",
					   text: "Network error, please try again later.",
					   icon: "warning",
					   button: "Ok"
					  
				  }) ;
			  }
		 });
		
	});
	
	// Functionality on click of update button to update report
	
	
	
	
}); // document ready ends




// Function to get Contract Area
function getContractArea(id, makepreselected)
{


 $.ajax({
	 url: base_url+'contractarea/getContractArea/'+id,
	 dataType: 'json',
	 type: 'get',
	 beforeSend: function(){
		 $('#contractArea').attr('disabled','disabled') ;
		 $('#contractArea').html('<option value="0">Loading..</option>');
	 },
	 success:function(response){
	   $('#contractArea').empty();
	   if( response.status == 0 )
	   {
			$('#contractArea').removeAttr('disabled');
		   var contractAreaAppend = '<option value="0">Please select Contract Area</option>';
		   for( var i=0; i<response.data.length; i++ )
		   {
			   if((response.data[i].LINKNO == $('#checkContractArea').data('contract_area_id')) || (response.data[i].LINKNO == $('#requestedContract').val() )  )
			   {
				 contractAreaAppend += '<option selected data-contractarea="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
				 $('#contractArea').attr('disabled','disabled');
			   }
			   else
			   {
				   
				   var preSelected = "";
			   
				   if ( makepreselected != "no" ) {
				   
					   if (response.data[i].LINKNO == makepreselected) {
							preSelected = "selected" ;
					   }
				   }
				   
				   
				   contractAreaAppend += '<option ' + preSelected + ' data-contractarea="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
			   }

		   }
		   $('#contractArea').html(contractAreaAppend);
	   }
	   if( response.status == 1 )
	   {
		 $('#contractArea').attr('disabled','disabled');
		 $('#contractArea').html('<option value="0">No record found</option>');
	   }
	 }
 });
}

// Function to get Office list
function getOfficeList(id, makepreselected)
{
 $.ajax({
	 url: base_url+'office/getOfficeList/'+id,
	 dataType: 'json',
	 type: 'get',
	 beforeSend: function(){
		 $('#officesList').attr('disabled','disabled');
		 $('#officesList').html('<option value="0">Loading..</option>');
	 },
	 success:function(response){
	   $('#officesList').empty();
	   if( response.status == 0 )
	   {
		  
		   var OfficeListAppend = '<option value="0">Please select Office</option>';
		   for( var i=0; i<response.data.length; i++ )
		   {
			  if( (response.data[i].LINKNO == $('#checkOffice').data('office_id')) || (response.data[i].LINKNO == $('#requestedOffice').val() ) )
			  {
				OfficeListAppend += '<option selected data-officename="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
				$('#officesList').attr('disabled','disabled');
			  }
			  else {
				  
			   var preSelected = "";
			   
			   if ( makepreselected != "no" ) {
			   
				   if (response.data[i].LINKNO == makepreselected) {
						preSelected = "selected" ;
				   }
			   }
				  
				OfficeListAppend += '<option ' + preSelected + ' data-officename="'+response.data[i].NAME+'" value="'+response.data[i].LINKNO+'">'+response.data[i].NAME+'</option>';
			  }


		   }
		   $('#officesList').html(OfficeListAppend);
		   $('#officesList').removeAttr('disabled');
	   }
	   if( response.status == 1 )
	   {
		 $('#officesList').attr('disabled','disabled');
		 $('#officesList').html('<option value="0">No record found</option>');
	   }
	 }
 });
}


//To get the logged in user auto reports when page loads.

function getReports() {
	
	$.ajax({
			  url: base_url + 'autoreporting/reportListing' ,
			  type: 'post',
			  dataType: 'json',
			  beforeSend:function(){
				 $("#__listingReportTableBody").html('<tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr><tr class="_empty_Row"><td style="width:10%;"><span class="skeleton-box"></span></td><td style="width:80%;"><span class="skeleton-box"></span> </td> <td style="width:80%;"><span class="skeleton-box"></span> </td><td class="__reportDeltd"><span class="skeleton-box"></span></td></tr>') ;
	
			  },
			  success:function(response){
				  
				  $("#__listingReportTableBody").html('') ;
				  
				  if ( checkDataTableLoaded == "notFirstTime" ) {
							$("#datatable").dataTable().fnDestroy() ;
				  }

				  checkDataTableLoaded  = "notFirstTime" ;
				  
				  var tableBodyHtml = '' ;
				  
				  if ( response.dataStatus == '1' ) {
					  
					  for( var i=0; i<response.data.length; i++ ){
						  
						  var reportName   = response.data[i].selected_report_name ;
						  var searchRegExp = /\_/g;
						  var replaceWith  = ' ';
						  reportName       = reportName.replace(searchRegExp, replaceWith);
						  
						  
						   if ( response.data[i].selected_frequency == "biWeekly" ) {
							  reportName       += ' (biweekly)' ;
						  } else {
							reportName       += ' (' + response.data[i].selected_frequency + ')' ;
						  }
						  
						  
						 if (response.data[i].report_link_account_parent_name) {
						  
							  if ( response.data[i].report_link_account_type == "OF" ) {
								  
								  var splitParent  =  response.data[i].report_link_account_parent_name.split(",") ;
								  var reportLinkAcoountParentName   = '<br />' + splitParent[1] +' > '+  splitParent[0] +' > ' + response.data[i].report_link_account_name ;
								  
							  } else if( response.data[i].report_link_account_type == "CA" ) {
								  
								  var reportLinkAcoountParentName   = '<br />' + response.data[i].report_link_account_parent_name +' > '+ response.data[i].report_link_account_name ;
								  
							  } else {
								var reportLinkAcoountParentName     = '<br />' + response.data[i].report_link_account_name ;
							  }
						 } else {
								if(response.data[i].report_link_account_type == "CC") {
									var reportLinkAcoountParentName     = '<br />' + response.data[i].report_link_account_name ;
								} else {
									var reportLinkAcoountParentName     = "" ;
								}
						 }
						  
						  
						  tableBodyHtml += '<tr data-number = "'+response.data[i].report_link_account_number+'" data-type = "'+response.data[i].report_link_account_type+'" data-frequency = "'+response.data[i].selected_frequency+'" data-signaltype = "'+response.data[i].signal_type	+'" data-reportname = "'+response.data[i].selected_report_name	+'" data-reportid = "'+response.data[i].id	+'" data-linkaccountparent = "'+response.data[i].report_link_account_parent	+'" data-multiplemailcc = "'+response.data[i].multiple_email_cc+'"><td style="width:10%;vertical-align: top!important" class="sorting_1">' +  ( i + 1 ) + '</td><td style="width:60%;"><span class="reportName">' + reportName + reportLinkAcoountParentName + '</span><span class="report_click getMoreDetails __updateReportData">Click to View/Edit Report</span></td><td>'+response.data[i].created_at+'</td><td class="__reportDeltd"><a href="javascript:void(0);" data-reportid = "'+response.data[i].id+'" class = "__deleteAutoReport"><i class="fa fa-trash" aria-hidden="true"></i></a></td></tr>' ;
						  
					  }
					  
				  }
				$("#__listingReportTableBody").html(tableBodyHtml) ;
				
				var tableDataTableInitialise =  $('#datatable').DataTable({
									  language: {
									   search: "",
									   searchPlaceholder: "Search" },
									   'pageLength': 30,
									   "aaSorting": [],
										'columnDefs': [ {
											'targets': [2], // column index (start from 0)
											'orderable': false, // set orderable false for selected columns
										}]

								});
			  }, error: function (jqXHR, exception) {
				  swal({
					   
					   title: "Error",
					   text: "Network error, please try again later.",
					   icon: "warning",
					   button: "Ok"
					  
				  }) ;
			  }
		 });

}


//Email validation check

function isEmail(email) {
  var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  return regex.test(email);
}



