<?php

Class Reporting extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('autoreport');
		$this->load->library('excel');
	}

	public function auto_reporting()
	{

		if(  $this->session->userdata('auto_reporting_read') !='1' ){
			redirect('/', 'refresh');
			 exit;
		}

		$this->load->view('system/auto_reporting');
	}


	public function addReports() {

		$selectedFrequency    	= $this->input->post('selectedFrequency') ;
		$selectedReportName   	= $this->input->post('selectedReportName') ;
		$linkaccountnumber    	= $this->input->post('linkaccountnumber') ;
		$userType    		  	= $this->input->post('userType') ;
		$linkaccountname      	= $this->input->post('linkaccountname') ;
		$linkaccountparent    	= $this->input->post('linkaccountparent') ;
		$linkaccountparentName 	= $this->input->post('linkaccountparentName') ;
		$multiple_email_cc    	= $this->input->post('multiple_email_cc') ;
		$signalType    		  	= $this->input->post('signalType') ;
		$userLevel    		  	= $this->input->post('user_level') ;
		$userLevelId    	  	= $this->input->post('user_level_id') ;


		$loggedInUserEmail = ( $this->session->has_userdata('login_email') ?  $this->session->userdata('login_email') : '' ) ;
		$userId 		   = ( $this->session->has_userdata('user_id') ?  $this->session->userdata('user_id') : '' ) ;


		if( $selectedFrequency && $selectedReportName && $linkaccountnumber && $userType && $loggedInUserEmail &&  $userId && $userLevel ){

			if ( $selectedReportName == "amber_alert_utilisation_report" ) {

				if ( !$signalType ) {

					echo json_encode(['error' => 1, 'message' => 'Missing required field signal Type']) ;
					exit ;
				}

			}

			$reportId = "" ;

			$validateSameDataAlreadyExists = $this->autoreport->validateSameDataAlreadyExists($selectedFrequency, $selectedReportName, $userType, $linkaccountparent, $userId, $linkaccountnumber, $signalType, $reportId ) ;


			if ( $validateSameDataAlreadyExists ) {
				echo json_encode(['error' => 1, 'message' => 'Selected frequency, report and hierarchy already exists']) ;
				exit ;
			}


			//Set the cron
			if ( $selectedFrequency == "daily" ) {
				$cron = "0-20 23 * * *" ;
			} elseif( $selectedFrequency == "weekly" ) {
				$cron = "0-20 23 * * 5" ;
			} elseif( $selectedFrequency == "biWeekly" ) {
				$cron = "0-20 23 15,30 * *	" ;
			} elseif( $selectedFrequency == "monthly" ) {
				$cron = "0-20 23 30 * * " ;
			} else {
				echo json_encode(['error' => 1, 'message' => 'Missing required field selected Frequency']) ;
				exit ;
			}

			//Prepare the array data to send to modal

			$data['user_id'] 					 		= $userId ;
			$data['user_email'] 				 		= $loggedInUserEmail ;
			$data['cron'] 						 		= $cron ;
			$data['selected_frequency'] 		 		= $selectedFrequency ;
			$data['selected_report_name'] 				= $selectedReportName ;
			$data['report_link_account_number']			= $linkaccountnumber ;
			$data['report_link_account_type'] 			= $userType ;
			$data['report_link_account_name'] 	 		= $linkaccountname ;
			$data['report_link_account_parent']  		= $linkaccountparent ;
			$data['report_link_account_parent_name']  	= $linkaccountparentName ;
			$data['multiple_email_cc']  				= $multiple_email_cc ;
			$data['signal_type'] 					 	= $signalType ;
			$data['user_level'] 			     		= $userLevel ;
			$data['user_level_id'] 			     		= $userLevelId ;
			$data['username'] 			    	 		= $this->session->userdata('login_name') ;

			$insertData = $this->autoreport->insertAutoReportingData($data) ;

			if ( $insertData ) {

				$this->load->library('logger');
				$logMessage = 'Auto reporting, '.str_replace("_"," ",$data['selected_report_name']).'('.$data['selected_frequency'].') has been added';
				$this->logger->trigger_log($this->session->userdata('username'),$logMessage);

				echo json_encode(['error' => 0, 'message' => 'Report added successfully']) ;
			} else {
				echo json_encode(['error' => 1, 'message' => 'Database error']) ;
			}

		} else {

			echo json_encode(['error' => 1, 'message' => 'Missing required fields']) ;

		}
	}


	public function reportListing() {

		$userId     = ( $this->session->has_userdata('user_id') ?  $this->session->userdata('user_id') : '' ) ;

		if ($userId) {

			$getReports = $this->autoreport->getReports($userId) ;

			if ( $getReports ) {

				for( $i=0; $i<count($getReports); $i++ ){
					$getReports[$i]['created_at'] = date('d F y H:i:s', strtotime($getReports[$i]['created_at']));
				}

				echo json_encode(['dataStatus' => 1, 'message' => 'Data found', 'data' => $getReports]) ;

			} else {
				echo json_encode(['dataStatus' => 0, 'message' => 'No data found']) ;
			}

		} else {
			echo json_encode(['dataStatus' => 0, 'message' => 'No user found']) ;
		}

	}


	public function deleteSingleReport() {


		$reportId = $this->input->post('reportId') ;

		if ( $reportId ) {

			$getReportName = $this->autoreport->getSingleReportData($reportId) ;

			$deleteSingleReport = $this->autoreport->deleteSingleReport($reportId) ;

			if ($deleteSingleReport) {



				$this->load->library('logger');
				$logMessage = 'Auto reporting, '.str_replace("_"," ",$getReportName['selected_report_name']).'('.$getReportName['selected_frequency'].') has been deleted';
				$this->logger->trigger_log($this->session->userdata('username'),$logMessage);
				echo json_encode(['error' => 0, 'message' => 'Report deleted successfully']) ;
			} else {
				echo json_encode(['error' => 1, 'message' => 'Database error']) ;
			}

		} else {
			echo json_encode(['error' => 1, 'message' => 'Missing required fields']) ;
		}


	}


	public function updateReports() {

		$selectedFrequency   	= $this->input->post('selectedFrequency') ;
		$selectedReportName   	= $this->input->post('selectedReportName') ;
		$linkaccountnumber   	= $this->input->post('linkaccountnumber') ;
		$userType    		 	= $this->input->post('userType') ;
		$linkaccountname      	= $this->input->post('linkaccountname') ;
		$linkaccountparent   	= $this->input->post('linkaccountparent') ;
		$linkaccountparentName 	= $this->input->post('linkaccountparentName') ;
		$multiple_email_cc    	= $this->input->post('multiple_email_cc') ;
		$signalType    		  	= $this->input->post('signalType') ;
		$userLevel    		  	= $this->input->post('user_level') ;
		$userLevelId    	  	= $this->input->post('user_level_id') ;
		$reportId    	  	  	= $this->input->post('reportId') ;


		$loggedInUserEmail = ( $this->session->has_userdata('login_email') ?  $this->session->userdata('login_email') : '' ) ;
		$userId 		   = ( $this->session->has_userdata('user_id') ?  $this->session->userdata('user_id') : '' ) ;


		if( $selectedFrequency && $selectedReportName && $linkaccountnumber && $userType && $loggedInUserEmail &&  $userId && $userLevel && $reportId){

			if ( $selectedReportName == "amber_alert_utilisation_report" ) {

				if ( !$signalType ) {

					echo json_encode(['error' => 1, 'message' => 'Missing required field signal Type']) ;
					exit ;
				}

			}


			$validateSameDataAlreadyExists = $this->autoreport->validateSameDataAlreadyExists($selectedFrequency, $selectedReportName, $userType, $linkaccountparent, $userId, $linkaccountnumber, $signalType, $reportId) ;


			if ( $validateSameDataAlreadyExists ) {
				echo json_encode(['error' => 1, 'message' => 'Selected frequency, report and hierarchy already exists']) ;
				exit ;
			}



			//Set the cron
			if ( $selectedFrequency == "daily" ) {
				$cron = "0-20 23 * * *" ;
			} elseif( $selectedFrequency == "weekly" ) {
				$cron = "0-20 23 * * 5" ;
			} elseif( $selectedFrequency == "biWeekly" ) {
				$cron = "0-20 23 15,30 * *	" ;
			} elseif( $selectedFrequency == "monthly" ) {
				$cron = "0-20 23 30 * * " ;
			} else {
				echo json_encode(['error' => 1, 'message' => 'Missing required field selected Frequency']) ;
				exit ;
			}

			//Prepare the array data to send to modal

			$data['user_id'] 							= $userId ;
			$data['user_email'] 				 		= $loggedInUserEmail ;
			$data['cron'] 						 		= $cron ;
			$data['selected_frequency'] 		 		= $selectedFrequency ;
			$data['selected_report_name'] 		 		= $selectedReportName ;
			$data['report_link_account_number']	 		= $linkaccountnumber ;
			$data['report_link_account_type'] 	 		= $userType ;
			$data['report_link_account_name'] 	 		= $linkaccountname ;
			$data['report_link_account_parent'] 		= $linkaccountparent ;
			$data['report_link_account_parent_name']  	= $linkaccountparentName ;
			$data['multiple_email_cc']  				= $multiple_email_cc ;
			$data['signal_type'] 				 		= $signalType ;
			$data['user_level'] 			     		= $userLevel ;
			$data['user_level_id'] 			    		= $userLevelId ;
			$data['username'] 			    	 		= $this->session->userdata('login_name') ;

			$updateData = $this->autoreport->updateAutoReportingData($data, $reportId) ;

			if ( $updateData ) {
				$this->load->library('logger');
				$logMessage = 'Auto reporting, '.str_replace("_"," ",$selectedReportName).'('.$selectedFrequency.') updated';
				$this->logger->trigger_log($this->session->userdata('username'),$logMessage);
				echo json_encode(['error' => 0, 'message' => 'Report updated successfully']) ;
			} else {
				echo json_encode(['error' => 1, 'message' => 'Database error']) ;
			}

		} else {

			echo json_encode(['error' => 1, 'message' => 'Missing required fields']) ;

		}
	}



	public function getReportFetchDataSendEmail($reportId) {

		if ( $reportId ) {

			$getReportData = $this->autoreport->getSingleReportData( $reportId ) ;

			if ($getReportData) {

				$selectedFrequency  	  = ( isset( $getReportData['selected_frequency']  ) ? $getReportData['selected_frequency'] : '' ) ;
				$selectedReportName 	  = ( isset( $getReportData['selected_report_name']  ) ? $getReportData['selected_report_name'] : '' ) ;
				$reportLinkAccountNumber  = ( isset( $getReportData['report_link_account_number']  ) ? $getReportData['report_link_account_number'] : '' ) ;
				$reportLinkAccountType    = ( isset( $getReportData['report_link_account_type']  ) ? $getReportData['report_link_account_type'] : '' ) ;
				$userEmail    = ( isset( $getReportData['user_email']  ) ? $getReportData['user_email'] : '' ) ;
				$multipleEmailcc    = ( isset( $getReportData['multiple_email_cc']  ) ? $getReportData['multiple_email_cc'] : '' ) ;

				if ($selectedFrequency && $selectedReportName && $reportLinkAccountNumber && $reportLinkAccountType && $userEmail){


					$startDate = "" ;
					$endDate   = "" ;

					if ($selectedFrequency == "daily") {

						$startDate = date('Y-m-d') . " 00:00:00";
						$endDate   = date('Y-m-d')." 23:59:59" ;

					} elseif($selectedFrequency == "weekly") {  // From this friday to last friday

					    $currentDay = date('l');
					    //$currentDay = "Friday" ; // need to comment later

					    if($currentDay == "Friday"){

							$startDate =  date('Y-m-d', strtotime("-7 days")) . " 00:00:00";
							$endDate   =  date('Y-m-d')." 23:59:59" ;
						}

					} elseif($selectedFrequency == "biWeekly") {

						$currentDay = date('d');
						//$currentDay = 15 ; // need to comment later

						if($currentDay == "15"){

							$startDate =  date('Y-m') . "-01 00:00:00";
							$endDate   =  date('Y-m')."-15 23:59:59" ;

						} elseif($currentDay == "30"){

							$startDate =  date('Y-m') . "-16 00:00:00";
							$endDate   =  date('Y-m')."-30 23:59:59" ;

						}



					} elseif($selectedFrequency == "monthly") {

						$currentDay = date('d');
						//$currentDay = 30 ; // need to comment later

						if($currentDay == "30"){
							$startDate =  date('Y-m') . "-01 00:00:00";
							$endDate   =  date('Y-m')."-30 23:59:59" ;
						}

					} else {
						exit;
					}

					/*
					echo $startDate . "<br />" ;
					echo $endDate . "<br />" ;
					echo $selectedReportName . "<br />" ;
					echo $selectedFrequency . "<br />" ;
					echo $reportLinkAccountNumber . "<br />" ;
					echo $reportLinkAccountType . "<br />" ;*/

					if ( $startDate && $endDate) {

						$getData 				= "" ;
						$uploadedExcelFilePath 	= "" ;
						$signalType			   	= "" ;
						$reportHasData			= "" ;

						if ( $selectedReportName == "user_activity_summary_report") {

							$getData = $this->getUserActivitySummaryData($reportLinkAccountNumber, $startDate, $endDate) ;

							if ( $getData ) {
								$uploadedExcelFilePath = $this->excelUserActivitySummaryData($getData) ;
							} else {
								$reportHasData			= "no" ;
							}


						} elseif ( $selectedReportName == "event_detail_summary_report") {

							$getData = $this->getEventDetailSummaryData($reportLinkAccountType, $reportLinkAccountNumber, $startDate, $endDate) ;


							if ( $getData ) {
								$uploadedExcelFilePath = $this->excelEventDetailSummaryData($getData) ;

							} else {
								$reportHasData			= "no" ;
							}


						} elseif ( $selectedReportName == "alarm_activation_report") {

							$getData = $this->getAlarmActivationReportData($reportLinkAccountType, $reportLinkAccountNumber, $startDate, $endDate) ;


							if ( $getData ) {
								$uploadedExcelFilePath = $this->excelAlarmActivationReportData($getData) ;
							} else {
								$reportHasData			= "no" ;
							}


						} elseif ( $selectedReportName == "amber_alert_utilisation_report") {

							$signalType = ( isset( $getReportData['signal_type']  ) ? $getReportData['signal_type'] : '' ) ;

							if ( $signalType ) {

								$getData = $this->getAmberAlertsUtilisationData($signalType, $reportLinkAccountNumber, $startDate, $endDate) ;

								if ( $getData ) {
									$uploadedExcelFilePath = $this->excelAmberAlertsUtilisationData($getData, $signalType, $startDate, $endDate) ;
								} else {
									$reportHasData			= "no" ;
								}

							} else {

								// exit if no signal type found for amber alert utilisation report
								exit ;
							}


						}  elseif ( $selectedReportName == "app_users_report") {



								$getData = $this->getAppUsersByGroup($reportLinkAccountType, $reportLinkAccountNumber) ;

								if ( $getData ) {
									$uploadedExcelFilePath = $this->excelAppUsersByGroup($getData) ;
								} else {
									$reportHasData			= "no" ;
								}

						}   elseif ( $selectedReportName == "homesafe_report") {

								$getData = $this->getHomesafeReporting($reportLinkAccountType, $reportLinkAccountNumber,$startDate,$endDate) ;

								if ( $getData ) {
									$uploadedExcelFilePath = $this->excelHomesafeReporting($getData) ;
								} else {
									$reportHasData			= "no" ;
								}

						} else {
							exit;
						}

						/***If file exists send email with attachment***/

						if( file_exists($uploadedExcelFilePath) || $reportHasData == "no" )  {
							$dataEmail 	  						 = [];
							$dataEmail['uploadedExcelFilePath']  = $uploadedExcelFilePath;
							$dataEmail['emailTo']  				 = $userEmail;
							$dataEmail['multipleEmailcc']  		 = $multipleEmailcc;
							$dataEmail['selectedFrequency']  	 = $selectedFrequency;
							$dataEmail['selectedReportName']     = $selectedReportName;
							$dataEmail['signalType']      		 = $signalType;
							$dataEmail['username']      		 = ( $getReportData['username']  ? $getReportData['username'] : 'Sir/Madam' ) ;
							$dataEmail['reportID']      		 = ( $getReportData['id']  ? $getReportData['id'] : 'No Id Found' ) ;

							if ($getReportData['report_link_account_parent_name']) {

								  if ( $getReportData['report_link_account_type'] == "OF" ) {

									   $splitParent  =  explode( ",",$getReportData['report_link_account_parent_name'] );
									   $reportLinkAcoountParentName   = $splitParent[1] . ' > ' . $splitParent[0] . ' > ' . $getReportData['report_link_account_name'] ;

								  } elseif( $getReportData['report_link_account_type'] == "CA" ) {

									  $reportLinkAcoountParentName   = $getReportData['report_link_account_parent_name'] . ' > ' .$getReportData['report_link_account_name'] ;

								  } else {
									$reportLinkAcoountParentName     = $getReportData['report_link_account_name'] ;
								  }
						   } else {
								if( $getReportData['report_link_account_type'] == "CC" ) {
									$reportLinkAcoountParentName     = $getReportData['report_link_account_name'] ;
								} else {
									$reportLinkAcoountParentName     = "" ;
								}
						  }

						  $dataEmail['reportLinkAcoountParentName']  = $reportLinkAcoountParentName ;
						  $dataEmail['reportHasData']  				 = $reportHasData ;

						  $this->sendEmail($dataEmail) ;

						}
						/***If file exists send email with attachment***/

				   }  // end of if start date and end date found

				} // end of if, report name and selected frequency is present
			} // end of if, report data is present

		} // end of if, report id is present


	}

	/***Connect informix get data ends from here***/

	public function getUserActivitySummaryData($reportLinkAccountNumber, $startDate, $endDate) {

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		$sql = 'SELECT linkacc_contract.name Contract, linkacc_office.name Office, customer.name, eventdef.descr, customer.serialno,count(sumlog.serialno) as tcount, systrans.transmittername, systrans.lastsignal, systrans.netaddr, trantype.descr as tdescr, entityproperties.propertyvalue,
		count(sumlog.serialno)
		FROM customer, outer sumlog , eventdef, linkacc linkacc_office, linkacc linkacc_contract, systrans, trantype, outer entityproperties
		WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ("'.$reportLinkAccountNumber.'") CONNECT BY PRIOR linkacc.linkno = linkacc.parent)
		AND customer.serialno = sumlog.serialno
		AND sumlog.evtime >="'.$startDate.'"
		AND sumlog.evtime <= "'.$endDate.'"
		AND sumlog.stcode = eventdef.stcode
		AND ( eventdef.stcode) IN (993, 994, 984, 991, 992, 1277, 1953, 986, 2002, 2004)
		AND customer.linkno = linkacc_office.linkno
		AND linkacc_office.parent = linkacc_contract.linkno
		AND customer.serialno = systrans.serialno
		AND trantype.trantype = systrans.transtype
		AND entityproperties.serialno = customer.serialno
		AND entityproperties.propertydefinition = "ImeiNumber"
		GROUP BY 1,2,3,4,5, 7, 8, 9, 10 , 11' ;

		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);

		$result = array();


		if( !empty($resultTotal) ){

			$mostRecent = 0 ;
			foreach ($resultTotal as $element) {
				$result[$element['SERIALNO']]['SERIALNO'] = $element['SERIALNO'];
			    $result[$element['SERIALNO']]['CONTRACT'] = $element['CONTRACT'];
			    $result[$element['SERIALNO']]['OFFICE'] = $element['OFFICE'];
			    $result[$element['SERIALNO']]['NAME'] = $element['NAME'];

				$pregReplaceKey  = preg_replace("/[ '()-]/", '_', $element['DESCR']);


			    if ( $element['TRANSMITTERNAME'] == 'Audio') {
					$result[$element['SERIALNO']]['transmittertypeaudio'][$pregReplaceKey] = $element['TCOUNT'];
				} else {
					$result[$element['SERIALNO']]['transmittertypeother'][$pregReplaceKey] = $element['TCOUNT'];
					$result[$element['SERIALNO']]['TRANSMITTERNAME'] = $element['TDESCR'];
				}
			    $result[$element['SERIALNO']]['PROPERTYVALUE'] = $element['PROPERTYVALUE']; // IMEI Number
				$result[$element['SERIALNO']]['NETADDR'] = $element['NETADDR']; // Mobile Number
				//$result[$element['SERIALNO']]['LASTSIGNAL'][] = $element['LASTSIGNAL'];

				/*****Dynamic Last Signal***/
				if ( $element['LASTSIGNAL'] ) {

					if ( isset( $result[$element['SERIALNO']]['LASTSIGNAL'] ) && $result[$element['SERIALNO']]['LASTSIGNAL'] ) {

						$curDateTime = strtotime($element['LASTSIGNAL']);
						$mostRecent  = strtotime($result[$element['SERIALNO']]['LASTSIGNAL']) ;

						if ($curDateTime > $mostRecent) {
								$result[$element['SERIALNO']]['LASTSIGNAL'] = date('d-M-Y h:i:s A',$curDateTime);
						}


					} else {
						$result[$element['SERIALNO']]['LASTSIGNAL'] = date('d-M-Y h:i:s A', strtotime($element['LASTSIGNAL']));
					}

				} else {
						if( !isset( $result[$element['SERIALNO']]['LASTSIGNAL'] ) ) {
							$result[$element['SERIALNO']]['LASTSIGNAL'] = "" ;
						}
				}
				/*****Dynamic Last Signal***/

			}
		return $result ;

	  }
    }



	public function getEventDetailSummaryData($reportLinkAccountType, $reportLinkAccountNumber, $startDate, $endDate) {

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);



		$sql = "SELECT
customer.name, systrans.netaddr, customer.serialno, sumlog.evtime, eventdef.descr, sumlog.lseqno as LSEQNO,
 (select replace(replace(evstring,'A:1 ',''), 'T:Orbis Red Alert(1) ','') from detlog where serialno = sumlog.serialno and lseqno = sumlog.lseqno and dseqno = (select min(dseqno) from detlog where serialno = sumlog.serialno and lseqno = sumlog.lseqno and catag = 34)) as location
FROM
sumlog, customer, eventdef, systrans, linkacc link_OF, linkacc link_CA, linkacc link_CC, linkacc link_L4
WHERE
sumlog.serialno = customer.serialno and sumlog.stcode = eventdef.stcode  and sumlog.serialno = systrans.serialno and sumlog.commsno = systrans.commsno
and customer.linkno = link_OF.linkno and link_OF.parent = link_CA.linkno and link_CA.parent = link_CC.linkno and link_CC.parent = link_L4.linkno
AND
sumlog.stcode in (991,992,993,994,995,984,985,986,1277,1278,1752,1753,1953,1969,2001,2002,2008,2009,2004,2005,2006) and sumlog.evtype IN (1,0)
and link_$reportLinkAccountType.linkno = $reportLinkAccountNumber
and sumlog.evtime >= '".$startDate."' and sumlog.evtime < '".$endDate."' order by sumlog.evtime DESC" ;

		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);


		return $resultTotal ;

	}



	public function getAlarmActivationReportData($reportLinkAccountType, $reportLinkAccountNumber, $startDate, $endDate) {

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);



$sql="SELECT customer.name, systrans.netaddr, customer.serialno, eventdef.descr, sumlog.lseqno as unique_incident_id, systrans.transmittername, (select replace(replace(evstring,'A:1 ',''), 'T:Orbis Red Alert(1) ','')  from detlog where serialno = sumlog.serialno and lseqno = sumlog.lseqno and dseqno = (select min(dseqno) from detlog where serialno = sumlog.serialno and lseqno = sumlog.lseqno and catag = 34)) as location,cause.descr as cause, sumlog.evtime FROM sumlog, customer, eventdef, systrans, linkacc link_OF, linkacc link_CA, linkacc link_CC, linkacc link_L4, OUTER cause, OUTER usr WHERE sumlog.serialno = customer.serialno and sumlog.stcode = eventdef.stcode and sumlog.serialno = systrans.serialno and sumlog.commsno = systrans.commsno and sumlog.cause = cause.cause and sumlog.usrinits = usr.usrinits and customer.linkno = link_OF.linkno and link_OF.parent = link_CA.linkno and link_CA.parent = link_CC.linkno and link_CC.parent = link_L4.linkno AND sumlog.stcode in (991,992,986,1277,1752,1953,2002) and sumlog.evtype IN (1,0) and sumlog.evtime >= '".$startDate."' and sumlog.evtime < '".$endDate."' and link_$reportLinkAccountType.linkno = $reportLinkAccountNumber
order by sumlog.evtime DESC" ;

		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);


		return $resultTotal ;

	}


	public function getAmberAlertsUtilisationData($signalType, $reportLinkAccountNumber, $startDate, $endDate) {


		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		if ( $signalType == "amber_alert_start" ) {
			$stCode = "984, 2004" ;
		} elseif ( $signalType == "amber_alert_extend" ) {
			$stCode = "1969, 2005" ;
		} elseif ( $signalType == "amber_alert_exceed" ) {
			$stCode = "986, 2002" ;
		} elseif ( $signalType == "amber_alert_voice" ) {
			$stCode = "993, 994" ;
		} elseif ( $signalType == "amber_alert_cancel" ) {
			$stCode = "985, 2006" ;
		} else {
			exit ;
		}

		$sql = 'SELECT linkacc_contract.name Contract, linkacc_office.name Office, customer.name, eventdef.descr, customer.serialno, systrans.transmittername, systrans.lastsignal, systrans.netaddr, trantype.descr as tdescr, entityproperties.propertyvalue, sumlog.evtime, eventdef.stcode
		FROM customer, outer sumlog , eventdef, linkacc linkacc_office, linkacc linkacc_contract, systrans, trantype, outer entityproperties
		WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ("'.$reportLinkAccountNumber.'") CONNECT BY PRIOR linkacc.linkno = linkacc.parent)
		AND customer.serialno = sumlog.serialno
		AND sumlog.evtime >="'.$startDate.'"
		AND sumlog.evtime <= "'.$endDate.'"
		AND sumlog.stcode = eventdef.stcode
		AND ( eventdef.stcode) IN ('.$stCode.')
		AND customer.linkno = linkacc_office.linkno
		AND linkacc_office.parent = linkacc_contract.linkno
		AND customer.serialno = systrans.serialno
		AND trantype.trantype = systrans.transtype
		AND entityproperties.serialno = customer.serialno
		AND entityproperties.propertydefinition = "ImeiNumber"' ;


		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);

		$result = [];

		if ( $resultTotal ) {

			foreach ($resultTotal as $element) {

				$result[$element['SERIALNO']]['NAME']       = $element['NAME'];

				if ( $element['EVTIME'] ) {
					$result[$element['SERIALNO']]['EVTIME'][]  = date('Y-m-d', strtotime($element['EVTIME']));
				}
			}

		}


		return $result ;

	}


	public function getAppUsersByGroup($reportLinkAccountType, $reportLinkAccountNumber){

		$resultTotal = $this->autoreport->getAppUsers($reportLinkAccountType, $reportLinkAccountNumber);
		return $resultTotal ;

	}


	public function getHomesafeReporting($userLevel,$groupID,$startDate,$endDate) {

		$startDate = date( 'Y-m-d' , strtotime($startDate));
		$endDate = date( 'Y-m-d' , strtotime($endDate));
		$endTime = "23:59:59";


		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		$sql = 'DROP TABLE IF EXISTS Homesafe_109234_max_lseqno;
		SELECT customer.name, customer.contno, systrans.netaddr, eventdef.descr, sumlog.serialno, MAX(sumlog.lseqno) max_lseqno
		FROM customer
		INNER JOIN systrans ON systrans.serialno = customer.serialno
		INNER JOIN sumlog ON sumlog.serialno = customer.serialno
		INNER JOIN eventdef ON eventdef.stcode = sumlog.stcode
		WHERE sumlog.stcode in (2017, 2018, 2019, 2021)
		AND sumlog.evtime >="'.$startDate.' 00:00:00"
		AND sumlog.evtime <= "'.$endDate.' '.$endTime.'"
		AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ('.$groupID.') CONNECT BY PRIOR linkacc.linkno=linkacc.parent)
		GROUP BY 1,2,3,4,5
		INTO TEMP Homesafe_109234_max_lseqno WITH NO LOG;' ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();



		$sql = "DROP TABLE IF EXISTS Homesafe_109234_serialno_lseqno;" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();




		$sql = "SELECT serialno, MAX(max_lseqno) lseqno
		FROM Homesafe_109234_max_lseqno
		GROUP BY 1
		INTO TEMP Homesafe_109234_serialno_lseqno WITH NO LOG" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();



		$sql = "SELECT customer.name, customer.contno, systrans.netaddr, eventdef.descr, sumlog.evtime, detlog1.latitude, detlog1.longitude
		FROM customer, sumlog, eventdef, systrans, Homesafe_109234_serialno_lseqno AS HS, OUTER detlog1
		WHERE sumlog.serialno = customer.serialno
		AND systrans.serialno = customer.serialno AND systrans.commsno = sumlog.commsno
		AND eventdef.stcode = sumlog.stcode
		AND detlog1.serialno = sumlog.serialno AND detlog1.lseqno = sumlog.lseqno
		AND HS.lseqno = sumlog.lseqno AND HS.serialno = sumlog.serialno
		AND detlog1.serialno = sumlog.serialno AND detlog1.lseqno = sumlog.lseqno
		AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno = linkacc.parent)
		AND detlog1.latitude IS NOT NULL
		AND detlog1.longitude IS NOT NULL
		UNION
		SELECT customer.name, customer.contno, systrans.netaddr, NULL::VARCHAR(50), NULL::DATETIME YEAR TO FRACTION(5), NULL::VARCHAR(50), NULL::VARCHAR(50)
		FROM customer, systrans
		WHERE customer.serialno = systrans.serialno
		AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent)
		AND systrans.transtype = 25029
		AND customer.serialno NOT IN(SELECT serialno FROM Homesafe_109234_serialno_lseqno)" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();

		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);

		return $resultTotal ;

	}

	/***Connect informix get data ends from here***/


	/***Excel generation starts from here***/


	public function excelUserActivitySummaryData($resultTotal) {

		$alphas = range('A', 'Z');


		$fileName = 'User_Activity_Report_'.date('His').mt_rand().'.xlsx';

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CONTRACT');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'OFFICE');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'USERNAME');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'TRANSMITTER TYPE');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'IMEI NUMBER');
		$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'MOBILE NUMBER');
		$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'DATE TIME OF LAST SIGNAL');
		$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'AMBER ALERTS DATA');
		$objPHPExcel->getActiveSheet()->SetCellValue('I1', 'AMBER ALERTS VOICE');
		$objPHPExcel->getActiveSheet()->SetCellValue('J1', 'RED ALERTS DATA');
		$objPHPExcel->getActiveSheet()->SetCellValue('K1', 'RED ALERTS VOICE');
		$objPHPExcel->getActiveSheet()->SetCellValue('L1', 'MAN DOWN ALERT');
		$objPHPExcel->getActiveSheet()->SetCellValue('M1', 'FALL ALERT');
		$objPHPExcel->getActiveSheet()->SetCellValue('N1', 'AMBER EXCEED');


		$objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:N1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);

		/* To set the heading colum width and freeze the heading starts */

			 for ($i=0; $i<14 ; $i++) {
				$objPHPExcel->getActiveSheet()->getColumnDimension($alphas[$i])->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension($alphas[$i])->setWidth(30);
			 }
	         $objPHPExcel->getActiveSheet()->freezePane('O2');

	    /* To set the heading colum width and freeze the heading ends */

		$rowCount = 2;

		foreach( $resultTotal as $newData )
		{
			if ( isset($newData['transmittertypeaudio']) && count ( $newData['transmittertypeaudio'] ) == 10 ) {
				$showDataAudio = true ;
			} else {
				$showDataAudio = false ;
			}

			if ( isset($newData['transmittertypeother']) && count ( $newData['transmittertypeother'] ) == 10 ) {
				$showDataOther = true ;
			} else {
				$showDataOther = false ;
			}

			if (!$showDataAudio || !$showDataOther) {
				continue ;
			}

			$amber_alert_other	=  	   ( isset($newData['transmittertypeother']['Amber_Alert']) ? $newData['transmittertypeother']['Amber_Alert'] : 0 ) ;

			$amber_alert_audio		=  ( isset($newData['transmittertypeaudio']['Amber_Alert']) ? $newData['transmittertypeaudio']['Amber_Alert'] : 0 ) ;

			$amber_alert_start_other =  ( isset($newData['transmittertypeother']['Amber_Alert_Start']) ? $newData['transmittertypeother']['Amber_Alert_Start'] : 0 ) ;

			$amber_cancel_o_Due__OrbisApp_other = ( isset($newData['transmittertypeother']['Amber_Cancel_O_Due__OrbisApp_']) ? $newData['transmittertypeother']['Amber_Cancel_O_Due__OrbisApp_'] : 0 ) ;

			$amber_cancel_o_Due__OrbisApp_audio =   ( isset($newData['transmittertypeaudio']['Amber_Cancel_O_Due__OrbisApp_']) ? $newData['transmittertypeaudio']['Amber_Cancel_O_Due__OrbisApp_'] : 0 ) ;

			$Amber_Cancel_Overdue_other = ( isset($newData['transmittertypeother']['Amber_Cancel_Overdue']) ? $newData['transmittertypeother']['Amber_Cancel_Overdue'] : 0 ) ;

			$Amber_Cancel_Overdue_audio =   ( isset($newData['transmittertypeaudio']['Amber_Cancel_Overdue']) ? $newData['transmittertypeaudio']['Amber_Cancel_Overdue'] : 0 ) ;

			$amber_alert_audio_audio		=  ( isset($newData['transmittertypeaudio']['Amber_Alert_Audio']) ? $newData['transmittertypeaudio']['Amber_Alert_Audio'] : 0 ) ;

			$Fall_audio		=  ( isset($newData['transmittertypeaudio']['Fall']) ? $newData['transmittertypeaudio']['Fall'] : 0 ) ;

			$Man_Down_audio		=  ( isset($newData['transmittertypeaudio']['Man_Down']) ? $newData['transmittertypeaudio']['Man_Down'] : 0 ) ;

			$Red_Alert_Audio_audio		=  ( isset($newData['transmittertypeaudio']['Red_Alert_Audio']) ? $newData['transmittertypeaudio']['Red_Alert_Audio'] : 0 ) ;


			//New added for identiSafe8 and 1000 devices

			$Information_Amber_Start_other =  ( isset($newData['transmittertypeother']['Information___Amber_Start']) ? $newData['transmittertypeother']['Information___Amber_Start'] : 0 ) ;

			$amber_alerts_data	  		 = ( $amber_alert_other +   $amber_alert_start_other + $Information_Amber_Start_other );

			$amber_alerts_voice        	  = ( $amber_alert_audio_audio +  $amber_alert_audio  );

			$red_alerts_data			 = ( isset($newData['transmittertypeother']['Red_Alert']) ? $newData['transmittertypeother']['Red_Alert'] : 0 ) ;



			$red_alerts_voice			 = ( $amber_cancel_o_Due__OrbisApp_audio + $Fall_audio + $Amber_Cancel_Overdue_audio + $Man_Down_audio + $Red_Alert_Audio_audio );


			$man_down_alert 			  = ( isset($newData['transmittertypeother']['Man_Down']) ? $newData['transmittertypeother']['Man_Down'] : 0 );

			$fall_alert						 = ( isset($newData['transmittertypeother']['Fall']) ? $newData['transmittertypeother']['Fall'] : 0 );

			$amber_exceed			 	 = ( $Amber_Cancel_Overdue_other + $amber_cancel_o_Due__OrbisApp_other );




			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $newData['CONTRACT']);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $newData['OFFICE']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $newData['NAME']);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $newData['TRANSMITTERNAME']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $newData['PROPERTYVALUE']);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $newData['NETADDR']);
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, ( $newData['LASTSIGNAL'] ? $newData['LASTSIGNAL'] : '-') );
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $amber_alerts_data);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $amber_alerts_voice);
			$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $red_alerts_data);
			$objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $red_alerts_voice);
			$objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $man_down_alert);
			$objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $fall_alert);
			$objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $amber_exceed);

			$rowCount++ ;
		}

		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);


		$report_path = $this->config->item('directoryPath') . 'auto_reports_cron/';

		 if(!is_dir($report_path))
		 {
				mkdir($report_path);
		 }


		chmod($report_path, 0777);
		$objWriter->save($report_path.$fileName);

		return $report_path.$fileName ;

		//header("Content-Type: application/vnd.ms-excel");
		//redirect(base_url().'assets/auto_reports_cron/'.$fileName);

	  }




	public function excelEventDetailSummaryData($resultTotal) {

		$fileName = 'Event_Detail_Summary_'.date('His').mt_rand().'.xlsx';

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Username');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Mobile Number');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'DateTime');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Signal Type');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Address');


		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(60);

		//$objPHPExcel->getActiveSheet()->freezePane('F2');

		$rowCount = 2;
		foreach ($resultTotal as $element) {

			//To get the Address by removing lat/long and other things

			if( isset($element['LOCATION']) || $element['LOCATION'] != '' )
			{
				//$resultTotal[$i]['LOCATION'] = $resultTotal[$i]['LOCATION'];
				if ( strpos($element['LOCATION'],"Lat,Long=") ) {

					$string = $element['LOCATION'] ;
					$explode = explode(" ", $string) ;

					$nameWithoutLatLong = str_replace(end($explode),"",$string);

					$address = $nameWithoutLatLong ;


				} else {
					$address = $element['LOCATION'] ;
				}

			}
			else{
				$address = '-';
			}

			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['NAME']);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['NETADDR']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, date('d F y H:i:s', strtotime($element['EVTIME'])));
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['DESCR']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $address);
			$rowCount++;
		}

		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);


		$report_path = $this->config->item('directoryPath') . 'auto_reports_cron/';

		 if(!is_dir($report_path))
		 {
				mkdir($report_path);
		 }


		chmod($report_path, 0777);
		$objWriter->save($report_path.$fileName);

		return $report_path.$fileName ;

		//header("Content-Type: application/vnd.ms-excel");
		//redirect(base_url().'assets/auto_reports_cron/'.$fileName);



	}


	public function excelAlarmActivationReportData($getSignalHistoryExport){


		$fileName = 'Alarm_Activation_Report_'.date('His').mt_rand().'.xlsx';
		//$empInfo = $this->export->employeeList();
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Time');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Name');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Mobile Number');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Signal Type');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Address');
		$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Cause');

		$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(60);


		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);



		// set Row
		$rowCount = 2;
		foreach ($getSignalHistoryExport as $element) {

			//To get the Address by removing lat/long and other things

			if( isset($element['LOCATION']) || $element['LOCATION'] != '' )
			{
				//$resultTotal[$i]['LOCATION'] = $resultTotal[$i]['LOCATION'];
				if ( strpos($element['LOCATION'],"Lat,Long=") ) {

					$string = $element['LOCATION'] ;
					$explode = explode(" ", $string) ;

					$nameWithoutLatLong = str_replace(end($explode),"",$string);

					$address = $nameWithoutLatLong ;


				} else {
					$address = $element['LOCATION'] ;
				}

			}
			else{
				$address = '-';
			}




			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, date('d F y H:i:s', strtotime($element['EVTIME'])));
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['NAME']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['NETADDR']);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['DESCR']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $address);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['CAUSE']);
			$rowCount++;
		}
		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
				// download file
		$report_path = $this->config->item('directoryPath') . 'auto_reports_cron/';
		if(!is_dir($report_path))
		{
			mkdir($report_path);
		}

		chmod($report_path, 0777);
		$objWriter->save($report_path.$fileName);

		return $report_path.$fileName ;

		//header("Content-Type: application/vnd.ms-excel");
		//redirect(base_url().'assets/auto_reports_cron/'.$fileName);



	}


	public function excelAmberAlertsUtilisationData($getData, $signalType, $startDate, $endDate){

		$date1=date_create($startDate);
		$date2=date_create("$endDate");
		$diff=date_diff($date1,$date2);

		$difference =  ( $diff->days + 1 ) ;

		$weekDateArray = [] ;

		for($i = 0; $i< $difference; $i++ ) {
			$weekDateArray[]  = date('Y-m-d', strtotime('-'.$i.' day', strtotime($endDate)));
		}

		$fileName = 'Amber_Alert_Utilization_'.date('His').mt_rand().'.xlsx';

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);



		/*To set the heading*/
		$signalFor = ucwords(str_replace("_alert_"," ",$signalType)) ;
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Amber Alert Utilization Report (".$signalFor.")");
		$objPHPExcel->getActiveSheet()->mergeCells('A1:E1');

		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 2, 'Username');
		$col = 1 ;
		foreach($weekDateArray as $key=>$value) {
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, 2, date('M jS Y', strtotime($value)));
			$col++ ;
		}
		/*To set the heading*/


		$row = 3 ;

		foreach ( $getData as $newData) {

			if( isset( $newData['EVTIME'] ) && $newData['EVTIME'] ) {

				$counts = array_count_values($newData['EVTIME']);


				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $newData['NAME']);

				$loopCount = 0 ;

				for( $i=1; $i<=count($weekDateArray); $i++ ) {

					$setDynamicValue = ( isset ( $counts[$weekDateArray[$loopCount]] ) ? ( round ( $counts[$weekDateArray[$loopCount]] / 2 ) ) : 0  )  ;


					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($i, $row, $setDynamicValue);

					$loopCount++ ;
				}



			} else {
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $newData['NAME']);
				for( $i=1; $i<=count($weekDateArray); $i++ ) {
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($i, $row, 0);
				}
			}

			$col++ ;
			$row++ ;
		}


		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
		// download file
		$report_path = $this->config->item('directoryPath') . 'auto_reports_cron/';
		if(!is_dir($report_path))
		{
			mkdir($report_path);
		}

		chmod($report_path, 0777);
		$objWriter->save($report_path.$fileName);

		return $report_path.$fileName ;

		//header("Content-Type: application/vnd.ms-excel");
		//redirect(base_url().'assets/auto_reports_cron/'.$fileName);

	}


	public function excelHomesafeReporting($resultTotal) {

		$fileName = 'Homesafe_Reporting_'.date('His').mt_rand().'.xlsx';

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Contract');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Username');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Mobile Number');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Date & Time');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Homesafe');

		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);

		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);

		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);

		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);

		$rowCount = 2;
		foreach ($resultTotal as $element) {



			if( empty($element['NAME']) )
			{
				$element['NAME'] = '-';
			} else {
				$nameEncoded	= utf8_decode($element['NAME']) ;
				$nameEncoded    = str_replace('?',' ', $nameEncoded) ;
				$element['NAME']  = $nameEncoded;
			}

			if( empty($element['CONTNO']) )
			{
				$element['CONTNO'] = '-';
			}

			if( empty($element['NETADDR']) )
			{
				$element['NETADDR'] = '-';
			}

			if( empty($element['DESCR']) )
			{
				$element['DESCR'] = '-';
			} else {

				if ( trim($element['DESCR']) == "Homesafe Entered" ) {
					$element['DESCR'] = 'YES';
				} elseif ( trim($element['DESCR']) == "Homesafe left" ) {
					$element['DESCR'] = 'NO';
				} else {
					$element['DESCR'] = '-';
				}
			}

			if( empty($element['EVTIME']) )
			{
				$element['EVTIME'] = '-';
			} else {

				$element['EVTIME'] = date('d F y H:i:s', strtotime($element['EVTIME']));
			}



			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['CONTNO']);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['NAME']);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit('C' . $rowCount, $element['NETADDR'], PHPExcel_Cell_DataType::TYPE_STRING);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['EVTIME']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['DESCR']);
			$rowCount++;
		}

		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);


		$report_path = $this->config->item('directoryPath') . 'auto_reports_cron/';

		 if(!is_dir($report_path))
		 {
				mkdir($report_path);
		 }


		chmod($report_path, 0777);
		$objWriter->save($report_path.$fileName);

		return $report_path.$fileName ;
	}


	public function excelAppUsersByGroup($resultTotal) {

		$fileName = 'App_Users_'.date('His').mt_rand().'.xlsx';

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'NAME');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'S.R. NO.');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'HANDSET NUMBER');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Carrier');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Model');
		$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'O.S Version');
		$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'App Version');


		$objPHPExcel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:G1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:G1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);


		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);

		//$objPHPExcel->getActiveSheet()->freezePane('F2');

		$rowCount = 2;
		foreach ($resultTotal as $element) {



			if( empty($element['carrier']) )
			{
				$element['carrier'] = '-';
			}

			if( empty($element['model']) )
			{
				$element['model'] = '-';
			}

			if( empty($element['version']) )
			{
				$element['version'] = '-';
			}

			if( empty($element['app_version']) )
			{
				$element['app_version'] = '-';
			}



			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['loginname']);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['lindex']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['number']);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['carrier']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['model']);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['version']);
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $element['app_version']);
			$rowCount++;
		}

		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);


		$report_path = $this->config->item('directoryPath') . 'auto_reports_cron/';

		 if(!is_dir($report_path))
		 {
				mkdir($report_path);
		 }


		chmod($report_path, 0777);
		$objWriter->save($report_path.$fileName);

		return $report_path.$fileName ;
	}

	/***Excel generation ends from here***/



	public function sendEmail($dataEmail)
    {

		$reportHasData = $dataEmail['reportHasData'] ;
		$email 	  =  trim($dataEmail['emailTo']) ;
		$subject  =  ucwords(str_replace("_"," ",$dataEmail['selectedReportName'])) . ' (' .  ucwords($dataEmail['selectedFrequency']) . ') generated for ' . $dataEmail['reportLinkAcoountParentName']  ;
		//$message  = 'This is ' . $dataEmail['selectedFrequency'] . ' ' . ucwords(str_replace("_"," ",$dataEmail['selectedReportName']));
		$filePath =  $dataEmail['uploadedExcelFilePath'] ;

		if ( $reportHasData == "no") {
			$message  = "Dear ".$dataEmail['username']. ",<br /><br />You are receiving this email as you have scheduled the report to be sent to you from sentry.orbisprotect.com. Please note, in case you do not get any report attached, it is because there was no data generated for the report." ;
		} else {
			$message  = "Dear ".$dataEmail['username']. ",<br /><br />Please find attached your ". ucwords(str_replace("_"," ",$dataEmail['selectedReportName']))    ." that you have setup to be delivered to you automatically from the Sentry customer management portal.<br /><br />If you wish to edit this report schedule please do so by logging into Sentry and making the necessary changes.<br /><br />Regards,<br />Orbis Protect" ;
		}


		$config = Array(
		  'protocol' 	 => 'smtp',
		  'smtp_host'	 => 'smtp.office365.com',
		  'smtp_port' 	 =>  587,
		  'smtp_user'	 => 'orbisreports@orbisprotect.com',
		  'smtp_pass'	 => 'Haqa5302',
		  'smtp_crypto'  => 'tls',
		  'mailtype' 	 => 'html',
		);


		/*
		$config = Array(
		  'protocol' 		  => 'smtp',
		  'smtp_host' 		  => 'smtp.gmail.com',
		  'smtp_port'		  => 587,
		  'smtp_user'		  => 'webmasterdevops@gmail.com',
		  'smtp_pass'		  => 'ravi@123',
		  'smtp_crypto'   	  => 'tls',
		  'mailtype'		  => 'html',
		);*/



	    $this->load->library('email', $config);
	    $this->email->set_newline("\r\n");
	    $this->email->set_crlf( "\r\n" );
	    $this->email->from('orbisreports@orbisprotect.com', 'Orbis');
	    $this->email->to($email);
	    if( isset($dataEmail['multipleEmailcc']) &&  $dataEmail['multipleEmailcc'] ) {
			$this->email->cc($dataEmail['multipleEmailcc']);
		}
	    $this->email->subject($subject);
	    $this->email->message($message);
	    if ( $reportHasData != "no") {
			$this->email->attach($filePath);
		}

	    //Please remove the log of cron later after testing to release the sql space
	    if($this->email->send())
	    {
			//echo 'Email send.';
			//Mail Sent
			$this->autoreport->logCron($dataEmail['reportID'], 'mail sent') ;
		}
	    else
	    {
		  //show_error($this->email->print_debugger());
		  //debug errors
		  //$errorMail = $this->email->print_debugger() ;
		  //$this->autoreport->logCron($reportID, 'mail not sent' . $errorMail) ;
		  $this->autoreport->logCron($dataEmail['reportID'], 'mail not sent') ;
	    }


	    unlink($filePath) ;


	}

	/***Mail function to send email***/


	function exception_report(){
		$this->load->view('system/exception_report');
	}



}
