<?php
/*
	Controller for course
*/

Class Elearning extends CI_Controller
{

	public $wsCurlUrl ;

	function __construct()
	{
		parent::__construct();

		$this->load->model('elearningmoodle');
		$this->load->library('curlmoodle');

		/*if ( $this->session->userdata('type') != "superadmin") {
			if(  $this->session->userdata('lms_status') == '0' ){
				redirect('/', 'refresh');
				exit;
			}
		}*/

		if( $this->session->userdata('login_id') != 1 )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('/');
		}


		$this->wsCurlUrl = $this->config->item('moodle')['wsdomain'].$this->config->item('moodle')['wsfilepath'].'?wstoken='.$this->config->item('moodle')['wstoken'].'&moodlewsrestformat='.$this->config->item('moodle')['wsrestformat'] ;


	}

	function index()
  {
 	$this->load->view('trainee/login');
  }

   function course()
   {
		$this->load->view('trainee/course');
   }

	 function forgotpassword()
	 {
	 $this->load->view('trainee/forgotpassword');
	 }


	 function myaccount()
	{
	$this->load->view('trainee/myaccount');
	}

	function dashboard()
 {
 $this->load->view('trainee/dashboard');
 }

 function courseadmin()
{
	if( $this->session->userdata('type') != 'superadmin' )
	{
		 redirect('/', 'refresh');
		 die;
	}

	$this->load->view('trainee/courseadmin');
}


function courseListingReportAdmin()
{
	if( $this->session->userdata('type') != 'superadmin' )
	{
		 redirect('/', 'refresh');
		 die;
	}
	
	$CostCentreResponse = $this->curl->curlHelperGetCostCentreAPI() ;
	$data['CostCentreList'] = $CostCentreResponse;
	
	$this->load->view('trainee/course_listing_report_admin', $data);
}



function addcourses()
{
$this->load->view('trainee/addcourses');
}

function viewcourses()
{
$this->load->view('trainee/viewcourses');
}

function course_detail($courseId)
{
	// Pendig to check for the id has to be there in url and then check if there is acourse for the course id in moodle.


	if( $this->session->userdata('type') != 'superadmin' )
	{
		 redirect('/', 'refresh');
		 die;
	}


	/***check if course id exists***/
	$parameter = [
				'options' => [
						'ids' => [$courseId]
				]
	];

	$functionname = 'core_course_get_courses';
	$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

	$response = $this->curlmoodle->post($serverurl, $parameter);
	$response =  json_decode($response, true) ;

	if ( isset($response[0]['id']) &&  $response[0]['id'] == $courseId){
		//do nothing
	} else {
		redirect('/elearning/courseadmin', 'refresh');
		die;
	}


	/***check if course id exists***/


	$CostCentreResponse = $this->curl->curlHelperGetCostCentreAPI() ;
	$data['CostCentreList'] = $CostCentreResponse;
	$data['courseId']		= $courseId ;

	$this->load->view('trainee/course_detail', $data);
}

  public function addElearningCourseToCostCentre() {

		 $selectedCCId 	  = $this->input->post('selectedCCId');
		 $selectedCCName  = $this->input->post('selectedCCName');
	     $mainCourseId    = $this->input->post('mainCourseId');


	     if($selectedCCId && $mainCourseId) {

		    $checkCourseAlreadyAssigned = $this->elearningmoodle->checkCourseAlreadyAssigned($selectedCCId, $mainCourseId) ;

			if ($checkCourseAlreadyAssigned) {
				echo json_encode([ 'error' => '1', 'msg' => 'Course already assigned']);
			} else {
				$insertData = $this->elearningmoodle->addElearningCourseToCostCentre($selectedCCId, $mainCourseId, $selectedCCName) ;
				if($insertData) {
					echo json_encode([ 'error' => '0', 'msg' => 'Cost Center linked with course']) ;
				} else {
					echo json_encode([ 'error' => '1', 'msg' => 'Database error']) ;
				}
			}

		 } else {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters']);
		 }
  }


   public function getAssignedCoursesToCostCentre() {

		$requestData 	= $this->input->post();
		$getLogs 		= $this->elearningmoodle->getAssignedCoursesToCostCentre($requestData);
		echo json_encode($getLogs);
	}


	public function getAssignedTraineeToCourse() {

		$requestData 	= $this->input->post();
		$getLogs 		= $this->elearningmoodle->getAssignedTraineeToCourse($requestData);
		echo json_encode($getLogs);
	}


	function getAllCostCentreListing()
	{

		$mainCourseId    = $this->input->post('mainCourseId');

		if(!$mainCourseId) {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters', 'data' => '']);
			exit;
		 }

		$xml_url = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLinkAccounts';
		$xml_request = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

			<soap:Header/>

			<soap:Body>

			<cls:ListLinkAccounts>

			<cls:listLinkAccountsRequestKey>

			<cls:ServiceVersion>Version_1_123_1</cls:ServiceVersion>

			<cls:UserName>sentrymaster</cls:UserName>

			<cls:Password>Pass2121!</cls:Password>

			<cls:AgencyOverride xsi:type="cls:LinkAccountAgencyOverride">

			<cls:LinkAccountIdentifier>20</cls:LinkAccountIdentifier>

			</cls:AgencyOverride>

			</cls:listLinkAccountsRequestKey>

			</cls:ListLinkAccounts>

			</soap:Body>

			</soap:Envelope>';


		   $curl_send = $this->curl->curl_send($xml_request, $xml_url);

		   $xmlToArray = $this->curl->xmlToArray($curl_send);


		   $getCostCentreResponse = ( isset( $xmlToArray['ListLinkAccountsResponse']['ListLinkAccountsResult']['ListOfLinkAccounts']['LinkAccountListItem'] ) && $xmlToArray['ListLinkAccountsResponse']['ListLinkAccountsResult']['ListOfLinkAccounts']['LinkAccountListItem'] ? $xmlToArray['ListLinkAccountsResponse']['ListLinkAccountsResult']['ListOfLinkAccounts']['LinkAccountListItem'] : '') ;

		   $getCostCentreResponseNew = [] ;

		   if( !empty($getCostCentreResponse) ){


			  $count = 0 ;
			  $allAssigned = 'yes' ;

			  for( $j=0; $j<count($getCostCentreResponse); $j++ ) {

				  $checkCourseAlreadyAssigned = $this->elearningmoodle->checkCourseAlreadyAssigned($getCostCentreResponse[$j]['Identifier'], $mainCourseId) ;

				  if ($checkCourseAlreadyAssigned) {
					  continue ;
				  }


				  $explodeName = explode(" ",$getCostCentreResponse[$j]['Name']) ;

				  if ( isset( $explodeName[0] ) && $explodeName[0] == "CC" && $getCostCentreResponse[$j]['Identifier'] != "20" ) {

						$getCostCentreResponseNew[$count]['LINKNO'] = $getCostCentreResponse[$j]['Identifier'];
						$getCostCentreResponseNew[$count]['NAME']   = trim(substr($getCostCentreResponse[$j]['Name'], 3));
						$count++ ;

				  }

				  $allAssigned = "no" ;

			  }
			  echo json_encode(['error' => '0' , 'msg' => 'data found', 'data' => $getCostCentreResponseNew, 'allAssigned' => $allAssigned]);
		   } else {
			  echo json_encode(['error' => '1' , 'msg' => 'No record found', 'data' => $getCostCentreResponseNew]) ;
		   }


	}



    public function removeCostCentreAssignedtoCourse() {

		 $selectedCCId 	  = $this->input->post('selectedCCId');
	     $mainCourseId    = $this->input->post('mainCourseId');


	     if($selectedCCId && $mainCourseId) {


			 $checkCourseAssignedToCCTrainee = $this->elearningmoodle->checkCourseAssignedToCCTrainee($selectedCCId, $mainCourseId);

			// debug($checkCourseAssignedToCCTrainee, 1) ;

			 if ( $checkCourseAssignedToCCTrainee ) {

				echo json_encode([ 'error' => '1', 'msg' => 'Trainee user of this cost centre has been assigned for this course, so please remove them from the course and try again']);

			 } else {

				$remove = $this->elearningmoodle->removeCostCentreAssignedtoCourse($selectedCCId, $mainCourseId);

				if ($remove) {
					echo json_encode([ 'error' => '0', 'msg' => 'Cost Centre removed']);
				} else {
					echo json_encode([ 'error' => '1', 'msg' => 'Database error occured']);
				}
			 }



		 } else {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters']);
		 }

    }


	 public function getNonAssignedTraineeToCourse() {

		$requestData 	= $this->input->post();
		$getLogs 		= $this->elearningmoodle->getNonAssignedTraineeToCourse($requestData);
		echo json_encode($getLogs);
	}


	function coursemanager()
	{
		
		if( $this->session->userdata('login_id') != 1 || $this->session->userdata('main_elearning_courses') != 1 )
		{
			 redirect('/', 'refresh');
			 die;
		}


		$this->load->view('trainee/courses_manager');
	}



	function course_detail_manager($courseId)
	{


		if( $this->session->userdata('login_id') != 1 || $this->session->userdata('main_elearning_courses') != 1 )
		{
			 redirect('/', 'refresh');
			 die;
		}



	   $checkCourseAlreadyAssigned = $this->elearningmoodle->checkCourseAlreadyAssigned($this->session->userdata('costcenterID'), $courseId) ;

	   if (!$checkCourseAlreadyAssigned) {
		     redirect('/elearning/coursemanager', 'refresh');
		     exit;
	   }


		/***check if course id exists***/
		$parameter = [
					'options' => [
							'ids' => [$courseId]
					]
		];

		$functionname = 'core_course_get_courses';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$response = $this->curlmoodle->post($serverurl, $parameter);
		$response =  json_decode($response, true) ;

		if ( isset($response[0]['id']) &&  $response[0]['id'] == $courseId){
			//do nothing
		} else {
			redirect('/elearning/coursemanager', 'refresh');
			die;
		}


		/***check if course id exists***/


		$CostCentreResponse = $this->curl->curlHelperGetCostCentreAPI() ;
		$data['CostCentreList'] = $CostCentreResponse;
		$data['courseId']		= $courseId ;

		$this->load->view('trainee/course_detail_manager', $data);
	}


	public function getAssignedTraineeToCourseForManager() {

		$requestData 	= $this->input->post();
		$getLogs 		= $this->elearningmoodle->getAssignedTraineeToCourseForManager($requestData);
		echo json_encode($getLogs);
	}


	public function getNonAssignedTraineeToCourseForManager() {

		$requestData 	= $this->input->post();
		$getLogs 		= $this->elearningmoodle->getNonAssignedTraineeToCourseForManager($requestData);
		echo json_encode($getLogs);
	}

/**************Course completion report***************/

public function coursecompletionreport() {
	
	
	 if( $this->session->userdata('type') != 'superadmin' )
	 {
		 redirect('/', 'refresh');
		 die;
	 }

	 
	$costCenterName = $this->input->get('costcenter') ;
	$courseId 	    = $this->input->get('courseid') ;
	
	if (!$costCenterName || !$courseId) {
		redirect('/elearning/courseListingReportAdmin', 'refresh');
		die;
	}
	
	

	/***check if course id exists***/
	$parameter = [
				'options' => [
						'ids' => [$courseId]
				]
	];

	$functionname = 'core_course_get_courses';
	$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

	$response = $this->curlmoodle->post($serverurl, $parameter);
	$response =  json_decode($response, true) ;
	
	if ( isset($response[0]['id']) &&  $response[0]['id'] == $courseId){
		//do nothing
	} else {
		redirect('/elearning/courseListingReportAdmin', 'refresh');
		die;
	}

	
	$data['costCenterName'] = urldecode($costCenterName) ;
	$data['courseId'] 		= $courseId ;
	$data['courseName'] 	= $response[0]['displayname'] ;
	
	
	/***check if course id exists***/
	
	 $this->load->view('trainee/coursecompletionreport', $data);
}

/**************Manager Course completion report***************/

public function courseCompletionReportManager($courseId) {
	
	
	if( $this->session->userdata('login_id') != 1 || $this->session->userdata('main_elearning_courses') != 1 )
	{
		 redirect('/', 'refresh');
		 die;
	}
	
	 $checkCourseAlreadyAssigned = $this->elearningmoodle->checkCourseAlreadyAssigned($this->session->userdata('costcenterID'), $courseId) ;

	 if (!$checkCourseAlreadyAssigned) {
		     redirect('/elearning/coursemanager', 'refresh');
		     exit;
	 }
	
	
	
	

	/***check if course id exists***/
	$parameter = [
				'options' => [
						'ids' => [$courseId]
				]
	];

	$functionname = 'core_course_get_courses';
	$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

	$response = $this->curlmoodle->post($serverurl, $parameter);
	$response =  json_decode($response, true) ;
	
	if ( isset($response[0]['id']) &&  $response[0]['id'] == $courseId){
		//do nothing
	} else {
		redirect('/elearning/coursemanager', 'refresh');
		die;
	}

	$data['courseId'] 		= $courseId ;
	$data['courseName'] 	= $response[0]['displayname'] ;
	
	
	/***check if course id exists***/
	
	 $this->load->view('trainee/course_completion_report _manager', $data);
}







public function coursecompletionreport_manager() {
	 $this->load->view('trainee/coursecompletionreport_manager');
}


}
