<?php $search_only = true;
if ($settings['product_show_filter'] == 'yes' && (
		($settings['filter_by_categories'] == 'yes' && count($terms) > 0) ||
		$settings['filter_by_attribute'] == 'yes' ||
		$settings['filter_by_price'] == 'yes' ||
		$settings['filter_by_status'] == 'yes'
	)):
	$search_only = false;

	if ($settings['filter_by_categories'] == 'yes' && $settings['filter_by_attribute'] != 'yes' && $settings['filter_by_price'] != 'yes' && $settings['filter_by_status'] != 'yes' && $settings['filter_by_categories_hierarchy'] != 'yes') {
		$single_filter = true;
	} else {
		$single_filter = false;
	}

	$product_loop_all = thegem_get_extended_product_posts(1, -1, $settings['orderby'], $settings['order'], $featured_only, $sale_only, false, $categories, $attributes);
	$posts_arr = [];
	$i = 0;
	if ($product_loop_all && $product_loop_all->have_posts()) {
		while ($product_loop_all->have_posts()) : $product_loop_all->the_post();
			global $product;

			$posts_arr[$i]['id'] = $product->get_id();
			if ($settings['filter_by_categories'] == 'yes') {
				$posts_arr[$i]['category'] = wp_get_object_terms(get_the_ID(), 'product_cat', array('fields' => 'slugs'));
			}

			if ($settings['filter_by_attribute'] == 'yes') {
				$filter_attr = $settings['repeater_attributes'];
				$attributes_list = $this->select_products_attributes();
				foreach ($filter_attr as $index => $item) {
					if (!empty($item['attribute_name'])) {
						$posts_arr[$i][$item['attribute_name']] = wp_get_object_terms(get_the_ID(), 'pa_' . $item['attribute_name'], array('fields' => 'slugs'));
					}
				}
			}
			if ($settings['filter_by_status'] == 'yes') {
				$posts_arr[$i]['status'] = [];
				if ($product->is_on_sale()) {
					array_push($posts_arr[$i]['status'], "sale");
				}
				if ($product->is_in_stock()) {
					array_push($posts_arr[$i]['status'], "stock");
				}
			}
			$i++;
		endwhile;
	}
	$filtersList = []; ?>

	<div class="portfolio-filters-list style-<?php echo $settings['filters_style']; ?> <?php echo $single_filter ? 'single-filter' : ''; ?> <?php echo $settings['filters_scroll_top'] == 'yes' ? 'scroll-top' : ''; ?>">

		<div class="show-filters-button <?php echo $settings['filter_buttons_hidden_show_icon'] == 'yes' ? 'icon' : ''; ?>">
			<?php echo $settings['filter_buttons_hidden_show_text']; ?>
			<?php if ($settings['filter_buttons_hidden_show_icon'] == 'yes') { ?>
				<span class="icon"></span>
			<?php } ?>
		</div>

		<div class="filters-outer">
			<div class="filters-list">
				<div class="list-scrollable">
					<h3><?php echo $settings['filter_buttons_hidden_sidebar_title']; ?></h3>
					<?php if ($settings['filter_by_search'] == 'yes') { ?>
						<form class="search-filter" role="search" action="">
							<div class="form">
								<input type="search"
									   placeholder="<?php echo $settings['filters_text_labels_search_text']; ?>"
									   value="<?php echo $search_current; ?>">
							</div>
							<div class="search-btn"></div>
						</form>
					<?php } ?>
					<?php if ($settings['filter_by_categories'] == 'yes' && count($terms) > 0) {
						$filtersList['category'] = []; ?>
						<div class="filter-item">
							<h4 class="name widget-title"><span
										class="by"><?php echo $settings['filter_buttons_hidden_filter_by_text']; ?> </span><?php echo $settings['filter_by_categories_title']; ?>
								<span class="arrow gem-elegant arrow-carrot-down"></span>
							</h4>
							<div class="list">
								<ul>
									<li>
										<a href="#" data-filter-type="category"
										   data-filter="*"
										   class="all <?php echo $active_cat == 'all' ? 'active' : '' ?>">
											<span class="title"><?php echo $settings['filters_text_labels_all_text']; ?></span>
										</a>
									</li>
									<?php foreach ($terms as $term) :
										array_push($filtersList['category'], $term->slug); ?>
										<li><a href="#" data-filter-type="category"
											   data-filter="<?php echo $term->slug; ?>"
											   class="<?php echo $active_cat == $term->slug ? 'active' : '' ?>">
												<span class="title"><?php echo $term->name; ?></span>
												<?php if ($settings['filter_by_categories_count'] == 'yes') {
													$count = 0;
													foreach ($posts_arr as $post_item) {
														if (in_array($term->slug, (array)$post_item['category'])) {
															$count++;
														};
													}
													?>
													<span class="count"><?php echo $count; ?></span>
												<?php } ?>
											</a>

											<?php if ($settings['filter_by_categories_hierarchy'] == 'yes') {
												$cat_args['slug'] = [];
												$cat_args['parent'] = $term->term_id;
												$child_terms = get_terms('product_cat', $cat_args);
												if ($child_terms) { ?>
													<ul>
														<?php foreach ($child_terms as $child_term) :
															array_push($filtersList['category'], $child_term->slug); ?>
															<li><a href="#"
																   data-filter-type="category"
																   data-filter="<?php echo $child_term->slug; ?>"
																   class="<?php echo $active_cat == $child_term->slug ? 'active' : '' ?>">
																	<span class="title"><?php echo $child_term->name; ?></span>
																	<?php if ($settings['filter_by_categories_count'] == 'yes') {
																		$count = 0;
																		foreach ($posts_arr as $post_item) {
																			if (in_array($child_term->slug, (array)$post_item['category'])) {
																				$count++;
																			};
																		}
																		?>
																		<span class="count"><?php echo $count; ?></span>
																	<?php } ?>
																</a>

																<?php
																$cat_args['parent'] = $child_term->term_id;
																$child_terms2 = get_terms('product_cat', $cat_args);
																if ($child_terms2) { ?>
																	<ul>
																		<?php foreach ($child_terms2 as $child_term2) :
																			array_push($filtersList['category'], $child_term2->slug); ?>
																			<li>
																				<a href="#"
																				   data-filter-type="category"
																				   data-filter="<?php echo $child_term2->slug; ?>"
																				   class="<?php echo $active_cat == $child_term2->slug ? 'active' : '' ?>">
																					<span class="title"<?php echo $child_term2->name; ?>></span>
																					<?php if ($settings['filter_by_categories_count'] == 'yes') {
																						$count = 0;
																						foreach ($posts_arr as $post_item) {
																							if (in_array($child_term2->slug, (array)$post_item['category'])) {
																								$count++;
																							};
																						}
																						?>
																						<span class="count"><?php echo $count; ?></span>
																					<?php } ?>
																				</a>
																			</li>
																		<?php endforeach; ?>
																	</ul>
																<?php }
																?>
															</li>
														<?php endforeach; ?>
													</ul>
												<?php }
											} ?>
										</li>
									<?php endforeach; ?>
								</ul>
							</div>
						</div>
					<?php } ?>

					<?php if ($settings['filter_by_attribute'] == 'yes') {
						$filter_attr = $settings['repeater_attributes'];
						$attributes_list = $this->select_products_attributes();
						foreach ($filter_attr as $index => $item) {
							if (!empty($item['attribute_name'])) {
								$attribute_label_name = $attributes_list[$item['attribute_name']];
								$filtersList[$item['attribute_name']] = [];
								?>
								<div class="filter-item attribute <?php echo $item['attribute_name'] . ' '; ?><?php echo $item['attribute_query_type'] == 'and' ? 'multiple' : 'single'; ?>">
									<h4 class="name widget-title"><span
												class="by"><?php echo $settings['filter_buttons_hidden_filter_by_text']; ?> </span><?php echo $item['attribute_title'] ?>
										<span class="arrow gem-elegant arrow-carrot-down"></span>
									</h4>
									<div class="list">
										<ul>
											<li>
												<a href="#"
												   data-filter-type="attribute"
												   data-attr="<?php echo $item['attribute_name']; ?>"
												   data-filter="*"
												   class="all <?php echo !isset($attributes_url[$item['attribute_name']]) ? 'active' : '' ?>">
													<span class="title"><?php echo $settings['filters_text_labels_all_text']; ?></span>
												</a>
											</li>
											<?php
											$terms = get_terms('pa_' . $item['attribute_name']);
											if (!empty($terms) && !is_wp_error($terms)) {
												foreach ($terms as $term) :
													if (isset($attributes[$item['attribute_name']])) {
														$attr_arr = $attributes[$item['attribute_name']];
														if (!in_array('0', $attr_arr, true) && !empty($attr_arr)) {
															if (!in_array($term->slug, $attr_arr, true)) {
																continue;
															}
														}
													};
													array_push($filtersList[$item['attribute_name']], $term->slug);
													?>
													<li><a href="#"
														   data-filter-type="attribute"
														   data-attr="<?php echo $item['attribute_name']; ?>"
														   data-filter="<?php echo $term->slug; ?>"
														   class="<?php echo isset($attributes_url[$item['attribute_name']]) && in_array($term->slug, $attributes_url[$item['attribute_name']]) ? 'active' : '' ?>">
															<span class="title"><?php echo $term->name; ?></span>
															<?php if ($settings['filter_by_attribute_count'] == 'yes') {
																$count = 0;
																foreach ($posts_arr as $post_item) {
																	if (in_array($term->slug, (array)$post_item[$item['attribute_name']])) {
																		$count++;
																	};
																}
																?>
																<span class="count"><?php echo $count; ?></span>
															<?php } ?>
														</a>
													</li>
												<?php endforeach;
											}
											?>
										</ul>
									</div>
								</div>
							<?php }
						}
					} ?>

					<?php if ($settings['filter_by_price'] == 'yes') {
						$price_range = thegem_get_extended_product_price_range($featured_only, $sale_only, $categories, $attributes); ?>
						<div class="filter-item">
							<h4 class="name widget-title"><span
										class="by"><?php echo $settings['filter_buttons_hidden_filter_by_text']; ?> </span><?php echo $settings['filter_by_price_title']; ?>
								<span class="arrow gem-elegant arrow-carrot-down"></span>
							</h4>
							<div class="list">
								<div class="price-range-slider">
									<div class="slider-range"
										 data-min="<?php echo($price_range['min']); ?>"
										 data-max="<?php echo($price_range['max']); ?>"
										 data-currency="<?php echo get_woocommerce_currency_symbol(); ?>"></div>
									<div class="slider-amount"><span
												class="text"><?php echo __('Price:', 'thegem'); ?> </span><span
												class="amount"></span></div>
								</div>
							</div>
						</div>
					<?php } ?>

					<?php if ($settings['filter_by_status'] == 'yes') {
						$filtersList['status'] = []; ?>
						<div class="filter-item multiple">
							<h4 class="name widget-title"><span
										class="by"><?php echo $settings['filter_buttons_hidden_filter_by_text']; ?> </span><?php echo $settings['filter_by_status_title']; ?>
								<span class="arrow gem-elegant arrow-carrot-down"></span>
							</h4>
							<div class="list">
								<ul>
									<li>
										<a href="#" data-filter="*"
										   data-filter-type="status"
										   class="active all"><?php echo $settings['filters_text_labels_all_text']; ?>
										</a>
									</li>
									<?php if ($settings['filter_by_status_sale'] == 'yes') {
										array_push($filtersList['status'], 'sale'); ?>
										<li><a href="#"
											   data-filter-type="status"
											   data-filter="sale">
												<span class="title"><?php echo $settings['filter_by_status_sale_text']; ?></span>
												<?php if ($settings['filter_by_status_count'] == 'yes') {
													$count = 0;
													foreach ($posts_arr as $post_item) {
														if (in_array('sale', (array)$post_item['status'])) {
															$count++;
														};
													}
													?>
													<span class="count"><?php echo $count; ?></span>
												<?php } ?>
											</a>
										</li>
									<?php }
									if ($settings['filter_by_status_stock'] == 'yes') {
										array_push($filtersList['status'], 'stock'); ?>
										<li><a href="#"
											   data-filter-type="status"
											   data-filter="stock">
												<span class="title"><?php echo $settings['filter_by_status_stock_text']; ?></span>
												<?php if ($settings['filter_by_status_count'] == 'yes') {
													$count = 0;
													foreach ($posts_arr as $post_item) {
														if (in_array('stock', (array)$post_item['status'])) {
															$count++;
														};
													}
													?>
													<span class="count"><?php echo $count; ?></span>
												<?php } ?>
											</a>
										</li>
									<?php } ?>
								</ul>
							</div>
						</div>
					<?php }

					$preset_path = __DIR__ . '/selected-filters.php';
					if (!empty($preset_path) && file_exists($preset_path)) {
						include($preset_path);
					} ?>
				</div>
			</div>
			<div class="close-filters"
				 data-posts='<?php echo json_encode($posts_arr); ?>'
				 data-filters-list='<?php echo json_encode($filtersList); ?>'></div>
		</div>

	</div>

<?php endif;