<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class SharedVariables
 * @package uncanny_learndash_groups
 */
class SharedVariables {

	/**
	 * User invitation email subject
	 *
	 * @return string
	 */
	public static function ulgm_term_condition() {

		$string = get_option( 'ulgm_term_condition', false );

		if ( ! $string ) {
			$string = '';
		}

		return stripslashes( $string );
	}

	/**
	 * User invitation email subject
	 *
	 * @return string
	 */
	public static function user_invitation_email_subject() {

		$string = get_option( 'ulgm_invitation_user_email_subject', false );

		if ( ! $string ) {
			$string = __( 'You have been invited to join #SiteUrl', 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * User invitation email body
	 *
	 * @return string
	 */
	public static function user_invitation_email_body() {

		$string = get_option( 'ulgm_invitation_user_email_body', false );

		if ( ! $string ) {
			$string = __( "You have been invited to join #SiteUrl! To accept your invitation, click the link below:\n[Insert registration page link here]\n\nEnter the following code on the registration form to activate your account:\n#RedemptionKey\n\nEnjoy, and welcome to the site!", 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * User welcome email subject
	 *
	 * @return string
	 */
	public static function user_welcome_email_subject() {

		$string = get_option( 'ulgm_user_welcome_email_subject', false );

		if ( ! $string ) {
			$string = __( 'You have been added to #SiteUrl', 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * UUser welcome email body
	 *
	 * @return string
	 */
	public static function user_welcome_email_body() {

		$string = get_option( 'ulgm_user_welcome_email_body', false );

		if ( ! $string ) {
			$string = __( "Hi #FirstName,\n\nYou have been added to #SiteUrl.\n\nYour login credentials are:\nLogin: #Username\nPassword: #Password\n\nTo log in, click the link below:\n#LoginUrl\n\n Thanks!", 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * Exiting user welcome email subject
	 *
	 * @return string
	 */
	public static function exiting_user_welcome_email_subject() {

		$string = get_option( 'ulgm_existing_user_welcome_email_subject', false );

		if ( ! $string ) {
			$string = __( 'You have been added to a new group on #SiteUrl', 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * Existing user welcome email body
	 *
	 * @return string
	 */
	public static function exiting_user_welcome_email_body() {

		$string = get_option( 'ulgm_existing_user_welcome_email_body', false );

		if ( ! $string ) {
			$string = __( "Hi #FirstName,\n\nYou have been added to a new group on #SiteUrl!\n\nTo access your new courses, log in here:\n#LoginUrl\n\nThanks!", 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * Group leader welcome email subject
	 *
	 * @return string
	 */
	public static function group_leader_welcome_email_subject() {

		$string = get_option( 'ulgm_group_leader_welcome_email_subject', false );

		if ( ! $string ) {
			$string = __( 'You have been added as a group leader on #SiteUrl', 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * Group leader welcome email body
	 *
	 * @return string
	 */
	public static function group_leader_welcome_email_body() {

		$string = get_option( 'ulgm_group_leader_welcome_email_body', false );

		if ( ! $string ) {
			$string = __( "Hi #FirstName,\n\nYou have been added as a group leader on #SiteUrl.\n\nYour login credentials are:\nLogin: #Username\nPassword: #Password\n\nTo log in, click the link below:\n#LoginUrl", 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}


	/**
	 * Existing group leader welcome email subject
	 *
	 * @return string
	 */
	public static function existing_group_leader_welcome_email_subject() {

		$string = get_option( 'ulgm_existing_group_leader_welcome_email_subject', false );

		if ( ! $string ) {
			$string = __( 'You have been promoted to group leader on #SiteUrl', 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}

	/**
	 * Existing group leader welcome email body
	 *
	 * @return string
	 */
	public static function existing_group_leader_welcome_email_body() {

		$string = get_option( 'ulgm_existing_group_leader_welcome_email_body', false );

		if ( ! $string ) {
			$string = __( "Hi #FirstName,\n\nYou have been promoted to leader of a group on #SiteUrl.\n\nYour login credentials are:\nLogin: #Username\nPassword: #Password\n\nTo log in, click the link below:\n#LoginUrl", 'uncanny-learndash-groups' );
		}

		return stripslashes( $string );
	}
}
