<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class SharedFunctions
 * @package uncanny_learndash_groups
 */
class SharedFunctions {

	static $chars = '123456789ABCDEFGHJKMNPQRSTUVWXTZabcdefghjkmnopqrstuvwxyz';
	static $code_group_id_meta_key = '_ulgm_code_group_id';
	static $license_meta_field = '_ulgm_license';
	static $group_name_field = '_ulgm_group_name';
	static $course_meta_field = '_ulgm_course';
	static $db_group_tbl = 'ulgm_group_details';
	static $db_group_codes_tbl = 'ulgm_group_codes';
	static $linked_group_id_meta = '_ulgm_linked_group_id';
	static $bulk_discount_options = '_ulgm_bulk_discount';
	static $group_management_page_id = false;
	static $group_report_page_id = false;
	static $group_quiz_report_page_id = false;
	static $group_manage_progress_report_page_id = false;
	static $group_assignment_report_page_id = false;
	static $group_essay_report_page_id = false;
	static $buy_courses_page_id = false;

	/**
	 * Total amount of seats left
	 *
	 * @param int $group_id
	 *
	 * @return int $total_seats
	 */
	public static function total_seats( $group_id ) {

		$total_seats = get_post_meta( $group_id, '_ulgm_total_seats', true );

		// TESTING
		return absint( $total_seats );
	}

	/**
	 * Total amount of seats left
	 *
	 * @param int $group_id
	 *
	 * @return int $seats_remaining
	 */
	public static function remaining_seats( $group_id ) {
		global $wpdb;
		$seats_remaining = 0;
		$code_group_id   = get_post_meta( $group_id, '_ulgm_code_group_id', true );
		if ( $code_group_id ) {
			$qry       = $wpdb->prepare(
				'SELECT COUNT(ID) AS remaining FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE student_id IS NULL AND user_email IS NULL AND group_id = %d ', $code_group_id
			);
			$available = $wpdb->get_var( $qry );

			if ( $available ) {
				$seats_remaining = $available;
			}
		}

		// TESTING
		return absint( $seats_remaining );
	}

	/**
	 * @param $qty
	 *
	 * @return array
	 */
	public static function generate_random_codes( $qty ) {
		$codes = [];
		for ( $i = 0; $i < $qty; $i ++ ) {
			$codes[] = self::random_string();
		}

		//First Pass
		$codes = self::verify_uniqueness_of_codes( $codes );
		if ( count( $codes ) !== $qty ) {
			$diff = $qty - count( $codes );
			for ( $i = 0; $i < $diff; $i ++ ) {
				$codes[] = self::random_string();
			}
		}

		//Second Pass
		/*$codes = self::verify_uniqueness_of_codes( $codes );
		if ( count( $codes ) !== $qty ) {
			$diff = $qty - count( $codes );
			for ( $i = 0; $i < $diff; $i ++ ) {
				$codes[] = self::random_string();
			}
		}*/

		return $codes;
	}

	/**
	 * @return string
	 */
	public static function random_string() {
		$string = '';
		for ( $i = 0; $i < 8; $i ++ ) {
			$string .= SharedFunctions::$chars[ mt_rand( 0, strlen( SharedFunctions::$chars ) - 1 ) ];
		}

		return $string;
	}

	/**
	 * @param $codes
	 *
	 * @return array
	 */
	public static function verify_uniqueness_of_codes( $codes ) {
		global $wpdb;
		$verified = [];
		if ( count( $codes ) > 2500 ) {
			$chunks = array_chunk( $codes, 2500, true );
			if ( $chunks ) {
				foreach ( $chunks as $chunk ) {
					$results = $wpdb->get_col( "SELECT code FROM $wpdb->prefix" . SharedFunctions::$db_group_codes_tbl . " WHERE code IN ('" . implode( "','", $chunk ) . "')" );
					if ( $results ) {
						foreach ( $results as $r ) {
							//$code_exists      = $r->code;
							$sani_code_exists = sanitize_title( $r->code );
							unset( $chunk[ $sani_code_exists ] );
							$new_code                             = self::random_string();
							$chunk[ sanitize_title( $new_code ) ] = $new_code;
						}
					}
				}

				if ( $chunks ) {
					foreach ( $chunks as $chunk ) {
						$verified = array_merge( $verified, $chunk );
					}
				}
			}
		} else {
			$results = $wpdb->get_col( "SELECT code FROM $wpdb->prefix" . SharedFunctions::$db_group_codes_tbl . " WHERE code IN ('" . implode( "','", $codes ) . "')" );
			if ( $results ) {
				foreach ( $results as $r ) {
					$sani_code_exists = sanitize_title( $r->code );
					unset( $codes[ $sani_code_exists ] );
					$new_code                             = self::random_string();
					$codes[ sanitize_title( $new_code ) ] = $new_code;
				}
			}
			$verified = $codes;
		}

		return $verified;
	}

	/**
	 * Total amount of available seats
	 *
	 * @param int $group_id
	 *
	 * @return int $available_seats
	 */
	public static function available_seats( $group_id ) {


		//$available_seats = self::total_seats( $group_id ) - self::remaining_seats( $group_id );
		$available_seats = self::remaining_seats( $group_id );

		// TESTING
		return $available_seats;
	}

	/**
	 * @param $group_id
	 *
	 * @return array
	 */
	//TODO:: Modify this to return multiple order ids
	public static function get_product_id_from_group_id( $group_id = null ) {
		if ( is_user_logged_in() && is_numeric( $group_id ) ) {
			global $wpdb;
			$results                   = array();
			$code_group_id             = get_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, true );
			$results['codes_group_id'] = $code_group_id;
			if ( is_numeric( $code_group_id ) ) {
				$qry           = $wpdb->prepare( "SELECT order_id FROM {$wpdb->prefix}" . SharedFunctions::$db_group_tbl . " WHERE ID = %d AND order_id IS NOT NULL", $code_group_id );
				$orders_id_arr = $wpdb->get_row( $qry );
				//Utilities::log( $orders_id_arr, '$orders_id_arr', true, 'results1' );
				if ( $orders_id_arr ) {
					$results['order_id'] = $orders_id_arr->order_id;
				}
			}
			/**/
			if ( $results ) {
				//Utilities::log( $results, '$results', true, 'results1' );
				if ( key_exists( 'order_id', $results ) ) {
					$order_id = (int) $results['order_id'];
				} else {
					$order_id = 0;
				}
				$code_group_id = (int) $results['codes_group_id'];
				$order         = wc_get_order( $order_id );
				$product_id    = 0;
				if ( $order ) {
					$line_items = $order->get_items( 'line_item' );

					if ( $line_items ) {
						foreach ( $line_items as $line_item ) {
							$_product = $line_item->get_product();
							if ( $_product instanceof \WC_Product && $_product->is_type( 'license' ) ) {
								$product_id = $line_item['product_id'];
							}
						}
					}
				}
				$return = array(
					'order_id'      => $order_id,
					'code_group_id' => $code_group_id,
					'product_id'    => $product_id,
				);

				//Utilities::log( $return, '$return', true, '$return' );

				return $return;
			}
		}
	}

	/**
	 * @param $group_id
	 *
	 * @param null $product_id
	 *
	 * @return array|bool
	 */
	public static function get_group_leader_all_orders( $group_id, $product_id = null ) {
		if ( is_user_logged_in() ) {
			global $wpdb;
			if ( is_numeric( $product_id ) ) {
				$qry = $wpdb->prepare( "SELECT wpp.order_item_id as OrderPrimaryID,wpp.order_id as OrderID,
           								wpm.meta_value as OrderProductId,wpsot.post_author as OrderPostAuthor,
           								wpu.ID as OrderUserID,wpu.user_email as OrderUserEmail 
									    FROM {$wpdb->prefix}woocommerce_order_items as wpp 
									    INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta as wpm ON wpp.order_item_id=wpm.order_item_id 
									    INNER JOIN {$wpdb->posts} wpsot ON wpp.order_id=wpsot.ID 
									    INNER JOIN {$wpdb->postmeta} wppostmeta ON wpp.order_id=wppostmeta.post_id 
									    INNER JOIN {$wpdb->users} wpu ON wppostmeta.meta_value=wpu.ID 
									    WHERE wpm.meta_key='_product_id' AND wppostmeta.meta_key='_customer_user'
									    AND wpu.ID = %d AND wpm.meta_value = %d", wp_get_current_user()->ID, $product_id );
				//Utilities::log( $qry, 'Qry', true, 'qry' );
				$results = $wpdb->get_results( $qry );
				if ( $results ) {
					$order_ids = array();
					foreach ( $results as $r ) {
						$order_ids[] = $r->OrderID;
					}

					return $order_ids;
				}
			} else {
				$qry = $wpdb->prepare(
					'SELECT post_id FROM ' . $wpdb->postmeta . ' WHERE meta_key LIKE %s AND meta_value = %d', SharedFunctions::$linked_group_id_meta, $group_id
				);
				//Utilities::log( $qry, 'Qry', true, 'qry' );
				$results = $wpdb->get_results( $qry );
				if ( $results ) {
					$order_ids = array();
					foreach ( $results as $r ) {
						$order_ids[] = $r->post_id;
					}

					return $order_ids;
				}
			}
		}

		return false;
	}

	/**
	 *
	 * @param null $group_id
	 * @param int $limit
	 *
	 * @param int $user_id
	 * @param int $order_id
	 *
	 * @param bool $is_cron
	 *
	 * @return array|bool
	 */
	public static function get_sign_up_code_from_group_id( $group_id = null, $limit = 1, $user_id = 0, $order_id = 0, $is_cron = false ) {

		if ( is_user_logged_in() || true === $is_cron ) {

			global $wpdb;

			if ( 0 === absint( $order_id ) ) {
				$order_id = self::get_order_id_from_group_id( $group_id );
			}
			//Utilities::log( $order_id, '$order_id', true, 'api' );

			if ( $order_id ) {

				$admin_created_group = get_post_meta( $group_id, '_ulgm_is_custom_group_created', true );

				if ( 'yes' === $admin_created_group ) {
					$codes_group_id = $wpdb->get_var(
						$wpdb->prepare(
							'SELECT ID FROM ' . $wpdb->prefix . SharedFunctions::$db_group_tbl . ' WHERE order_id = %d', $order_id
						)
					);
					//$codes_group_id = $order_id;
				} else {
					$codes_group_id = get_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, true );
				}
				$sql = $wpdb->prepare(
					'SELECT code FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE student_id IS NULL AND user_email IS NULL AND code_status LIKE "available" AND group_id = %d ORDER BY RAND() LIMIT %d', $codes_group_id, $limit
				);
				//Utilities::log( $sql, '$sql', true, 'api' );

				$code = $wpdb->get_col(
					$wpdb->prepare(
						'SELECT code FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE student_id IS NULL AND user_email IS NULL AND code_status LIKE "available" AND group_id = %d ORDER BY RAND() LIMIT %d', $codes_group_id, $limit
					)
				);
				//Utilities::log( $code, '$code', true, 'api' );
				if ( $code ) {
					if ( 1 === $limit ) {
						return $code[0];
					} else {
						return $code;
					}
				}
			}
		}

		return false;
	}

	/**
	 * @param $group_id
	 *
	 * @return array|bool|null|object
	 */
	public static function get_codes_for_download_csv( $group_id ) {
		if ( is_user_logged_in() && ! empty( $group_id ) ) {

			global $wpdb;
			$user_group_ids = learndash_get_administrators_group_ids( wp_get_current_user()->ID, true );

			// Does user have administrative access
			if ( ! in_array( $group_id, $user_group_ids ) ) {
				return false;
			}

			$order_id = self::get_order_id_from_group_id( $group_id );

			if ( $order_id ) {

				$admin_created_group = get_post_meta( $group_id, '_ulgm_is_custom_group_created', true );

				if ( 'yes' === $admin_created_group ) {
					// Group was created in wp-admin
					$codes_group_id = absint( get_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, true ) );
				} else {
					$codes_group_id = get_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, true );
				}

				$codes = $wpdb->get_results(
					$wpdb->prepare(
						"SELECT gd.group_name, gc.code
							FROM {$wpdb->prefix}" . SharedFunctions::$db_group_tbl . " gd
							LEFT JOIN {$wpdb->prefix}" . SharedFunctions::$db_group_codes_tbl . " gc
							ON gd.ID = gc.group_id
							WHERE gd.ID = %d AND student_id IS NULL AND user_email IS NULL LIMIT 0, 9000", $codes_group_id
					), ARRAY_A
				);

				if ( $codes ) {
					return $codes;
				}
			}
		}

		return false;
	}

	/**
	 * @param null $group_id
	 *
	 * @return bool|\WP_Post
	 */
	public static function get_order_id_from_group_id( $group_id = null ) {

		if ( is_user_logged_in() ) {

			$admin_created_group = get_post_meta( $group_id, '_ulgm_is_custom_group_created', true );

			if ( 'yes' === $admin_created_group ) {
				global $wpdb;
				// Group was created in wp-admin
				$code_group_id = absint( get_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, true ) );
				$order_id      = $wpdb->get_var( $wpdb->prepare( "SELECT order_id FROM {$wpdb->prefix}" . SharedFunctions::$db_group_tbl . " WHERE ID = %d", $code_group_id ) );
				//Utilities::log( $code_group_id, '$code_group_id', true, 'save' );
				if ( $order_id ) {
					return $order_id;
				}

				return false;

			} else {

				// If its wasn't created in the wp-admin page then it must have been a woo-order

				$args = array(
					'post_type'   => 'shop_order',
					'post_status' => 'wc-completed',
					'fields'      => 'ids',
					'meta_query'  => array(
						'relation' => 'AND',
						array(
							'key'     => SharedFunctions::$linked_group_id_meta,
							'value'   => $group_id,
							'type'    => 'numeric',
							'compare' => '=',
						),
						/*array(
							'key'     => '_customer_user',
							'value'   => wp_get_current_user()->ID,
							'type'    => 'numeric',
							'compare' => '=',
						),*/
						array(
							'key'     => 'parent_order_id',
							'compare' => 'NOT EXISTS',
						),
					),
				);


				$posts = get_posts( $args );
				if ( $posts ) {
					foreach ( $posts as $post ) {
						//assuming there'll be only 1 post for a single group.
						return $post;
					}
				}


			}

		}

		return false;
	}

	/**
	 * @param null $code
	 *
	 * @return bool
	 */
	public static function sign_up_code_available( $code = null ) {
		if ( ! empty( $code ) ) {
			global $wpdb;
			$verify = $wpdb->get_var(
				$wpdb->prepare(
					'SELECT student_id FROM  ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE student_id IS NULL AND code LIKE %s', $code
				)
			);

			if ( $verify ) {
				return true;
			} else {
				return false;
			}
		}
	}


	/**
	 * @param null $code
	 *
	 * @return bool|mixed
	 */
	public static function get_group_id_from_code( $code = null ) {
		if ( ! empty( $code ) ) {
			global $wpdb;
			$order_id = $wpdb->get_var(
				$wpdb->prepare(
					'SELECT g.order_id FROM  ' . $wpdb->prefix . SharedFunctions::$db_group_tbl . ' g 
					LEFT JOIN ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' gc 
					ON g.ID = gc.group_id
					WHERE code LIKE %s', $code
				)
			);

			if ( $order_id ) {
				return get_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, true );
			} else {
				return false;
			}
		}
	}

	/**
	 * @param $code
	 *
	 * @return bool|mixed
	 * @internal param $order_id
	 * @internal param $user_id
	 *
	 * @internal param null $code
	 */
	public static function get_codes_group_id_from_code( $code ) {
		if ( ! empty( $code ) ) {
			global $wpdb;
			$prepare = $wpdb->prepare(
				"SELECT group_id FROM {$wpdb->prefix}" . SharedFunctions::$db_group_codes_tbl . " WHERE code = %s", $code
			);
			//Utilities::log( $prepare, '$prepare', true, 'api' );
			$code_group_id = $wpdb->get_var( $prepare );

			if ( $code_group_id ) {
				return $code_group_id;
			} else {
				return false;
			}
		}
	}

	/**
	 * Get the page id of the report page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_group_report_page_id( $url = false ) {

		if ( ! self::$group_report_page_id ) {
			self::$group_report_page_id = get_option( 'ulgm_group_report_page' );
		}

		// Return URL
		if ( $url ) {
			$permalink = get_permalink( (int) self::$group_report_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$group_report_page_id;
	}

	/**
	 * Get the page id of the quiz report page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_group_quiz_report_page_id( $url = false ) {

		if ( ! self::$group_quiz_report_page_id ) {
			self::$group_quiz_report_page_id = get_option( 'ulgm_group_quiz_report_page' );
		}

		// Return URL
		if ( $url ) {
			$permalink = get_permalink( (int) self::$group_quiz_report_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$group_quiz_report_page_id;
	}

	/**
	 * Get the page id of the quiz report page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_group_manage_progress_report_page_id( $url = false ) {

		if ( ! self::$group_manage_progress_report_page_id ) {
			self::$group_manage_progress_report_page_id = get_option( 'ulgm_group_manage_progress_page' );
		}

		// Return URL
		if ( $url && ! empty( self::$group_manage_progress_report_page_id ) ) {
			$permalink = get_permalink( (int) self::$group_manage_progress_report_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$group_manage_progress_report_page_id;
	}

	/**
	 * Get the page id of the Assignment report page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_group_assignment_report_page_id( $url = false ) {

		if ( ! self::$group_assignment_report_page_id ) {
			self::$group_assignment_report_page_id = get_option( 'ulgm_group_assignment_report_page' );
		}

		// Return URL
		if ( $url ) {
			$permalink = get_permalink( (int) self::$group_assignment_report_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$group_assignment_report_page_id;
	}

	/**
	 * Get the page id of the Essay report page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_group_essay_report_page_id( $url = false ) {

		if ( ! self::$group_essay_report_page_id ) {
			self::$group_essay_report_page_id = get_option( 'ulgm_group_essay_report_page' );
		}

		// Return URL
		if ( $url ) {
			$permalink = get_permalink( (int) self::$group_essay_report_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$group_essay_report_page_id;
	}

	/**
	 * Get the page id of the buy courses page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_buy_courses_page_id( $url = false ) {

		if ( ! self::$buy_courses_page_id ) {
			self::$buy_courses_page_id = get_option( 'ulgm_group_buy_courses_page' );
		}

		// Return URL
		if ( $url ) {
			$permalink = get_permalink( (int) self::$buy_courses_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$buy_courses_page_id;
	}

	/**
	 * Get the page id of the group management page
	 *
	 * @param bool $url Return url of page
	 *
	 * @return int/string Page ID or the URL
	 */
	public static function get_group_management_page_id( $url = false ) {

		if ( ! self::$group_management_page_id ) {
			self::$group_management_page_id = get_option( 'ulgm_group_management_page' );
		}

		// Return URL
		if ( $url ) {
			$permalink = get_permalink( (int) self::$group_management_page_id );

			if ( $permalink ) {
				return $permalink;
			} else {
				return '';
			}
		}

		// Return ID
		return (int) self::$group_management_page_id;
	}

	/**
	 * Get the add to cart link for extra seats in a group
	 *
	 * @param int $group_id
	 * @param int $amount_seats
	 *
	 * @return string $link Link to add seats to cart
	 */
	public static function add_group_seats_link( $group_id, $amount_seats ) {

		$site = site_url();

		$link = "$site?modify-group=true&modify-group-id=$group_id&new-qty=$amount_seats";

		return $link;

	}

	/**
	 * Get the add to cart link for extra seats in a group
	 *
	 * @param int $group_id
	 *
	 * @return string $link Link to add seats to cart
	 * @internal param int $amount_seats
	 *
	 */
	public static function add_buy_courses_link( $group_id ) {
		$link       = self::get_buy_courses_page_id( true );
		$product_id = self::get_product_id_from_group_id( $group_id );
		$link       .= '?modify-license=' . $product_id['product_id'] . "&group-id={$group_id}&_wpnonce=" . wp_create_nonce( Utilities::get_plugin_name() );

		return $link;

	}

	/**
	 * @param $code
	 * @param null $user_id
	 * @param null $order_id
	 * @param null $code_status available || pending || redeemed
	 *
	 * @param null $group_id
	 * @param null $user_email
	 *
	 * @return null
	 */
	public static function set_sign_up_code_status( $code, $user_id = null, $order_id = null, $code_status = null, $group_id = null, $user_email = null ) {

		global $wpdb;

		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}

		if ( empty( $code ) || null === $code_status ) {
			return null;
		} else {

			//Making sure that we have code_status column available
			Database::alter_db_table();

			$success = false;

			if ( null !== $code_status ) {
				$update = $wpdb->update(
					$wpdb->prefix . Database::$group_codes_tbl,
					array( 'code_status' => $code_status ),
					array( 'code' => $code ),
					array( '%s' ),
					array( '%s' )
				);

				if ( $update ) {
					$success = true;
				} else {
					$success = false;
				}

			}

			if ( null !== $user_id ) {
				$update = $wpdb->update(
					$wpdb->prefix . Database::$group_codes_tbl,
					array( 'student_id' => $user_id, 'used_date' => date( 'Y-m-d H:i:s', time() ) ),
					array( 'code' => $code ),
					array( '%d', '%s' ),
					array( '%s' )
				);

				if ( $update ) {
					$success = true;
				} else {
					$success = false;
				}

			}
			if ( null !== $user_email ) {
				$update = $wpdb->update(
					$wpdb->prefix . Database::$group_codes_tbl,
					array( 'user_email' => $user_email, ),
					array( 'code' => $code ),
					array( '%s' ),
					array( '%s' )
				);

				if ( $update ) {
					$success = true;
				} else {
					$success = false;
				}

			}

			if ( $success && null !== $user_id ) {
				update_user_meta( $user_id, 'uo_code_status', $code );
			}

			return $success;

		}
	}

	/**
	 * @param $user_id
	 * @param $group_id
	 */
	public static function redeem_all_pending_group_codes( $user_id, $group_id ) {

		if ( empty( trim( $group_id ) ) || is_null( trim( $group_id ) ) ) {
			return;
		}

		if ( ! is_numeric( trim( $group_id ) ) ) {
			return;
		}

		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}

		//Making sure that we have code_status column available
		Database::alter_db_table();

		global $wpdb;

		$time  = current_time( 'mysql' );
		$table = $wpdb->prefix . Database::$group_codes_tbl;
		$query = $wpdb->prepare( "UPDATE {$table} SET code_status = %s, used_date = %s WHERE student_id = %d AND code_status = %s AND group_id = %d", 'redeemed', "$time", $user_id, 'not redeemed', $group_id );

		$wpdb->query( $query );

		update_user_meta( $user_id, 'uo_code_status', 'redeemed' );

	}

	/**
	 * @param $code
	 * @param null $group_id
	 * @param bool $replace
	 *
	 * @return null
	 */
	public static function remove_sign_up_code( $code, $group_id = null, $replace = false ) {
		global $wpdb;
		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}

		if ( null === $group_id ) {
			$group_id = self::get_group_id_from_code( $code );
		}
		if ( empty( $code ) ) {
			return null;
		} else {
			if ( false === $replace ) {
				$wpdb->delete( $wpdb->prefix . Database::$group_codes_tbl, array(
					'code' => $code,
				), array( '%s' ) );
			} else {
				$new_code = self::generate_random_codes( 1 );
				if ( $new_code ) {
					$new_code = $new_code[0];

					//Update to change from php null to mysql NULL
					$wpdb->query( "UPDATE " . $wpdb->prefix . Database::$group_codes_tbl . " 
									SET code='$new_code', 
										code_status = 'available', 
										used_date = NULL, 
										student_id = NULL, 
										user_email = NULL 
										WHERE code='" . trim( $code ) . "'" );

					/*$wpdb->update(
						$wpdb->prefix . Database::$group_codes_tbl,
						array(
							'code'        => $new_code,
							'code_status' => 'available',
							'used_date'   => null,
							'student_id'  => null,
							'user_email'  => null,
						),
						array( 'code' => $code )
					);*/
				}
			}
		}

		return null;
	}

	/**
	 * Return the code data for a user with a group
	 *
	 * @param $user_id
	 * @param $group_id
	 *
	 * @return mixed
	 */
	public static function get_user_code( $user_id, $group_id ) {

		$code_data = null;

		// Get associated order ID from LD group ID
		$order_id = absint( self::get_order_id_from_group_id( $group_id ) );

		// No associated codes found
		if ( empty( $order_id ) ) {
			return $code_data;
		}
		if ( $order_id ) {

			$admin_created_group = get_post_meta( $group_id, '_ulgm_is_custom_group_created', true );

			if ( 'yes' === $admin_created_group ) {
				// Group was created in wp-admin
				$codes_group_id = absint( get_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, true ) );
			} else {
				$codes_group_id = get_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, true );
			}

			// Value didn't validate as a number
			if ( ! $codes_group_id ) {
				return $code_data;
			}
			global $wpdb;

			if ( ! class_exists( 'Database' ) ) {
				include_once( Utilities::get_include( 'database.php' ) );
			}

			$group_codes_tbl = Database::$group_codes_tbl;

			$code_data = $wpdb->get_var( $wpdb->prepare( "SELECT code FROM {$wpdb->prefix}{$group_codes_tbl} WHERE group_id = %d AND student_id = %d", $codes_group_id, $user_id ) );
			if ( $code_data ):
				return $code_data;
			endif;
		}
	}

	/**
	 * @param string $all
	 * @param null $cache
	 * @param null $user_id
	 */
	public static function remove_transient_cache( $all = 'no', $cache = null, $user_id = null ) {
		if ( null === $user_id ) {
			$user_id = wp_get_current_user()->ID;
		}
		//Utilities::log( $user_id, '$user_id', true, 'transient_logs' );
		//Utilities::log( $cache, '$cache', true, 'transient_logs' );
		if ( 'no' === $all ) {
			$cache = str_replace( 'USERID', $user_id, $cache );
			//Utilities::log( $cache, '$cache---after', true, 'transient_logs' );

			delete_transient( $cache );
		} elseif ( 'yes' === $all ) {
			delete_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
			delete_transient( '_ulgm_user_' . $user_id . '_order' );
		}
	}

	/**
	 * @param $cache
	 * @param array $data
	 * @param int $time
	 * @param null $user_id
	 */
	public static function set_transient_cache( $cache, $data = array(), $user_id = null, $time = 360 ) {
		if ( null === $user_id ) {
			$user_id = wp_get_current_user()->ID;
		}
		$cache = str_replace( 'USERID', $user_id, $cache );
		set_transient( $cache, $data, $time * MINUTE_IN_SECONDS );
	}

	/**
	 * @param $product_id
	 *
	 * @return int
	 */
	public static function get_orders_from_product_id( $product_id ) {
		global $wpdb;
		$results = $wpdb->get_results( $wpdb->prepare( "SELECT DISTINCT wpp.order_id as OrderID           
										FROM {$wpdb->prefix}woocommerce_order_items as wpp 
										    INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta as wpm ON wpp.order_item_id=wpm.order_item_id 
										    INNER JOIN {$wpdb->postmeta} wppostmeta ON wpp.order_id=wppostmeta.post_id 
										    WHERE wpm.meta_key='_product_id' AND wpm.meta_value = %d", $product_id ) );

		if ( $results ) {
			return count( $results );
		} else {
			return 0;
		}
	}

	/**
	 * @param $code
	 * @param $group_id
	 * @param int $user_id
	 *
	 * @return bool|null|string
	 */
	public static function get_temp_email_from_code( $code, $group_id, $user_id = 0 ) {
		if ( is_user_logged_in() ) {

			global $wpdb;

			if ( 0 === absint( $user_id ) ) {
				$user_group_ids = learndash_get_administrators_group_ids( wp_get_current_user()->ID, true );
			} else {
				$user_group_ids = learndash_get_administrators_group_ids( $user_id, true );
			}

			// Does user have administrative access
			if ( ! in_array( $group_id, $user_group_ids ) ) {
				return false;
			}
			if ( empty( $code ) || empty( $group_id ) ) {
				return false;
			}


			$order_id = self::get_order_id_from_group_id( $group_id );


			if ( $order_id ) {

				$admin_created_group = get_post_meta( $group_id, '_ulgm_is_custom_group_created', true );

				if ( 'yes' === $admin_created_group ) {
					$codes_group_id = $wpdb->get_var(
						$wpdb->prepare(
							'SELECT ID FROM ' . $wpdb->prefix . SharedFunctions::$db_group_tbl . ' WHERE order_id = %d', $order_id
						)
					);
					//$codes_group_id = $order_id;
				} else {
					$codes_group_id = get_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, true );
				}

				$user_email = $wpdb->get_var( $wpdb->prepare( 'SELECT user_email FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE code LIKE %s AND group_id = %d AND code_status LIKE %s', $code, $codes_group_id, 'not redeemed' ) );

				//Utilities::log( $user_email, '$user_email', true, 'resend' );
				if ( $user_email ) {
					return $user_email;
				}
			}
		}

		return false;
	}

	/**
	 * @param $user_email
	 * @param $group_id
	 * @param int $user_id
	 *
	 * @return bool|null|string
	 */
	public static function get_code_from_temp_email( $user_email, $group_id, $user_id = 0 ) {
		if ( is_user_logged_in() ) {

			global $wpdb;

			if ( 0 === absint( $user_id ) ) {
				$user_group_ids = learndash_get_administrators_group_ids( wp_get_current_user()->ID, true );
			} else {
				$user_group_ids = learndash_get_administrators_group_ids( $user_id, true );
			}

			// Does user have administrative access
			if ( ! in_array( $group_id, $user_group_ids ) ) {
				return false;
			}
			if ( empty( $user_email ) || empty( $group_id ) ) {
				return false;
			}


			$order_id = self::get_order_id_from_group_id( $group_id );


			if ( $order_id ) {

				$admin_created_group = get_post_meta( $group_id, '_ulgm_is_custom_group_created', true );

				if ( 'yes' === $admin_created_group ) {
					$codes_group_id = $wpdb->get_var(
						$wpdb->prepare(
							'SELECT ID FROM ' . $wpdb->prefix . SharedFunctions::$db_group_tbl . ' WHERE order_id = %d', $order_id
						)
					);
					//$codes_group_id = $order_id;
				} else {
					$codes_group_id = get_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, true );
				}

				$user_code = $wpdb->get_var( $wpdb->prepare( 'SELECT code FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE user_email LIKE %s AND group_id = %d AND code_status LIKE %s', $user_email, $codes_group_id, 'not redeemed' ) );

				//Utilities::log( $user_code, '$user_code', true, 'resend' );
				if ( $user_code ) {
					return $user_code;
				}
			}
		}

		return false;
	}

	/**
	 * @param $key
	 *
	 * @return array
	 */
	public static function is_key_available( $key ) {
		global $wpdb;
		/*$user    = wp_get_current_user();
		$user_id = $user->ID;*/
		//Modifying logic here to be able to use 1 coupon maximum times!
		$results = $wpdb->get_row( $wpdb->prepare( "SELECT gd.ld_group_id, gc.* 
											  	FROM {$wpdb->prefix}" . SharedFunctions::$db_group_codes_tbl . " gc
												LEFT JOIN {$wpdb->prefix}" . SharedFunctions::$db_group_tbl . " gd 
												ON gc.group_id = gd.ID 
												WHERE gc.code LIKE %s", $key ) );
		if ( $results ) {
			$code_id       = $results->ID;
			$student_id    = $results->student_id;
			$ld_group_id   = $results->ld_group_id;
			$code_group_id = $results->group_id;

			if ( self::remaining_seats( $ld_group_id ) === 0 ) {
				return array(
					'result' => 'failed',
					'error'  => 'seat_not_available',
				);
			}

			if ( ! empty( $student_id ) && ! is_null( $student_id ) ) {
				return array(
					'result' => 'failed',
					'error'  => 'existing',
				);
			} else {
				$return = array(
					'result'      => 'success',
					'code_id'     => $code_id,
					'ld_group_id' => $ld_group_id,
					'group_id'    => $code_group_id,
					'key'         => $key,
				);

				return $return;
			}
		} else {

			return array(
				'result' => 'failed',
				'error'  => 'invalid',
			);

		}
	}

	/**
	 * @param $user_id
	 * @param $code
	 * @param string $code_status
	 *
	 * @return bool
	 */
	public static function set_user_to_code( $user_id, $code, $code_status = 'redeemed' ) {
		if ( empty( $user_id ) || empty( $code ) ) {
			return false;
		}
		global $wpdb;
		$success = false;

		if ( null !== $code_status ) {
			$update = $wpdb->update(
				$wpdb->prefix . Database::$group_codes_tbl,
				array( 'code_status' => $code_status, 'student_id' => $user_id, 'used_date' => date( 'Y-m-d H:i:s' ) ),
				array( 'code' => $code ),
				array( '%s', '%d', '%s' ),
				array( '%s' )
			);

			if ( $update ) {
				$success = true;
			} else {
				$success = false;
			}
		}

		return $success;
	}

	/**
	 * @param $user_id
	 * @param $ld_group_id
	 *
	 * @return bool
	 */
	public static function set_user_to_group( $user_id, $ld_group_id ) {
		if ( empty( $user_id ) || empty( $ld_group_id ) ) {
			return false;
		}
		ld_update_group_access( $user_id, $ld_group_id );
		$transient_key = 'learndash_user_groups_' . $user_id;
		delete_transient( $transient_key );
	}

	/**
	 * @param $user_id
	 * @param $ld_group_id
	 *
	 * @return null|string
	 */
	public static function is_user_already_member_of_group( $user_id, $ld_group_id ) {
		// Get associated order ID from LD group ID
		$order_id = absint( self::get_order_id_from_group_id( $ld_group_id ) );

		// No associated codes found
		if ( empty( $order_id ) ) {
			return null;
		}
		if ( $order_id ) {

			$admin_created_group = get_post_meta( $ld_group_id, '_ulgm_is_custom_group_created', true );

			if ( 'yes' === $admin_created_group ) {
				// Group was created in wp-admin
				$codes_group_id = absint( get_post_meta( $ld_group_id, SharedFunctions::$code_group_id_meta_key, true ) );
			} else {
				$codes_group_id = get_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, true );
			}

			// Value didn't validate as a number
			if ( ! $codes_group_id ) {
				return null;
			}
			global $wpdb;

			if ( ! class_exists( 'Database' ) ) {
				include_once( Utilities::get_include( 'database.php' ) );
			}

			$group_codes_tbl = Database::$group_codes_tbl;

			$code_data = $wpdb->get_var( $wpdb->prepare( "SELECT code FROM {$wpdb->prefix}{$group_codes_tbl} WHERE group_id = %d AND student_id = %d", $codes_group_id, $user_id ) );
			if ( $code_data ) {
				return 'yes';
			} else {
				return 'no';
			}
		}
	}

	/**
	 * @param null $user_id
	 * @param null $group_id
	 */
	public static function delete_transient( $user_id = null, $group_id = null ) {
		if ( null !== $user_id ) {
			$transient_key = 'learndash_user_groups_' . $user_id;
			delete_transient( $transient_key );
		}

		if ( null !== $group_id ) {
			$transient_key = 'learndash_group_users_' . $group_id;
			delete_transient( $transient_key );
		}
	}
}