<?php

namespace uncanny_learndash_groups;

/**
 * Class ProcessManualGroupAdminPage
 * @package uncanny_learndash_groups
 */
class ProcessManualGroupAdminPage {
	/**
	 * ProcessManualGroupAdminPage constructor.
	 */
	function __construct() {
		add_action( 'admin_menu', array( $this, 'create_manual_group_admin_page' ), 10 );
		// Enqueue page specific styles
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'create_new_group_scripts' ), 30 );
		add_action( 'wp_ajax_search_user', array( $this, 'search_user_by_email' ), 33 );
		add_shortcode( 'uo_groups_create_group', array( $this, 'options_output' ) );
	}

	/**
	 *
	 */
	public function create_manual_group_admin_page() {

		$page_title = esc_html__( 'Uncanny LearnDash Groups', 'uncanny-learndash-groups' );
		$menu_title = esc_html__( 'Uncanny Groups', 'uncanny-learndash-groups' );
		$capability = 'manage_options';
		$menu_slug  = 'uncanny-groups-create-group';
		$function   = array( $this, 'options_output' );

		// Menu Icon blends into sidebar when the default admin color scheme is used
		$admin_color_scheme = get_user_meta( get_current_user_id(), 'admin_color', true );

		$icon_url = 'data:image/svg+xml;base64,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';

		$position = 82; // 81 - Above Settings Menu

		// Create the main page
		add_menu_page( $page_title, $menu_title, $capability, $menu_slug, $function, $icon_url, $position );

		// Create a link the main page when the menu expands
		add_submenu_page( $menu_slug, __( 'Create Group', 'uncanny-learndash-groups' ), __( 'Create Group', 'uncanny-learndash-groups' ), $capability, $menu_slug, array(
			$this,
			'options_output',
		) );
	}

	public function create_new_group_scripts() {
		global $post;
		if ( Utilities::has_shortcode( $post, 'uo_groups_create_group' ) || Utilities::has_block( $post, 'uncanny-learndash-groups/uo-groups-create-group' ) ) {
			wp_enqueue_script( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.js' ), array( 'jquery' ), Utilities::get_version(), true );

			// Load Styles for Licensing page located in general plugin styles
			wp_register_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );
			$user_colors = Utilities::user_colors();
			wp_add_inline_style( 'ulgm-frontend', $user_colors );
			wp_enqueue_style( 'ulgm-frontend', $user_colors );

			wp_enqueue_media();
		}

	}

	public function add_scripts() {
		// Load Styles for Licensing page located in general plugin styles
		wp_enqueue_style( 'ulgm-backend', Utilities::get_asset( 'backend', 'bundle.min.css' ), array(), Utilities::get_version() );

		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_register_style( 'jquery-ui-styles', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/base/jquery-ui.css' );
		wp_enqueue_style( 'jquery-ui-styles' );

		//wp_enqueue_script( 'jquery-auto-complete', Utilities::get_js( 'jquery-auto-complete.min.js' ), '', Utilities::get_version(), true );
		wp_register_script( 'ulgm-backend', Utilities::get_asset( 'backend', 'bundle.min.js' ), array( 'jquery' ), Utilities::get_version(), true );
		wp_localize_script( 'ulgm-backend', 'ajax_url', array( 'url' => admin_url( 'admin-ajax.php' ) ) );
		wp_enqueue_script( 'ulgm-backend' );

		wp_enqueue_media();

	}

	/**
	 * @param $hook
	 */
	public function admin_scripts( $hook ) {
		if ( strpos( $hook, 'uncanny-groups-create-group' ) ) {
			$this->add_scripts();
		}
	}

	/**
	 * Create Theme Options page
	 *
	 * @since 1.0.0
	 */
	function options_output( $atts = [] ) {
		global $post;

		$atts = shortcode_atts( [
			'category'        => '',
			'course_category' => '',
		], $atts, 'uo_groups_create_group' );

		if ( isset( $_GET['is-group-created'] ) ) {
			return '<h3>' . __( 'Group Created!', 'uncanny-learndash-groups' ) . '</h3>';
		}
		if ( is_user_logged_in() ) {
			$user = wp_get_current_user();
			if ( current_user_can( 'manage_options' ) || in_array( 'administrator', $user->roles ) || in_array( 'group_leader', $user->roles ) ) {
				if ( Utilities::has_shortcode( $post, 'uo_groups_create_group' ) || Utilities::has_block( $post, 'uncanny-learndash-groups/uo-groups-create-group' ) ) {
					ob_start();

					include Utilities::get_template( 'admin-custom-groups.php' );

					return ob_get_clean();
				} else {
					include Utilities::get_template( 'admin-custom-groups.php' );
				}

			} else {
				echo __( 'Oops! You are not allowed to view this page.', 'uncanny-learndash-groups' );
			}
		} else {
			echo __( 'Oops! You are not logged in to view this page.', 'uncanny-learndash-groups' );
		}

	}

	/**
	 *
	 */
	function search_user_by_email() {

		if ( isset( $_GET['term'] ) && ! empty( $_GET['term'] ) ) {
			$term = strtolower( $_GET['term'] );
		} elseif ( isset( $_GET['name'] ) && ! empty( $_GET['name'] ) ) {
			$term = strtolower( $_GET['name'] );
		} else {
			echo wp_json_encode( array() );
			die();
		}
		$suggestions = array();

		$loop = get_users( array( 'search' => "{$term}*" ) );
		foreach ( $loop as $user ) {
			$suggestions[] = $user->user_email;
		}


		$response = wp_json_encode( $suggestions );
		echo $response;
		die();

	}
}