<?php
/**
 * Adds the licensing settings.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_License_Field
 *
 * Adds the licensing settings.
 *
 * @since 1.0.0
 */
class LD_ConvertKit_License_Field {

	/**
	 * LD_ConvertKit_License_Field constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		// License Settings Section
		add_action( 'sfwd_lms-nss_license_footer', array( $this, 'licensing_settings_section' ) );

		// Enqueue some minimal styles
		add_action( 'admin_page_nss_plugin_license-sfwd_lms-settings', array( $this, 'enqueue_styles' ) );
	}

	/**
	 * The Licensing Settings Section in which we output our Settings Fields
	 *
	 * @since 1.0.0
	 * @access private
	 */
	function licensing_settings_section() {

		settings_errors( 'ld_convertkit_support' );
		?>

        <div class="learndash-convertkit-wrap wrap">
            <h2>
                LearnDash - ConvertKit
            </h2>

            <div class="rbp-support-licensing-form">
                <form method="post">
					<?php LearnDash_ConvertKit()->support->licensing_fields(); ?>
                </form>
            </div>

			<?php LearnDash_ConvertKit()->support->support_form(); ?>
        </div>
		<?php
	}

	/**
	 * Enqueues styles for this page.
     *
	 * @since 1.0.0
	 * @access private
	 */
	function enqueue_styles() {

		LearnDash_ConvertKit()->support->enqueue_all_scripts();
	}
}