<?php
/**
 * Instructor Course Reports Template
 */
?>
<div id="learndash-instructor-reports"  class="wrap">
    <h2>
        <?php _e('Course Reports', 'wdm_instructor_role'); ?>
    </h2>
    <br>
    <div class="sfwd_settings_left">
        <div class=" " id="div-instructor-courses">
            <div class="inside">
                <?php if (!empty($allCoursesList)) : ?>
                    <label class="wdm-filter-title">
                        <?php _e('Select Course :', 'wdm_instructor_role') ?>
                    </label>
                    <select name="sel-instructor-courses" id="instructor-courses" onchange='wdm_change_report(this)'>
                        <?php foreach ($allCoursesList as $course_id) : ?>
                            <?php if (count(ir_get_users_with_course_access($course_id, array('direct', 'group')) > 0)) : ?>
                                <option value="<?php echo esc_html($course_id); ?>"
                                <?php echo ($current_post == $course_id) ? 'selected' : ''; ?>>
                                    <?php esc_html_e(get_the_title($course_id)); ?>
                                </option>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </select>

                    <div id="wdm_main_report_div" >
                        <?php
                            $report_html = self::wdmShowReportHtml($current_post);
                            $arr_report_html = json_decode($report_html, true);

                            if (isset($arr_report_html['html'])) {
                                echo $arr_report_html['html'];
                            }
                        ?>
                    </div>
                <?php else : ?>
                    <?php echo __('No reports to display', 'wdm_instructor_role'); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
