<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class ProcessManualGroup
 * @package uncanny_learndash_groups
 */
class ProcessManualGroup {
	/**
	 * ProcessManualGroup constructor.
	 */
	function __construct() {
		add_action( 'wp_loaded', array( $this, 'process_manual_group' ), 99 );
	}

	/**
	 *
	 */
	public function process_manual_group() {

		if ( ( isset( $_POST['is_custom_group_nonce'] ) && wp_verify_nonce( $_POST['is_custom_group_nonce'], Utilities::get_prefix() . '_nonce' ) ) && ( isset( $_POST['is_custom_group'] ) && 'yes' === $_POST['is_custom_group'] ) ) :

			$group_leader_first_name = $_POST['ulgm_group_leader_first_name'];
			$group_leader_last_name  = $_POST['ulgm_group_leader_last_name'];
			$group_leader_email      = $_POST['ulgm_group_leader_email'];
			$group_name              = $_POST['ulgm_group_name'];
			$number_of_seats         = $_POST['ulgm_group_total_seats'];
			$group_courses           = $_POST['ulgm_group_courses'];
			$group_image             = $_POST['ulgm_group_image_attachment_id'];

			if ( empty( $group_leader_email ) && is_user_logged_in() ) {
				$current_user            = wp_get_current_user();
				$group_leader_email      = $current_user->user_email;
				$group_leader_first_name = $current_user->first_name;
				$group_leader_last_name  = $current_user->last_name;
			}

			$args = [
				'ulgm_group_leader_first_name' => $group_leader_first_name,
				'ulgm_group_leader_last_name'  => $group_leader_last_name,
				'ulgm_group_leader_email'      => $group_leader_email,
				'ulgm_group_name'              => $group_name,
				'ulgm_group_total_seats'       => $number_of_seats,
				'ulgm_group_courses'           => $group_courses,
				'ulgm_group_image'             => $group_image,
			];

			self::process( $args, $_POST );

		endif;
	}

	/**
	 * @param $args
	 * @param null $_post
	 */
	public static function process( $args, $_post = null ) {

		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}

		$group_leader_first_name = $args['ulgm_group_leader_first_name'];
		$group_leader_last_name  = $args['ulgm_group_leader_last_name'];
		$group_leader_email      = sanitize_email( $args['ulgm_group_leader_email'] );
		$group_name              = $args['ulgm_group_name'];
		$number_of_seats         = absint( $args['ulgm_group_total_seats'] );
		$group_courses           = $args['ulgm_group_courses'];
		$group_image             = absint( $args['ulgm_group_image'] );
		$already_exists          = email_exists( $group_leader_email );
		$user_details            = array(
			'first_name' => $group_leader_first_name,
			'last_name'  => $group_leader_last_name,
			'email'      => $group_leader_email,
		);
		$plain_password          = wp_generate_password( $length = 10, $include_standard_special_chars = false );

		$group_leader_id = self::get_group_leader_id( $user_details, $plain_password );

		if ( $group_leader_id ) {
			$group_title   = $group_name;
			$ld_group_args = array(
				'post_type'    => 'groups',
				'post_status'  => apply_filters( 'uo_create_new_group_status', 'publish' ),
				'post_title'   => $group_title,
				'post_content' => '',
				'post_author'  => $group_leader_id,
			);

			$group_id = wp_insert_post( $ld_group_args );

			update_post_meta( $group_id, '_ulgm_is_custom_group_created', 'yes' );
			update_post_meta( $group_id, '_thumbnail_id', $group_image );

			ld_update_leader_group_access( $group_leader_id, $group_id );

			if ( ! empty( $group_courses ) ) {
				foreach ( $group_courses as $course_id ) {
					ld_update_course_group_access( (int) $course_id, (int) $group_id, false );
					$transient_key = 'learndash_course_groups_' . $course_id;
					delete_transient( $transient_key );
				}
			}
			update_post_meta( $group_id, '_ulgm_total_seats', $number_of_seats );
			$order_id      = Database::get_random_order_number();
			$attr          = array(
				'user_id'    => $group_leader_id,
				'order_id'   => $order_id,
				'group_id'   => $group_id,
				'group_name' => $group_title,
				'qty'        => $number_of_seats,
			);
			$codes         = SharedFunctions::generate_random_codes( $number_of_seats );
			$code_group_id = Database::add_codes( $attr, $codes );

			update_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
			update_user_meta( $group_leader_id, '_ulgm_custom_order_id', $order_id );

			if ( 'yes' !== get_option( 'do_not_add_group_leader_as_member', 'no' ) ) {
				$rest_api = new RestApiEndPoints();
				$rest_api->add_existing_user( array( 'user_email' => $group_leader_email ), true, $group_id, $order_id, 'redeemed', false );
			}
			if ( ! $already_exists ) {
				// Group leader welcome email subject
				$ulgm_group_leader_welcome_email_subject = SharedVariables::group_leader_welcome_email_subject();

				// Group leader welcome email subject
				$ulgm_group_leader_welcome_email_body = SharedVariables::group_leader_welcome_email_body();

			} else {
				$plain_password = "";

				// Group leader welcome email subject
				$ulgm_group_leader_welcome_email_subject = SharedVariables::existing_group_leader_welcome_email_subject();

				// Group leader welcome email subject
				$ulgm_group_leader_welcome_email_body = SharedVariables::existing_group_leader_welcome_email_body();

			}
			// Send Welcome email, for extra validation we are sending in the user id and getting user data from WP because there may be filters
			$rest_api = new RestApiEndPoints();
			$rest_api->send_welcome_email( $group_leader_id, $plain_password, $ulgm_group_leader_welcome_email_subject, $ulgm_group_leader_welcome_email_body, $group_title );

			do_action( 'uo_new_group_created', $group_id, $group_leader_id );

			if ( ! isset( $_post['is_front_end'] ) && ! is_null( $_post ) ) {
				wp_safe_redirect( get_edit_post_link( $group_id, false ) );
				exit;
			}
			if ( isset( $_post['group_page_id'] ) ) {
				wp_safe_redirect( get_permalink( $_post['group_page_id'] ) . '?is-group-created=yes' );
				exit;
			}

			return;
		}
	}

	/**
	 * @param $user_details
	 *
	 * @param string $plain_password
	 *
	 * @return int
	 */
	public static function get_group_leader_id( $user_details, $plain_password = '' ) {
		$email        = $user_details['email'];
		$fname        = $user_details['first_name'];
		$lname        = $user_details['last_name'];
		$exists       = email_exists( $email );
		$group_leader = get_user_by( 'email', $email );

		if ( $exists ) {
			// Get user
			// Check if user is not a group leader yet
			if ( ! user_can( $group_leader, 'group_leader' ) ) {
				$u = new \WP_User( $group_leader->ID );
				// Give the user group_leader capabilities
				$u->add_role( 'group_leader' );
			}

			return absint( $exists );
		} else {
			if ( empty( $plain_password ) ) {
				$user_pass = wp_generate_password( $length = 10, $include_standard_special_chars = false );
			} else {
				$user_pass = $plain_password;
			}
			$new_user = wp_insert_user( array(
				'user_login'      => $email,
				'user_pass'       => $user_pass,
				'user_email'      => $email,
				'first_name'      => $fname,
				'last_name'       => $lname,
				'user_registered' => date( 'Y-m-d H:i:s' ),
				'role'            => 'group_leader',
			) );
			if ( $new_user ) {
				// send an email to the admin alerting them of the registration
				//wp_new_user_notification( $new_user, null, 'user' );
				update_user_meta( $new_user, '_ulgm_is_custom_group_leader', 'yes' );

				return absint( $new_user );
			}
		}
	}
}