<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class AdminMenu
 * @package uncanny_learndash_groups
 */
class AdminPage {


	/**
	 * An array of localized and filtered strings that are used in templates
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      array
	 */
	static $ulgm_management_admin_page = array();

	/**
	 * class constructor
	 */
	public function __construct() {


		// Setup menu and page options in admin
		if ( is_admin() ) {

			// Create Plugin admin menus, pages, and sub-pages
			add_action( 'admin_menu', array( $this, 'create_admin_area' ), 51 );

			// Licensing is not autoloaded, load manually
			include_once( Utilities::get_include( 'licensing.php' ) );

			// Create a new instance of EDD Liccensing
			$licensing = new Licensing();

			// Create sub-page for EDD licensing
			$licensing->page_name   = 'Licensing';
			$licensing->page_slug   = 'uncanny-learndash-groups-licensing';
			$licensing->parent_slug = 'uncanny-groups';
			$licensing->store_url   = 'https://www.uncannyowl.com/';
			$licensing->item_name   = 'Uncanny LearnDash Groups';
			$licensing->author      = 'Uncanny Owl';
			$licensing->add_licensing();

		}

	}

	/**
	 * Create Plugin admin menus, pages, and sub-pages
	 *
	 * @since 1.0.0
	 */
	function create_admin_area() {

		$menu_slug   = 'uncanny-groups';
		$capability  = 'manage_options';
		$function    = array( $this, 'options_output' );
		$parent_slug = 'uncanny-groups-create-group';
		// Register main page settings
		add_action( 'admin_init', array( $this, 'register_settings' ) );

		// Create a link the main page when the menu expands
		add_submenu_page( $parent_slug, __( 'Settings', 'uncanny-learndash-groups' ), __( 'Settings', 'uncanny-learndash-groups' ), $capability, $menu_slug, $function );
		add_submenu_page( $parent_slug, __( 'Email Settings', 'uncanny-learndash-groups' ), __( 'Email Settings', 'uncanny-learndash-groups' ), $capability, $menu_slug . '-email-settings', [
			$this,
			'email_settings_output',
		] );

		// Enqueue page specific styles
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 30 );

	}

	/**
	 * Register a settings and its data
	 *
	 * @since 1.0.0
	 */
	function register_settings() {

		register_setting( Utilities::get_prefix() . '-settings-group', Utilities::get_prefix() . '_welcome_email_subject' );
		register_setting( Utilities::get_prefix() . '-settings-group', Utilities::get_prefix() . '_welcome_email_body' );

		register_setting( Utilities::get_prefix() . '-settings-group', Utilities::get_prefix() . '_redemption_email_subject' );
		register_setting( Utilities::get_prefix() . '-settings-group', Utilities::get_prefix() . '_redemption_email_body' );

	}

	/**
	 * Create Theme Options page
	 *
	 * @since 1.0.0
	 */
	function options_output() {

		$this->localize_filter_globalize_text();

		include Utilities::get_template( 'admin-groups.php' );

	}

	/**
	 * Create Theme Options page
	 *
	 * @since 1.0.0
	 */
	function email_settings_output() {

		$this->localize_filter_globalize_text();

		include Utilities::get_template( 'admin-email-settings.php' );

	}

	/**
	 * Filter and localize all text, then set as global for use in template file
	 *
	 * @since 1.0.0
	 */
	function localize_filter_globalize_text() {

		// Page message set by rest call (localized during rest call)
		if ( isset( $_GET['message'] ) ) {
			self::$ulgm_management_admin_page['text']['message'] = $_GET['message'];
		} else {
			self::$ulgm_management_admin_page['text']['message'] = '';
		}

		// User invitation email subject
		self::$ulgm_management_admin_page['ulgm_term_condition'] = SharedVariables::ulgm_term_condition();

		// User invitation email subject
		self::$ulgm_management_admin_page['ulgm_invitation_user_email_subject'] = SharedVariables::user_invitation_email_subject();

		// User invitation email body
		self::$ulgm_management_admin_page['ulgm_invitation_user_email_body'] = SharedVariables::user_invitation_email_body();;


		// User welcome email subject
		self::$ulgm_management_admin_page['ulgm_user_welcome_email_subject'] = SharedVariables::user_welcome_email_subject();;

		// User welcome email body
		self::$ulgm_management_admin_page['ulgm_user_welcome_email_body'] = SharedVariables::user_welcome_email_body();

		// Exiting user welcome email subject
		self::$ulgm_management_admin_page['ulgm_existing_user_welcome_email_subject'] = SharedVariables::exiting_user_welcome_email_subject();

		// Existing user welcome email body
		self::$ulgm_management_admin_page['ulgm_existing_user_welcome_email_body'] = SharedVariables::exiting_user_welcome_email_body();

		// Group leader welcome email subject
		self::$ulgm_management_admin_page['ulgm_group_leader_welcome_email_subject'] = SharedVariables::group_leader_welcome_email_subject();

		// Group leader welcome email body
		self::$ulgm_management_admin_page['ulgm_group_leader_welcome_email_body'] = SharedVariables::group_leader_welcome_email_body();

		// Existing group leader welcome email subject
		self::$ulgm_management_admin_page['ulgm_existing_group_leader_welcome_email_subject'] = SharedVariables::existing_group_leader_welcome_email_subject();

		// Existing group leader welcome email body
		self::$ulgm_management_admin_page['ulgm_existing_group_leader_welcome_email_body'] = SharedVariables::existing_group_leader_welcome_email_body();

		// Group management page
		self::$ulgm_management_admin_page['ulgm_group_management_page'] = SharedFunctions::get_group_management_page_id();

		// Group Buy Courses page
		self::$ulgm_management_admin_page['ulgm_group_buy_courses_page'] = SharedFunctions::get_buy_courses_page_id();

		// Group report page
		self::$ulgm_management_admin_page['ulgm_group_report_page'] = SharedFunctions::get_group_report_page_id();

		// Group quiz report page
		self::$ulgm_management_admin_page['ulgm_group_quiz_report_page'] = SharedFunctions::get_group_quiz_report_page_id();

		// Group manage progress page
		self::$ulgm_management_admin_page['ulgm_group_manage_progress_page'] = SharedFunctions::get_group_manage_progress_report_page_id();

		// Group assignment report page
		self::$ulgm_management_admin_page['ulgm_group_assignment_report_page'] = SharedFunctions::get_group_assignment_report_page_id();

		// Group essay report page
		self::$ulgm_management_admin_page['ulgm_group_essay_report_page'] = SharedFunctions::get_group_essay_report_page_id();

		// Color Settings
		self::$ulgm_management_admin_page['ulgm_main_color']                  = get_option( 'ulgm_main_color', '#ff9655' );
		self::$ulgm_management_admin_page['text']['ulgm_main_color']          = __( 'Main Color', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['ulgm_font_color']                  = get_option( 'ulgm_font_color', '#fff' );
		self::$ulgm_management_admin_page['text']['ulgm_font_color']          = __( 'Font Color', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_add_to_cart_message'] = __( 'Adding Seats Message', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['ulgm_add_to_cart_message']         = get_option( 'ulgm_add_to_cart_message', '' );

		// Per seat text
		self::$ulgm_management_admin_page['ulgm_per_seat_text']                        = get_option( 'ulgm_per_seat_text', __( 'Seat', 'uncanny-learndash-groups' ) );
		self::$ulgm_management_admin_page['ulgm_per_seat_text_plural']                 = get_option( 'ulgm_per_seat_text_plural', __( 'Seats', 'uncanny-learndash-groups' ) );
		self::$ulgm_management_admin_page['text']['page_settings']                     = __( 'Settings', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_per_seat_text']                = __( 'Per Seat Text - Singular', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_per_seat_text_plural']         = __( 'Per Seat Text - Plural', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['show_license_product_on_front']     = __( 'Show License Products in Store', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['do_not_add_group_leader_as_member'] = __( 'Do not add Group Leaders as Group Members', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['allow_to_remove_users_anytime']     = __( 'Allow Group Leaders to remove students at any time', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['allow_group_leaders_to_manage_progress']     = __( 'Allow Group Leaders to Manage Progress', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['group_leaders_dont_use_seats']      = __( 'Group Leaders don\'t use seats', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['add_courses_as_part_of_license']    = __( 'Automatically include Group Course products in Group License purchases', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['add_groups_as_woo_products']        = __( 'Enable association of products and groups', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_management_page']        = __( 'Group Management Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_buy_courses_page']       = __( 'Buy Courses Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_report_page']            = __( 'Group Report Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_quiz_report_page']       = __( 'Group Quiz Report Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_manage_progress_page']   = __( 'Group Manage Progress Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_assignment_report_page'] = __( 'Assignment Management Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_essay_report_page']      = __( 'Essay Management Page', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_group_license_product_cat']    = __( 'Default License Category', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['ulgm_migrate_old_groups_to_new']    = __( 'Start Process', 'uncanny-learndash-groups' );

		self::$ulgm_management_admin_page['text']['redemption_email_template']                    = __( 'Redemption Email Template', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['user_welcome_email_template']                  = __( 'User Welcome Email Template', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['existing_user_welcome_email_template']         = __( 'Existing User Welcome Email Template', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['group_leader_welcome_email_template']          = __( 'Group Leader Welcome Email Template', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['existing_group_leader_welcome_email_template'] = __( 'Existing Group Leader Welcome Email Template', 'uncanny-learndash-groups' );

		// Global Email Settings
		self::$ulgm_management_admin_page['text']['email_settings'] = __( 'Email Settings', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['email_from']             = get_option( 'ulgm_email_from', '' );
		self::$ulgm_management_admin_page['text']['email_from']     = __( 'From Email', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['name_from']              = get_option( 'ulgm_name_from', '' );
		self::$ulgm_management_admin_page['text']['name_from']      = __( 'From Name', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['reply_to']               = get_option( 'ulgm_reply_to', '' );
		self::$ulgm_management_admin_page['text']['reply_to']       = __( 'Reply To', 'uncanny-learndash-groups' );

		self::$ulgm_management_admin_page['text']['subject']   = __( 'Subject', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['body']      = __( 'Body', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['variables'] = __( 'Variables', 'uncanny-learndash-groups' );
		//self::$ulgm_management_admin_page['text']['test_email_address'] = __( 'Test Email Address: ', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['redemption_email_template '] = __( 'Redemption Email Template', 'uncanny-learndash-groups' );
		self::$ulgm_management_admin_page['text']['save_changes']               = __( 'Save Changes', 'uncanny-learndash-groups' );

	}

	/**
	 * Load Scripts that are specific to the admin page
	 *
	 * @param string $hook Admin page being loaded
	 *
	 * @since 1.0
	 *
	 */
	function admin_scripts( $hook ) {
		/*
		 * Only load styles if the page hook contains the pages slug
		 *
		 * Hook can be either the toplevel_page_{page_slug} if its a parent  page OR
		 * it can be {parent_slug}_pag_{page_slug} if it is a sub page.
		 * Lets just check if our page slug is in the hook.
		 */

		// Target Licensing page
		if ( 'uncanny-groups_page_uncanny-learndash-groups-licensing' === $hook ) {
			// Load Styles for Licensing page located in general plugin styles
		}

		// Target group management page
		if ( isset( $_GET['page'] ) && preg_match( '/(uncanny-groups)/', $_GET['page'] ) ) {
			wp_enqueue_style( 'ulgm-backend', Utilities::get_asset( 'backend', 'bundle.min.css' ), array(), Utilities::get_version() );
			// Add the color picker css file
			wp_enqueue_style( 'wp-color-picker' );
			// Setup group management JS with localized WP Rest API variables @see rest-api-end-points.php
			wp_register_script( 'ulgm-backend', Utilities::get_asset( 'backend', 'bundle.min.js' ), array(
				'jquery',
				'wp-color-picker'
			), Utilities::get_version(), true );

			// API data
			$api_setup = array(
				'root'  => esc_url_raw( rest_url() . 'ulgm_management/v1/' ),
				'nonce' => \wp_create_nonce( 'wp_rest' ),
			);

			wp_localize_script( 'ulgm-backend', 'ulgmRestApiSetup', $api_setup );
			wp_enqueue_script( 'ulgm-backend' );


		}

	}
}