<?php
/*
Plugin Name: LearnDash JigoShop Integration
Plugin URI: http://www.learndash.com
Description: LearnDash JigoShop Integration Plugin
Version: 1.1
Author: LearnDash
Author URI: http://www.learndash.com
*/

class learndash_jigoshop {
	public $debug = true;
	
	function __construct() {
		add_action( 'jigoshop_product_write_panel_tabs', array( $this, 'product_write_panel_tab' ), 99 );
		add_action( 'jigoshop_product_write_panels', array( $this, 'product_write_panel'), 99 );
		add_filter( 'jigoshop_process_product_meta', array( $this, 'product_save_data' ) );
		add_action( 'order_status_completed', array( $this, 'completed_order' ) );
	}

		/**
		* defines the fields used in the plugin
		*
		* @since 
		* @return void
		*/
	function define_fields() {
		// define the product metadata fields used by this plugin
		$this->product_fields = array(
			array( 'id' => 'ld_js_courses', 'label' => __( 'Courses', 'ld_js' ), 'title' => __( 'Courses', 'ld_js' ), 'placeholder' => '', 'type' => 'select-multiple', 'values'=> $this->list_courses(), 'never_hide' => true ),
			array( 'id' => 'ld_js_access', 'label' => __( 'Access Level', 'ld_js' ), 'title' => __( 'Access Level', 'ld_js' ), 'placeholder' => '', 'type' => 'select', 'values'=> $this->list_accesslevels(), 'never_hide' => true ),
		);
	}
	
	function debug($msg) {
		$original_log_errors = ini_get('log_errors');
		$original_error_log = ini_get('error_log');
		ini_set('log_errors', true);
		ini_set('error_log', dirname(__FILE__).DIRECTORY_SEPARATOR.'debug.log');
		
		global $ld_sf_processing_id;
		if(empty($ld_sf_processing_id))
		$ld_sf_processing_id	= time();
		
		if(isset($_GET['debug']) || $this->debug)
		error_log("[$ld_sf_processing_id] ".print_r($msg, true)); //Comment This line to stop logging debug messages.
		
		ini_set('log_errors', $original_log_errors);
		ini_set('error_log', $original_error_log);		
	}
	function get_order_user($email) {
		if ( !is_admin() && is_user_logged_in() ) {
			$user = wp_get_current_user();
			$user_id = $user->ID;
		} else {
			if ( $user_id = email_exists( $email ) ) {
				//$user = get_user_by( 'id', $user_id );
			} else {
				$username = $email;
				if ( username_exists( $email ) ) {
					$count = 1;
					do {
						$new_username = $count . "_" . $email;
						$count++;
					} while ( username_exists( $new_username ) );
					$username = $new_username;
				}
				$random_password = wp_generate_password( 12, false );
				$user_id = wp_create_user( $username, $random_password, $email );
				//$user = get_user_by( 'id', $user_id );
				
				wp_new_user_notification( $user_id, $random_password );
			}
		}
		return $user_id;
	}
	function completed_order($order_id) {
		$this->debug("Order ID:".$order_id);
		$order_data = get_post_meta( $order_id, 'order_data', true );
		
		$products = get_post_meta( $order_id, 'order_items', true );
		$this->debug("Order Products:". print_r($products, true));
		$this->debug("Has Products? " . (is_array($products)? "Yes":"No"));
		
		//Get User
		$email = $order_data['billing_email'];
		$user_id = $this->get_order_user($email);
		
		
		if(is_array($products))
		foreach($products as $product) {
			$id = $product['id'];
			$this->debug("Processing Access for Product ID: ".$id);
			
			$learndash_access = get_post_meta( $id, 'ld_js_product_data', true );
			$this->debug("Product's Access [ld_js_product_data]: ".print_r($learndash_access,true));
			$this->debug("Need's Work? ".(!empty($learndash_access)? "Yes":"No"));
			
			if(!empty($learndash_access)) {
			
				$courses = $learndash_access['ld_js_courses'];
				$this->debug("Checking Course Access [ld_js_courses]:".print_r($courses, true));
				
				if(is_array($courses))
				{
					foreach($courses as $courseid) {
						$this->debug("Updating Course Access: Course ID:".$courseid." User ID:".$user_id);
						if(function_exists('ld_update_course_access'))
						{
							$meta = ld_update_course_access($user_id, $courseid);
							
							if(isset($meta['sfwd-courses_course_access_list']))
							$this->debug('Updated Course Access List: '. print_r($meta['sfwd-courses_course_access_list'], true));
							else
							$this->debug('Error: Updated but empty Course Access List for Course ID:'.$course_id);
						}
						else
						{
							$this->debug("LearnDash LMS not installed or not compatible. function ld_update_course_access does not exist.");						
						}
							
					}
				}
				
				$accesslevel = $learndash_access['ld_js_access'];
				$this->debug("Checking Access Levels[ld_js_courses]:".print_r($accesslevel, true));
				if(!empty($accesslevel))
				{
					$now = time();
					$payment = array('amount' => $product['cost_inc_tax'],
								'currency' => " PURCHASE",
								'timestamp' => $now
								);
								
					if(function_exists('learndash_plus_update_user_level'))
					{
						$this->debug("Adding Access Level:".$accesslevel." to User ID:".$user_id." with details:".print_r($payment, true));
						learndash_plus_update_user_level($user_id, $accesslevel, $payment);
					}
					else
					{
						$this->debug("LearnDash Access not installed or not compatible. function learndash_plus_update_user_level does not exist.");
					}
				}
			}
		}
		
	}
	
	function list_courses() {
		global $post;
		$postid = $post->ID;
		query_posts( array( 'post_type' => 'sfwd-courses', 'posts_per_page' => -1 ) );
		$courses = array();
		while ( have_posts() ) {
			the_post(); 
			$courses[get_the_ID()] = get_the_title();
		}
		wp_reset_query();
		$post = get_post($postid);
		return $courses;
	}
	function product_write_panel_tab() {
		?>
			<li><a href="#ld_js_course"><?php _e( 'LearnDash Access', 'ld_js' ); ?></a></li>
		<?php
	}

	function list_accesslevels() {
		$access = array();
		if(function_exists('learndash_plus_get_levels'))
		{
			$accesslevels = learndash_plus_get_levels();
			if(empty($accesslevels[0]))
			$access[0] = "Don't Assign";
			
			foreach($accesslevels as $id=>$v)
			$access[$id] = $v['name'];
			
		}
		return $access;
	}

	function product_write_panel() {

			global $post;
			$data = get_post_meta( $post->ID, 'ld_js_product_data', true );
			
			$this->define_fields();
		?>
			<div id="ld_js_course" class="panel jigoshop_options_panel">
			<?php
				foreach ($this->product_fields as $field) :
					$value = isset($data[$field['id']])? $data[$field['id']]:'';
					echo '<p><label for="'.$field['id'].'">'.$field['label'].'</label>';
					switch ($field['type']) :
						case 'text' :
							echo '<input type="text" id="'.$field['id'].'" name="'.$field['id'].'" value="'.$value.'" placeholder="'.$field['placeholder'].'"/>';
						break;
						case 'number' :
							echo '<input type="number" id="'.$field['id'].'" name="'.$field['id'].'" value="'.$value.'" placeholder="'.$field['placeholder'].'"/>';
						break;
						case 'textarea' :
							echo '<textarea id="'.$field['id'].'" name="'.$field['id'].'" placeholder="'.$field['placeholder'].'">'.$value.'</textarea>';
						break;
						case 'checkbox' :
							$checked = ($value == 'on') ? ' checked=checked' : '';
							echo '<input type="checkbox" id="'.$field['id'].'" name="'.$field['id'].'" value="on"'.$checked.'>';
						break;
						case 'select' :
							echo '<select id="'.$field['id'].'" name="'.$field['id'].'">';
							foreach ($field['values'] as $k => $v) :
								$selected = ($value == $k) ? ' selected="selected"' : '';
								echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>';
							endforeach;
							echo '</select>';
						break;
						case 'select-multiple':
						
							echo '<select id="'.$field['id'].'" name="'.$field['id'].'[]" multiple="multiple">';

							foreach ($field['values'] as $k => $v) :
								if(!is_array($value)) $value = (array) $value;
								$selected = (in_array($k, $value)) ? ' selected="selected"' : '';
								echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>';
							endforeach;
							echo '</select>';

					endswitch;
					echo '</p>';
				endforeach;
				?>
				<br>
			</div>
		<?php
	
	}
	
	function product_save_data() {
		global $post;
		$this->define_fields();
		$data = get_post_meta( $post->ID, 'ld_js_product_data', true );
		foreach ( $this->product_fields as $field ) {				
				$data[$field['id']] =  $_POST[$field['id']] ;
		}
		update_post_meta( $post->ID, 'ld_js_product_data', $data );
	}
}

new learndash_jigoshop();
