<?php

namespace uncanny_automator;

/**
 * Class WP_SUBMITPOST
 * @package uncanny_automator
 */
class WP_SUBMITPOST {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'SUBMITPOST';
		$this->trigger_meta = 'WPPOST';
		// TODO trigger is not finshed
		//$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'action'              => 'shutdown',
			'validation_function' => array( $this, 'submit_post' ),
			'options'             => [
				[
					'option_code'        => 'NUMTIMES',
					'label'              => 'Number of Times',
					'input_type'         => 'text',
					// to setup example, lets define the value the child will be based on
					'current_value'      => false,
					'default_value'      => false,
					'validation_type'    => 'integer',
					'validation_message' => 'Please add how many times the page must be submitted.',
				],
			],
		);


		$uncanny_automator->register_trigger( $trigger );

		return;
	}
}
