<?php

namespace uncanny_automator;

/**
 * Class LF_QUIZPASSED
 * @package uncanny_automator
 */
class LF_QUIZPASSED {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LF';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LFQUIZPASSED';
		$this->trigger_meta = 'LFQUIZ';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Courses 2:Number of times*/
			'sentence'            => sprintf( __( 'User passes {{a/any quiz:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User passes {{a/any quiz}}', 'uncanny-automator' ),
			'action'              => 'lifterlms_quiz_passed',
			'priority'            => 20,
			'accepted_args'       => 3,
			'validation_function' => array( $this, 'lf_quiz_passed' ),
			'options'             => [
				$uncanny_automator->options->all_lf_quizs( null, $this->trigger_meta ),
				$uncanny_automator->options->number_of_times(),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param string $user_id   .
	 * @param string $quiz_id   .
	 * @param object $quiz_obj  .
	 */
	public function lf_quiz_passed( $user_id, $quiz_id, $quiz_obj ) {

		if ( empty( $user_id ) ) {
			return;
		}

		global $uncanny_automator;

		$args = [
			'code'           => $this->trigger_code,
			'meta'           => $this->trigger_meta,
			'post_id'        => intval( $quiz_id ),
			'user_id'        => $user_id,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}
}
