<?php

namespace uncanny_automator;

/**
 * Class LP_MARKLESSONDONE
 * @package uncanny_automator
 */
class LP_MARKLESSONDONE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LP';

	private $action_code;
	private $action_meta;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'LPMARKLESSONDONE-A';
		$this->action_meta = 'LPLESSON';
		$this->define_action();
		add_action( 'wp_ajax_select_section_from_course_LPMARKLESSONDONE', array( $this, 'select_section_from_course_func' ) );
		add_action( 'wp_ajax_select_lesson_from_section_LPMARKLESSONDONE', array( $this, 'select_lesson_from_section_func' ) );
	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;
		$args = [
			'post_type'      => 'lp_course',
			'posts_per_page' => 999,
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		];
		$options = $uncanny_automator->options->wp_query( $args, false, 'course' );

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Courses*/
			'sentence'           => sprintf( __( 'Mark {{a lesson:%1$s}} complete', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Mark {{a lesson}} complete', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => array( $this, 'lp_mark_lesson_done' ),
			'options_group'      => [
				$this->action_meta => [
					$uncanny_automator->options->select_field_ajax(
						'LPCOURSE',
						__( 'Select a Course', 'uncanny-automator' ),
						$options,
						'',
						'',
						false,
						true,
						[
							'target_field' => 'LPSECTION',
							'endpoint'     => 'select_section_from_course_LPMARKLESSONDONE',
						]
					),
					$uncanny_automator->options->select_field_ajax(
						'LPSECTION',
						__( 'Select a Section', 'uncanny-automator' ),
						[ '' => __( 'Select a Course Above', 'uncanny-automator' ) ],
						'',
						'',
						false,
						true,
						[
							'target_field' => $this->action_meta,
							'endpoint'     => 'select_lesson_from_section_LPMARKLESSONDONE',
						]),
					$uncanny_automator->options->select_field( $this->action_meta, __( 'Select a Lesson', 'uncanny-automator' ), [ '' => __( 'Select a Section Above', 'uncanny-automator' ) ] ),
				],
			],
		);

		$uncanny_automator->register_action( $action );
	}


	/**
	 * Validation function when the action is hit.
	 *
	 * @param string $user_id user id.
	 * @param array  $action_data action data.
	 * @param string $recipe_id recipe id.
	 */
	public function lp_mark_lesson_done( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		if ( ! function_exists( 'learn_press_get_current_user' ) ) {
			$error_message = 'The function learn_press_get_current_user does not exist';
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_message );
			return;
		}
		$user      = learn_press_get_user( $user_id );
		$lesson_id = $action_data['meta'][ $this->action_meta ];
		$course_id = $action_data['meta']['LPCOURSE'];

		// Mark lesson completed.
		$result = $user->complete_lesson( $lesson_id, $course_id );

		if ( ! is_wp_error( $result ) ) {
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
		} else {
			$error_message = $result->get_error_message();
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_message );
			return;
		}

	}

	/**
	 * Return all the sections of course ID provided in ajax call
	 */
	public function select_section_from_course_func() {
		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {

			$course_curd = new \LP_Course_CURD();
			$sections    = $course_curd->get_course_sections( absint( $_POST['value'] ) );

			foreach ( $sections as $section ) {
				$fields[] = [
					'value' => $section->section_id,
					'text'  => $section->section_name,
				];
			}
		}

		echo wp_json_encode( $fields );
		die();
	}

	/**
	 * Return all the lessons of section ID provided in ajax call
	 */
	public function select_lesson_from_section_func() {
		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {
			$course_curd = new \LP_Section_CURD(absint( $_POST['values']['LPCOURSE'] ));
			$lessons    = $course_curd->get_section_items( absint( $_POST['value'] ) );

			foreach ( $lessons as $lesson ) {
				$fields[] = [
					'value' => $lesson['id'],
					'text'  => $lesson['title'],
				];
			}
		}

		echo wp_json_encode( $fields );
		die();
	}
}
