<?php

namespace uncanny_automator;

/**
 * Class LD_TOPICDONE
 * @package uncanny_automator
 */
class LD_TOPICDONE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LD_TOPICDONE';
		$this->trigger_meta = 'LDTOPIC';
		$this->define_trigger();

		add_action( 'wp_ajax_select_lesson_from_course_LD_TOPICDONE', array( $this, 'lesson_from_course_func' ), 15 );
		add_action( 'wp_ajax_select_topic_from_lesson_LD_TOPICDONE', array( $this, 'topic_from_lesson_func' ), 15 );
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$args = [
			'post_type'      => 'sfwd-courses',
			'posts_per_page' => 999,
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		];

		$course_options = $uncanny_automator->options->wp_query( $args, true, 'course' );

		$args = [
			'post_type'      => 'sfwd-lessons',
			'posts_per_page' => 999,
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		];

		$lesson_options = $uncanny_automator->options->wp_query( $args, true, 'course' );

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Topics 2:Number of times*/
			'sentence'            => sprintf( __( 'User completes {{a topic:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User completes {{a topic}}', 'uncanny-automator' ),
			'action'              => 'learndash_topic_completed',
			'priority'            => 10,
			'accepted_args'       => 1,
			'validation_function' => array( $this, 'topic_completed' ),
			'options'             => [
				$uncanny_automator->options->number_of_times(),
			],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->select_field_ajax(
						'LDCOURSE',
						__( 'Select a Course', 'uncanny-automator' ),
						$course_options,
						'',
						'',
						false,
						true,
						[
							'target_field' => 'LDLESSON',
							'endpoint'     => 'select_lesson_from_course_LD_TOPICDONE',
						]
					),
					$uncanny_automator->options->select_field_ajax(
						'LDLESSON',
						__( 'Select a Lesson', 'uncanny-automator' ),
						$lesson_options,
						'',
						'',
						false,
						true,
						[
							'target_field' => 'LDTOPIC',
							'endpoint'     => 'select_topic_from_lesson_LD_TOPICDONE',
						]
					),
					$uncanny_automator->options->select_field( 'LDTOPIC', __( 'Select a Topic', 'uncanny-automator' ) ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $data
	 */
	public function topic_completed( $data ) {

		if ( empty( $data ) ) {
			return;
		}

		global $uncanny_automator;

		$user  = $data['user'];
		$topic = $data['topic'];

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $topic->ID,
			'user_id' => $user->ID,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function lesson_from_course_func() {

		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];

		if ( isset( $_POST ) ) {

			if ( '-1' === absint( $_POST['value'] ) ) {
				$args = [
					'post_type'      => 'sfwd-lessons',
					'posts_per_page' => 999,
					'orderby'        => 'title',
					'order'          => 'ASC',
					'post_status'    => 'publish',
				];
			} else {
				$args = [
					'post_type'      => 'sfwd-lessons',
					'meta_query'     => array(
						'relation' => 'OR',
						array(
							'key'     => 'course_id',
							'value'   => absint( $_POST['value'] ),
							'compare' => '=',
						),
						array(
							'key'     => 'ld_course_' . absint( $_POST['value'] ),
							'value'   => absint( $_POST['value'] ),
							'compare' => '=',
						),
					),
					'posts_per_page' => 999,
					'orderby'        => 'title',
					'order'          => 'ASC',
					'post_status'    => 'publish',
				];
			}

			$options = $uncanny_automator->options->wp_query( $args, true, 'lesson' );

			foreach ( $options as $lesson_id => $lesson_name ) {
				$fields[] = array(
					'value' => $lesson_id,
					'text'  => $lesson_name,
				);
			}
		}

		echo wp_json_encode( $fields );
		die();
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function topic_from_lesson_func() {

		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields   = array();
		$fields[] = array(
			'value' => - 1,
			'text'  => __( 'Any Topic', 'uncanny-automator' ),
		);

		if ( isset( $_POST ) ) {

			$trigger_id = absint( $_POST['item_id'] );

			if ( $trigger_id ) {

				if ( isset( $_POST['values'] ) && isset( $_POST['values']['LDCOURSE'] ) ) {
					$course_id = $_POST['values']['LDCOURSE'];
				} else {
					$course_id = 0;
				}

				if ( '-1' === $_POST['value'] ) {
					$lesson = null;
					echo wp_json_encode( $fields );
					die();
				} else {
					$lesson = absint( $_POST['value'] );
				}

				$topics = learndash_get_topic_list( $lesson, absint( $course_id ) );

				foreach ( $topics as $topic ) {
					$fields[] = array(
						'value' => $topic->ID,
						'text'  => $topic->post_title,
					);
				}
			}
		}

		echo wp_json_encode( $fields );
		die();
	}
}
