<?php

namespace uncanny_automator;

/**
 * Class Automator_Error_Messages
 * @package uncanny_automator
 */
class Automator_Error_Messages {

	/**
	 * Collection of error messages
	 * @var array
	 */
	private $error_messages = array();

	public function __construct() {

		$this->error_messages['email-failed']                = __( 'Email was not sent successfully', 'uncanny-automator' );
		$this->error_messages['email-success']               = __( 'Email was sent successfully', 'uncanny-automator' );
		$this->error_messages['not-logged-in']               = __( 'User is not logged in', 'uncanny-automator' );
		$this->error_messages['action-not-active']           = __( 'The plugin for this action is not active', 'uncanny-automator' );
		$this->error_messages['action-function-not-exist']   = __( 'Action function does not exist.', 'uncanny-automator' );
		$this->error_messages['plugin-not-active']           = __( 'Action plugin not active or does not exist.', 'uncanny-automator' );
		$this->error_messages['anon-user-action-do-nothing'] = __( 'Anonymous recipe user action set to do nothing.', 'uncanny-automator' );

	}

	/**
	 * Get the message associated with the error key
	 *
	 * @param null|string $additional_information
	 * @param null|string $error_key
	 *
	 * @return null|string
	 */
	public function get( $error_key = null, $additional_information = '' ) {

		/**
		 * Filters all error messages before a specific error message is set
		 */
		$error_messages = apply_filters( 'automator_error_messages', $this->error_messages );
		$error_message  = null;

		if ( isset( $error_messages[ $error_key ] ) ) {
			$error_message = $error_messages[ $error_key ] . $additional_information;
		} else {
			return 'No message';
		}

		/**
		 * Filters the specific error message
		 */
		$error_message = apply_filters( 'automator_error_message', $error_message, $error_key, $additional_information );

		return $error_message;
	}
}
