<?php

namespace uncanny_automator;

/**
 * Class Triggers_Post_Type
 *
 * Hidden Post Type to hold Triggers
 *
 * @package uncanny_automator
 */
class Triggers_Post_Type {

	/**
	 * TriggersPostType constructor.
	 */
	public function __construct() {

		// Register Custom Post Type
		add_action( 'init', array( $this, 'uo_automator_triggers' ), 0 );
		//add_filter( 'q_get_recipe_data', array( $this, 'q_get_recipe_data' ), 10, 3 );
		add_filter( 'add_recipe_child', array( $this, 'add_recipe_child' ), 10, 4 );

	}

	/**
	 * Register Custom Post Type without a menu page (internal use only)
	 */
	public function uo_automator_triggers() {

		$labels = array(
			'name'                  => __( 'Automator Triggers', 'uncanny-automator' ),
			'singular_name'         => __( 'Automator Trigger', 'uncanny-automator' ),
			'menu_name'             => __( 'Triggers', 'uncanny-automator' ),
			'name_admin_bar'        => __( 'Post Type', 'uncanny-automator' ),
			'archives'              => __( 'Item Archives', 'uncanny-automator' ),
			'attributes'            => __( 'Item Attributes', 'uncanny-automator' ),
			'parent_item_colon'     => __( 'Parent Item:', 'uncanny-automator' ),
			'all_items'             => __( 'All Items', 'uncanny-automator' ),
			'add_new_item'          => __( 'Add New Item', 'uncanny-automator' ),
			'add_new'               => __( 'Add New', 'uncanny-automator' ),
			'new_item'              => __( 'New Item', 'uncanny-automator' ),
			'edit_item'             => __( 'Edit Item', 'uncanny-automator' ),
			'update_item'           => __( 'Update Item', 'uncanny-automator' ),
			'view_item'             => __( 'View Item', 'uncanny-automator' ),
			'view_items'            => __( 'View Items', 'uncanny-automator' ),
			'search_items'          => __( 'Search Item', 'uncanny-automator' ),
			'not_found'             => __( 'Not found', 'uncanny-automator' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'uncanny-automator' ),
			'featured_image'        => __( 'Featured Image', 'uncanny-automator' ),
			'set_featured_image'    => __( 'Set featured image', 'uncanny-automator' ),
			'remove_featured_image' => __( 'Remove featured image', 'uncanny-automator' ),
			'use_featured_image'    => __( 'Use as featured image', 'uncanny-automator' ),
			'insert_into_item'      => __( 'Insert into item', 'uncanny-automator' ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', 'uncanny-automator' ),
			'items_list'            => __( 'Items list', 'uncanny-automator' ),
			'items_list_navigation' => __( 'Items list navigation', 'uncanny-automator' ),
			'filter_items_list'     => __( 'Filter items list', 'uncanny-automator' ),
		);
		$args   = array(
			'label'               => __( 'Automator Trigger', 'uncanny-automator' ),
			'description'         => __( 'Steps for Triggers', 'uncanny-automator' ),
			'labels'              => $labels,
			'supports'            => array( 'title' ),
			'hierarchical'        => false,
			'public'              => false,
			'show_ui'             => false,
			'show_in_menu'        => false,
			'menu_position'       => 5,
			'show_in_admin_bar'   => false,
			'show_in_nav_menus'   => false,
			'can_export'          => false,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'capability_type'     => 'page',
		);

		register_post_type( 'uo-trigger', $args );
	}

	/**
	 * @param bool $create_post
	 * @param string $post_type
	 * @param string $action
	 * @param object $recipe
	 *
	 * @return \WP_REST_Response $response
	 */
	function add_recipe_child( $create_post, $post_type, $action, $recipe ) {

		if ( 'uo-trigger' === $post_type && 'create_trigger' === $action ) {
			global $wpdb;
			$fl = $wpdb->get_var( "SELECT COUNT(ID) FROM {$wpdb->posts} WHERE post_type = '{$post_type}' AND post_parent = {$recipe->ID}" );
			if ( 1 <= (int) $fl ) {
				$return['success'] = false;

				$response = new \WP_REST_Response( $return, 200 );

				return $response;
			}
		}

		return $create_post;
	}
}