<?php
/**
 * Plugin Name: Uncanny Automator Pro
 * Description: Adds multiple trigger support, advanced log filtering, automatic log pruning and Pro triggers and actions to Uncanny Automator!
 * Version: 2.0.1
 * Author: Uncanny Owl Inc.
 * Author URI: https://www.uncannyowl.com/
 * Plugin URI: https://automatorplugin.com/
 * Text Domain: uncanny-automator-pro
 * Domain Path: /languages
 */

namespace Uncanny_Automator_Pro;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! defined( 'UAP_AUTOMATOR_PRO_FILE' ) ) {
	define( 'UAP_AUTOMATOR_PRO_FILE', __FILE__ );
}

/**
 * This class initiates the plugin load sequence and sets general plugin variables
 *
 * @package Private_Plugin_Boilerplate
 */
class InitializePlugin {

	/**
	 * The parent plugins Namespace
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	const PARENT_PLUGIN_NAMESPACE = 'Uncanny_Automator';

	/**
	 * The plugin name
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	const PLUGIN_NAME = 'Uncanny Automator Pro';

	/**
	 * The plugin name acronym
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	const PLUGIN_PREFIX = 'uapro';

	/**
	 * Min PHP Version
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	const MIN_PHP_VERSION = '5.6';

	/**
	 * The plugin version number
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	const PLUGIN_VERSION = '2.0.1';

	/**
	 * The full path and filename
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	const MAIN_FILE = __FILE__;

	/**
	 * Allows the debugging scripts to initialize and log them in a file
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $log_debug_messages = false;

	/**
	 * The instance of the class
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      Object
	 */
	private static $instance = null;

	/**
	 * Creates singleton instance of class
	 *
	 * @since 1.0.0
	 *
	 * @return InitializePlugin $instance The InitializePlugin Class
	 */
	public static function get_instance() {

		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * class constructor
	 */
	private function __construct() {

		// Load Utilities
		$this->initialize_utilities();

		// Load Configuration
		$this->initialize_config();

		// Load the plugin files
		$this->boot_plugin();

	}

	/**
	 * Initialize Static singleton class that has shared function and variables that can be used anywhere in WP
	 *
	 * @since 1.0.0
	 */
	private function initialize_utilities() {

		include_once( dirname( __FILE__ ) . '/src/utilities.php' );
		Utilities::set_date_time_format();

	}

	/**
	 * Initialize Static singleton class that configures all constants, utilities variables and handles activation/deactivation
	 *
	 * @since 1.0.0
	 */
	private function initialize_config() {

		include_once( dirname( __FILE__ ) . '/src/config.php' );

		$config_instance = Config::get_instance();

		$config_instance->configure_plugin_before_boot( self::PLUGIN_NAME, self::PLUGIN_PREFIX, self::PLUGIN_VERSION, self::MAIN_FILE, $this->log_debug_messages );

	}

	/**
	 * Initialize Static singleton class auto loads all the files needed for the plugin to work
	 *
	 * @since 1.0.0
	 */
	private function boot_plugin() {

		// Only include Module_interface, do not initialize is ... interfaces cannot be initialized
		add_filter( 'Skip_class_initialization', array( $this, 'add_skipped_classes' ), 10, 1 );

		include_once( dirname( __FILE__ ) . '/src/boot.php' );

		Boot::get_instance();

		do_action( Utilities::get_prefix() . '_plugin_loaded' );

	}

	/**
	 * Add Classes that need to be included automatically but not initialized
	 *
	 * @param array $skipped_classes Collection of classes that are being skipped over for initialization (new Class)
	 *
	 * @return array
	 */
	public function add_skipped_classes( $skipped_classes ) {
		$skipped_classes[] = 'Module_Interface';

		return $skipped_classes;
	}
}

// Let's run it
InitializePlugin::get_instance();