<?php

namespace Uncanny_Automator_Pro;

/**
 * Class WP_SETUSERMETA
 * @package Uncanny_Automator_Pro
 */
class WP_SETUSERMETA {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $action_code;
	private $action_meta;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'SETUSERMETA';
		$this->action_meta = 'WPUMETAVAL';
		$this->define_action();
	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Groups*/
			'sentence'           => sprintf( __( 'Set user meta value: {{meta value:%1$s}} for meta key: {{meta key:%2$s}}', 'uncanny-automator' ), $this->action_meta, 'WPUMETAKEY' ),
			'select_option_name' => __( 'Set user {{meta}}', 'uncanny-automator' ),
			'priority'           => 11,
			'accepted_args'      => 3,
			'execution_function' => array( $this, 'set_user_meta' ),
			'options'            => [
				$uncanny_automator->options->text_field( $this->action_meta, __( 'Enter meta value', 'uncanny-automator' ), false, 'text', null ),
				$uncanny_automator->options->text_field( 'WPUMETAKEY', __( 'Enter meta key', 'uncanny-automator' ), false, 'text', null ),
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Validation function when the action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function set_user_meta( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		if ( ! empty( $user_id ) ) {
			$meta_key   = sanitize_title( $action_data['meta']['WPUMETAKEY'] );
			$meta_value = sanitize_text_field( $action_data['meta'][ $this->action_meta ] );
			update_user_meta( $user_id, $meta_key, $meta_value );
		} else {
			$error_msg = $uncanny_automator->error_message->get( 'not-logged-in' );
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_msg );

			return;
		}

		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}
}
