<?php

namespace Uncanny_Automator_Pro;

/**
 * Class ANON_GF_SUBFIELD
 * @package Uncanny_Automator_Pro
 */
class ANON_GF_SUBFORM {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'GF';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'ANONGFSUBFORM';
		$this->trigger_meta = 'ANONGFFORMS';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Forms 2:Number of times*/
			'sentence'            => sprintf( __( 'A {{Gravity form:%1$s}} is submitted', 'uncanny-automator' ), $this->trigger_meta ),
			'select_option_name'  => __( 'A {{Gravity form}} is submitted', 'uncanny-automator' ),
			'action'              => 'gform_after_submission',
			'type'                => 'anonymous',
			'priority'            => 20,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'gform_submit' ),
			'options'             => [
				$uncanny_automator->options->list_gravity_forms( null, $this->trigger_meta ),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $entry
	 * @param $form
	 */
	public function gform_submit( $entry, $form ) {

		global $uncanny_automator;

		if ( empty( $entry ) ) {
			return;
		}

		$user_id = get_current_user_id();

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $form['id'],
			'user_id' => $user_id,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}
}