<?php

namespace Uncanny_Automator_Pro;

/**
 * Class GP_REVOKEACHIEVEMENT_A
 * @package Uncanny_Automator_Pro
 */
class GP_REVOKEACHIEVEMENT_A {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'GP';

	private $action_code;
	private $action_meta;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'REVOKEACHIEVEMENT';
		$this->action_meta = 'GPACHIEVEMENT';
		$this->define_action();

		add_action( 'wp_ajax_select_achievements_from_types_REVOKEACHIEVEMENT', [ $this, 'select_achievements_from_types_func' ] );

	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name(),
			'support_link'       => $uncanny_automator->get_author_support_link(),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Lessons*/
			'sentence'           => sprintf( __( 'Revoke {{an Achievement:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Revoke {{an Achievement}}', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => array( $this, 'revoke_an_achievement' ),
			'options_group'      => [
				$this->action_meta => [
					$uncanny_automator->options->list_gp_award_types(
						__( 'Select an Achievement Type', 'uncanny-automator' ),
						'GPAWARDTYPES',
						[
							'token'        => false,
							'is_ajax'      => true,
							'target_field' => $this->action_meta,
							'endpoint'     => 'select_achievements_from_types_REVOKEACHIEVEMENT',
						]
					),
					$uncanny_automator->options->select_field( $this->action_meta, __( 'Select a Award', 'uncanny-automator' ), [ '' => __( 'Select a Type Above', 'uncanny-automator' ) ] ),
				],
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function revoke_an_achievement( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		$achievement_id = $action_data['meta'][ $this->action_meta ];
		// If the user has not already earned the achievement...
		if ( gamipress_get_user_achievements( [ 'user_id' => absint( $user_id ), 'achievement_id' => absint( $achievement_id ) ] ) ) {
			
			gamipress_revoke_achievement_to_user( absint( $achievement_id ), absint( $user_id ) );

			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
		} else {
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, __( 'User did not have the specified Achievement.', 'uncanny-automator' ) );
		}
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_achievements_from_types_func() {

		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {

			$args = [
				'post_type'      => $_POST['value'],
				'posts_per_page' => 999,
				'orderby'        => 'title',
				'order'          => 'ASC',
				'post_status'    => 'publish',
			];
		}

		$options = $uncanny_automator->options->wp_query( $args, false, 'awards' );

		foreach ( $options as $award_id => $award_name ) {
			$fields[] = array(
				'value' => $award_id,
				'text'  => $award_name,
			);
		}

		echo wp_json_encode( $fields );
		die();
	}

}
