<?php

namespace Uncanny_Automator_Pro;

/**
 * Class ANON_CF_SUBFIELD
 * @package Uncanny_Automator_Pro
 */
class ANON_CF_SUBFIELD {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'CF';

	private $trigger_code;
	private $trigger_meta;
	private $tag_types;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'ANONCFSUBFIELD';
		$this->trigger_meta = 'ANONCFFORMS';
		add_filter( 'wpcf_verify_nonce', '__return_true' );
		$this->define_trigger();
		add_action( 'wp_ajax_select_form_fields_ANONCFFORMS', array( $this, 'select_form_fields_func' ) );
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {
		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'meta'                => $this->trigger_meta,
			/* Translators: 1:Forms*/
			'sentence'            => sprintf( __( 'A {{Caldera Form:%1$s}} is submitted with {{a specific value:%2$s}} in {{a specific field:%3$s}}', 'uncanny-automator' ), $this->trigger_meta, 'SUBVALUE', $this->trigger_code ),
			'select_option_name'  => __( 'A {{Caldera Form}} is submitted with {{a specific value}} in {{a specific field}}', 'uncanny-automator' ),
			'action'              => 'caldera_forms_submit_complete',
			'type'                => 'anonymous',
			'priority'            => 99,
			'accepted_args'       => 4,
			'validation_function' => array( $this, 'caldera_forms_submit' ),
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_caldera_forms_forms( null, $this->trigger_meta, [
						'token'        => false,
						'is_ajax'      => true,
						'target_field' => $this->trigger_code,
						'endpoint'     => 'select_form_fields_ANONCFFORMS',
					] ),
					$uncanny_automator->options->select_field( $this->trigger_code, __( 'Select a field', 'uncanny-automator' ) ),
					$uncanny_automator->options->text_field( 'SUBVALUE' ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $form
	 * @param $result
	 */
	public function caldera_forms_submit( $form, $referrer, $process_id, $entryid ) {
		global $uncanny_automator;

		$user_id = get_current_user_id();

		if ( empty( $form ) ) {
			return;
		}

		$recipes    = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );
		$conditions = $this->match_condition( $form, $recipes, $this->trigger_meta, $this->trigger_code, 'SUBVALUE' );

		if ( ! $conditions ) {
			return;
		}

		if ( ! empty( $conditions ) ) {
			foreach ( $conditions['recipe_ids'] as $recipe_id ) {
				if ( ! $uncanny_automator->is_recipe_completed( $recipe_id, $user_id ) ) {
					$args = [
						'code'            => $this->trigger_code,
						'meta'            => $this->trigger_meta,
						'recipe_to_match' => $recipe_id,
						'ignore_post_id'  => true,
						'user_id'         => $user_id,
					];

					$uncanny_automator->maybe_add_trigger_entry( $args );
				}
			}
		}

	}

	/**
	 * @param      $form
	 * @param null $recipes
	 * @param null $trigger_meta
	 * @param null $trigger_code
	 * @param null $trigger_second_code
	 *
	 * @return array|bool
	 */
	public function match_condition( $form, $recipes = null, $trigger_meta = null, $trigger_code = null, $trigger_second_code = null ) {

		if ( null === $recipes ) {
			return false;
		}

		$matches        = [];
		$recipe_ids     = [];
		$entry_to_match = $form['ID'];

		foreach ( $recipes as $recipe ) {
			foreach ( $recipe['triggers'] as $trigger ) {
				if ( key_exists( $trigger_meta, $trigger['meta'] ) && (string) $trigger['meta'][ $trigger_meta ] === (string) $entry_to_match ) {
					$matches[ $recipe['ID'] ]    = [
						'field' => $trigger['meta'][ $trigger_code ],
						'value' => $trigger['meta'][ $trigger_second_code ],
					];
					$recipe_ids[ $recipe['ID'] ] = $recipe['ID'];
					break;
				}
			}
		}

		if ( ! empty( $matches ) ) {
			foreach ( $matches as $recipe_id => $match ) {
				if ( $_POST[ $match['field'] ] != $match['value'] ) {
					unset( $recipe_ids[ $recipe_id ] );
				}
			}
		}

		if ( ! empty( $recipe_ids ) ) {
			return [ 'recipe_ids' => $recipe_ids, 'result' => true ];
		}

		return false;
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_form_fields_func() {

		global $uncanny_automator;

		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];

		if ( isset( $_POST ) ) {
			$form_id = $_POST['value'];
			$integration = $_POST['integration'];

			$form = \Caldera_Forms_Forms::get_form( $form_id );

			if ( ! empty( $form['fields'] ) ) {
				foreach ( $form['fields'] as $field ) {
					if ( $field['type'] !== 'html'
					     && $field['type'] !== 'summary'
					     && $field['type'] !== 'section_break'
					     && $field['type'] !== 'button'
					) {
						$fields[] = [
							'value' => $field['ID'],
							'text'  => $field['label'],
						];
					}
				}
			}
		}

		echo wp_json_encode( $fields );
		die();
	}
}