<?php

namespace Uncanny_Automator_Pro;

/**
 * Class BP_REMOVEFROMGROUP
 * @package Uncanny_Automator_Pro
 */
class BP_REMOVEFROMGROUP {

    private $action_code;
    private $action_meta;
    private $action_integration;

    /**
     * SetAutomatorTriggers constructor.
     */
    public function __construct() {
        $this->action_code        = 'BPREMOVEFROMGROUP';
        $this->action_meta        = 'BPREMOVEGROUPS';
        $this->action_integration = 'BP';
        add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ), 30 );
    }

    /**
     *
     */
    public function plugins_loaded() {

        $this->define_action();
    }

    /**
     *
     */
    public function define_action() {

        global $uncanny_automator;

        $bp_group_args = array(
            'uo_include_any' => true,
            'uo_any_label'   => __( 'All Groups', 'uncanny-automator' ),
            'status'         => array( 'public', 'hidden', 'private' ),
        );

        $action = array(
            'author'             => $uncanny_automator->get_author_name(),
            'support_link'       => $uncanny_automator->get_author_support_link(),
            'integration'        => $this->action_integration,
            'code'               => $this->action_code,
            'sentence'           => sprintf( __(  'Remove user from {{a group:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
            'select_option_name' => __( 'Remove user from {{a group}}', 'uncanny-automator' ),
            'priority'                  => 10,
            'accepted_args'             => 1,
            'execution_function' => array( $this, 'remove_from_bp_group' ),
            'options'                   => [
                $uncanny_automator->options->all_buddypress_groups( null, $this->action_meta, $bp_group_args ),
            ],
        );

        $uncanny_automator->register_action( $action );
    }


    /**
     * Remove from BP Groups
     *
     * @param string $user_id
     * @param array  $action_data
     * @param string $recipe_id
     *
     * @return void
     *
     * @since 1.1
     */
    public function remove_from_bp_group( $user_id, $action_data, $recipe_id ) {

        global $uncanny_automator;
        $remove_from_bp_group = $action_data['meta'][ $this->action_meta ];
        if( $remove_from_bp_group === "-1")
        {
            $all_user_groups = groups_get_user_groups($user_id);
            if(!empty($all_user_groups['groups']))
            {
                foreach($all_user_groups['groups'] as $group)
                {
                    $result = groups_leave_group($group, $user_id);
                }
            }
        }else{
            groups_leave_group($remove_from_bp_group, $user_id);
        }

        $uncanny_automator->complete_action($user_id, $action_data, $recipe_id);
    }
}