var EditableTable = function () {

    return {

        //main function to initiate the module
        init: function () {
            function restoreRow(oTable, nRow) {
                var aData = oTable.fnGetData(nRow);
                var jqTds = $('>td', nRow);

                for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                    oTable.fnUpdate(aData[i], nRow, i, false);
                }

                oTable.fnDraw();
            }

            function editRow(oTable, nRow) {
                var aData = oTable.fnGetData(nRow);
                var jqTds = $('>td', nRow);
                var selected;
                if(aData[1] == "Active") { selectedA = "selected"; }else{ selectedA='';}
                if(aData[1] == "Disable") { selectedD = "selected"; }else{ selectedD='';}

                jqTds[0].innerHTML = '<input id="geofence_name_' + aData[2] + '" type="text" class="form-control small" value="' + aData[0] + '">';
                //jqTds[1].innerHTML = '<input type="text" class="form-control small" value="' + aData[1] + '">';
                jqTds[1].innerHTML = '<select id="geofence_status_' + aData[2] + '" name="geofence_status" '+ selectedA +' class="form-control selectpicker error" aria-invalid="true"><option value="1">Active</option><option '+ selectedD +' value="0">Disable</option></select>';
                //jqTds[2].innerHTML = '<input type="text" class="form-control small" value="' + aData[2] + '">';
                jqTds[3].innerHTML = '<a class="edit save_row" data-id="' + aData[2] + '" href="">Save</a>';
                jqTds[4].innerHTML = '<a class="cancel" href="">Cancel</a>';
            }

            function saveRow(oTable, nRow) {
                var jqInputs = $('input', nRow);
                oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
                oTable.fnUpdate('<a class="edit" href="javascript:void(0)" class="draw-map map-sum-btn">Edit</a>', nRow, 3, false);
                oTable.fnUpdate('<a class="delete" href="javascript:void(0)" class="draw-map map-sum-btn">Delete</a>', nRow, 4, false);
                oTable.fnDraw();
            }

            function cancelEditRow(oTable, nRow) {
                var jqInputs = $('input', nRow);
                oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
                oTable.fnUpdate('<a class="edit btn btnOption" href="javascript:void(0)" class="draw-map map-sum-btn"><span class="glyphicon glyphicon-pencil"></span></a>', nRow, 3, false);
                oTable.fnDraw();
            }

            var oTable = $('#editable-sample').dataTable({
                "sDom": "<'row'<'col-lg-6'><'col-lg-6'>r>t<'row'<'col-lg-6'><'col-lg-6'p>>",
                //"sPaginationType": "bootstrap",
                "searching": false,
                "pageLength": 5,
                "lengthChange": false,
                 "bLengthChange": false,
                  "bInfo" : false,
                  //"bPaginate": false,
                "oLanguage": {
                    //"sLengthMenu": "_MENU_ records per page",
                    "oPaginate": {
                        "sPrevious": "Prev",
                        "sNext": "Next"
                    }
                },
"order": [[ 6, "desc" ]],
                "columnDefs": [ {
                    "targets": [3,4,5],
                    "orderable": false
                  } ]
            });

          //  jQuery('#editable-sample_wrapper .dataTables_filter input').addClass("form-control medium"); // modify table search input
            jQuery('#editable-sample_wrapper .dataTables_length select').addClass("form-control xsmall"); // modify table per page dropdown

            var nEditing = null;

            $('#editable-sample_new').click(function (e) {
                e.preventDefault();
                var aiNew = oTable.fnAddData(['', '', '', '',
                        '<a class="edit" href="">Edit</a>', '<a class="cancel" data-mode="new" href="">Cancel</a>'
                ]);
                var nRow = oTable.fnGetNodes(aiNew[0]);
                editRow(oTable, nRow);
                nEditing = nRow;
            });

            $('#editable-sample a.delete').on('click', function (e) {
                e.preventDefault();

                if (confirm("Are you sure to delete this row ?") == true) {
                  //alert( $(this).data('id') );
                  $.ajax({
                    url: base_url+'geo/delete_geofence',
                    type: 'post',
                    data: { id: $(this).data('id') },
                    // beforeSend: function()
                    // {
                    //   $('.btnOption').text('Processing');
                    // },
                    success: function(response)
                    {
                      console.log(response);
                    }
                  })
                }

                var nRow = $(this).parents('tr')[0];
                oTable.fnDeleteRow(nRow);
                alert("Deleted!");
            });

            $('#editable-sample a.cancel').on('click', function (e) {
                e.preventDefault();
                if ($(this).attr("data-mode") == "new") {
                    var nRow = $(this).parents('tr')[0];
                    oTable.fnDeleteRow(nRow);
                } else {
                    restoreRow(oTable, nEditing);
                    nEditing = null;
                }
            });

            $('#editable-sample a.edit').on('click', function (e) {
                e.preventDefault();
                /* Get the row as a parent of the link that was clicked on */
                var nRow = $(this).parents('tr')[0];

                if (nEditing !== null && nEditing != nRow) {
                    /* Currently editing - but not this row - restore the old before continuing to edit mode */
                    restoreRow(oTable, nEditing);
                    editRow(oTable, nRow);
                    nEditing = nRow;
                } else if (nEditing == nRow && this.innerHTML == "Save") {
                    /* Editing this row and want to save it */
                    //alert('--');
                    saveRow(oTable, nEditing);
                    nEditing = null;
                    alert("Updated! Do not forget to do some ajax to sync with backend :)");
                } else {
                    /* No edit in progress - let's start one */
                    editRow(oTable, nRow);
                    nEditing = nRow;
                }
            });
        }

    };

}();
