<?php

Class Switchs extends CI_Model
{

	public $table_street = 'street_sheet';
	public $table_address = 'street_address';
	public $assign_area = 'assign_area';

	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql',true);
	}

	function total_knocked()
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['status <>' => 'n/a'])->get()->result_array();
	}

	function total_address()
	{
		return $this->mysql->select('*')->from($this->table_address)->get()->result_array();
	}

	function total_pitch()
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['status' => 'P'])->get()->result_array();
	}

	function total_sale()
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['status' => 'S'])->get()->result_array();
	}

	function team_street($teamID)
	{
		return $this->mysql->select('*')->from($this->assign_area)->where(['team_id' => $teamID])->get()->result_array();
	}

	function team_street_area($teamID)
	{
		return $this->mysql->select('*')->from($this->assign_area)->where(['team_id' => $teamID])->get()->first_row('array');
	}

	function street_address($streetID)
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['street_id' => $streetID])->get()->result_array();
	}

	function street_address_area($streetID)
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['street_id' => $streetID])->get()->first_row('array');
	}

	function not_assigned_area()
	{
		$result = $this->mysql->select('postcode')->from($this->table_street)->where('assign' ,'0')->get()->result();
		foreach( $result as $row )
	    {
	         $data[] = $row->postcode;
	    }
	    return $data;
	}

	function get_street_id($postcode)
	{
		$result = $this->mysql->select('street_id')->from($this->table_street)->where(['postcode' => $postcode])->get()->result();
		foreach( $result as $row )
	    {
	         $data = $row->street_id;
	    }
	    return $data;
	}

	function set_area_team($data)
	{
		for( $m=0; $m<count($data['street_id']); $m++ )
		{
			$row['team_id'] = $data['team_id'];
			$row['assign_street_id'] = $data['street_id'][$m];
			$this->mysql->insert($this->assign_area,$row);
		}

		//set street to assign status
		for( $i=0; $i<count($data['street_id']); $i++ )
		{
			$row1['assign'] = '1';
			$update = $this->mysql->where('street_id',$data['street_id'][$i])->update($this->table_street,$row1);
		}
		return $update;

	}

	function street_detail($streetID)
	{
		return $this->mysql->select('*')->from($this->table_street)->where('street_id', $streetID)->get()->first_row('array');
	}

	function street_detail_postocde($streetID)
	{
		$return = $this->mysql->select('postcode')->from($this->table_street)->where('street_id', $streetID)->get();
		foreach( $return->result() as $row )
		{
			return $row->postcode;
		}
	}
}