<?php

Class Switchs extends CI_Model
{

	public $table_street = 'street_sheet';
	public $table_address = 'street_address';
	public $assign_area = 'assign_area';
	public $address_user = 'address_user';
	public $address_knock = 'address_knock';
	public $address_pitch = 'address_pitch';
	
	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql',true);
	}

	function total_knocked()
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['status <>' => 'n/a'])->get()->result_array();
	}

	function total_address()
	{
		return $this->mysql->select('*')->from($this->table_address)->get()->result_array();
	}

	function total_pitch()
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['status' => 'P'])->get()->result_array();
	}

	function total_sale()
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['status' => 'S'])->get()->result_array();
	}

	function team_street($teamID)
	{
		return $this->mysql->select('*')->from($this->assign_area)->where(['team_id' => $teamID])->get()->result_array();
	}

	function team_street_area($teamID)
	{
		return $this->mysql->select('*')->from($this->assign_area)->where(['team_id' => $teamID])->get()->first_row('array');
	}

	function street_address($streetID)
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['street_id' => $streetID])->get()->result_array();
	}

	function street_address_area($streetID)
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['street_id' => $streetID])->get()->first_row('array');
	}

	function not_assigned_area()
	{
		$result = $this->mysql->select('postcode')->from($this->table_street)->where('assign' ,'0')->get()->result();
		foreach( $result as $row )
	    {
	         $data[] = $row->postcode;
	    }
	    return $data;
	}

	function get_street_id($postcode)
	{
		$result = $this->mysql->select('street_id')->from($this->table_street)->where(['postcode' => $postcode])->get()->result();
		foreach( $result as $row )
	    {
	         $data = $row->street_id;
	    }
	    return $data;
	}

	function set_area_team($data)
	{
		for( $m=0; $m<count($data['street_id']); $m++ )
		{
			$row['user_id'] = $data['user_id'];
			$row['assign'] = '1';
			$update = $this->mysql->where('street_id',$data['street_id'][$m])->update('street_sheet',$row);
		}

		//set street to assign status
		// for( $i=0; $i<count($data['street_id']); $i++ )
		// {
		// 	$row1['assign'] = '1';
		// 	$update = $this->mysql->where('street_id',$data['street_id'][$i])->update($this->table_street,$row1);
		// }
		return $update;

	}

	function street_detail($streetID)
	{
		return $this->mysql->select('*')->from($this->table_street)->where('street_id', $streetID)->get()->first_row('array');
	}

	function street_detail_postocde($streetID)
	{
		$return = $this->mysql->select('postcode')->from($this->table_street)->where('street_id', $streetID)->get();
		foreach( $return->result() as $row )
		{
			return $row->postcode;
		}
	}

	function get_user_street($userID)
	{
		$return = $this->mysql->select('*')->from($this->table_street)->where(['user_id' => $userID])->get();
		foreach( $return->result() as $row )
		{
			return $row->street_id;
		}
	}

	function not_assign_area()
	{
		return $this->mysql->select('*')->from($this->table_street)->where(['assign'=> '0'])->get()->result_array();
		//echo $this->mysql->last_query();
	}

	//assign street
	function update_user_street($street_id,$id)
	{
		//debug($street_id,1);
		for( $i=0; $i<count($street_id);$i++ )
		{
			$data['user_id'] = $id;
			$data['assign'] = '1';
			$data['update_at'] = date('Y-m-d H:i:s');
			$update = $this->mysql->where('street_id',$street_id[$i])->update($this->table_street,$data);
			//echo $this->mysql->last_query();
		}
		//exit;
		return $update;
		
		//echo $this->mysql->last_query();
	}

	function knock_user($userID)
	{
		return $this->mysql->distinct()->select('address_id')->from($this->address_user)->where(['user_id' => $userID])->get()->result_array();
	}

	function sale_user($address_id)
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['address_id' => $address_id, 'status' => 'S' ])->get()->first_row('array');
	}

	function pitch_user($address_id)
	{
		return $this->mysql->select('*')->from($this->table_address)->where(['address_id' => $address_id, 'status' => 'P' ])->get()->first_row('array');
	}

	function knock_canvasser($userID)
	{
		return $this->mysql->distinct()->select('address_id')->from($this->address_knock)->where(['user_id' => $userID])->get()->result_array();
	}

	function pitch_canvasser($userID)
	{
		return $this->mysql->distinct()->select('address_id')->from($this->address_pitch)->where(['user_id' => $userID])->get()->result_array();
	}

	function sales_canvasser($userID)
	{
		return $this->mysql->distinct()->select('address_id')->from('sales')->where(['user_id' => $userID])->get()->result_array();
	}
}