<?php

Class User extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->model('sales');
		$this->load->model('users');
		$this->load->model('streets');
	
	}

	function index()
	{
		if( $this->session->userdata('login_id') != 1 )
        {
        	redirect('/user/login');
        }
        else
        {
        	redirect('/user/home');	
        }
		
	}

	function login()
	{
		$this->load->view('layout/newlogin');
	}

	function logout()
	{
		$this->session->set_userdata('login_id','0');
		redirect('/');
	}

	function system_user()
	{
		$this->session->set_userdata('type', 'system');
		$this->session->set_userdata('login_id', 1);
		$this->session->set_userdata('login_name', 'Super User');
		$this->session->set_userdata('office_id', '23');
		//$this->offices->event_log();
		if($this->session->userdata('type') && $this->session->userdata('login_id') )
		{
			echo 'done';
		}
		else
		{
			echo 'fail';
		}
	}

	function home()
	{
		if( $this->session->userdata('login_id') != 1 )
        {
        	redirect('/user/login');
        }
		// for sales tab on dashboard
		$sales = $this->sales->get_sales();
		for( $m=0; $m<count($sales); $m++ )
		{
			$data['user_detail'][] = $this->users->get_user_detail($sales[$m]['user_id']);

			for( $i=0; $i<count( $data['user_detail'] ); $i++ )
			{
				$data['user_detail'][$m]['commission_earned'] = $this->users->get_user_commission($data['user_detail'][$i]['user_id']);
			}
		}

		//for knocks on dashboard
		$data['knocks'] = $this->streets->get_knock_address();
		for( $k=0; $k<count($data['knocks']); $k++ )
		{
			$data['knocks'][$k]['street_name'] = $this->streets->get_street_by_address($data['knocks'][$k]['street_id']);
		}

		// pitch tab on dashbaord
		$data['pitch'] = $this->streets->get_pitch();
		for( $n=0; $n<count($data['pitch']); $n++ )
		{
			$data['pitch'][$n]['street_name'] = $this->streets->get_street_by_address($data['pitch'][$n]['street_id']);
		}

		//debug($data['pitch'],1);
		$data['content'] = 'user/user_list';
		$this->load->view('layout/master',$data);
	}
}
