<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>


    <!--[if gte mso 15]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Signup Confirmation</title>

    <style>
        @import url('https://fonts.googleapis.com/css?family=Quicksand:400,500');
    </style>

    <style type="text/css">
        p {
            margin: 10px 0;
            padding: 0;
        }

        table {
            border-collapse: collapse;
        }

        h1, h2, h3, h4, h5, h6 {
            display: block;
            margin: 0;
            padding: 0;
        }

        img, a img {
            border: 0;
            height: auto;
            outline: none;
            text-decoration: none;
        }

        body, #bodyTable, #bodyCell {
            height: 100%;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        .mcnPreviewText {
            display: none !important;
        }

        #outlook a {
            padding: 0;
        }

        img {
            -ms-interpolation-mode: bicubic;
        }

        table {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        .ReadMsgBody {
            width: 100%;
        }

        .ExternalClass {
            width: 100%;
        }

        p, a, li, td, blockquote {
            mso-line-height-rule: exactly;
        }

        a[href^=tel], a[href^=sms] {
            color: inherit;
            cursor: default;
            text-decoration: none;
        }

        p, a, li, td, body, table, blockquote {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        .ExternalClass, .ExternalClass p, .ExternalClass td, .ExternalClass div, .ExternalClass span, .ExternalClass font {
            line-height: 100%;
        }

        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        #bodyCell {
            padding: 10px;
        }

        .templateContainer {
            max-width: 600px !important;
        }

        a.mcnButton {
            display: block;
        }

        .mcnImage, .mcnRetinaImage {
            vertical-align: bottom;
        }

        .mcnTextContent {
            word-break: break-word;
        }

        .mcnTextContent img {
            height: auto !important;
        }

        .mcnDividerBlock {
            table-layout: fixed !important;
        }

        /*
        @tab Page
        @section Background Style
        @tip Set the background color and top border for your email. You may want to choose colors that match your company's branding.
        */
        body, #bodyTable {
            /*@editable*/
            background-color: #FAFAFA;
        }

        /*
        @tab Page
        @section Background Style
        @tip Set the background color and top border for your email. You may want to choose colors that match your company's branding.
        */
        #bodyCell {
            /*@editable*/
            border-top: 0;
        }

        /*
        @tab Page
        @section Email Border
        @tip Set the border for your email.
        */
        .templateContainer {
            /*@editable*/
            border: 0;
        }

        /*
        @tab Page
        @section Heading 1
        @tip Set the styling for all first-level headings in your emails. These should be the largest of your headings.
        @style heading 1
        */
        h1 {
            /*@editable*/
            color: #202020;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 26px;
            /*@editable*/
            font-style: normal;
            /*@editable*/
            font-weight: bold;
            /*@editable*/
            line-height: 125%;
            /*@editable*/
            letter-spacing: normal;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Page
        @section Heading 2
        @tip Set the styling for all second-level headings in your emails.
        @style heading 2
        */
        h2 {
            /*@editable*/
            color: #202020;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 22px;
            /*@editable*/
            font-style: normal;
            /*@editable*/
            font-weight: bold;
            /*@editable*/
            line-height: 125%;
            /*@editable*/
            letter-spacing: normal;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Page
        @section Heading 3
        @tip Set the styling for all third-level headings in your emails.
        @style heading 3
        */
        h3 {
            /*@editable*/
            color: #202020;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 20px;
            /*@editable*/
            font-style: normal;
            /*@editable*/
            font-weight: bold;
            /*@editable*/
            line-height: 125%;
            /*@editable*/
            letter-spacing: normal;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Page
        @section Heading 4
        @tip Set the styling for all fourth-level headings in your emails. These should be the smallest of your headings.
        @style heading 4
        */
        h4 {
            /*@editable*/
            color: #202020;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 18px;
            /*@editable*/
            font-style: normal;
            /*@editable*/
            font-weight: bold;
            /*@editable*/
            line-height: 125%;
            /*@editable*/
            letter-spacing: normal;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Preheader
        @section Preheader Style
        @tip Set the background color and borders for your email's preheader area.
        */
        #templatePreheader {
            /*@editable*/
            background-color: #fafafa;
            /*@editable*/
            background-image: none;
            /*@editable*/
            background-repeat: no-repeat;
            /*@editable*/
            background-position: center;
            /*@editable*/
            background-size: cover;
            /*@editable*/
            border-top: 0;
            /*@editable*/
            border-bottom: 0;
            /*@editable*/
            padding-top: 9px;
            /*@editable*/
            padding-bottom: 9px;
        }

        /*
        @tab Preheader
        @section Preheader Text
        @tip Set the styling for your email's preheader text. Choose a size and color that is easy to read.
        */
        #templatePreheader .mcnTextContent, #templatePreheader .mcnTextContent p {
            /*@editable*/
            color: #656565;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 12px;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Preheader
        @section Preheader Link
        @tip Set the styling for your email's preheader links. Choose a color that helps them stand out from your text.
        */
        #templatePreheader .mcnTextContent a, #templatePreheader .mcnTextContent p a {
            /*@editable*/
            color: #656565;
            /*@editable*/
            font-weight: normal;
            /*@editable*/
            text-decoration: underline;
        }

        /*
        @tab Header
        @section Header Style
        @tip Set the background color and borders for your email's header area.
        */
        #templateHeader {
            /*@editable*/
            background-color: #FFFFFF;
            /*@editable*/
            background-image: none;
            /*@editable*/
            background-repeat: no-repeat;
            /*@editable*/
            background-position: center;
            /*@editable*/
            background-size: cover;
            /*@editable*/
            border-top: 0;
            /*@editable*/
            border-bottom: 0;
            /*@editable*/
            padding-top: 9px;
            /*@editable*/
            padding-bottom: 0;
        }

        /*
        @tab Header
        @section Header Text
        @tip Set the styling for your email's header text. Choose a size and color that is easy to read.
        */
        #templateHeader .mcnTextContent, #templateHeader .mcnTextContent p {
            /*@editable*/
            color: #202020;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 16px;
            /*@editable*/
            line-height: 150%;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Header
        @section Header Link
        @tip Set the styling for your email's header links. Choose a color that helps them stand out from your text.
        */
        #templateHeader .mcnTextContent a, #templateHeader .mcnTextContent p a {
            /*@editable*/
            color: #2BAADF;
            /*@editable*/
            font-weight: normal;
            /*@editable*/
            text-decoration: underline;
        }

        /*
        @tab Body
        @section Body Style
        @tip Set the background color and borders for your email's body area.
        */
        #templateBody {
            /*@editable*/
            background-color: #ffffff;
            /*@editable*/
            background-image: none;
            /*@editable*/
            background-repeat: no-repeat;
            /*@editable*/
            background-position: center;
            /*@editable*/
            background-size: cover;
            /*@editable*/
            border-top: 0;
            /*@editable*/
            border-bottom: 2px solid #EAEAEA;
            /*@editable*/
            padding-top: 0;
            /*@editable*/
            padding-bottom: 9px;
        }

        /*
        @tab Body
        @section Body Text
        @tip Set the styling for your email's body text. Choose a size and color that is easy to read.
        */
        #templateBody .mcnTextContent, #templateBody .mcnTextContent p {
            /*@editable*/
            color: #202020;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 16px;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Body
        @section Body Link
        @tip Set the styling for your email's body links. Choose a color that helps them stand out from your text.
        */
        #templateBody .mcnTextContent a, #templateBody .mcnTextContent p a {
            /*@editable*/
            color: #2BAADF;
            /*@editable*/
            font-weight: normal;
            /*@editable*/
            text-decoration: underline;
        }

        /*
        @tab Footer
        @section Footer Style
        @tip Set the background color and borders for your email's footer area.
        */
        #templateFooter {
            /*@editable*/
            background-color: #EA495C;
            /*@editable*/
            background-image: url("<?php echo base_url(); ?>assets/images/email_footer.png");
            /*@editable*/
            background-repeat: no-repeat;
            /*@editable*/
            background-position: center bottom;
            /*@editable*/
            background-size: cover;
            /*@editable*/
            border-top: 0;
            /*@editable*/
            border-bottom: 0;
            /*@editable*/
            padding-top: 9px;
            /*@editable*/
            padding-bottom: 100px;
        }

        #templateFooter .mcnFollowIconContent img{
            height: 30px;
            width: auto;
            display: block;
            padding-top: 20px;
        }

        /*
        @tab Footer
        @section Footer Text
        @tip Set the styling for your email's footer text. Choose a size and color that is easy to read.
        */
        #templateFooter .mcnTextContent, #templateFooter .mcnTextContent p {
            /*@editable*/
            color: #FFFFFF;
            /*@editable*/
            font-family: 'Quicksand', sans-serif;
            /*@editable*/
            font-size: 14px;
            /*@editable*/
            text-align: left;
        }

        /*
        @tab Footer
        @section Footer Link
        @tip Set the styling for your email's footer links. Choose a color that helps them stand out from your text.
        */
        #templateFooter .mcnTextContent a, #templateFooter .mcnTextContent p a {
            /*@editable*/
            color: #FFFFFF;
            /*@editable*/
            font-weight: normal;
            /*@editable*/
            text-decoration: none;
        }

        @media only screen and (min-width: 768px) {
            .templateContainer {
                width: 600px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            body, table, td, p, a, li, blockquote {
                -webkit-text-size-adjust: none !important;
            }

        }

        @media only screen and (max-width: 480px) {
            body {
                width: 100% !important;
                min-width: 100% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            #bodyCell {
                padding-top: 10px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnRetinaImage {
                max-width: 100% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImage {
                width: 100% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnCartContainer, .mcnCaptionTopContent, .mcnRecContentContainer, .mcnCaptionBottomContent, .mcnTextContentContainer, .mcnBoxedTextContentContainer, .mcnImageGroupContentContainer, .mcnCaptionLeftTextContentContainer, .mcnCaptionRightTextContentContainer, .mcnCaptionLeftImageContentContainer, .mcnCaptionRightImageContentContainer, .mcnImageCardLeftTextContentContainer, .mcnImageCardRightTextContentContainer, .mcnImageCardLeftImageContentContainer, .mcnImageCardRightImageContentContainer {
                max-width: 100% !important;
                width: 100% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnBoxedTextContentContainer {
                min-width: 100% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImageGroupContent {
                padding: 9px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnCaptionLeftContentOuter .mcnTextContent, .mcnCaptionRightContentOuter .mcnTextContent {
                padding-top: 9px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImageCardTopImageContent, .mcnCaptionBottomContent:last-child .mcnCaptionBottomImageContent, .mcnCaptionBlockInner .mcnCaptionTopContent:last-child .mcnTextContent {
                padding-top: 18px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImageCardBottomImageContent {
                padding-bottom: 9px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImageGroupBlockInner {
                padding-top: 0 !important;
                padding-bottom: 0 !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImageGroupBlockOuter {
                padding-top: 9px !important;
                padding-bottom: 9px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnTextContent, .mcnBoxedTextContentColumn {
                padding-right: 18px !important;
                padding-left: 18px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcnImageCardLeftImageContent, .mcnImageCardRightImageContent {
                padding-right: 18px !important;
                padding-bottom: 0 !important;
                padding-left: 18px !important;
            }

        }

        @media only screen and (max-width: 480px) {
            .mcpreview-image-uploader {
                display: none !important;
                width: 100% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Heading 1
            @tip Make the first-level headings larger in size for better readability on small screens.
            */
            h1 {
                /*@editable*/
                font-size: 22px !important;
                /*@editable*/
                line-height: 125% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Heading 2
            @tip Make the second-level headings larger in size for better readability on small screens.
            */
            h2 {
                /*@editable*/
                font-size: 20px !important;
                /*@editable*/
                line-height: 125% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Heading 3
            @tip Make the third-level headings larger in size for better readability on small screens.
            */
            h3 {
                /*@editable*/
                font-size: 18px !important;
                /*@editable*/
                line-height: 125% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Heading 4
            @tip Make the fourth-level headings larger in size for better readability on small screens.
            */
            h4 {
                /*@editable*/
                font-size: 16px !important;
                /*@editable*/
                line-height: 150% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Boxed Text
            @tip Make the boxed text larger in size for better readability on small screens. We recommend a font size of at least 16px.
            */
            .mcnBoxedTextContentContainer .mcnTextContent, .mcnBoxedTextContentContainer .mcnTextContent p {
                /*@editable*/
                font-size: 14px !important;
                /*@editable*/
                line-height: 150% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Preheader Visibility
            @tip Set the visibility of the email's preheader on small screens. You can hide it to save space.
            */
            #templatePreheader {
                /*@editable*/
                display: block !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Preheader Text
            @tip Make the preheader text larger in size for better readability on small screens.
            */
            #templatePreheader .mcnTextContent, #templatePreheader .mcnTextContent p {
                /*@editable*/
                font-size: 14px !important;
                /*@editable*/
                line-height: 150% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Header Text
            @tip Make the header text larger in size for better readability on small screens.
            */
            #templateHeader .mcnTextContent, #templateHeader .mcnTextContent p {
                /*@editable*/
                font-size: 16px !important;
                /*@editable*/
                line-height: 150% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Body Text
            @tip Make the body text larger in size for better readability on small screens. We recommend a font size of at least 16px.
            */
            #templateBody .mcnTextContent, #templateBody .mcnTextContent p {
                /*@editable*/
                font-size: 16px !important;
                /*@editable*/
                line-height: 150% !important;
            }

        }

        @media only screen and (max-width: 480px) {
            /*
            @tab Mobile Styles
            @section Footer Text
            @tip Make the footer content text larger in size for better readability on small screens.
            */
            #templateFooter .mcnTextContent, #templateFooter .mcnTextContent p {
                /*@editable*/
                font-size: 14px !important;
                /*@editable*/
                line-height: 150% !important;
            }

        }</style>
</head>
<body>
<center>
    <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable">
        <tr>
            <td align="center" valign="top" id="bodyCell">
                <table align="center" border="0" cellspacing="0" cellpadding="0" width="600" style="width:600px;">
                    <tr>
                        <td align="center" valign="top" width="600" style="width:600px;">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="templateContainer">


                                <!------------------------------- START HEADER ------------------------------->
                                <tr>
                                    <td valign="top" id="templateHeader">
                                        <table class="mcnImageBlock" style="min-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0">
                                            <tbody class="mcnImageBlockOuter">
                                            <tr>
                                                <td style="padding:0px" class="mcnImageBlockInner" valign="top">
                                                    <table class="mcnImageContentContainer" style="min-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="left">
                                                        <tbody>
                                                        <tr>
                                                            <td class="mcnImageContent" style="padding-right: 0px; padding-left: 0px; padding-top: 0; padding-bottom: 0; text-align:center;" valign="top">
                                                                <img alt="" src="<?php echo base_url(); ?>assets/images/meter_header.png" style="width:100%;max-width:1200px; padding-bottom: 0; display: inline !important; vertical-align: bottom;" class="mcnImage" width="600" align="middle">
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                <!------------------------------- END HEADER ------------------------------->


                                <tr>
                                    <td valign="top" id="templateBody">


                                        <!------------------------------- START MAIN BODY ------------------------------->
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
                                            <tbody class="mcnTextBlockOuter">
                                            <tr>
                                                <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
                                                    <table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
                                                        <tr>
                                                            <td valign="top" width="600" style="width:600px;">
                                                                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                                                                    <tbody>
                                                                    <tr>
                                                                        <td valign="top" class="mcnTextContent" style="padding-top:0; padding-right:18px; padding-bottom:9px; padding-left:18px;">

                                                                            <h1 style="margin: 50px 0px; text-align: left;">
                                                                                <span style="font-family: 'Quicksand', sans-serif; font-weight:normal; font-size:46px; color: #1C3659;">Please provide a meter reading</span></span>
                                                                            </h1>

                                                                            <font style="font-family: 'Quicksand', sans-serif;">
                                                                                <span style="font-size:17px">
                                                                                    Hello <?= $email_info['name']; ?>,<br><br>
                                                                                    We’re just getting your bill ready, and we need you to provide a <strong>meter reading</strong>. This will help keep you energy bills fair & accurate.<br><br>
                                                                                    The quickest & easiest way to submit a reading is to do it online in our <a href="<?php echo base_url(); ?>index.php/user/login/" target="_blank">client portal</a>.<br><br>
                                                                                    If you need any help, simply email <a href="mailto:hello@eversmartenergy.co.uk" target="_blank">hello@eversmartenergy.co.uk</a>. You can also find help & advice in our <a href="<?php echo base_url(); ?>index.php/Helpfaqs" target="_blank">FAQs page</a> and the <a href="<?php echo base_url(); ?>index.php/" target="_blank">Eversmart Community forum</a>.<br><br>
                                                                                    From the Eversmart Team
                                                                                </span>
                                                                            </font>
                                                                            <br><br><br>
                                                                        </td>

                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <!------------------------------- END MAIN BODY ------------------------------->


                                    </td>
                                </tr>


                                <!------------------------------- START FOOTER ------------------------------->
                                <tr>
                                    <td valign="top" id="templateFooter" mc:container="footer_container" mccontainer="footer_container" class="tpl-container">

                                        <div mc:block="1858901" mc:blocktype="footer" mcblock="1858901" mcblocktype="footer" class="tpl-block">
                                            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">

                                                <tbody class="mcnTextBlockOuter">
                                                <tr>
                                                    <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
                                                        <table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
                                                            <tr>
                                                                <td valign="top" width="600" style="width:600px;">
                                                                    <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                                                                        <tbody>
                                                                        <tr>
                                                                            <td valign="top" class="mcnTextContent" style="padding-top:0; padding-right:18px; padding-bottom:9px; padding-left:18px;">
                                                                                <br>
                                                                                <span style="color:#1C3659; font-size:17px; font-family: 'Quicksand-Medium', sans-serif;">Our mailing address is:</span>
                                                                                <br>
                                                                                <span style="font-size:15px;">10 Empress Business Park,</span>
                                                                                <br>
                                                                                <span style="font-size:15px;">380 Chester Road, Manchester, M16 9EB</span><br>
                                                                                <br>
                                                                                <span style="color:#1C3659; font-size:17px; font-family: 'Quicksand-Medium', sans-serif;">Text us on:</span><br>
                                                                                <span style="font-size:15px;"><a href="sms:07537417858">07537417858</a></span><br>
                                                                                <br>
                                                                                <span style="color:#1C3659; font-size:17px; font-family: 'Quicksand-Medium', sans-serif;">Genius Hub:</span><br>
                                                                                <span style="font-size:15px;"><a href="http://geniushub.eversmartenergy">geniushub.eversmartenergy</a></span><br>
                                                                                <br>
                                                                                <span style="color:#1C3659; font-size:17px; font-family: 'Quicksand-Medium', sans-serif;">Website:</span><br>
                                                                                <span style="font-size:15px;"><a href="http://www.eversmartenergy.co.uk/">www.eversmartenergy.co.uk</a></span><br>
                                                                                <br>
                                                                                <span style="color:#1C3659; font-size:17px; font-family: 'Quicksand-Medium', sans-serif;">Email Eversmart:</span><br>
                                                                                <span style="font-size:15px;"><a href=mailto:hello@eversmartenergy.co.uk>hello@eversmartenergy.co.uk</a></span><br>
                                                                                <br>
                                                                                <span style="font-size:10px;">Copyright © 2017, Eversmart Energy All rights reserved</span>
                                                                            </td>

                                                                            <td align="left" valign="top" style="width: 45px;">
                                                                                <!-- Facebook -->
                                                                                <table align="left" style="display:inline; width: 30px;" border="0" cellspacing="0" cellpadding="0">
                                                                                    <tbody>
                                                                                    <tr>
                                                                                        <td class="mcnFollowContentItemContainer" valign="top" >
                                                                                            <table width="100%" class="mcnFollowContentItem" border="0" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                <tr>
                                                                                                    <td align="right" valign="top" >
                                                                                                        <table width="" align="right" border="0" cellspacing="0" cellpadding="0">
                                                                                                            <tbody>
                                                                                                            <tr>
                                                                                                                <td width="30" align="center" class="mcnFollowIconContent" valign="top">
                                                                                                                    <a href="http://www.facebook.com/eversmartenergy" target="_blank"><img src="<?php echo base_url(); ?>assets/images/facebookicon.png" height="30" width="auto"></a>
                                                                                                                </td>
                                                                                                            </tr>
                                                                                                            </tbody>
                                                                                                        </table>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </td>

                                                                            <td align="left" valign="top" style="width: 45px;">
                                                                                <!-- Twitter -->
                                                                                <table align="left" style="display:inline; width: 30px;" border="0" cellspacing="0" cellpadding="0">
                                                                                    <tbody>
                                                                                    <tr>
                                                                                        <td class="mcnFollowContentItemContainer" valign="top" >
                                                                                            <table width="100%" class="mcnFollowContentItem" border="0" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                <tr>
                                                                                                    <td align="right" valign="top" >
                                                                                                        <table width="" align="right" border="0" cellspacing="0" cellpadding="0">
                                                                                                            <tbody>
                                                                                                            <tr>
                                                                                                                <td width="30" align="center" class="mcnFollowIconContent" valign="top">
                                                                                                                    <a href="http://www.twitter.com/eversmartenergy" target="_blank"><img src="<?php echo base_url(); ?>assets/images/twittericon.png" height="30" width="auto"></a>
                                                                                                                </td>
                                                                                                            </tr>
                                                                                                            </tbody>
                                                                                                        </table>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </td>

                                                                            <td align="left" valign="top" style="width: 45px;">
                                                                                <!-- Insta -->
                                                                                <table align="left" style="display:inline; width: 30px;" border="0" cellspacing="0" cellpadding="0">
                                                                                    <tbody>
                                                                                    <tr>
                                                                                        <td class="mcnFollowContentItemContainer" valign="top" >
                                                                                            <table width="100%" class="mcnFollowContentItem" border="0" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                <tr>
                                                                                                    <td align="right" valign="top" >
                                                                                                        <table width="" align="right" border="0" cellspacing="0" cellpadding="0">
                                                                                                            <tbody>
                                                                                                            <tr>
                                                                                                                <td width="30" align="center" class="mcnFollowIconContent" valign="top">
                                                                                                                    <a href="http://instagram.com/eversmartenergy" target="_blank"><img src="<?php echo base_url(); ?>assets/images/instaicon.png" height="30" width="auto"></a>
                                                                                                                </td>
                                                                                                            </tr>
                                                                                                            </tbody>
                                                                                                        </table>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </td>

                                                                            <td align="left" valign="top" style="width: 80px;">
                                                                                <!-- Website -->
                                                                                <table align="left" style="display:inline; width: 30px;" border="0" cellspacing="0" cellpadding="0">
                                                                                    <tbody>
                                                                                    <tr>
                                                                                        <td class="mcnFollowContentItemContainer" valign="top" style="padding-right:0; padding-bottom:9px;">
                                                                                            <table width="100%" class="mcnFollowContentItem" border="0" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                <tr>
                                                                                                    <td align="right" valign="top" >
                                                                                                        <table width="" align="right" border="0" cellspacing="0" cellpadding="0">
                                                                                                            <tbody>
                                                                                                            <tr>
                                                                                                                <td width="30" align="center" class="mcnFollowIconContent" valign="top">
                                                                                                                    <a href="http://www.eversmartenergy.co.uk" target="_blank"><img src="<?php echo base_url(); ?>assets/images/websiteicon.png" height="30" width="auto"></a>
                                                                                                                </td>
                                                                                                            </tr>
                                                                                                            </tbody>
                                                                                                        </table>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                                </tbody>

                                            </table>
                                        </div>

                                    </td>
                                </tr>
                                <!------------------------------- END FOOTER ------------------------------->


                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</center>
</body>
</html>
