<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Admin - Customer Sign-Up</title>
	
    <link href="<?php echo base_url(); ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Quicksand:300,400,500,700" rel="stylesheet">

    <link rel="shortcut icon" type="image/png" href="<?php echo base_url(); ?>assets/img/favicon.png" />
    
</head>

<body>

    <div class="container custform col-lg-12">
    <div class="signup_msg"></div>

        <div class="row contact_row">

            <div class="contact_col first_col col-md-6">

                <form class="form-horizontal" id="newCustForm">
                    <fieldset>

                        <legend>Contact Details</legend>

                        <div class="form-group">
                            
                            <label class="control-label form-style-label" for="contact-title">Name</label>  
                            
                            <div class="form-style-field-sm">
                                <input id="contact-title" onkeypress="return !isNumberKey(event)" name="contact-title" type="text" placeholder="Title" class="form-control input-md" maxlength="13"> 
                            </div>

                            <div class="form-style-field-md">
                                <input id="contact-fname" onkeypress="return !isNumberKey(event)" name="contact-fname" type="text" placeholder="Forename" class="form-control input-md" maxlength="25" spellcheck="false">
                            </div>

                            <div class="form-style-field-md">
                                <input id="contact-lname" onkeypress="return !isNumberKey(event)" name="contact-lname" type="text" placeholder="Surname" class="form-control input-md" maxlength="25" spellcheck="false">  
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label form-style-label" for="contact-dob">Date of Birth</label> 

                            <div class="form-style-field-lg">
                                <input id="contact-dob" name="contact-dob" type="date" placeholder="" class="form-control input-md">   
                            </div>
                        </div>

                    </fieldset>
            </div>

            <div class="contact_col second_col col-md-6">

                <fieldset>

                    <legend>Contact Address</legend>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="contact-postcode">Postcode</label>

                        <div class="form-style-field-lg">
                            <input id="contact-postcode" name="contact-postcode" type="search" placeholder="" maxlength="10" spellcheck="false" class="form-control input-md">
                
                        </div>               
                    </div>
                    
                    <div class="form-group">

                        <label class="control-label form-style-label" for="contact-lookup"></label>

                        <div class="form-style-field-lg">
                            <button id="contact-lookup" name="contact-lookup" class="btn btn-primary">Look Up</button>
                        </div>
                    </div>

                </fieldset>

            </div>

            <div class="contact_col third_col col-md-6">

                <fieldset>
                    
                    <div class="form-group">

                        <label class="control-label form-style-label" for="contact-email">Email</label> 

                        <div class="form-style-field-lg">
                            <input id="contact-email" name="contact-email" type="email" placeholder="" maxlength="35" spellcheck="false" class="form-control input-md">   
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label form-style-label" for="contact-emailcheck"></label>
                        <div class="form-style-field-lg">
                            <div class="checkbox">
                                <input class="cnt-check" type="checkbox" name="contact-emailcheck" id="contact-emailcheck-0" value="1">
                                <label class="emailcheck" for="contact-emailcheck-0">Click here if the signee does not have an email address</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="contact-tel">Landline</label>  

                        <div class="form-style-field-lg">
                            <input id="contact-tel" name="contact-tel" onkeypress="return isNumberKey(event)" type="text" placeholder="" maxlength="14" class="form-control input-md">  
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="contact-mobile">Mobile</label>

                        <div class="form-style-field-lg">
                            <input id="contact-mobile" name="contact-mobile" onkeypress="return isNumberKey(event)" type="text" placeholder="" maxlength="14" class="form-control input-md"> 
                        </div>
                    </div>
                </fieldset>
            </div>

            <div class="contact_col fourth_col col-md-6">

                <div class="form-group">

                    <label class="control-label form-style-label" for="address_select" id="pcod-address"></label>

                    <div class="form-style-field-lg">
                        <div id="address_select"></div>
                    </div>
                </div>

                <div id="address_na">
                    
                    <div class="form-group">

                        <label class="control-label form-style-label" for="na-add1">Address Line 1</label>

                        <div class="form-style-field-lg">
                            <input id="na-add1" name="na-add1" type="text" placeholder="" maxlength="35" spellcheck="false" class="form-control input-md"> 
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="na-add2">Address Line 2</label>

                        <div class="form-style-field-lg">
                            <input id="na-add2" name="na-add2" type="text" placeholder="" maxlength="35" spellcheck="false" class="form-control input-md"> 
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="na-addtown">Town</label>

                        <div class="form-style-field-lg">
                            <input id="na-addtown" name="na-addtown" type="text" placeholder="" maxlength="20" spellcheck="false" class="form-control input-md"> 
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="na-addcounty">County</label>

                        <div class="form-style-field-lg">
                            <input id="na-addcounty" name="na-addcounty" type="text" placeholder="" maxlength="20" spellcheck="false" class="form-control input-md"> 
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="na-pcod">Postcode</label>

                        <div class="form-style-field-lg">
                            <input id="na-pcod" name="na-pcod" type="text" placeholder="" maxlength="10" spellcheck="false" class="form-control input-md"> 
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label form-style-label" for="na-addcheck"></label>
                        <div class="form-style-field-lg">
                            <div class="checkbox">
                                <input class="na-add-check" type="checkbox" name="na-addcheck" id="na-addcheck-0" value="1">
                                <label class="emailcheck" for="na-addcheck-0" id="na-add-check">Use same address for supply?</label>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="form-group">
                    <label class="control-label form-style-label" for="contact-addcheck"></label>
                    <div class="form-style-field-lg">
                        <div class="checkbox">
                            <input class="add-check" type="checkbox" name="contact-addcheck" id="contact-addcheck-0" value="1">
                            <label class="emailcheck" for="contact-addcheck-0" id="add-check">Use same address for supply?</label>
                        </div>
                    </div>
                </div>

            </div>

        </div>

        <div class="row tariff_row">

            <div class="tariff_col first_col col-md-6">
                <fieldset>

                    <legend>Tariff & Direct Debit</legend>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="tariff-brand">Brand</label>

                        <div class="form-style-field-lg">
                            <select id="tariff-brand" name="tariff-brand" class="form-control">
                                <option value="1">Eversmart (EVE)</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="tariff-tariff">Tariff</label>

                        <div class="form-style-field-lg">
                            <div id="tariffselect" style="width:100%;"></div>
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="tariff-payment">Payment Method</label>

                        <div class="form-style-field-lg">
                            <select id="tariff-payment" name="tariff-payment" class="form-control">
                                <option value="1">(Please Select) </option>
                                <option value="2">Direct Debit</option>
                                <option value="3">Prepay</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group" id="ddpay">

                        <label class="control-label form-style-label" for="contact-ddamount">Direct Debit Amount</label>

                        <div class="form-style-field-lg">
                            <input id="contact-ddamount" name="contact-ddamount" type="number" placeholder="£" class="form-control input-md"> 
                        </div>
                    </div>

                </fieldset>
            </div>

            <div class="tariff_col second_col col-md-6">
                <fieldset id="ddbank">

                    <legend>Bank Details</legend>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="bank-bname">Account Name</label>

                        <div class="form-style-field-lg">
                            <input id="bank-bname" name="bank-bname" onkeypress="return !isNumberKey(event)" type="text" maxlength="25" spellcheck="false" placeholder="" class="form-control input-md">
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="bank-bnum">Account Number</label>

                        <div class="form-style-field-lg">
                            <input id="bank-bnum" name="bank-bnum" onkeypress="return isNumberKey(event)" maxlength="8" type="text" placeholder="" class="form-control input-md">
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="bank-sort">Sort Code</label>

                        <div class="form-style-field-lg">
                            <input id="bank-sort" name="bank-sort" onkeypress="return isNumberKey(event)" maxlength="6" type="text" placeholder="" class="form-control input-md">
                        </div>
                    </div>

                </fieldset>
            </div>

        </div>

        <div class="row detail_row">

            <div class="detail_col first_col col-md-6">
                <fieldset>

                    <legend>Other Details</legend>

                    <div class="form-group">

                        <label style="margin-top: 0px" class="control-label form-style-label" for="detail-hear">How did you hear about us?</label>
                        
                        <div class="form-style-field-lg">
                            <select id="detail-hear" name="detail-hear" class="form-control">
                                <option value="1">(Please Select) </option>
                                <option value="2">Facebook</option>
                                <option value="3">Google</option>
                                <option value="4">Radio</option>
                                <option value="5">Other</option>
                                <option value="6">Refer a Friend</option>
                                <option value="7">Rep</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" id="promo-label" for="detail-promo">Promo Code</label>  

                        <div class="form-style-field-lg">
                            <input id="detail-promo" name="detail-promo" type="text" placeholder="" maxlength="35" spellcheck="false" class="form-control input-md">
                        </div>
                    </div>

                </fieldset>

                
            </div>

            <div class="detail_col second_col col-md-6">
                <fieldset>

                    <legend>Supply Address</legend>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="supply-postcode">Postcode</label>

                        <div class="form-style-field-lg">
                            <input id="supply-postcode" name="supply-postcode" type="search" placeholder="" maxlength="10" spellcheck="false" class="form-control input-md">
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="detail-lookupsupply"></label>

                        <div class="form-style-field-lg">
                            <button id="detail-lookupsupply" name="detail-lookupsupply" class="btn btn-primary">Look Up</button>
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="supply-lookup" id="pcod-supp-address"></label>

                        <div class="form-style-field-lg">
                            <div id="supply_select"></div>
                        </div>
                    </div>

                </fieldset>


            </div>

            <div class="detail_col third_col col-md-6">

                <fieldset>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="detail-promocheck"></label>

                        <div class="form-style-field-lg" style="display:block">
                            <div class="checkbox">
                                <input class="promo-check" type="checkbox" name="detail-promocheck" id="detail-promocheck-0" value="nopromo">
                                <label class="promo-check-label" for="detail-promocheck-0">No Promo Code</label>
                            </div>

                            <div class="checkbox">
                                <input class="promo-check" type="checkbox" name="detail-promocheck" id="detail-promocheck-1" value="optout">
                                <label class="promo-check-label" for="detail-promocheck-1">Marketing Opt Out?</label>
                            </div>

                            <div class="checkbox">
                                <input class="promo-check" type="checkbox" name="detail-promocheck" id="detail-promocheck-2" value="paperbill">
                                <label class="promo-check-label" for="detail-promocheck-2">Paper Billing</label>
                            </div>

                        </div>
                    </div>

                </fieldset>

            </div>

            <div class="detail_col fourth_col col-md-6">
                <!-- blank -->
            </div>

        </div>

        <div class="row meterpoint_row">

            <div class="meterpoint_col first_col col-md-6">

                <fieldset>

                    <legend>Electricity</legend>

                    <div id="main-mpan">
                        <div class="line-sep lsfix"></div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpancheck">Original MPAN</label>

                            <div class="form-style-field-lg">
                                <div class="checkbox">
                                    <input class="mpan-check" type="checkbox" name="mtrpoint-mpancheck" id="mtrpoint-mpancheck-main" value="mpan">
                                    <label class="mpan-check-label" id="mpan-found-main" for="mtrpoint-mpancheck-main"></label>
                                </div>

                            </div>
                        </div>
                        
                    </div>

                    <div id="mpan-existing">
                        <div class="line-sep"></div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpancheck">MPAN</label>

                            <div class="form-style-field-lg">
                                <div class="checkbox">
                                    <input class="mpan-check" type="checkbox" name="mtrpoint-mpancheck" id="mtrpoint-mpancheck-0" value="mpan">
                                    <label class="mpan-check-label" id="mpan-found" for="mtrpoint-mpancheck-0"></label>
                                </div>

                            </div>
                        </div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="sel_prev_supplier">Prev Supplier</label>

                            <div class="form-style-field-lg">
                                <div id="sel_prev_supplier" style="width:100%;"></div>
                            </div>
                        </div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="sel_prev_tariff">Prev Tariff</label>

                            <div class="form-style-field-lg">
                                <select id="sel_prev_tariff_empty" name="sel_prev_tariff_empty" class="form-control" style="width:100%;">
                                    <option value="1">(Please Select Tariff)</option>
                                </select>
                                <div id="sel_prev_tariff" style="width:100%;"></div>
                            </div>
                        </div>

                        <!-- <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpan-eac">EAC</label>  

                            <div class="form-style-field-lg">
                                <input id="mtrpoint-mpan-eac" name="mtrpoint-mpan-eac" type="text" placeholder="" class="form-control input-md">  
                            </div>
                        </div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpan-eacn">EAC Night</label>

                            <div class="form-style-field-lg">
                                <input id="mtrpoint-mpan-eacn" name="mtrpoint-mpan-eacn"type="text" placeholder="" class="form-control input-md"> 
                            </div>
                        </div>

                        <legend>Agent Contract Details</legend>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpan-dc">Data Collector</label>

                            <div class="form-style-field-lg">
                                <select id="mtrpoint-mpan-dc" name="mtrpoint-mpan-dc" class="form-control">
                                    <option value="1">TMA-DC</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpan-mo">Meter Operator</label>

                            <div class="form-style-field-lg">
                                <select id="mtrpoint-mpan-mo" name="mtrpoint-mpan-mo" class="form-control">
                                    <option value="1">FUML-MOP</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mpan-da">Data Aggregator</label>

                            <div class="form-style-field-lg">
                                <select id="mtrpoint-mpan-da" name="mtrpoint-mpan-da" class="form-control">
                                    <option value="1">TMA-DA</option>
                                </select>
                            </div>
                            
                        </div> -->

                    </div>

                    
                    <div class="line-sep"></div>
                    <div class="form-group">
                        
                        <label class="control-label form-style-label" for="mtrpoint-mpan">New MPAN</label>  

                        <div class="form-style-field-lg">
                            <input id="mtrpoint-mpan" name="mtrpoint-mpan" type="text" placeholder="" onkeypress="return isNumberKey(event)" maxlength="13" spellcheck="false" class="form-control input-md">
                        </div>
                    </div>

                    <div class="form-group">

                        <label class="control-label form-style-label" for="mtrpoint-mpanadd"></label>

                        <div class="form-style-field-lg">
                            <button id="mtrpoint-mpanadd" name="mtrpoint-mpanadd"  class="btn btn-primary">Add</button>
                        </div>
                    </div>
                    
                </fieldset>

            </div>

            <div class="meterpoint_col second_col col-md-6">

                    <fieldset>

                        <legend>Gas</legend>

                        <div id="main-mprn">
                            <div class="line-sep lsfix"></div>

                            <div class="form-group">

                                <label class="control-label form-style-label" for="mtrpoint-mprncheck">Original MPRN</label>

                                <div class="form-style-field-lg">
                                    <div class="checkbox">
                                        <input class="mprn-check" type="checkbox" name="mtrpoint-mprncheck" id="mtrpoint-mprncheck-main" value="mprn">
                                        <label class="mprn-check-label" id="mprn-found-main" for="mtrpoint-mprncheck-main"></label>
                                    </div>

                                </div>
                            </div>
                            
                        </div>

                        <div id="mprn-existing">
                            <div class="line-sep lsfix"></div>

                            <div class="form-group">

                                <label class="control-label form-style-label" for="mtrpoint-mprncheck">MPRN</label>

                                <div class="form-style-field-lg">
                                    <div class="checkbox">
                                        <input class="mprn-check" type="checkbox" name="mtrpoint-mprncheck" id="mtrpoint-mprncheck-0" value="mpan">
                                        <label class="mprn-check-label" id="mprn-found" for="mtrpoint-mprncheck-0"></label>
                                    </div>

                                </div>
                            </div>

                            <!--<div class="form-group">

                                <label class="control-label form-style-label" for="mtrpoint-mprn-aq">AQ</label>  

                                <div class="form-style-field-lg">
                                    <input id="mtrpoint-mprn-eac" name="mtrpoint-mprn-aq" type="text" placeholder="" class="form-control input-md">  
                                </div>
                            </div>-->

                        </div>

                        <div class="line-sep"></div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mprn">New MPRN</label>

                            <div class="form-style-field-lg">
                                <input id="mtrpoint-mprn" name="mtrpoint-mprn" type="text" placeholder="" onkeypress="return isNumberKey(event)" maxlength="11" spellcheck="false" class="form-control input-md">
                            </div>
                        </div>

                        <div class="form-group">

                            <label class="control-label form-style-label" for="mtrpoint-mprnadd"></label>

                            <div class="form-style-field-lg">
                                <button id="mtrpoint-mprnadd" name="mtrpoint-mprnadd" class="btn btn-primary">Add</button>
                            </div>
                        </div>

                    </fieldset>
                

            </div>
        </div>

        <div class="row submit_row" id="form-end">
            <div class="submit_col first_col col-md-6">

                <fieldset>

                    <div class="form-group">

                        <button id="submit-form" name="submit-form" class="btn btn-primary">SUBMIT FORM</button>

                    </div>

                </fieldset>

            </div>

            <div class="submit_col second_col col-md-6">

                <fieldset>

                    <div class="form-group">

                        <button id="clear-form" name="clear-form" class="btn btn-primary">CLEAR FORM</button>

                    </div>

                </fieldset>

                </form>
            </div>
        </div>
    </div>

    <section class="postcode_top mt0">
        <div class="postcode_box ie-extra-padding" id="background-none">
            <form id="newcust_form">
                
                <input type="text" name="senderReference" id="senderReference">
                <input type="text" name="reference" id="reference">
                <input type="text" name="billingEntityCode" id="senderReference">
                <input type="text" name="submittedSource" id="submittedSource">
                <input type="text" name="changeOfTenancyFl" id="changeOfTenancyFl">
                <input type="text" name="tariff" id="tariff">

                <input type="text" name="title" id="title">
                <input type="text" name="forename" id="forename">
                <input type="text" name="surname" id="surname">
                <input type="text" name="email" id="email">
                <input type="text" name="phone1" id="phone1">
                <input type="text" name="phone2" id="phone2">
                <input type="text" name="dateOfBirth" id="dateOfBirth">
                <input type="text" name="billingMethod" id="billingMethod">
                <input type="text" name="primaryContact" id="primaryContact">

                <input type="text" name="address_careOf" id="address_careOf">
                <input type="text" name="address_address1" id="address_address1">
                <input type="text" name="address_address2" id="address_address2">
                <input type="text" name="address_town" id="address_town">
                <input type="text" name="address_county" id="address_county">
                <input type="text" name="address_postcode" id="address_postcode">
                <input type="text" name="address_countryCode" id="address_countryCode">
                
                <input type="text" name="supply_careOf" id="supply_careOf">
                <input type="text" name="supply_address1" id="supply_address1">
                <input type="text" name="supply_address2" id="supply_address2">
                <input type="text" name="supply_town" id="supply_town">
                <input type="text" name="supply_county" id="supply_county">
                <input type="text" name="supply_postcode" id="supply_postcode">
                <input type="text" name="supply_countryCode" id="supply_countryCode">

                <input type="text" name="ddAmount" id="ddAmount">
                <input type="text" name="bankAccountName" id="bankAccountName">
                <input type="text" name="bankAccountNumber" id="bankAccountNumber">
                <input type="text" name="bankAccountSortCode" id="bankAccountSortCode">

                <input type="text" name="quotefor" id="quotefor">

                <input type="text" name="elecReference" id="elecReference">
                <input type="text" name="elecPrevSupplier" id="elecPrevSupplier">
                <input type="text" name="elecPrevTariff" id="elecPrevTariff">
                <input type="text" name="elecProductCode" id="elecProductCode">
                <input type="text" name="mpans" id="mpans">

                <input type="text" name="gasReference" id="gasReference">
                <input type="text" name="gasProductCode" id="gasProductCode">
                <input type="text" name="mprns" id="mprns">
                
            </form>
        </div>
    </section>

    <script type="text/javascript" src="<?php echo base_url(); ?>assets/js/jquery-3.2.1.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/js/popper.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/js/bootstrap.min.js"></script>

<script>

    $( document ).ready(function() 
    {
        // initialise form elements
        $('#address_na').hide();
        $('#form-end').hide();
        $('#ddpay').hide();
        $('#ddbank').hide();
        $('#na-addcheck-0').hide();
        $('#contact-addcheck-0').hide();
        $('#na-add-check').hide();
        $('#add-check').hide();
        $('#mpan-existing').hide();
        $('#mprn-existing').hide();
        $('#main-mpan').hide();
        $('#main-mprn').hide();
        $('#sel_prev_tariff_empty').show();
        $('#sel_prev_tariff').hide();

        // display list of our tariffs
        $.ajax({
            url: base_url+'index.php/admin/our_tariffs',
            type: 'get',
            beforeSend:function(){
                $('#tariffselect').html('Loading...');
            },
            success:function(response)
            {
                $('#tariffselect').html(response);
            }
        });

        // display list of prev suppliers
        $.ajax({
            url: base_url+'index.php/admin/prev_supplier_lookup',
            type: 'get',
            beforeSend:function(){
                $('#sel_prev_supplier').html('Loading...');
            },
            success:function(response)
            {
                $('#sel_prev_supplier').html(response);
                
            }
        });

        function formatDate (input) 
        {
            var datePart = input.match(/\d+/g),
            year = datePart[0].substring(0),
            month = datePart[1], day = datePart[2];
            return day+'/'+month+'/'+year;
        }

        // populates mpan/mprn based on entered postcode
        $(document).on('change','#address_select',function(){

            $('#contact-addcheck-0').show();
            $('#add-check').show();
            $('#form-end').show();
            
            var selected_mprn = $(this).find(':selected').data('mprn');
            var mpanlower = $(this).find(':selected').data('mpanlower');
            var selectedpostcode = $(this).find(':selected').data('selectedpostcode');
            var selected_address = $('#quotation_address').find(':selected').val();
            var selected_bnum = $(this).find(':selected').data('bnum');
            var selected_thor = $(this).find(':selected').data('thor');
            var selected_dplo = $(this).find(':selected').data('dplo');
            var selected_town = $(this).find(':selected').data('town');
            var selected_cntys = $(this).find(':selected').data('cnty');

            var first_line_adds =  selected_bnum + ' ' + selected_thor;

            var elecReference = 'elec_' + Math.floor(Math.random() * 10000);
            var gasReference = 'gas_' + Math.floor(Math.random() * 10000);
            var tariffCode = 'WH-VAR';

            $('#mpan-existing .line-sep').addClass('lsfix');

	        if( mpanlower )
            {
                $('#mtrpoint-mpancheck-0').prop("checked", true);
                $("#mpan-found-main").text(mpanlower);
                $("#mpan-found").text(mpanlower);
                $('#mpan-existing').show();
            }

		    if( selected_mprn )
			{
                $('#mtrpoint-mprncheck-0').prop("checked", true);
                $("#mprn-found-main").text(selected_mprn);
                $("#mprn-found").text(selected_mprn);
                $('#mprn-existing').show();
            }
            
            // populate fields of hidden form with entered info

            $('#newcust_form #senderReference').val('Eversmart');
            $('#newcust_form #reference').val('Eversmart');
            $('#newcust_form #billingEntityCode').val('Eversmart');
            $('#newcust_form #marketingOptOutFl').val('false');
            $('#newcust_form #submittedSource').val('Tele');
            $('#newcust_form #changeOfTenancyFl').val('false');
            $('#newcust_form #primaryContact').val('true');
            $('#newcust_form #address_address1').val(first_line_adds);
            $('#newcust_form #address_address2').val(selected_dplo);
            $('#newcust_form #address_town').val(selected_town);
            $('#newcust_form #address_county').val(selected_cntys);
            $('#newcust_form #address_postcode').val(selectedpostcode);
            $('#newcust_form #address_countryCode').val('GB');

            $('#newcust_form #elecReference').val(elecReference);
            $('#newcust_form #elecProductCode').val(tariffCode + '-Elec');
            
            $('#newcust_form #gasReference').val(gasReference);
            $('#newcust_form #gasProductCode').val(tariffCode + '-Gas');

            $('#newcust_form #mpans').val(mpanlower);
            $('#newcust_form #mprns').val(selected_mprn);

            if($('#mtrpoint-mpancheck-0').prop("checked") == true && $('#mtrpoint-mprncheck-0').prop("checked") == true)
            {
                $('#newcust_form #quotefor').val('both');
            }

            if($('#mtrpoint-mpancheck-0').prop("checked") == true && $('#mtrpoint-mprncheck-0').prop("checked") == false)
            {
                $('#newcust_form #quotefor').val('electricity');
            }

            if($('#mtrpoint-mpancheck-0').prop('checked') == true || $('#mtrpoint-mpancheck-main').prop('checked') == true)
            {
                $('#mtrpoint-mpan').attr('readonly', true);
            }
            else
            {
                $('#mtrpoint-mpan').attr('readonly', false);
            }

            if($('#mtrpoint-mprncheck-0').prop('checked') == true || $('#mtrpoint-mprncheck-main').prop('checked') == true)
            {
                $('#mtrpoint-mprn').attr('readonly', true);
            }
            else
            {
                $('#mtrpoint-mprn').attr('readonly', false);
            }
        });

        // populates hidden form with supply details when selected from drop-down
        $(document).on('change','#supply_select',function(){
            var selectedpostcode_supp = $(this).find(':selected').data('selectedpostcode');
            var selected_address_supp = $('#supply_address').find(':selected').val();
            var selected_bnum_supp = $(this).find(':selected').data('bnum');
            var selected_thor_supp = $(this).find(':selected').data('thor');
            var selected_dplo_supp = $(this).find(':selected').data('dplo');
            var selected_town_supp = $(this).find(':selected').data('town');
            var selected_cntys_supp = $(this).find(':selected').data('cnty');

            var first_line_adds_supp =  selected_bnum_supp + ' ' + selected_thor_supp ;

            $('#newcust_form #supply_address1').val(first_line_adds_supp);
            $('#newcust_form #supply_address2').val(selected_dplo_supp);
            $('#newcust_form #supply_town').val(selected_town_supp);
            $('#newcust_form #supply_county').val(selected_cntys_supp);
            $('#newcust_form #supply_postcode').val(selectedpostcode_supp);
            $('#newcust_form #supply_countryCode').val('GB');
            
        });

        // populates tariff fields on hidden form when selected from drop-down & amends fields based on which tariff is selected
        $(document).on('change','#tariffselect',function(){
            var strTar = $('#tariffselect option:selected').text();
            var trimmedTar = $.trim(strTar);
            $('#newcust_form #tariff').val(trimmedTar);
            
            if(trimmedTar.includes('(elecgas)') )
            {
                if($('#mtrpoint-mprncheck-0').prop('checked') == false)
                {   
                    var selected_mprn = $('#address_select').find(':selected').data('mprn');
                    var gasReference = 'gas_' + Math.floor(Math.random() * 10000);
                    var tariffCode_gas = 'WH-VAR';
                    
                    $('#newcust_form #mprns').val(selected_mprn);
                    $('#newcust_form #gasReference').val(gasReference);
                    $('#newcust_form #gasProductCode').val(tariffCode_gas + '-Gas');
                }
                $('#newcust_form #quotefor').val('both');
            }
            
            if(trimmedTar.includes('(elec)') )
            {
                if($('#mtrpoint-mprncheck-0').prop('checked') == true)
                {
                    $('#main-mprn').show();
                    $('#mprn-existing').hide();

                    $('#mtrpoint-mprncheck-0').prop("checked", false);
                    $('#newcust_form #gasReference').val('');
                    $('#newcust_form #gasProductCode').val('');
                    $('#newcust_form #mprns').val('');
                }
                $('#newcust_form #quotefor').val('electricity');
            }
        });

        $(document).on('change','#sel_prev_supplier',function(){
            $('#sel_prev_tariff_empty').hide();
            $('#sel_prev_tariff').show();
            var str = $('#sel_prev_supplier option:selected').text();
            var trimmed = $.trim(str);
            $('#newcust_form #elecPrevSupplier').val(trimmed);

            $.ajax({
                url: base_url+'index.php/admin/prev_tariff_lookup',
                type: 'post',
                data: {elec_supplier: trimmed},
                beforeSend:function(){
                    $('#sel_prev_tariff').html('Loading...');
                },
                success:function(response)
                {
                    $('#sel_prev_tariff').html(response);
                }
            });
        });

        $(document).on('change','#sel_prev_tariff',function(){
            var strPTar = $('#sel_prev_tariff option:selected').text();
            var trimmedPTar = $.trim(strPTar);
            $('#newcust_form #elecPrevTariff').val(trimmedPTar);
        });

        // updates hidden form fields as fields are being entered
        $('#contact-title').change(function(){$('#newcust_form #title').val($('#contact-title').val());});
        $('#contact-fname').change(function(){
            $('#newcust_form #forename').val($('#contact-fname').val());
            $('#newcust_form #address_careOf').val($('#contact-fname').val()+' '+$('#contact-lname').val());
            $('#newcust_form #supply_careOf').val($('#contact-fname').val()+' '+$('#contact-lname').val());
        });
        $('#contact-lname').change(function(){
            $('#newcust_form #surname').val($('#contact-lname').val());
            $('#newcust_form #address_careOf').val($('#contact-fname').val()+' '+$('#contact-lname').val());
            $('#newcust_form #supply_careOf').val($('#contact-fname').val()+' '+$('#contact-lname').val());
        });
        $('#contact-title').change(function(){$('#newcust_form #title').val($('#contact-title').val());});
        $('#contact-email').change(function(){$('#newcust_form #email').val($('#contact-email').val());});
        $('#contact-tel').change(function(){$('#newcust_form #phone1').val($('#contact-tel').val());});
        $('#contact-mobile').change(function(){$('#newcust_form #phone2').val($('#contact-mobile').val());});
        $('#contact-dob').change(function(){$('#newcust_form #dateOfBirth').val(formatDate($('#contact-dob').val()));});
        $('#contact-ddamount').change(function(){$('#newcust_form #ddAmount').val($('#contact-ddamount').val());});

        $('#bank-bname').change(function(){$('#newcust_form #bankAccountName').val($('#bank-bname').val());});
        $('#bank-bnum').change(function(){$('#newcust_form #bankAccountNumber').val($('#bank-bnum').val());});
        $('#bank-sort').change(function(){$('#newcust_form #bankAccountSortCode').val($('#bank-sort').val());});

        if($('#mtrpoint-mpancheck-0').prop('checked') == true || $('#mtrpoint-mpancheck-main').prop('checked') == true)
        {
            $('#mtrpoint-mpan').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mpan').attr('readonly', false);
        }

        if($('#mtrpoint-mprncheck-0').prop('checked') == true || $('#mtrpoint-mprncheck-main').prop('checked') == true)
        {
            $('#mtrpoint-mprn').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mprn').attr('readonly', false);
        }

        if(!$('#address_na').is(':visible'))
        {
            $('#newcust_form #senderReference').val('Eversmart');
            $('#newcust_form #reference').val('Eversmart');
            $('#newcust_form #billingEntityCode').val('Eversmart');
            $('#newcust_form #marketingOptOutFl').val('false');
            $('#newcust_form #submittedSource').val('Tele');
            $('#newcust_form #changeOfTenancyFl').val('false');
            $('#newcust_form #primaryContact').val('true');
            $('#na-add1').change(function(){$('#newcust_form #address_address1').val($('#na-add1').val());});
            $('#na-add2').change(function(){$('#newcust_form #address_address2').val($('#na-add2').val());});
            $('#na-addtown').change(function(){$('#newcust_form #address_town').val($('#na-addtown').val());});
            $('#na-addcounty').change(function(){$('#newcust_form #address_county').val($('#na-addcounty').val());});
            $('#na-pcod').change(function(){$('#newcust_form #address_postcode').val($('#na-pcod').val());});
            $('#newcust_form #address_countryCode').val('GB');
        }

        $('#na-add1').on('input', function() {$('#na-addcheck-0').prop('checked', false);});
        $('#na-add2').on('input', function() {$('#na-addcheck-0').prop('checked', false);});
        $('#na-addtown').on('input', function() {$('#na-addcheck-0').prop('checked', false);});
        $('#na-addcounty').on('input', function() {$('#na-addcheck-0').prop('checked', false);});
        $('#na-pcod').on('input', function() {$('#na-addcheck-0').prop('checked', false);});
    });

    // prevents form submit
    $('#newCustForm').submit(function(ev) 
    {
        ev.preventDefault();
    });

    // validation - only numbers
    function isNumberKey(evt) 
    {
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode > 31 && (charCode < 48 || charCode > 57))
            return false;

        return true;
    };

    // populate supply address with contact address when checkbox checked
    $('#contact-addcheck-0').click(function()
    {
        if($(this).prop("checked") == true)
        {
            var selectedpostcode_supp = $('#address_select').find(':selected').data('selectedpostcode');
            var selected_address_supp = $('#address_select').find(':selected').val();
            var selected_bnum_supp = $('#address_select').find(':selected').data('bnum');
            var selected_thor_supp = $('#address_select').find(':selected').data('thor');
            var selected_dplo_supp = $('#address_select').find(':selected').data('dplo');
            var selected_town_supp = $('#address_select').find(':selected').data('town');
            var selected_cntys_supp = $('#address_select').find(':selected').data('cnty');

            var first_line_adds_supp =  selected_bnum_supp + ' ' + selected_thor_supp ;

            $('#newcust_form #supply_address1').val(first_line_adds_supp);
            $('#newcust_form #supply_address2').val(selected_dplo_supp);
            $('#newcust_form #supply_town').val(selected_town_supp);
            $('#newcust_form #supply_county').val(selected_cntys_supp);
            $('#newcust_form #supply_postcode').val(selectedpostcode_supp);
            $('#newcust_form #supply_countryCode').val('GB');
            $('input[name=supply-postcode]').val($('#contact-postcode').val());
            $('#detail-lookupsupply').click();

            setTimeout(function(){
                $('#supply_address').val($('#quotation_address').val());
            },1000);
            
        }
        else
        {
            $('input[name=supply-postcode]').val('');
            $('#supply_address').val('');
        }
    });

    // populate supply address with manually entered address when checkbox checked
    $('#na-addcheck-0').click(function()
    {
        if($(this).prop("checked") == true)
        {
            $('#newcust_form #supply_address1').val($('#na-add1').val());
            $('#newcust_form #supply_address2').val($('#na-add2').val());
            $('#newcust_form #supply_town').val($('#na-addtown').val());
            $('#newcust_form #supply_county').val($('#na-addcounty').val());
            $('#newcust_form #supply_postcode').val($('#na-pcod').val());
            $('#newcust_form #supply_countryCode').val('GB');
        }
    });

    // show/hide promo code fields on checkbox
    $('#detail-promocheck-0').click(function()
    {
        if($(this).prop("checked") == true)
        {
            $('#detail-promo').attr('readonly', true);
        }
        else
        {
            $('#detail-promo').attr('readonly', false);
        }
    });

    // check/uncheck paper billing checkbox depending on if cust has email
    $('#contact-emailcheck-0').click(function()
    {
        if($(this).prop("checked") == true)
        {
            $('#contact-email').val('');
            $('#contact-email').attr('readonly', true);
            $('#detail-promocheck-2').prop("checked", true);
        }
        else
        {
            $('#contact-email').attr('readonly', false);
            $('#detail-promocheck-2').prop("checked", false);
        }
    });

    // show/hide extra DD fields when selecting direct debit
    $( "#tariff-payment" ).change(function() {
        var payselect =  $( "#tariff-payment option:selected" ).val();
        if(payselect == '2')
        {
            $('#newcust_form #billingMethod').val('directdebit');
            $('#ddpay').show();
            $('#ddbank').show();
        }
        else if(payselect == '3')
        {
            $('#newcust_form #billingMethod').val('prepay');
            $('#ddpay').hide();
            $('#ddbank').hide();
        }
        else
        {
            $('#ddpay').hide();
            $('#ddbank').hide();
        }
    });

    var base_url = "http://localhost:3000/" ;

    // postcode search for address lookup
    $('#contact-lookup').click(function(){

        $('#contact-addcheck-0').prop("checked", false);
        $('#contact-addcheck-0').hide();
        $('#add-check').hide();
        $('#na-addcheck-0').prop("checked", false);
        $('#na-addcheck-0').hide();
        $('#na-add-check').hide();
        

        $('select[name="sel_prev_supplier"]').val('default');
        $('select[name="sel_prev_tariff"]').val('default');

        $('#newcust_form #elecPrevSupplier').val('');
        $('#newcust_form #elecPrevTariff').val('');

        $.ajax({
            url: base_url+'index.php/admin/address_lookup',
            data: { pcod: $('#contact-postcode').val() },
            type: 'POST',
            beforeSend:function(){
                $('#address_select').html('Loading...');
            },
            success:function(response)
            {
                if(!response.includes('data-selectedpostcode') || response.includes('2000	') )
                {
                    $('#address_address1').val(''); $('#address_address2').val(''); $('#address_town').val(''); $('#address_county').val('');
                    $('#address_postcode').val(''); $('#supply_address1').val(''); $('#supply_address2').val(''); $('#supply_town').val('');
                    $('#supply_county').val(''); $('#supply_postcode').val(''); $('#quotefor').val(''); $('#elecReference').val('');
                    $('#elecProductCode').val(''); $('#mpans').val(''); $('#gasReference').val(''); $('#gasProductCode').val(''); $('#mprns').val('');
                    $('#na-addcheck-0').show();
                    $('#na-add-check').show();
                    $('#supply-postcode').val('');
                    $('select[name="supply_address"]').val('0');
                    $('#na-add1').val(''); $('#na-add2').val(''); $('#na-addtown').val(''); $('#na-addcounty').val('');
                    $('#pcod-address').text('Address not found');
                    $('#address_select').html('<p style="position:relative;top:8px;">Please enter manually:</p>');
                    $('#address_na').show();
                    $('#na-pcod').val($('#contact-postcode').val());
                    $('#newcust_form #address_postcode').val($('#na-pcod').val());
                }
                else
                {
                    $('#address_address1').val(''); $('#address_address2').val(''); $('#address_town').val(''); $('#address_county').val('');
                    $('#address_postcode').val(''); $('#supply_address1').val(''); $('#supply_address2').val(''); $('#supply_town').val('');
                    $('#supply_county').val(''); $('#supply_postcode').val(''); $('#quotefor').val(''); $('#elecReference').val('');
                    $('#elecProductCode').val(''); $('#mpans').val(''); $('#gasReference').val(''); $('#gasProductCode').val(''); $('#mprns').val('');
                    $('#na-add1').val(''); $('#na-add2').val(''); $('#na-addtown').val(''); $('#na-addcounty').val('');
                    $("#pcod-address").text('Address');
                    $('#address_na').hide();
                    $('#address_select').html(response);
                }
                
            }
        });
    });

    // postcode search for suppply address lookup
    $('#detail-lookupsupply').click(function(){
        $("#pcod-supp-address").text('Address');
        $.ajax({
            url: base_url+'index.php/admin/supply_address_lookup',
            data: { pcod: $('#supply-postcode').val() },
            type: 'POST',
            beforeSend:function(){
                $('#supply_select').html('Loading...');
            },
            success:function(response)
            {
                $('#supply_select').html(response);
            }
        });
    });

    // retain original mpan found from postcode search
    $(document).on('change','#mtrpoint-mpancheck-main',function(){
        if($(this).prop("checked") == true && $('#mpan-existing').css('display') == 'none')
        {
            var mpanlower = $('#address_select').find(':selected').data('mpanlower');
            $(this).prop("checked", false);
            $('#main-mpan').hide();
            $('#mtrpoint-mpancheck-0').prop("checked", true);
            $('#mpan-existing .line-sep').addClass('lsfix');
            $('#mpan-found').html(mpanlower);
            $('#mpan-existing').show();
            $('#newcust_form #mpans').val(mpanlower);
        }

        if($(this).prop("checked") == true && $('#main-mpan').css('display') == 'block' && $('#mpan-existing').css('display') == 'block')
        {
            var mpanlower = $('#address_select').find(':selected').data('mpanlower');
            $('#mpan-existing .line-sep').addClass('lsfix');
            $('#main-mpan').hide();
            $('#mpan-found').html(mpanlower);
            $(this).prop("checked", false);
            $('#mtrpoint-mpancheck-0').prop("checked", true);
            $('#newcust_form #mpans').val(mpanlower);
        }

        if($(this).prop('checked') == true || $('#mtrpoint-mpancheck-0').prop('checked') == true)
        {
            $('#mtrpoint-mpan').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mpan').attr('readonly', false);
        }
    });

    // retain original mprn found from postcode search
    $(document).on('change','#mtrpoint-mprncheck-main',function(){
        if($(this).prop("checked") == true && $('#mprn-existing').css('display') == 'none')
        {
            var selected_mprn = $('#address_select').find(':selected').data('mprn');
            var gasReference = 'gas_' + Math.floor(Math.random() * 10000);
            var tariffCode_gas = 'WH-VAR';

            $(this).prop("checked", false);
            $('#main-mprn').hide();
            $('#mtrpoint-mprncheck-0').prop("checked", true);
            $('#mprn-existing .line-sep').addClass('lsfix');
            $('#mprn-found').html(selected_mprn);
            $('#mprn-existing').show();
            $('#newcust_form #mprns').val(selected_mprn);
            $('#newcust_form #gasReference').val(gasReference);
            $('#newcust_form #gasProductCode').val(tariffCode_gas + '-Gas');
        }

        if($(this).prop("checked") == true && $('#main-mprn').css('display') == 'block' && $('#mprn-existing').css('display') == 'block')
        {
            var selected_mprn = $('#address_select').find(':selected').data('mprn');
            var gasReference = 'gas_' + Math.floor(Math.random() * 10000);
            var tariffCode_gas = 'WH-VAR';

            $('#mprn-existing .line-sep').addClass('lsfix');
            $('#main-mprn').hide();
            $('#mprn-found').html(selected_mprn);
            $(this).prop("checked", false);
            $('#mtrpoint-mprncheck-0').prop("checked", true);
            $('#newcust_form #mprns').val(selected_mprn);
            $('#newcust_form #gasReference').val(gasReference);
            $('#newcust_form #gasProductCode').val(tariffCode_gas + '-Gas');
        }

        if($(this).prop('checked') == true || $('#mtrpoint-mprncheck-0').prop('checked') == true)
        {
            $('#mtrpoint-mprn').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mprn').attr('readonly', false);
        }
    });

    // hide mpan fields if mpan checkbox is de-selected
    $(document).on('change','#mtrpoint-mpancheck-0',function(){
        if($(this).prop("checked") == false)
        {
            $('select[name="sel_prev_supplier"]').val('default');
            $('select[name="sel_prev_tariff"]').val('default');
            $('#newcust_form #elecPrevSupplier').val('');
            $('#newcust_form #elecPrevTariff').val('');
            $('#newcust_form #mpans').val('');
        }

        if($(this).prop("checked") == false && $('#mpan-found').val() != null)
        {
            $('#main-mpan').show();
            $('#mpan-existing').hide();
            $('#mtrpoint-mpan').val('');
        }

        if($(this).prop("checked") == true && $('#mtrpoint-mprncheck-0').prop("checked") == true)
        {
            $('#newcust_form #quotefor').val('both');
        }

        if($(this).prop("checked") == true && $('#mtrpoint-mprncheck-0').prop("checked") == false)
        {
            $('#newcust_form #quotefor').val('electricity');
        }

        if($(this).prop('checked') == true)
        {
            $('#mtrpoint-mpan').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mpan').attr('readonly', false);
        }
    });

    // hide mprn fields if mprn checkbox is de-selected
    $(document).on('change','#mtrpoint-mprncheck-0',function(){
        if($(this).prop("checked") == false)
        {
			$('#newcust_form #gasReference').val('');
			$('#newcust_form #gasProductCode').val('');
            $('#newcust_form #mprns').val('');
        }

        if($(this).prop("checked") == false && $('#mprn-found').val() != null)
        {
            $('#main-mprn').show();
            $('#mprn-existing').hide();
            $('#mtrpoint-mprn').val('');
        }

        if($(this).prop("checked") == true && $('#mtrpoint-mpancheck-0').prop("checked") == true)
        {
            $('#newcust_form #quotefor').val('both');
        }

        if($(this).prop("checked") == false && $('#mtrpoint-mprncheck-0').prop("checked") == true)
        {
            $('#newcust_form #quotefor').val('electricity');
        }

        if($(this).prop('checked') == true)
        {
            $('#mtrpoint-mprn').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mprn').attr('readonly', false);
        }
    });
    
    // add new mpan button
    $('#mtrpoint-mpanadd').click(function(){
        if($('#mtrpoint-mpan').val().length != 0 && $('#mtrpoint-mpan').val().length == 13)
        {
            var elecReference = 'elec_' + Math.floor(Math.random() * 10000);
            var tariffCode = 'WH-VAR';

            //$('#mpan-existing .line-sep').addClass('lsfix');
            $('#mtrpoint-mpancheck-0').prop("checked", true);
            $("#mpan-found").text($('#mtrpoint-mpan').val());
            $('#mpan-existing').show();
            $('select[name="sel_prev_supplier"]').val('default');
            $('select[name="sel_prev_tariff"]').val('default');

            $('#newcust_form #elecReference').val(elecReference);
            $('#newcust_form #elecProductCode').val(tariffCode + '-Elec');
            $('#newcust_form #mpans').val($('#mtrpoint-mpan').val());
        }

        if($('#mtrpoint-mpancheck-main').prop('checked') == false && $('#mtrpoint-mpan').val().length != 0 && $('#mtrpoint-mpan').val().length == 13)
        {
            $('#mpan-existing .line-sep').removeClass('lsfix');
        }

        if($('#mtrpoint-mpancheck-0').prop('checked') == true || $('#mtrpoint-mpancheck-main').prop('checked') == true)
        {
            $('#mtrpoint-mpan').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mpan').attr('readonly', false);
        }

        setTimeout(function(){
            $('#mtrpoint-mpan').val('');
            
        },50);

    });

    // add new mprn button
    $('#mtrpoint-mprnadd').click(function(){
        if($('#mtrpoint-mprn').val().length != 0 && ( $('#mtrpoint-mprn').val().length == 10 || $('#mtrpoint-mprn').val().length == 11) )
        {
            var gasReference = 'gas_' + Math.floor(Math.random() * 10000);
            var tariffCode_gas = 'WH-VAR';

            //$('#mprn-existing .line-sep').addClass('lsfix');
            $('#mtrpoint-mprncheck-0').prop("checked", true);
            $("#mprn-found").text($('#mtrpoint-mprn').val());
            $('#mprn-existing').show();

            $('#newcust_form #gasReference').val(gasReference);
            $('#newcust_form #gasProductCode').val(tariffCode_gas + '-Gas');
            $('#newcust_form #mprns').val($('#mtrpoint-mprn').val());
        }

        if($('#mtrpoint-mprncheck-main').prop('checked') == false && $('#mtrpoint-mprn').val().length != 0 && ( $('#mtrpoint-mprn').val().length == 10 || $('#mtrpoint-mprn').val().length == 11) )
        {
            $('#mprn-existing .line-sep').removeClass('lsfix');
        }

        if($('#mtrpoint-mprncheck-0').prop('checked') == true || $('#mtrpoint-mprncheck-main').prop('checked') == true)
        {
            $('#mtrpoint-mprn').attr('readonly', true);
        }
        else
        {
            $('#mtrpoint-mprn').attr('readonly', false);
        }

        setTimeout(function(){
            $('#mtrpoint-mprn').val('');
            
        },50);

    });

    // clear forms
    $('#clear-form').click(function(){
        document.getElementById("newCustForm").reset();
        document.getElementById("newcust_form").reset();

        $('#form-end').hide();
        $('#ddpay').hide();
        $('#ddbank').hide();
        $('#contact-addcheck-0').hide();
        $('#add-check').hide();
        $('#na-addcheck-0').hide();
        $('#na-add-check').hide();
        $('#mpan-existing').hide();
        $('#mprn-existing').hide();
        $('#main-mpan').hide();
        $('#main-mprn').hide();
        $('#sel_prev_tariff_empty').show();
        $('#sel_prev_tariff').hide();

        $('select[name="quotation_address"]').val('0');
        $('select[name="supply_address"]').val('0');
        $('select[name="tariffselect"]').val('default');
        $('select[name="sel_prev_supplier"]').val('default');
        $('select[name="sel_prev_tariff"]').val('default');
    });

    // form validation
    $('#submit-form').click(function(){
        var tar = $.trim($('#tariffselect :selected').text());

        var Errors = [];
        if($('#contact-title').val() == '') { Errors += ' - A title is required\n'; }
        if($('#contact-fname').val() == '') { Errors += ' - A forename is required\n'; }
        if($('#contact-lname').val() == '') { Errors += ' - A surname is required\n'; }
        if($('#contact-dob').val() == '') { Errors += ' - A date of birth is required\n'; }
        if($('#contact-email').val() == '') { Errors += ' - An email address is required\n'; }
        if($('#contact-tel').val() == '') { Errors += ' - A phone number is required\n'; }
        if($('#tariffselect :selected').text() == '(Please Select Tariff)') { Errors += ' - Please select a tariff from the drop-down\n'; }
        if($('#tariff-payment :selected').text() == '(Please Select) ') { Errors += ' - Please select a payment method from the drop-down\n'; }
        if($('#tariff-payment :selected').text() == 'Direct Debit')
        {
            if($('#contact-ddamount').val() == '') { Errors += ' - Please enter a Direct Debit amount\n'; }
            if($('#bank-bname').val() == '') { Errors += ' - Please enter a Bank Account Name\n'; }
            if($('#bank-bnum').val() == '') { Errors += ' - Please enter a Bank Account Number\n'; }
            if($('#bank-sort').val() == '') { Errors += ' - Please enter a Bank Account Sort Code\n'; }
        } 
        if($('#detail-hear :selected').text() == '(Please Select) ') { Errors += ' - Please select how the customer heard about us\n'; }
        if($('#contact-postcode').val() == '') { Errors += ' - A customer postcode is required\n'; }
        if($('#quotation_address :selected').text() == '(Please Select Address)') { Errors += ' - Please select a customer address from the drop-down\n'; }
        if($('#supply-postcode').val() == '') { Errors += ' - A supply postcode is required\n'; }
        if($('#supply_address :selected').text() == '(Please Select Address)') { Errors += ' - Please select a supply address from the drop-down\n'; }
        if($('#sel_prev_supplier :selected').text() == '(Please Select Supplier)') { Errors += ' - Please select the customers previous supplier from the drop-down\n'; }
        if($('#sel_prev_tariff :selected').text() == '(Please Select Tariff)') { Errors += ' - Please select the customers previous tariff from the drop-down\n'; }
        if(tar.includes('(elecgas)') && $('#newcust_form #mpans').val() == '') { Errors += ' - Please select/enter an MPAN\n'; }
        if(tar.includes('(elecgas)') && $('#newcust_form #mprns').val() == '') { Errors += ' - Please select/enter an MPRN\n'; }
        if(tar.includes('(elec)') && $('#newcust_form #mpans').val() == '') { Errors += ' - Please select/enter an MPAN\n'; }
        if($('#newcust_form #supply_careOf').val() == '') { $('#newcust_form #supply_careOf').val($('#newcust_form #address_careOf').val()) }

        if(Errors.length >0)
        {
           alert('Please check the following:\n\n'+Errors);
        }

    });
    
   /* $.ajax({
        url: "<?php echo base_url(); ?>index.php/user/enroll_customer",
        type: 'post',
        //dataType: 'json',
        data: $('#registraion-form').serialize(),
        success:function(response){
            console.log(response);

            if( response.error == '0' ){

                $('#registraion-form')[0].reset();
                $('.signup_msg').html('<div class="alert alert-success" role="alert"><strong>Success!</strong> Signup Successful. Please check your mail.</div>');
            }
            if( response.error == '1' ){
                $('.signup_msg').html('<div class="alert alert-danger" role="alert"><strong>Error!</strong>  '+response.msg+'.</div>');
            }
            if( response.error == '2' ){
                $('.signup_msg').html('<div class="alert alert-danger" role="alert"><strong>Error!</strong> '+response.msg+'</div>');
            }
        }
    });*/
</script>

</body>
