<?php
use \vendor\stripe;
defined('BASEPATH') OR exit('No direct script access allowed');


class User extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('user_modal');
        $this->load->model('error_modal');
        $this->load->model('api_modal');
        $this->mysql = $this->load->database('mysql', true);
        $this->load->library('session');
    }



    function monthyear() {

        $monthyear = $this->input->get('monthyearinput'); 

        $this->session->set_userdata('monthyear', $monthyear);

        echo json_encode(['monthyear' => $monthyear]);

    }


    function yearlypayment() {


        $data['id'] = $this->session->userdata('id');
        $data['email'] = $this->session->userdata('email');
        $data['year_price'] = $this->session->userdata('year_price');
        $data['address'] = $this->session->userdata('address');
        $data['postcode'] = $this->session->userdata('postcode');
        $data['junifer_id'] = $this->session->userdata('junifer_id');

         $data['content'] = 'energy/yearlypayment';
        $this->load->view('energy/yearlypayments',$data);

    }

    function signup()
    {



       $this->session->set_userdata('summary_detail', $this->input->post());
    
        $data['summary_from_info'] = $this->session->userdata('summary_detail');

        if (!empty($this->session->userdata('tariff_detail'))) {

            $data['tariff_detail'] = $this->session->userdata('tariff_detail');
        }
        $data['signup_info'] = $this->session->userdata('signup_detail');

        $data['monthyear'] =   $this->session->userdata('monthyear');



        ////////////////////////////////////////////////////////////
        ////////////// START - WEB TO CASE VARIABLES ///////////////

        // Standard vars - We will have to get this from signup form later
        $data['first_name'] = '';
        $data['last_name'] = '';
        $data['email'] = '';
        $data['phone'] = '';
        $data['dob'] = '';
        $data['description'] = '';

        // We'll have to generate these in the enroll customer function
        $data['junifer_customer_id'] = '';
        $data['dyball_account_id'] = '';

        if($data['signup_info']['quotation_pay_energy'] == 'prepay'){ // Dyball ALL PENDING

            $data['subject'] = 'Pending Registration - Dyball Account - Pending';

            $data['PendingSelected'] = 'selected="selected"'; // External System Registration Status
            $data['Dyball'] = "selected='selected'"; // Case Record Type

        }
        else { // Junifer
            $data['NewJuniferAccount'] = 'selected="selected"'; // Case Record Type
        }


        // These are the only two we have at the moment
        $data['address'] = $data['signup_info']['quotation_address'];
        $data['postcode'] = $data['signup_info']['postcode'];


        $data['elec_supply_end_date'] = date('d-m-Y', strtotime("+20 days"));
        $data['gas_supply_end_date'] = date('d-m-Y', strtotime("+20 days"));
        $data['elec_tariff_comparison_rate'] = '';
        $data['elec_comparison_rate'] = '';
        $data['gas_expected_supply_start_date'] = date('d-m-Y', strtotime("+21 days"));
        $data['elec_expected_supply_start_date'] = date('d-m-Y', strtotime("+21 days"));
        $data['elec_estimated_annual_cost'] = $data['tariff_detail']['newSpendElec'];
        $data['gas_estimated_annual_cost'] = $data['tariff_detail']['newSpendGas'];
        $data['gas_unit_rate'] = $data['tariff_detail']['unitRate1Gas'];
        $data['elec_unit_rate'] = $data['tariff_detail']['unitRate1Elec'];
        $data['elec_daily_standing_charge'] = $data['tariff_detail']['standingChargeElec'];
        $data['gas_daily_standing_charge'] = $data['tariff_detail']['standingChargeGas'];
        $data['elec_annual_consumption'] = ($data['signup_info']['existingkWhsIntervalElec']=='year'?$data['signup_info']['existingkWhsElec']:$data['signup_info']['existingkWhsElec']*12);
        $data['gas_annual_consumption'] = ($data['signup_info']['quotation_gas_energy_interval']=='year'?$data['signup_info']['quotation_gas_energy_usage']:$data['signup_info']['quotation_gas_energy_usage']*12);

        //////////////  END - WEB TO CASE VARIABLES ////////////////
        ////////////////////////////////////////////////////////////

        //echo '<pre>'.print_r($this->input->post(),1).'</pre>';
        //echo '<pre>'.print_r($data,1).'</pre>';
        //exit;
        $this->load->view('layout/signup', $data);
        
    }

    function testpage()
    {
        $this->load->view('layout/theme_contact');
    }

    function enroll_customer()
    {

        $session_detail = $this->session->userdata('signup_detail');
        $tariff_detail = $this->session->userdata('tariff_detail');

        $monthyear =  $this->session->userdata('monthyear');

        // Find the tariff code matching the name
        if ($tariff_detail['tariffName']) {

            if ($monthyear === 'yearlypay') 
           {
            $TariffCode = 'FSC1R-F12-NOV2019' ;
            }

          

           else {

           $TariffData = $this->mysql->select('*')->from('tariff')->like('tariff_name', $tariff_detail['tariffName'])->get()->first_row('array');
           $TariffCode = $TariffData['tariff_code'];
    
        }
    }

        $explode = explode(' ', $session_detail['postcode']);

        //echo '<pre>'.print_r($_SESSION,1).'</pre>';
        //echo '<pre>'.print_r($this->input->post(),1).'</pre>';
        //echo '<pre>'.print_r($session_detail,1).'</pre>';
        //echo '<pre>'.print_r($tariff_detail,1).'</pre>';
        //echo '<pre>'.print_r($explode,1).'</pre>';

        $Salt = file_get_contents('ese_key.txt');


        if ($this->input->post('plan_id') != '' || !empty($this->input->post('plan_id'))) {
            $signup_type = '2';
        } else {
            $signup_type = '0';
        }

        $elec_reference = 'elec_' . rand(0, 9999);
        $gas_reference = 'gas_' . rand(0, 9999);

        $dob = date('Y-m-d', strtotime($this->input->post('customer_dob')));

    
        if ($monthyear === 'yearlypay') 
        {

            $parameter = [
                'senderReference' => 'Eversmart',
                //'reference' => 'Big Dans Bonanza',
                'reference' => 'Eversmart',
                'billingEntityCode' => 'Eversmart',
                'marketingOptOutFl' => false,
                'submittedSource' => 'Tele',
                'changeOfTenancyFl' => false,
                'contacts' => [
                    [
                        'title' => $this->input->post('customer_title'),
                        'forename' => $this->input->post('fname'),
                        'surname' => $this->input->post('lname'),
                        'email' => $this->input->post('email'),
                        'phone1' => $this->input->post('telephone'),
                        'phone2' => $this->input->post('customer_phone'),
                        'dateOfBirth' => $dob,
                        'billingMethod' => "Both",
                        'primaryContact' => true,
                        'address' => [
                            'careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                            // 'address1' => $this->input->post('customer_address'),
                            'address1' => $this->input->post('quotation_first_line_address'),
                            'address2' => $this->input->post('quotation_dplo_address'),
                            'town' => $this->input->post('quotation_town_address'),
                            'county' => $this->input->post('quotation_city_address'),
                            'postcode' => $session_detail['postcode'],
                            'countryCode' => 'GB'
                        ],
                    ]
                ],
                'supplyAddress' => [
                    'careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'address1' => $this->input->post('quotation_first_line_address'),
                    'address2' => $this->input->post('quotation_dplo_address'),
                    'town' => $this->input->post('quotation_town_address'),
                    'county' => $this->input->post('quotation_city_address'),
                    'postcode' => $session_detail['postcode'],
                    'countryCode' => 'GB'
                ],
               
            ];

         }

        else {
            $parameter = [
                'senderReference' => 'Eversmart',
                //'reference' => 'Big Dans Bonanza',
                'reference' => 'Eversmart',
                'billingEntityCode' => 'Eversmart',
                'marketingOptOutFl' => false,
                'submittedSource' => 'Tele',
                'changeOfTenancyFl' => false,
                'contacts' => [
                    [
                        'title' => $this->input->post('customer_title'),
                        'forename' => $this->input->post('fname'),
                        'surname' => $this->input->post('lname'),
                        'email' => $this->input->post('email'),
                        'phone1' => $this->input->post('telephone'),
                        'phone2' => $this->input->post('customer_phone'),
                        'dateOfBirth' => $dob,
                        'billingMethod' => "Both",
                        'primaryContact' => true,
                        'address' => [
                            'careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                            // 'address1' => $this->input->post('customer_address'),
                            'address1' => $this->input->post('quotation_first_line_address'),
                            'address2' => $this->input->post('quotation_dplo_address'),
                            'town' => $this->input->post('quotation_town_address'),
                            'county' => $this->input->post('quotation_city_address'),
                            'postcode' => $session_detail['postcode'],
                            'countryCode' => 'GB'
                        ],
                    ]
                ],
                'supplyAddress' => [
                    'careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'address1' => $this->input->post('quotation_first_line_address'),
                    'address2' => $this->input->post('quotation_dplo_address'),
                    'town' => $this->input->post('quotation_town_address'),
                    'county' => $this->input->post('quotation_city_address'),
                    'postcode' => $session_detail['postcode'],
                    'countryCode' => 'GB'
                ],
                'directDebitInfo' => [
                    'bankAccountSortCode' => $this->input->post('sort_code'),
                    'bankAccountNumber' => $this->input->post('account_number'),
                    'bankAccountName' => $this->input->post('account_name')
                ],
    
            ];
        }
       // var_dump($parameter);
 
        // Electricity
        if ($session_detail['quotation_for'] == 'electricity') {
            $parameter['electricityProduct']['reference'] = $elec_reference;
            $parameter['electricityProduct']['previousSupplier'] = $session_detail['quotation_supplier'];
            $parameter['electricityProduct']['previousTariff'] = $session_detail['existingTariffNameElec'];
            
            if ( $session_detail['meterTypeElec'] === 'E7'){
            $parameter['electricityProduct']['productCode'] = $TariffCode . '-E7';
            }

            else {
                $parameter['electricityProduct']['productCode'] = $TariffCode . '-E';
            }


            $parameter['electricityProduct']['mpans'] = array(['mpanCore' => $session_detail['quotation_mpanlower']]);
        }

        // Gas
        if ($session_detail['quotation_for'] == 'gas') {
            $parameter['gasProduct']['reference'] = $gas_reference;

            
            $parameter['gasProduct']['productCode'] = $TariffCode . '-G';
            $parameter['gasProduct']['mprns'] = array(['mprn' => $session_detail['quotation_mprn']]);
        }

        // Dual
        if ($session_detail['quotation_for'] == 'both') {
            $parameter['gasProduct']['reference'] = $gas_reference;
            $parameter['gasProduct']['productCode'] = $TariffCode . '-G';
            $parameter['gasProduct']['mprns'] = array(['mprn' => $session_detail['quotation_mprn']]);
            $parameter['electricityProduct']['reference'] = $elec_reference;
            $parameter['electricityProduct']['previousSupplier'] = $session_detail['quotation_supplier'];
            $parameter['electricityProduct']['previousTariff'] = $session_detail['existingTariffNameElec'];

            if ( $session_detail['meterTypeElec'] === 'E7'){
                $parameter['electricityProduct']['productCode'] = $TariffCode . '-E7';
                }
    
                else {
                    $parameter['electricityProduct']['productCode'] = $TariffCode . '-E';
                }
    
            $parameter['electricityProduct']['mpans'] = array(['mpanCore' => $session_detail['quotation_mpanlower']]);
        }


        // Sign up customer
        if ($session_detail['quotation_pay_energy'] == 'directdebit' || $session_detail['quotation_pay_energy'] == 'paperbill') {

            
            if (empty($tariff_detail['exitFeeElec'])) {
                $tariff_detail['exitFeeElec'] = '0';
            }

            $dplo = $this->input->post('quotation_dplo_address');

            if ($dplo == NULL) {
                $dplo = 'Area';
            }


            if ($monthyear === 'yearlypay') 
            {

            $db_parameter = [
                'title' => $this->input->post('customer_title'),
                'forename' => $this->input->post('fname'),
                'surname' => $this->input->post('lname'),
                'billingMethod' => $session_detail['quotation_pay_energy'],
                'email' => $this->input->post('email'),
                //'password' => base64_encode($this->input->post('customer_confirm_password')),
                'phone1' => $this->input->post('telephone'),
                'phone2' => $this->input->post('customer_phone'),
                'dateOfBirth' => $dob,
                'address_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),

                //'address_address1' => $this->input->post('customer_address'),

                'first_line_address' => $this->input->post('quotation_first_line_address'),

                'dplo_address' =>  $dplo,
                'town_address' => $this->input->post('quotation_town_address'),
                'city_address' => $this->input->post('quotation_city_address'),

                'address_postcode' =>  urlencode($session_detail['postcode']),
                'address_countryCode' => 'GB',

                'supplyAddress_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
                'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                'supplyAddress_postcode' =>  urlencode($session_detail['postcode']),
                'supplyAddress_countryCode' => 'GB',
                'bankAccountSortCode' => $this->input->post('sort_code'),
                'bankAccountNumber' => $this->input->post('account_number'),
                'bankAccountName' =>  $this->input->post('account_name'),
                // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                // "electricityProduct_productCode"=>"Big Dans Bonanza",
                // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                // "gasProduct_reference" =>  $gas_reference,
                // "gasProduct_productCode"=>"BDBG",
                // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                "signup_type" => $signup_type,
                'plan_price' =>  $this->input->post('plan_price'),
                'original_price' =>  $this->input->post('original_price'),
                'complete_price' =>  $this->input->post('complete_price'),
                'plan_id' =>  $this->input->post('plan_id'),
                'tariff_newspend' => $tariff_detail['newSpend'],
                'tariff_tariffName' => $tariff_detail['tariffName'],
                'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                'exitFeeElec' => $tariff_detail['exitFeeElec'],
                'elec_mpan_core' => $session_detail['quotation_mpanlower'],
                'success' => 'fail',
                'Error_msg' => $session_detail['errormsg'],
                //'junifer_msg' => $loginResponse['body']['errorDescription'],
                'meterTypeElec' => $session_detail['meterTypeElec']
            ];

        }

        else {
            $db_parameter = [
                'title' => $this->input->post('customer_title'),
                'forename' => $this->input->post('fname'),
                'surname' => $this->input->post('lname'),
                'billingMethod' => $session_detail['quotation_pay_energy'],
                'email' => $this->input->post('email'),
                //'password' => base64_encode($this->input->post('customer_confirm_password')),
                'phone1' => $this->input->post('telephone'),
                'phone2' => $this->input->post('customer_phone'),
                'dateOfBirth' => $dob,
                'address_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),

                //'address_address1' => $this->input->post('customer_address'),

                'first_line_address' => $this->input->post('quotation_first_line_address'),

                'dplo_address' =>  $dplo,
                'town_address' => $this->input->post('quotation_town_address'),
                'city_address' => $this->input->post('quotation_city_address'),

                'address_postcode' =>  urlencode($session_detail['postcode']),
                'address_countryCode' => 'GB',

                'supplyAddress_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
                'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                'supplyAddress_postcode' =>  urlencode($session_detail['postcode']),
                'supplyAddress_countryCode' => 'GB',
                //'bankAccountSortCode' => $this->input->post('sort_code'),
                //'bankAccountNumber' => $this->input->post('account_number'),
                //'bankAccountName' =>  $this->input->post('account_name'),
                // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                // "electricityProduct_productCode"=>"Big Dans Bonanza",
                // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                // "gasProduct_reference" =>  $gas_reference,
                // "gasProduct_productCode"=>"BDBG",
                // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                "signup_type" => $signup_type,
                'plan_price' =>  $this->input->post('plan_price'),
                'original_price' =>  $this->input->post('original_price'),
                'complete_price' =>  $this->input->post('complete_price'),
                'plan_id' =>  $this->input->post('plan_id'),
                'tariff_newspend' => $tariff_detail['newSpend'],
                'tariff_tariffName' => $tariff_detail['tariffName'],
                'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                'exitFeeElec' => $tariff_detail['exitFeeElec'],
                'elec_mpan_core' => $session_detail['quotation_mpanlower'],
                'success' => 'fail',
                'Error_msg' => $session_detail['errormsg'],
                //'junifer_msg' => $loginResponse['body']['errorDescription'],
                'meterTypeElec' => $session_detail['meterTypeElec']
            ];
        }

            $response = $this->curl->junifer_request('/rest/v1/customers/enrolCustomer', $parameter, 'post');
            $loginResponse = $this->parseHttpResponse($response);


            if ($loginResponse['headers']['http_code'] == 'HTTP/1.1 200 OK' || $loginResponse['headers']['http_code'] == 'HTTP/1.1 200 ok' || $loginResponse['headers']['http_code'] == 'HTTP/1.1 200 Ok') {

                //insert data in database

                if (empty($tariff_detail['exitFeeElec'])) {
                    $tariff_detail['exitFeeElec'] = '0';
                }

                $dplo = $this->input->post('quotation_dplo_address');

                if ($dplo == NULL) {
                    $dplo = 'Area';
                }


                if ($monthyear === 'yearlypay') 
                {

                $db_parameter = [
                    'customer_id' => $loginResponse['body']['customerId'],
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),

                    //'address_address1' => $this->input->post('customer_address'),

                    'first_line_address' => $this->input->post('quotation_first_line_address'),

                    'dplo_address' => $dplo,
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),

                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                    //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                    //'bankAccountSortCode' => $this->input->post('sort_code'),
                    //'bankAccountNumber' => $this->input->post('account_number'),
                   // 'bankAccountName' => $this->input->post('account_name'),
                    // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                    // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                    // "electricityProduct_productCode"=>"Big Dans Bonanza",
                    // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                    // "gasProduct_reference" =>  $gas_reference,
                    // "gasProduct_productCode"=>"BDBG",
                    // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                    "signup_type" => $signup_type,
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower']
                ];

            }
            else {
                $db_parameter = [
                    'customer_id' => $loginResponse['body']['customerId'],
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),

                    //'address_address1' => $this->input->post('customer_address'),

                    'first_line_address' => $this->input->post('quotation_first_line_address'),

                    'dplo_address' => $dplo,
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),

                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                    //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                    'bankAccountSortCode' => $this->input->post('sort_code'),
                    'bankAccountNumber' => $this->input->post('account_number'),
                    'bankAccountName' => $this->input->post('account_name'),
                    // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                    // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                    // "electricityProduct_productCode"=>"Big Dans Bonanza",
                    // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                    // "gasProduct_reference" =>  $gas_reference,
                    // "gasProduct_productCode"=>"BDBG",
                    // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                    "signup_type" => $signup_type,
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower']
                ];
            }

                if ($session_detail['quotation_for'] == 'electricity') {
                    // $db_parameter['electricityProduct_previousSupplier'] = $elec_reference;
                    $db_parameter['electricityProduct_previousSupplier'] = $session_detail['quotation_supplier'];
                    $db_parameter['electricityProduct_previousTariff'] = $session_detail['existingTariffNameElec'];
                     
                    if ( $session_detail['meterTypeElec'] === 'E7'){
                    $parameter['electricityProduct']['productCode'] = $TariffCode . '-E7';
                     }

                    else {
                    $parameter['electricityProduct']['productCode'] = $TariffCode . '-E';
                     }

                    $db_parameter['electricityProduct_mpans'] = $session_detail['quotation_mpanlower'];
                }

                if ($session_detail['quotation_for'] == 'gas') {
                    $db_parameter['gasProduct_reference'] = $gas_reference;
                    $db_parameter['gasProduct_productCode'] = $TariffCode . '-G';
                    $db_parameter['gasProduct_mprns'] = $session_detail['quotation_mprn'];
                }

                if ($session_detail['quotation_for'] == 'both') {
                    $db_parameter['electricityProduct_previousSupplier'] = $session_detail['quotation_supplier'];
                    $db_parameter['electricityProduct_previousTariff'] = $session_detail['existingTariffNameElec'];
                    
                    if ( $session_detail['meterTypeElec'] === 'E7'){
                        $parameter['electricityProduct']['productCode'] = $TariffCode . '-E7';
                        }
            
                        else {
                            $parameter['electricityProduct']['productCode'] = $TariffCode . '-E';
                        }
            
                    $db_parameter['electricityProduct_mpans'] = $session_detail['quotation_mpanlower'];
                    $db_parameter['gasProduct_reference'] = $gas_reference;
                    $db_parameter['gasProduct_productCode'] = $TariffCode . '-G';
                    $db_parameter['gasProduct_mprns'] = $session_detail['quotation_mprn'];
                }

                if ($session_detail['saasref'] != null) {
                    $db_parameter['saasref'] = $session_detail['saasref'];
                }


                $this->session->set_flashdata('customer_id', $loginResponse['body']['customerId']);
                $this->session->set_flashdata('fname', $this->input->post('fname'));
                $this->session->set_flashdata('lname', $this->input->post('lname'));

                
                $insert_customer_info = $this->user_modal->insert_customer_info($db_parameter);

                ///intercom
                $fname = $this->input->post('fname');
                $lname = $this->input->post('lname');
                $email = $this->input->post('email');
                $this->intercom_create($insert_customer_info, $email, $fname.' '.$lname);
                

               // print_r($loginResponse);
               

                // Now update the record
                $sql = "UPDATE customer_info SET password=AES_ENCRYPT(SHA1(?), '" . $Salt . "') WHERE id=?";
                $this->mysql->query($sql, array($this->input->post('customer_confirm_password'), $insert_customer_info));


            } else if ((strpos($loginResponse['body']['errorDescription'], "Required 'mpanCore'") !== false && $monthyear != 'yearlypay') || (strpos($loginResponse['body']['errorDescription'], "Required 'MPAN'") !== false && $monthyear !== 'yearlypay')) {

                $this->error_modal->log('signup error', $loginResponse['body']['errorDescription']);

                if (empty($tariff_detail['exitFeeElec'])) {
                    $tariff_detail['exitFeeElec'] = '0';
                }
                ///failed sign up add to database still///

                $dplo = $this->input->post('quotation_dplo_address');

                if ($dplo == NULL) {
                    $dplo = 'Area';
                }


                if ($monthyear === 'yearlypay') 
                {

                $db_parameter = [
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),

                    //'address_address1' => $this->input->post('customer_address'),

                    'first_line_address' => $this->input->post('quotation_first_line_address'),

                    'dplo_address' => $dplo,
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),

                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                    //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                   // 'bankAccountSortCode' => $this->input->post('sort_code'),
                   // 'bankAccountNumber' => $this->input->post('account_number'),
                    //'bankAccountName' => $this->input->post('account_name'),
                    // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                    // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                    // "electricityProduct_productCode"=>"Big Dans Bonanza",
                    // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                    // "gasProduct_reference" =>  $gas_reference,
                    // "gasProduct_productCode"=>"BDBG",
                    // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                    "signup_type" => $signup_type,
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower'],
                    'success' => 'fail',
                    'Error_msg' => $session_detail['errormsg'],
                    'junifer_msg' => $loginResponse['body']['errorDescription']
                ];

            }
            else 
            {
                $db_parameter = [
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),

                    //'address_address1' => $this->input->post('customer_address'),

                    'first_line_address' => $this->input->post('quotation_first_line_address'),

                    'dplo_address' => $dplo,
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),

                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                    //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                    'bankAccountSortCode' => $this->input->post('sort_code'),
                    'bankAccountNumber' => $this->input->post('account_number'),
                    'bankAccountName' => $this->input->post('account_name'),
                    // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                    // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                    // "electricityProduct_productCode"=>"Big Dans Bonanza",
                    // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                    // "gasProduct_reference" =>  $gas_reference,
                    // "gasProduct_productCode"=>"BDBG",
                    // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                    "signup_type" => $signup_type,
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower'],
                    'success' => 'fail',
                    'Error_msg' => $session_detail['errormsg'],
                    'junifer_msg' => $loginResponse['body']['errorDescription']
                ];
            }

                if ($session_detail['quotation_for'] == 'electricity') {
                    // $db_parameter['electricityProduct_previousSupplier'] = $elec_reference;
                    $db_parameter['electricityProduct_previousSupplier'] = $session_detail['quotation_supplier'];
                    $db_parameter['electricityProduct_previousTariff'] = $session_detail['existingTariffNameElec'];
                    $db_parameter['electricityProduct_productCode'] = $TariffCode . '-E';
                    $db_parameter['electricityProduct_mpans'] = $session_detail['quotation_mpanlower'];
                    $db_parameter['elec_meter_serial'] = $session_detail['quotation_elec_meter_serial'];


                }

                if ($session_detail['quotation_for'] == 'gas') {
                    $db_parameter['gasProduct_reference'] = $gas_reference;
                    $db_parameter['gasProduct_productCode'] = $TariffCode . '-G';
                    $db_parameter['gasProduct_mprns'] = $session_detail['quotation_mprn'];
                    $db_parameter['gas_meter_serial'] = $session_detail['quotation_gas_meter_serial'];
                }

                if ($session_detail['quotation_for'] == 'both') {
                    $db_parameter['electricityProduct_previousSupplier'] = $session_detail['quotation_supplier'];
                    $db_parameter['electricityProduct_previousTariff'] = $session_detail['existingTariffNameElec'];
                    $db_parameter['electricityProduct_productCode'] = $TariffCode . '-E';
                    $db_parameter['electricityProduct_mpans'] = $session_detail['quotation_mpanlower'];
                    $db_parameter['elec_meter_serial'] = $session_detail['quotation_elec_meter_serial'];

                    $db_parameter['gas_meter_serial'] = $session_detail['quotation_gas_meter_serial'];
                    $db_parameter['gasProduct_reference'] = $gas_reference;
                    $db_parameter['gasProduct_productCode'] = $TariffCode . '-G';
                    $db_parameter['gasProduct_mprns'] = $session_detail['quotation_mprn'];
                }

                if ($session_detail['saasref'] != null) {
                    $db_parameter['saasref'] = $session_detail['saasref'];
                }

                $this->session->set_flashdata('fname', $this->input->post('fname'));
                $this->session->set_flashdata('lname', $this->input->post('lname'));

                $insert_customer_info = $this->user_modal->insert_customer_info($db_parameter);

                // Now update the record
                $sql = "UPDATE customer_info SET password=AES_ENCRYPT(SHA1(?), '" . $Salt . "') WHERE id=?";
                $this->mysql->query($sql, array($this->input->post('customer_confirm_password'), $insert_customer_info));

                ///saasquatch

                $fname = $this->input->post('fname');
                $lname = $this->input->post('lname');
                $email = $this->input->post('email');

                $random = rand(0, 99);
                $random = ($random <= 9 ? "0" . $random : $random);

                $para = [
                    "id" => $insert_customer_info,
                    "accountId" => $insert_customer_info,
                    "firstName" => $fname,
                    "email" => $email,
                    "referable" => "true",
                    "referralCode" => $fname . $lname . $random,    // forename . surname . random number between 00 and 99
                    "locale" => "en_UK",
                    "referredBy" =>
                        array(
                            "code" => $session_detail['saasref'],
                            "isConverted" => false
                        )
                ];

                $creating_ref_user = $this->curl->curlSaas('open/account/' . $insert_customer_info . '/user/' . $insert_customer_info . '', $para, 'post');


                ///intercom
                $this->intercom_create($insert_customer_info, $email, $fname.' '.$lname);


                //need an if statement to not allow failed go cardless ** return error still

                //Generate a random string.
                $token = openssl_random_pseudo_bytes(16);

                //Convert the binary data into hexadecimal representation.
                $token = bin2hex($token);

                $this->activation_email($insert_customer_info, $token, $this->input->post('fname'), $this->input->post('email'));

                $token_in_database = $this->user_modal->token_in_database($token, $insert_customer_info);

                echo json_encode(['error' => '0', 'token' => $token, 'msg' => 'signup successful']);



                exit;
            } else {

                $this->error_modal->log('signup error', $loginResponse['body']['errorDescription']);

                echo json_encode(['error' => '1', 'token' => null, 'msg' => $loginResponse['body']['errorDescription']]);        
                
                exit;


            }


            $parameter_account = ['email' => $this->input->post('email')];
            $get_account_id = $this->curl->junifer_request('/rest/v1/accounts/?email=' . $this->input->post('email'));
            $get_account = $this->parseHttpResponse($get_account_id);


            if ($get_account['headers']['http_code'] == 'HTTP/1.1 200 OK' || $get_account['headers']['http_code'] == 'HTTP/1.1 200 ok' || $get_account['headers']['http_code'] == 'HTTP/1.1 200 Ok') {

                $first_account = '';

                for ($var = 0; $var < count($get_account['body']); $var++) {
                    if ($var == '0') {
                        //echo $get_account['body']['results'][$var]['id'];
                        $first_account = $get_account['body']['results'][$var]['id'];
                        $data = [
                            "username" => $this->input->post('email'),
                            "password" => $this->input->post('customer_password'),
                            "customers" => [
                                ["id" => $loginResponse['body']['customerId']]
                            ],
                            "expiryDttm" => date('Y-m-d', strtotime('+1 year')) . 'T20:00:00.0000'
                        ];
                    }
                }
                $this->user_modal->update_account_id($insert_customer_info, $first_account);
                //echo json_encode($data);

            } else {

                $this->error_modal->log('customer id created but account id creating issue', $get_account['body']['errorDescription']);
                echo json_encode(['error' => '1', 'token' => null, 'msg' => $get_account['body']['errorDescription']]);
                exit;
            }


            // register web user
            $request_for_register_user = $this->curl->junifer_request('/rest/v1/webUsers/', $data, 'post');
            $request_for_register_user = $this->parseHttpResponse($request_for_register_user);

            if ($request_for_register_user['headers']['http_code'] == 'HTTP/1.1 200 OK' || $request_for_register_user['headers']['http_code'] == 'HTTP/1.1 200 ok' || $request_for_register_user['headers']['http_code'] == 'HTTP/1.1 200 Ok' || $request_for_register_user['headers']['http_code'] == 'HTTP/1.1 201 Created') {

                $this->activation_email($insert_customer_info, $request_for_register_user['body']['token'], $this->input->post('fname'), $this->input->post('email'));

                $token_in_database = $this->user_modal->token_in_database($request_for_register_user['body']['token'], $insert_customer_info);

                echo json_encode(['error' => '0', 'token' => $request_for_register_user['body']['token'], 'msg' => 'signup successful', 'junifer_id' => $first_account, 'year_price' => $tariff_detail['newSpend']]);

                $this->session->set_userdata('junifer_id', $first_account);
                $this->session->set_userdata('year_price', $tariff_detail['newSpend']);
                $this->session->set_userdata('id', $first_account);
                $this->session->set_userdata('address',  $this->input->post('quotation_first_line_address'));
                $this->session->set_userdata('postcode',  urlencode($session_detail['postcode']));
                $this->session->set_userdata('email', $this->input->post('email'));


                if ($monthyear === 'yearlypay') 
                {

            //update customer info in database
            $db_parameter = [
            'title' => $this->input->post('customer_title'),
            'forename' => $this->input->post('fname'),
            'surname' => $this->input->post('lname'),
            'billingMethod' => $session_detail['quotation_pay_energy'],
            'email' => $this->input->post('email'),
            //'password' => base64_encode($this->input->post('customer_confirm_password')),
            'phone1' => $this->input->post('telephone'),
            'phone2' => $this->input->post('customer_phone'),
            'dateOfBirth' => $dob,
            'address_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),

            //'address_address1' => $this->input->post('customer_address'),

            'first_line_address1' => $this->input->post('quotation_first_line_address'),
            'dplo_address' => $dplo,
            'town_address' => $this->input->post('quotation_town_address'),
            'city_address' => $this->input->post('quotation_city_address'),


            'address_postcode' =>  urlencode($session_detail['postcode']),
            'address_countryCode' => 'GB',

            'supplyAddress_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
            'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
            'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
            'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
            'supplyAddress_postcode' =>  urlencode($session_detail['postcode']),
            'supplyAddress_countryCode' => 'GB',
           // 'bankAccountSortCode' => $this->input->post('sort_code'),
           // 'bankAccountNumber' => $this->input->post('account_number'),
           // 'bankAccountName' =>  $this->input->post('account_name'),
            "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
            "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
            "electricityProduct_productCode"=>$TariffCode.'-Elec',
            "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
            // "gasProduct_reference" =>  $gas_reference,
            // "gasProduct_productCode"=>"BDBG",
            // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
            "signup_type" => '3',
            'plan_price' =>  $this->input->post('plan_price'),
            'original_price' =>  $this->input->post('original_price'),
            'complete_price' =>  $this->input->post('complete_price'),
            'plan_id' =>  $this->input->post('plan_id'),
            'start_date' => date('Y-m-d'),
            'prefix' => 'DYB_ELEC_',
            'tariff_newspend' => $tariff_detail['newSpend'],
            'tariff_tariffName' => $tariff_detail['tariffName'],
            'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
            'exitFeeElec' => $tariff_detail['exitFeeElec'],
            'elec_mpan_core' => $session_detail['quotation_mpanlower'],
            'meterTypeElec' => $session_detail['meterTypeElec']
            ];

        }
        else 
        {
            $db_parameter = [
                'title' => $this->input->post('customer_title'),
                'forename' => $this->input->post('fname'),
                'surname' => $this->input->post('lname'),
                'billingMethod' => $session_detail['quotation_pay_energy'],
                'email' => $this->input->post('email'),
                //'password' => base64_encode($this->input->post('customer_confirm_password')),
                'phone1' => $this->input->post('telephone'),
                'phone2' => $this->input->post('customer_phone'),
                'dateOfBirth' => $dob,
                'address_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
    
                //'address_address1' => $this->input->post('customer_address'),
    
                'first_line_address1' => $this->input->post('quotation_first_line_address'),
                'dplo_address' => $dplo,
                'town_address' => $this->input->post('quotation_town_address'),
                'city_address' => $this->input->post('quotation_city_address'),
    
    
                'address_postcode' =>  urlencode($session_detail['postcode']),
                'address_countryCode' => 'GB',
    
                'supplyAddress_careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
                'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                'supplyAddress_postcode' =>  urlencode($session_detail['postcode']),
                'supplyAddress_countryCode' => 'GB',
                'bankAccountSortCode' => $this->input->post('sort_code'),
                'bankAccountNumber' => $this->input->post('account_number'),
                'bankAccountName' =>  $this->input->post('account_name'),
                "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                "electricityProduct_productCode"=>$TariffCode.'-Elec',
                "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                // "gasProduct_reference" =>  $gas_reference,
                // "gasProduct_productCode"=>"BDBG",
                // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                "signup_type" => '3',
                'plan_price' =>  $this->input->post('plan_price'),
                'original_price' =>  $this->input->post('original_price'),
                'complete_price' =>  $this->input->post('complete_price'),
                'plan_id' =>  $this->input->post('plan_id'),
                'start_date' => date('Y-m-d'),
                'prefix' => 'DYB_ELEC_',
                'tariff_newspend' => $tariff_detail['newSpend'],
                'tariff_tariffName' => $tariff_detail['tariffName'],
                'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                'exitFeeElec' => $tariff_detail['exitFeeElec'],
                'elec_mpan_core' => $session_detail['quotation_mpanlower'],
                'meterTypeElec' => $session_detail['meterTypeElec']
                ];
    
        }
            ///saasquatch

            $fname = $this->input->post('fname');
            $lname = $this->input->post('lname');
            $email = $this->input->post('email');

            $random = rand(0, 99);
            $random = ($random <= 9 ? "0" . $random : $random);

            $para = [
                "id" => $insert_customer_info,
                "accountId" => $insert_customer_info,
                "firstName" => $fname,
                "email" => $email,
                "referable" => "true",
                "referralCode" => $fname . $lname . $random,    // forename . surname . random number between 00 and 99
                "locale" => "en_UK",
                "referredBy" =>
                    array(
                        "code" => $session_detail['saasref'],
                        "isConverted" => false
                    )
            ];

            $creating_ref_user = $this->curl->curlSaas('open/account/' . $insert_customer_info . '/user/' . $insert_customer_info . '', $para, 'post');


            ///saasquatch

            } else {

                $this->error_modal->log('register webuser fail', $request_for_register_user['body']['errorDescription']);
                echo json_encode(['error' => '1', 'token' => null, 'msg' => $request_for_register_user['body']['errorDescription']]);

            }

        }


        if ($session_detail['quotation_pay_energy'] == 'prepay') {

            $customer_data = ['forename' => $this->input->post('fname'), 'signup_type' => '3'];

            $insert_customer_info = $this->user_modal->insert_customer_info($customer_data);

            // Now update the record
            $sql = "UPDATE customer_info SET password=AES_ENCRYPT(SHA1(?), '" . $Salt . "') WHERE id=?";
            $this->mysql->query($sql, array($this->input->post('customer_confirm_password'), $insert_customer_info));


            ///intercom
            $fname = $this->input->post('fname');
            $lname = $this->input->post('lname');
            $email = $this->input->post('email');
            $this->intercom_create($insert_customer_info, $email, $fname.' '.$lname);
            

            if (empty($insert_customer_info) || $insert_customer_info == 0) {
                echo json_encode(['error' => '0', 'msg' => 'Server Error']);
                exit;
            }

            if ($session_detail['quotation_for'] == 'electricity') {

                $dplo = $this->input->post('quotation_dplo_address');

                if ($dplo == NULL) {
                    $dplo = 'Area';
                }

                //update customer info in database
                $db_parameter = [
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),

                    //'address_address1' => $this->input->post('customer_address'),

                    'first_line_address1' => $this->input->post('quotation_first_line_address'),
                    'dplo_address' => $dplo,
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),


                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                    'bankAccountSortCode' => $this->input->post('sort_code'),
                    'bankAccountNumber' => $this->input->post('account_number'),
                    'bankAccountName' => $this->input->post('account_name'),
                    "electricityProduct_previousSupplier" => $session_detail['quotation_supplier'],
                    "electricityProduct_previousTariff" => $session_detail['existingTariffNameElec'],
                    "electricityProduct_productCode" => $TariffCode . '-Elec',
                    "electricityProduct_mpans" => $session_detail['quotation_mpan'],
                    // "gasProduct_reference" =>  $gas_reference,
                    // "gasProduct_productCode"=>"BDBG",
                    // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,
                    "signup_type" => '3',
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'start_date' => date('Y-m-d'),
                    'prefix' => 'DYB_ELEC_',
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower']
                ];

                //get last account_number from database
                $elec_parameter['AuthKey'] = $this->authkey_dyball_regman;
                $elec_parameter['MPAN'] = $session_detail['quotation_mpan'];
                $elec_parameter['StartDate'] = date('Y-m-d');
                $elec_parameter['AccountNumber'] = $insert_customer_info;
                $elec_parameter['CustomerName'] = $this->input->post('fname') . ' ' . $this->input->post('lname');
                $elec_parameter['ContactPostCode'] = $this->input->post('postcode');
                $elec_parameter['ElectricityPostCode'] = $this->input->post('postcode');
                $elec_parameter['ContractSignedDate'] = date('Y-m-d');
                $elec_parameter['ContactEmail'] = $this->input->post('email');

                // register mpan on dyball
                $response = $this->curl->curl_dyball('/api/RegManager/RegisterMpan', $elec_parameter, 'post');
                $response = $this->parseHttpResponse($response);
                //debug($response,1);
                if ($response['body']['success'] == 'true') {


                    //insert token in database
                    $token = md5(uniqid(rand(0, 9999), true));
                    $this->activation_email($insert_customer_info, $token, $this->input->post('fname'), $this->input->post('email'));

                    $token_in_database = $this->user_modal->token_in_database($token, $insert_customer_info);

                    //update data in database
                    $update_customer_info = $this->user_modal->update_customer_info($db_parameter, $insert_customer_info);

                    if ($update_customer_info) {

                        echo json_encode(['error' => '0', 'msg' => 'signup successful']);


                        ///saasquatch

                    }

                } else {

                    echo json_encode(['error' => '1', 'msg' => 'error while signup']);
                    $this->error_modal->log('register webuser fail', $response['errorMessage']);

                }

            }// if quotation is for electricity

            if ($session_detail['quotation_for'] == 'both') {

                $dplo = $this->input->post('quotation_dplo_address');

                if ($dplo == NULL) {
                    $dplo = 'Area';
                }

                $db_parameter = [
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),


                    // 'address_address1' => $this->input->post('customer_address'),

                    'first_line_address' => $this->input->post('quotation_first_line_address'),
                    'dplo_address' => $dplo,
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),

                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),
                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                    'bankAccountSortCode' => $this->input->post('sort_code'),
                    'bankAccountNumber' => $this->input->post('account_number'),
                    'bankAccountName' => $this->input->post('account_name'),
                    "electricityProduct_previousSupplier" => $session_detail['quotation_supplier'],
                    "electricityProduct_previousTariff" => $session_detail['existingTariffNameElec'],
                    "electricityProduct_productCode" => $TariffCode . "-Elec",
                    "electricityProduct_mpans" => $session_detail['quotation_mpan'],
                    "gasProduct_reference" => $gas_reference,
                    "gasProduct_productCode" => $TariffCode . "-Gas",
                    "gasProduct_mprns" => $session_detail['quotation_mprn'],
                    "signup_type" => '3',
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'start_date' => date('Y-m-d'),
                    'prefix' => 'DYB_DUAL_',
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower']
                ];

                //get last account_number from database
                $elec_parameter['AuthKey'] = $this->authkey_dyball_regman;
                $elec_parameter['MPAN'] = $session_detail['quotation_mpanlower'];
                $elec_parameter['StartDate'] = date('Y-m-d');
                $elec_parameter['AccountNumber'] = $insert_customer_info;
                $elec_parameter['CustomerName'] = $this->input->post('fname') . ' ' . $this->input->post('lname');
                $elec_parameter['ContactPostCode'] = $session_detail['postcode'];
                $elec_parameter['ElectricityPostCode'] = $session_detail['postcode'];
                $elec_parameter['ContractSignedDate'] = date('Y-m-d');
                $elec_parameter['ContactEmail'] = $this->input->post('email');
                //debug($elec_parameter);
                $elec_response = $this->curl->curl_dyball('/api/RegManager/RegisterMpan', $elec_parameter, 'post');
                //echo '<br>--<br>';
                //debug($elec_response);
                $elec_response = $this->parseHttpResponse($elec_response);
                //debug($elec_response);

                $gas_parameter['AuthKey'] = $this->authkey_dyball_gasman;
                $gas_parameter['MPRN'] = $session_detail['quotation_mprn'];
                $gas_parameter['StartDate'] = date('Y-m-d');
                $gas_parameter['AccountNumber'] = $insert_customer_info;
                $gas_parameter['CustomerId'] = $insert_customer_info;
                $gas_parameter['CustomerName'] = $this->input->post('fname') . ' ' . $this->input->post('lname');
                $gas_parameter['InCode'] = $explode[1];
                $gas_parameter['OutCode'] = $explode[0];
                $gas_parameter['PostCode'] = $session_detail['postcode'];
                $gas_parameter['ContractSignedDate'] = date('Y-m-d');
                $gas_parameter['ContactSurname'] = $this->input->post('fname');
                //debug($gas_parameter);
                // register mprn on dyball
                $gas_response = $this->curl->curl_dyball('/api/GasManager/RegisterMprn', $gas_parameter, 'post');
                $gas_response = $this->parseHttpResponse($gas_response);
                //debug($gas_response['body']);


                if ($gas_response['body']['success'] == 'true' && $elec_response['body']['success'] == 'true') {

                    //insert token in database
                    $token = md5(uniqid(rand(0, 9999), true));

                    $this->activation_email($insert_customer_info, $token, $this->input->post('fname'), $this->input->post('email'));

                    $token_in_database = $this->user_modal->token_in_database($token, $insert_customer_info);

                    //update data in database
                    $update_customer_info = $this->user_modal->update_customer_info($db_parameter, $insert_customer_info);

                    if ($update_customer_info) {

                        echo json_encode(['error' => '0', 'msg' => 'signup successful']);


                    }

                } else if ($gas_response['body']['success'] == 'false' && $elec_response['body']['success'] == 'true') {

                    $token = md5(uniqid(rand(0, 9999), true));

                    $this->activation_email($insert_customer_info, $token, $this->input->post('fname'), $this->input->post('email'));

                    $token_in_database = $this->user_modal->token_in_database($token, $insert_customer_info);

                    //update data in database
                    $update_customer_info = $this->user_modal->update_customer_info($db_parameter, $insert_customer_info);

                    $this->error_modal->log('dyball register webuser done for electricity but fail for gas', $gas_response['body']['errorMessage']);
                    echo json_encode(['error' => '3', 'msg' => 'error while signup: signup done for electricity but fail for gas']);

                } else if ($gas_response['body']['success'] == 'true' && $elec_response['body']['success'] == 'false') {

                    $token = md5(uniqid(rand(0, 9999), true));

                    $this->activation_email($insert_customer_info, $token, $this->input->post('fname'), $this->input->post('email'));

                    $token_in_database = $this->user_modal->token_in_database($token, $insert_customer_info);

                    //update data in database
                    $update_customer_info = $this->user_modal->update_customer_info($db_parameter, $insert_customer_info);

                    $this->error_modal->log('dyball register webuser done for gas but fail for electricity', $elec_parameter['body']['errorMessage']);
                    echo json_encode(['error' => '4', 'msg' => 'error while signup: signup done for gas but fail for electricity']);

                } else {

                    echo json_encode(['error' => '1', 'msg' => 'error while signup']);

                }

            }

            // if quotation is for both electricity and gas
            if ($session_detail['quotation_for'] == 'gas') {

                $dplo = $this->input->post('quotation_dplo_address');


                if ($dplo == NULL) {
                    $dplo = 'Area';
                }


                $db_parameter = [
                    'title' => $this->input->post('customer_title'),
                    'forename' => $this->input->post('fname'),
                    'surname' => $this->input->post('lname'),
                    'billingMethod' => $session_detail['quotation_pay_energy'],
                    'email' => $this->input->post('email'),
                    //'password' => base64_encode($this->input->post('customer_confirm_password')),
                    'phone1' => $this->input->post('telephone'),
                    'phone2' => $this->input->post('customer_phone'),
                    'dateOfBirth' => $dob,
                    'address_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    // 'address_address1' => $this->input->post('customer_address'),

                    'first_line_address' => $this->input->post('quotation_first_line_address'),
                    'town_address' => $this->input->post('quotation_town_address'),
                    'city_address' => $this->input->post('quotation_city_address'),
                    'dplo_address' => $dplo,

                    'address_postcode' => urlencode($session_detail['postcode']),
                    'address_countryCode' => 'GB',

                    'supplyAddress_careOf' => $this->input->post('fname') . ' ' . $this->input->post('lname'),
                    'supplyAddress_address1' => $this->input->post('quotation_first_line_address'),

                    'supplyAddress_town_address' => $this->input->post('quotation_town_address'),
                    'supplyAddress_city_address' => $this->input->post('quotation_city_address'),
                    'supplyAddress_postcode' => urlencode($session_detail['postcode']),
                    'supplyAddress_countryCode' => 'GB',
                    'bankAccountSortCode' => $this->input->post('sort_code'),
                    'bankAccountNumber' => $this->input->post('account_number'),
                    'bankAccountName' => $this->input->post('account_name'),
                    // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                    // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                    // "electricityProduct_productCode"=>"Little Dans Bonanza",
                    // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],
                    "gasProduct_reference" => $gas_reference,
                    "gasProduct_productCode" => $TariffCode . "-Gas",
                    "gasProduct_mprns" => $session_detail['quotation_mprn'],
                    "signup_type" => '3',
                    'plan_price' => $this->input->post('plan_price'),
                    'original_price' => $this->input->post('original_price'),
                    'complete_price' => $this->input->post('complete_price'),
                    'plan_id' => $this->input->post('plan_id'),
                    'start_date' => date('Y-m-d'),
                    'prefix' => 'DYB_GAS_',
                    'tariff_newspend' => $tariff_detail['newSpend'],
                    'tariff_tariffName' => $tariff_detail['tariffName'],
                    'tariff_unitRate1Elec' => $tariff_detail['unitRate1Elec'],
                    'exitFeeElec' => $tariff_detail['exitFeeElec'],
                    'elec_mpan_core' => $session_detail['quotation_mpanlower']
                ];


                $gas_parameter['AuthKey'] = $this->authkey_dyball_gasman;
                $gas_parameter['MPRN'] = $session_detail['quotation_mprn'];
                $gas_parameter['StartDate'] = date('Y-m-d');
                $gas_parameter['AccountNumber'] = $insert_customer_info;
                $gas_parameter['CustomerId'] = $insert_customer_info;
                $gas_parameter['CustomerName'] = $this->input->post('fname') . ' ' . $this->input->post('lname');
                $gas_parameter['InCode'] = $explode[1];
                $gas_parameter['OutCode'] = $explode[0];
                $gas_parameter['PostCode'] = $session_detail['postcode'];
                $gas_parameter['ContractSignedDate'] = date('Y-m-d');
                $gas_parameter['ContactSurname'] = $this->input->post('fname');

                // register mprn on dyball
                $gas_response = $this->curl->curl_dyball('/api/GasManager/RegisterMprn', $gas_parameter, 'post');
                $gas_response = $this->parseHttpResponse($gas_response);

                if ($gas_response['body']['success'] == 'true') {
                    //insert token in database
                    $token = md5(uniqid(rand(0, 9999), true));
                    //$email_data['email_info'] = [ 'token' => $token, 'name' => $this->input->post('fname') ];

                    //$template = $this->load->view( 'layout/email_template', $email_data , true);

                    //$this->load->library('email');
                    //$this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
                    //$this->email->to($this->input->post('email'));
                    //$this->email->subject('Signup Confirmation');
                    //$this->email->message($template);
                    //$this->email->send();

                    $this->activation_email($insert_customer_info, $token, $this->input->post('fname'), $this->input->post('email'));

                    $token_in_database = $this->user_modal->token_in_database($token, $insert_customer_info);

                    //update data in database
                    $update_customer_info = $this->user_modal->update_customer_info($db_parameter, $insert_customer_info);
                    if ($update_customer_info) {
                        echo json_encode(['error' => '0', 'token' => $token, 'msg' => 'signup successful']);


                        ///intercom
                        $this->intercom_create($insert_customer_info, $email, $fname.' '.$lname);


                    }
                    //

                } else {
                    $this->error_modal->log('register webuser fail', $gas_response['body']['errorMessage']);
                    echo json_encode(['error' => '1', 'msg' => 'error while signup']);
                }
            }


        }


    } // end enroll customer


    public static function logMessage($errLevel, $msg, $depth = 1)
    {
        $btStack = debug_backtrace($depth);
        $callerFrame = $btStack[$depth - 1];

        $sid = substr(session_id(), 0, 8);
        $method = $callerFrame['class'] . '.' . $callerFrame['function'];
        $lineNo = $callerFrame['line'];
        $fullMessage = 'SID:' . $sid . ' ' . $method . '(' . $lineNo . '): ' . $msg;

        log_message($errLevel, $fullMessage);
    }

    function parseHttpResponse($response)
    {
        // Parse the headers
        $headers = array();

        $body = null;

        // Split up the httpResponse
        $responseParts = explode("\r\n\r\n", $response);
        foreach ($responseParts as $i => $responsePart) {
            $lines = explode("\r\n", $responsePart);

            // If the part has 200 response Code, parse the rest of the lines as headers.
            //if($lines[0] == "HTTP/1.1 " )
            if (strpos($lines[0], 'HTTP/1.1') !== false) {
                if (preg_match('/^HTTP\/1.1 [4,5]/', $lines[0])) {
                    // 4xx or 5xx error
                    // so log the error
                    $this->logMessage('error', 'Line 0=' . $lines[0], 2);
                }

                foreach ($lines as $j => $line) {
                    if ($j === 0) {
                        $headers['http_code'] = $line;
                    } else {
                        list ($key, $value) = explode(': ', $line);

                        $headers[$key] = $value;
                    }
                }
            } // If last element, probably body
            else if ($i === sizeof($responseParts) - 1) {
                $body = json_decode($responsePart, true);
            }
        }

        return array(
            'headers' => $headers,
            'body' => $body
        );
    }

    function confirmation()
    {
        if (empty($_GET['t'])) {
            echo "<center><h3>No token provided. Please contact support at support@eversmartenergy.co.uk</h3></center>";
            exit;
        }

        $parameter = ["token" => $_GET['t']];
        //check for the token
        $check_for_token = $this->user_modal->check_token_confirm($_GET['t']);
        $get_customer_detail = $this->user_modal->get_account_detail($check_for_token['customer_id']);
        if ($get_customer_detail['signup_type'] == 3) {
            $change_status = $this->user_modal->change_status($_GET['t']);
            $this->load->view('layout/confirmation_template');
            // $response = $this->curl->junifer_request('/rest/v1/webUsers/activate',$parameter, 'post');
            // $response = $this->parseHttpResponse($response);
            //debug($response);
            // if($response['headers']['http_code'] == 'HTTP/1.1 204 No Content')
            // {
            //   $change_status = $this->user_modal->change_status($_GET['t']);
            //   $this->load->view('layout/confirmation_template');
            // }else if( $response['headers']['http_code'] == 'HTTP/1.1 400 Bad Request' ){
            //   echo "<center><h3>".$response['body']['errorDescription'].". Please contact support at support@eversmartenergy.co.uk</h3></center>";
            // }
            // else{

            //   echo "<center><h3>This token has already been redeemed. Please contact support at support@eversmartenergy.co.uk</h3></center>";
            // }
        }
        if ($get_customer_detail['signup_type'] == 0 && $get_customer_detail['success'] == null) {
            $response = $this->curl->junifer_request('/rest/v1/webUsers/activate', $parameter, 'post');
            $response = $this->parseHttpResponse($response);
            //debug($response);
            if ($response['headers']['http_code'] == 'HTTP/1.1 204 No Content') {
                $change_status = $this->user_modal->change_status($_GET['t']);
                $this->load->view('layout/confirmation_template');
            } else if ($response['headers']['http_code'] == 'HTTP/1.1 400 Bad Request') {
                echo "<center><h3>" . $response['body']['errorDescription'] . ". Please contact support at support@eversmartenergy.co.uk</h3></center>";
            } else {

                echo "<center><h3>This token has already been redeemed. Please contact support at support@eversmartenergy.co.uk</h3></center>";
            }
        } else if ($get_customer_detail['signup_type'] == 0 && $get_customer_detail['success'] == 'fail') {

            $change_status = $this->user_modal->change_status($_GET['t']);
            $this->load->view('layout/confirmation_template');

        } else {
            echo "<center><h3>Something went wrong... Please contact support at support@eversmartenergy.co.uk</h3></center>";
        }
    }

    function login()
    {
        $this->load->view('user/login');
    }


    function check_login()
    {

        $token = $this->input->post('token');

        if ($this->input->post('user_email') == 'meterbooking@eversmartenergy.co.uk' && $this->input->post('user_password') == 'admin') {
            $info['customer_id'] = 0;
            $info['account_id'] = 0;
            $info['account_number'] = 0;
            $info['title'] = 'Mr.';
            $info['first_name'] = 'Admin';
            $info['account_status'] = '0';
            $info['signup_type'] = '6';
            $this->session->set_userdata('login_data', $info);
            echo json_encode(['error' => '5', 'data' => [], 'msg' => 'admin login']);
            exit;
        }

        $login_response = $this->user_modal->login_check($this->input->post());
        //echo '<pre>'.print_r($login_response,1).'</pre>';
        //exit;

        if (isset($login_response['admin_role_type_id']) && $login_response['admin_role_type_id'] == 1) {
            $this->session->set_userdata('login_data', $login_response);
            echo json_encode(['error' => '0', 'msg' => 'admin_success']);
            exit;
        } else if ( isset($login_response['admin_role_type_id']) && $login_response['admin_role_type_id'] == 2) {
            $this->session->set_userdata('login_data', $login_response);
            echo json_encode(['error' => '0', 'msg' => 'cs_success']);
            exit;
        } else if ( isset($login_response['admin_role_type_id']) && $login_response['admin_role_type_id'] == 3) {
            $this->session->set_userdata('login_data', $login_response);
            echo json_encode(['error' => '0', 'msg' => 'tm_success']);
            exit;
        } else if ( isset($login_response['admin_role_type_id']) && $login_response['admin_role_type_id'] == 4) {
            $this->session->set_userdata('login_data', $login_response);
            echo json_encode(['error' => '0', 'msg' => 'sf_success']);
            exit;
        } else if (!empty($login_response) || $login_response != null) {

           
            // Get / Set & Get intercom credentials in session
            if(isset($login_response['intercom_id']) && $login_response['intercom_id'] != '')
            {
                $IntercomData = $this->get_intercom($login_response['intercom_id']);
                
                //print_r($IntercomData);

                if(isset($IntercomData['errors'][0]['message']) && $IntercomData['errors'][0]['message'] == 'User Not Found') {
                    $name = $login_response['forename'].' '.$login_response['surname'];
                    $IntercomData = $this->intercom_create($login_response['id'], $login_response['email'], $name);    
                }
            }
            else
            {        
                $name = $login_response['forename'].' '.$login_response['surname'];
                $IntercomData = $this->intercom_create($login_response['id'], $login_response['email'], $name);
            } 
            // End if else intercom in session


            if ($login_response['active'] == 1) {

                if ($login_response['api_user_status'] == 0) {

                    //$next_week = date('d/m/Y', strtotime($login_response['create_at'].'+1 week')); // 26/05/2014

                    $DateSeg = explode('-', $login_response['create_at']);
                    $CreatedAt = date('Y-m-d H:i:s', mktime(23, 59, 59, (int)$DateSeg[1], (int)$DateSeg[2], (int)$DateSeg[0]));

                    $next_week = strtotime($CreatedAt . '+21 days');
                    $noOfDay = date('Y-m-d', $next_week);  // date after 21 days

                    //echo $now = date( 'Y-m-d', strtotime($login_response['create_at'])); // or your date as well
                    $now = date('Y-m-d');
                    $date1 = date_create($now);
                    $date2 = date_create(date('Y-m-d', strtotime($login_response['create_at'])));

                    //difference between two dates
                    $diff = date_diff($date1, $date2);

                    //count days
                    $info['current_day'] = $diff->format("%a");


                    //$difference = $next_week - time(); // next weeks date minus todays date
                    //$difference = date('j', $difference);

                    // if we are after the 3 weeks set difference to 0
                    if ($next_week < time()) {
                        $difference = '0';
                    } else {

                        $difference = $next_week - time(); // next weeks date minus todays date
                        $difference = date('j', $difference);
                    }


                    $info['day_left'] = $difference;

                    $info['create_at'] = $login_response['create_at'];
                    $info['first_reading_gas'] = $login_response['first_reading_gas'];
                    $info['first_reading_elec'] = $login_response['first_reading_elec'];
                    $info['booked_meter'] = $login_response['booked_meter'];
                    $info['admin_role_type_id'] = $login_response['admin_role_type_id'];
                    $info['id'] = $login_response['id'];
                    $info['intercom_id'] = $IntercomData['id'];
                    $info['intercom_user_id'] = $IntercomData['user_id'];
                    $info['intercom_name'] = $IntercomData['name'];
                    $info['intercom_email'] = $IntercomData['email'];
                    $info['title'] = $login_response['title'];
                    $info['first_name'] = $login_response['forename'];
                    $info['last_name'] = $login_response['surname'];
                    $info['phone1'] = $login_response['phone1'];
                    $info['signup_type'] = $login_response['signup_type'];
                    $info['account_status'] = $login_response['api_user_status'];
                    // $info['user_mpan'] = $check_user_active['electricityProduct_mpans'];
                    $info['user_mprn'] = $login_response['gasProduct_mprns'];
                    $info['address'] = $login_response['first_line_address'];
                    $info['town_address'] = $login_response['town_address'];
                    $info['dplo_address'] = $login_response['dplo_address'];
                    $info['city_address'] = $login_response['city_address'];
                    $info['address_postcode'] = $login_response['address_postcode'];
                    $info['phone1'] = $login_response['phone1'];
                    $info['mpancore'] = $login_response['elec_mpan_core'];

                    $info['elec_meter_serial'] = $login_response['elec_meter_serial'];
                    $info['gas_meter_serial'] = $login_response['gas_meter_serial'];

                    $info['customer_id'] = $login_response['customer_id'];
                    $info['account_id'] = $login_response['account_id'];
                    $info['account_number'] = $login_response['account_id'];

                    $info['email'] = $login_response['email'];
                    $info['mpancore'] = $login_response['elec_mpan_core'];
                    $info['meterpoint_mpan'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPAN"];
                    $info['meterpoint_mprn'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPRN"];

                    $info['billingMethod'] = $login_response['billingMethod'];
                    $info['tariff_newspend'] = $login_response['tariff_newspend'];
                    $info['exitFeeElec'] = $login_response['exitFeeElec'];
                    $info['tariff_tariffName'] = $login_response['tariff_tariffName'];
                    $info['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];

                    $info['meterTypeElec'] = $login_response['meterTypeElec'];

                    // Initialise this var...will be overwritten on first successful login
                    // this is when api_user_status is set so we wont set this in the future
                    $info['junifer_account_active'] = 0;

                    // debug($info,1);
                    $this->session->set_userdata('login_data', $info);

                    // Prepay (Dyball) customers should be taken straight into the portal with a restricted view
                    if ($login_response['signup_type'] == 3) { // Dyball

                        echo json_encode(['error' => '0', 'data' => $info, 'msg' => 'dyball_success']);
                        exit;
                    } else {
                        echo json_encode(['error' => '4', 'msg' => 'user status at junifer is pending']);
                        exit;

                    }

                }

                if ($login_response['signup_type'] == 0 || $login_response['signup_type'] == 2) {

                    //get user detail from junifer
                    //debug($junifer_response);
                    if (!empty($login_response['customer_id'])) {

                        $info['admin_role_type_id'] = $login_response['admin_role_type_id'];
                        $info['id'] = $login_response['id'];
                        $info['intercom_id'] = $IntercomData['id'];
                        $info['intercom_user_id'] = $IntercomData['user_id'];
                        $info['intercom_name'] = $IntercomData['name'];
                        $info['intercom_email'] = $IntercomData['email'];    
                        $info['title'] = $login_response['title'];
                        $info['first_name'] = $login_response['forename'];
                        $info['last_name'] = $login_response['surname'];
                        $info['signup_type'] = $login_response['signup_type'];
                        // $info['user_mpan'] = $check_user_active['electricityProduct_mpans'];
                        $info['user_mprn'] = $login_response['gasProduct_mprns'];
                        $info['address'] = $login_response['first_line_address'];
                        $info['town_address'] = $login_response['town_address'];
                        $info['dplo_address'] = $login_response['dplo_address'];
                        $info['city_address'] = $login_response['city_address'];
                        $info['address_postcode'] = $login_response['address_postcode'];
                        $info['phone1'] = $login_response['phone1'];
                        $info['mpancore'] = $login_response['elec_mpan_core'];
                        $info['account_status'] = $login_response['api_user_status'];
                        $info['elec_meter_serial'] = $login_response['elec_meter_serial'];
                        $info['gas_meter_serial'] = $login_response['gas_meter_serial'];

                        $info['customer_id'] = $login_response['customer_id'];
                        $info['account_id'] = $login_response['account_id'];

                        $info['email'] = $login_response['email'];
                        $info['mpancore'] = $login_response['elec_mpan_core'];
                        $info['meterpoint_mpan'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPAN"];
                        $info['meterpoint_mprn'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPRN"];

                        $info['billingMethod'] = $login_response['billingMethod'];
                        $info['tariff_newspend'] = $login_response['tariff_newspend'];
                        $info['exitFeeElec'] = $login_response['exitFeeElec'];
                        $info['tariff_tariffName'] = $login_response['tariff_tariffName'];
                        $info['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];
                        $info['meterTypeElec'] = $login_response['meterTypeElec'];

                        $info['junifer_account_active'] = 1;

                        $account_balanace = $this->curl->junifer_request('/rest/v1/accounts/' . $login_response['account_id']);
                        // $account_balanace = $this->curl->junifer_request('/rest/v1/accounts/525');

                        $response = $this->parseHttpResponse($account_balanace);

                        if (isset($response['headers']['http_code'])) {

                            if ($response['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                                $info['balance'] = $response['body']['balance'];
                                $info['account_number'] = $response['body']['number'];
                            } else {
                                $info['balance'] = 0;
                                $info['account_number'] = 0;
                            }
                        } else {
                            $info['balance'] = 0;
                            $info['account_number'] = 0;
                        }

                        //set data in session
                        $this->session->set_userdata('login_data', $info);
                        echo json_encode(['error' => '0', 'data' => $info, 'msg' => 'success']);

                    } else {
                        echo json_encode(['error' => '1', 'data' => [], 'msg' => 'error']);
                        exit;
                    }
                } elseif ($login_response['signup_type'] == 3) {

                    $info['admin_role_type_id'] = $login_response['admin_role_type_id'];
                    $info['id'] = $login_response['id'];
                    $info['intercom_id'] = $IntercomData['id'];
                    $info['intercom_user_id'] = $IntercomData['user_id'];
                    $info['intercom_name'] = $IntercomData['name'];
                    $info['intercom_email'] = $IntercomData['email'];
                    $info['title'] = $login_response['title'];
                    $info['first_name'] = $login_response['forename'];
                    $info['last_name'] = $login_response['surname'];
                    $info['signup_type'] = $login_response['signup_type'];
                    // $info['user_mpan'] = $check_user_active['electricityProduct_mpans'];
                    $info['user_mprn'] = $login_response['gasProduct_mprns'];
                    $info['address'] = $login_response['first_line_address'];
                    $info['dplo_address'] = $login_response['dplo_address'];
                    $info['town_address'] = $login_response['town_address'];
                    $info['city_address'] = $login_response['city_address'];
                    $info['address_postcode'] = $login_response['address_postcode'];
                    $info['phone1'] = $login_response['phone1'];

                    $info['mpancore'] = $login_response['elec_mpan_core'];
                    $info['account_status'] = $login_response['api_user_status'];
                    $info['elec_meter_serial'] = $login_response['elec_meter_serial'];
                    $info['gas_meter_serial'] = $login_response['gas_meter_serial'];

                    $info['customer_id'] = $login_response['customer_id'];
                    $info['account_id'] = $login_response['account_id'];
                    $info['prefix'] = $login_response['prefix'];
                    $info['email'] = $login_response['email'];
                    $info['mpancore'] = $login_response['elec_mpan_core'];
                    $info['meterpoint_mpan'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPAN"];
                    $info['meterpoint_mprn'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPRN"];

                    $info['account_number'] = $login_response['prefix'] . $login_response['id'];

                    $info['billingMethod'] = $login_response['billingMethod'];
                    $info['tariff_newspend'] = $login_response['tariff_newspend'];
                    $info['tariff_tariffName'] = $login_response['tariff_tariffName'];
                    $info['exitFeeElec'] = $login_response['exitFeeElec'];
                    $info['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];
                    $info['meterTypeElec'] = $login_response['meterTypeElec'];

                    $info['junifer_account_active'] = 0;

                    //set data in session
                    $this->session->set_userdata('login_data', $info);
                    echo json_encode(['error' => '0', 'data' => $info, 'msg' => 'dyball_success']);
                }

            } else {

                if (empty($token)) {
                    echo json_encode(['error' => '1', 'msg' => 'Token required for reset password']);
                    exit;
                } else {

                    //check token in database
                    $check_token = $this->user_modal->check_token($token);

                    //check for token type
                    if ($check_token['token_type'] == '0') {

                        //check for token expiry
                        $curret_date = date('Y-m-d H:i:s');
                        $token_date = $check_token['expire_date'];

                        //Convert them to timestamps.
                        $date1Timestamp = strtotime($token_date);
                        $date2Timestamp = strtotime($curret_date);

                        //Calculate the difference.
                        $difference = $date2Timestamp - $date1Timestamp;

                        //echo '<br>'.$difference;
                        if ($difference > 0) {
                            echo json_encode(['error' => '1', 'msg' => 'Token expire']);
                            exit;
                        } else {

                            // update query
                            $customer_update = $this->user_modal->customer_update($login_response['id']);
                            if ($customer_update) {

                                if ($login_response['signup_type'] == 0 || $login_response['signup_type'] == 2) {

                                    //get user detail from junifer
                                    if (!empty($login_response['customer_id'])) {

                                        $info['admin_role_type_id'] = $login_response['admin_role_type_id'];
                                        $info['id'] = $login_response['id'];
                                        $info['intercom_id'] = $IntercomData['id'];
                                        $info['intercom_user_id'] = $IntercomData['user_id'];
                                        $info['intercom_name'] = $IntercomData['name'];
                                        $info['intercom_email'] = $IntercomData['email'];                    
                                        $info['title'] = $login_response['title'];
                                        $info['first_name'] = $login_response['forename'];
                                        $info['last_name'] = $login_response['surname'];
                                        $info['signup_type'] = $login_response['signup_type'];
                                        // $info['user_mpan'] = $check_user_active['electricityProduct_mpans'];
                                        $info['user_mprn'] = $login_response['gasProduct_mprns'];
                                        $info['address'] = $login_response['first_line_address'];
                                        $info['dplo_address'] = $login_response['dplo_address'];
                                        $info['town_address'] = $login_response['town_address'];
                                        $info['city_address'] = $login_response['city_address'];
                                        $info['address_postcode'] = $login_response['address_postcode'];
                                        $info['phone1'] = $login_response['phone1'];
                                        $info['mpancore'] = $login_response['elec_mpan_core'];
                                        $info['account_status'] = $login_response['api_user_status'];
                                        $info['elec_meter_serial'] = $login_response['elec_meter_serial'];
                                        $info['gas_meter_serial'] = $login_response['gas_meter_serial'];

                                        $info['customer_id'] = $login_response['customer_id'];
                                        $info['account_id'] = $login_response['account_id'];

                                        $info['email'] = $login_response['email'];
                                        $info['mpancore'] = $login_response['elec_mpan_core'];
                                        $info['meterpoint_mpan'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPAN"];
                                        $info['meterpoint_mprn'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPRN"];

                                        $info['billingMethod'] = $login_response['billingMethod'];
                                        $info['tariff_newspend'] = $login_response['tariff_newspend'];
                                        $info['exitFeeElec'] = $login_response['exitFeeElec'];
                                        $info['tariff_tariffName'] = $login_response['tariff_tariffName'];
                                        $info['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];

                                        $account_balanace = $this->curl->junifer_request('/rest/v1/accounts/' . $login_response['account_id']);
                                        $response = $this->parseHttpResponse($account_balanace);
                                        //debug($response,1);

                                        if ($response['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                                            $info['balance'] = $response['body']['balance'];
                                            $info['account_number'] = $response['body']['number'];
                                        } else {
                                            $info['balance'] = 0;
                                            $info['account_number'] = 0;
                                        }

                                        //set data in session
                                        $this->session->set_userdata('login_data', $info);
                                        echo json_encode(['error' => '0', 'data' => $info, 'msg' => 'success']);
                                    } else {
                                        echo json_encode(['error' => '1', 'data' => [], 'msg' => 'error']);
                                    }


                                } elseif ($login_response['signup_type'] == 3) {

                                    $info['admin_role_type_id'] = $login_response['admin_role_type_id'];
                                    $user_login_detail['id'] = $login_response['id'];
                                    $user_login_detail['customers'] = $login_response['id'];
                                    $user_login_detail['accounts'] = $login_response['prefix'] . $login_response['id'];
                                    $user_login_detail['account_number'] = $login_response['prefix'] . $login_response['id'];
                                    $user_login_detail['user_mpan'] = $login_response['electricityProduct_mpans'];
                                    $user_login_detail['user_mprn'] = $login_response['gasProduct_mprns'];
                                    $user_login_detail['user_name'] = $login_response['forename'];
                                    $info['address'] = $login_response['first_line_address'];
                                    $info['town_address'] = $login_response['town_address'];
                                    $info['dplo_address'] = $login_response['dplo_address'];
                                    $info['city_address'] = $login_response['city_address'];
                                    $user_login_detail['signup_type'] = $login_response['signup_type'];
                                    $user_login_detail['prefix'] = $login_response['prefix'];
                                    $user_login_detail['title'] = $login_response['title'];
                                    $user_login_detail['account_status'] = $login_response['api_user_status'];
                                    $user_login_detail['billingMethod'] = $login_response['billingMethod'];
                                    $user_login_detail['tariff_newspend'] = $login_response['tariff_newspend'];
                                    $user_login_detail['tariff_tariffName'] = $login_response['tariff_tariffName'];
                                    $user_login_detail['exitFeeElec'] = $login_response['exitFeeElec'];
                                    $user_login_detail['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];

                                    //set data in session
                                    $this->session->set_userdata('login_data', $user_login_detail);
                                    echo json_encode(['error' => '0', 'data' => $user_login_detail, 'msg' => 'success']);

                                }

                            }
                        }

                    } else {

                        echo json_encode(['error' => '1', 'msg' => 'invalid token']);

                    }
                }
            }

        } else {

            echo json_encode(['error' => '2', 'msg' => 'wrong username password']);

        }

    }


    function dashboard()
    {
        if ($this->session->has_userdata('login_data')) {

            $daily_use_gas_total = 0;
            $daily_use_elec_total = 0;

            $get_user_account_id = $this->session->userdata('login_data')['account_id'];
            $get_id = $this->session->userdata('login_data')['id'];

            /* Payment */
            if ($this->session->userdata('login_data')['signup_type'] == 0 || $this->session->userdata('login_data')['signup_type'] == 2) {

                $get_balance_junifer = $this->curl->junifer_request('/rest/v1/accounts/' . $get_user_account_id . '');
                $get_balance_junifer = $this->parseHttpResponse($get_balance_junifer);
                if ($get_balance_junifer['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                    $data['balance'] = $get_balance_junifer['body']['balance'];
                }

                $get_balance_junifer = $this->curl->junifer_request('/rest/v1/accounts/' . $get_user_account_id . '');
                $get_balance_junifer = $this->parseHttpResponse($get_balance_junifer);
                if ($get_balance_junifer['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                    $data['balance'] = $get_balance_junifer['body']['balance'];
                }

                if ($this->session->has_userdata('login_data')) {
                    if ($this->session->has_userdata('login_data')) {
                        $from_date = date('Y-m-d', strtotime("-1 days"));
                        $to_date = date('Y-m-d');
                        $fromdate_monthly = date('Y-m-01');
                        $todate_monthly = date('Y-m-01', strtotime("+1 month"));
                        $get_meterpoint_ids = $this->curl->junifer_request_usage('/rest/v1/accounts/' . $get_user_account_id . '/agreements');
                        $get_meterpoint_ids_responce = json_decode($get_meterpoint_ids);

                        if (!empty($get_meterpoint_ids_responce->results)) {
                            for ($r = 0; $r < count($get_meterpoint_ids_responce->results); $r++) {
                                if ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Electricity Supply') {
                                    if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {
                                        $electric_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;
                                    }
                                } elseif ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Gas Supply') {
                                    if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {
                                        $gas_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;
                                    }
                                }
                            }
                        }

                        if (isset($electric_meter_point_id)) {

                            $daily_use_elec_total = 0;
                            $el_response_monthly_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/' . $electric_meter_point_id . '/readings?fromDt=' . $fromdate_monthly . '&toDt=' . $todate_monthly . '');
                            $response = json_decode($el_response_monthly_array, true);

                            $daily_use_elec = $this->curl->junifer_request_usage('/rest/v1/meterPoints/' . $electric_meter_point_id . '/readings?fromDt=' . $from_date . '&toDt=' . $to_date . '');
                            $daily_use_elec = json_decode($daily_use_elec, true);
                            $daily_use_elec_total = $daily_use_elec['results'][0]['consumption'] + $daily_use_elec['results'][1]['consumption'];


                            $data['results'] = $response['results'];
                            $data['last_reading'] = end($response['results']);
                        }

                        if (isset($gas_meter_point_id)) {
                            $daily_use_gas_total = 0;
                            $gas_response = $this->curl->junifer_request_usage('/rest/v1/meterPoints/' . $gas_meter_point_id . '/readings?fromDt=' . $fromdate_monthly . '&toDt=' . $todate_monthly . '');
                            $gas_response = json_decode($gas_response, true);

                            $daily_use_gas = $this->curl->junifer_request_usage('/rest/v1/meterPoints/' . $gas_meter_point_id . '/readings?fromDt=' . $from_date . '&toDt=' . $to_date . '');
                            $daily_use_gas = json_decode($daily_use_gas, true);
                            $daily_use_gas_total = $daily_use_gas['results'][0]['consumption'] + $daily_use_gas['results'][1]['consumption'];

                            $data['daily_use_gas_total'] = $daily_use_gas_total;
                            $data['results'] = $gas_response['results'];
                            $data['last_reading_gas'] = end($gas_response['results']);
                        }

                    }
                }
            }

            /* Saas */
            $referrals = $this->curl->curlSaas('account/' . $get_id . '/user/' . $get_id . '/pii');
            $referrals = json_decode($referrals);
            $ref = 0;
            $format_bal = 0;
            $ref = $referrals->referrals->totalCount;

            $list_reward = $this->curl->curlSaas('reward/balance?accountId=' . $get_id . '');
            $list_reward = json_decode($list_reward);

            if ($list_reward == null) {
                $format_bal = 0;
            } else {
                $assigned_bal = $list_reward[0]->totalAssignedCredit;
                $redeemed_bal = $list_reward[0]->totalRedeemedCredit;
                $current_bal = $assigned_bal - $redeemed_bal;
                $format_bal = $current_bal / 100;
            }

            /* Messages */
            if ($this->session->userdata('login_data')['signup_type'] == 0 || $this->session->userdata('login_data')['signup_type'] == 2) {
                $junifer_msgs = $this->curl->junifer_request('/rest/v1/accounts/' . $get_user_account_id . '/communications');
                $junifer_msgs = $this->parseHttpResponse($junifer_msgs);
                if ($junifer_msgs['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                    $junifer_msgs = $junifer_msgs['body'];
                } else {
                    $junifer_msgs = [];
                }
            } else {
                $junifer_msgs = [];
            }


            $data['daily_use_elec_total'] = $daily_use_elec_total;
            $data['daily_use_gas_total'] = $daily_use_gas_total;
            $data['junifer_msgs'] = $junifer_msgs;
            $data['ref'] = $ref;
            $data['format_bal'] = $format_bal;
            $data['session_data'] = $this->session->userdata('login_data');
            $this->load->view('user/dashboard', $data);
        } else {
            $this->login();
        }
    }

    function logout()
    {
        session_destroy();
        echo json_encode(['error' => '0', 'data' => [], 'msg' => 'logout']);
    }

    function meter_reading()
    {
        //debug($this->session->userdata('login_data'),1);
        if (empty($this->session->userdata('login_data'))) {
            header('location:' . base_url() . 'index.php/user/login');
            exit;
        }
        //check session data
        //debug($this->session->userdata('login_data'));
        if ($this->session->userdata('login_data')['signup_type'] == 0 || $this->session->userdata('login_data')['signup_type'] == 2)
            if ($this->session->has_userdata('login_data')) {

                //get user reading from junifer
                //debug($this->session->userdata('login_data'));
                $current_year = date('Y-m-d');
                $last_year = date('Y-m-d', strtotime(date("Y-m-d", time()) . " - 365 day"));
                $fromdate_monthly = date('Y-m-01');        //date('Y-m-01')
                $todate_monthly = date('Y-m-01', strtotime("+1 month"));


                //get meterpoint id
                //  echo '/rest/v1/ecoes/mpans?postcode=WA15%208RS&limit=5';
                // $curl_request = $this->curl->junifer_request('/rest/v1/ecoes/mpans?postcode=WA15%208RS&limit=5');

                // echo '/rest/v1/ecoes/meterPoints?meterSerialNumber=D07W550193&queryDttm=2018-05-17';
                // $curl_request = $this->curl->junifer_request('/rest/v1/ecoes/meterPoints?meterSerialNumber=D07W550193&queryDttm=2018-05-17' );
                // $curl_request = $this->parseHttpResponse($curl_request);
                // debug($curl_request,1);
                // //echo '/rest/v1/meterPoints/'.$this->session->userdata('login_data')['account_id'].'/paymentscheduleperiods?fromDt='.$current_year.'&toDt='.$last_year;
                //
                // $parameter = [ 'fromDt' => $current_year, 'toDt' => $last_year ];
                // $response = $this->curl->junifer_request('/rest/v1/meterPoints/'.$this->session->userdata('login_data')['account_id'].'/paymentscheduleperiods?fromDt='.$current_year.'&toDt='.$last_year);
                // $response = $this->parseHttpResponse($response);

                $get_user_account_id = $this->session->userdata('login_data')['account_id'];
                $get_meterpoint_ids = $this->curl->junifer_request_usage('/rest/v1/accounts/' . $get_user_account_id . '/agreements');
                $get_meterpoint_ids_responce = json_decode($get_meterpoint_ids);


                if (!empty($get_meterpoint_ids_responce->results)) {
                    for ($r = 0; $r < count($get_meterpoint_ids_responce->results); $r++) {


                        if ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Electricity Supply') {

                            if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {

                                $electric_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;

                            }
                        } elseif ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Gas Supply') {

                            if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {

                                $gas_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;

                            }
                        }
                    }
                }


                if (isset($electric_meter_point_id)) {
                    $el_response_monthly_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/' . $electric_meter_point_id . '/readings?fromDt=' . $fromdate_monthly . '&toDt=' . $todate_monthly . '');
                    $response = json_decode($el_response_monthly_array, true);
                    $data['results'] = $response['results'];
                    $data['last_reading'] = end($response['results']);
                }


                if (isset($gas_meter_point_id)) {
                    $gas_response = $this->curl->junifer_request_usage('/rest/v1/meterPoints/' . $gas_meter_point_id . '/readings?fromDt=' . $fromdate_monthly . '&toDt=' . $todate_monthly . '');
                    $gas_response = json_decode($gas_response, true);
                    $data['gas_reading'] = $gas_response['results'];
                    $data['last_reading_gas'] = end($gas_response['results']);
                    //var_dump($data['gas_results']);
                }


                //  $response = $this->curl->junifer_request_test('/rest/v1/meterPoints/402/readings');
                //  $response = json_decode($response,true);
                // debug($response);
                header('content-type: text/html');
//          $data['results'] = $response['results'];
                $data['session_data'] = $this->session->userdata('login_data');

                $data['content'] = 'dashboard/meter_reading';
                //debug($data,1);
            }
        if ($this->session->userdata('login_data')['signup_type'] == 3) {
            // echo '1';
            $result_response = array();
            $gas_results = array();
            if (!empty($this->session->userdata('login_data')['mpancore'])) {
                $parameter = ["AuthKey" => $this->authkey_dyball_serve, "AccountNumber" => "DYB_ELEC_" . $this->session->userdata('login_data')['id']];
                //debug($parameter);
                $response = $this->curl->curl_dyball('/api/customerselfservice/GetElectricityReadings', $parameter, 'post');
                //debug($response,1);
                $response = json_decode($response, true);
                $result = $response['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
                for ($i = 0; $i < count($result); $i++) {
                    $result_response[$i]['readingDttm'] = $result[$i]['ReadDate'];
                    $result_response[$i]['consumption'] = $result[$i]['Reading'];
                }
                //$data['last_reading'] = end($response['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings']);
            } else {
                $result_response = '';
            }
            if (!empty($this->session->userdata('login_data')['user_mprn'])) {
                $parameter_gas = ["AuthKey" => "EVERSMARTENERGYSUPP", "AccountNumber" => "EVDYB" . $this->session->userdata('login_data')['account_id']];
                $response_gas = $this->curl->junifer_request_test('/api/CustomerSelfService/GetGasReadings', $parameter_gas, 'post');
                $response_gas = json_decode($response_gas, true);
                $result_gas = $response_gas['Mprns'][0]['MprnMeters'][0]['Readings'];
                for ($i = 0; $i < count($result_gas); $i++) {
                    $gas_results[$i]['readingDttm'] = $result_gas[$i]['ReadDate'];
                    $gas_results[$i]['consumption'] = $result_gas[$i]['Reading'];
                }
                if (isset($response_gas['Mprns'][0]['MprnMeters'][0]['Readings'])) {
                    $data['last_gas_reading'] = end($response_gas['Mprns'][0]['MprnMeters'][0]['Readings']);
                } else {
                    $data['last_gas_reading'] = [];
                }
            } else {
                $gas_results = '';
            }

            //debug($response);
            header('content-type: text/html');
            $data['results'] = $result_response;
            $data['gas_reading'] = $gas_results;
            $data['session_data'] = $this->session->userdata('login_data');

            $data['content'] = 'dashboard/meter_reading';
        }
        $data['title'] = 'Meter Reading';
        //debug($data,1);
        $this->load->view('layout/dashboard_master', $data);


    }



    function submit_reading()
    {

        if ($this->input->post('signupType') == 3) // Dyball
        {

            $login_response = $this->user_modal->get_account_detail($this->session->userdata('login_data')['id']);
            $users_mpan = $login_response['elec_mpan_core']; // '1610009348896' ;

            if (isset($users_mpan)) {

                $parameter = [
                    "AuthKey" => "b450e45e-63b9-4c68-b1d7-7b5794115314",
                    "MPAN" => $users_mpan,
                    "CurrentMeterOnly" => "True"
                ];

                $response_getmeterdetails = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetMpanMeterDetails', $parameter, 'post');
                $response_getmeterdetails = $this->parseHttpResponse($response_getmeterdetails);


                $parameter_elec = json_encode(array(
                    "AuthKey" => "b450e45e-63b9-4c68-b1d7-7b5794115314",
                    "MPAN" => $users_mpan,
                    "readingDt" => date('Y-m-d'),
                    "Meters" => array(array(
                        "Registers" => array(array(
                            "Reading" => $this->input->post('elec_submit_reds')
                        ))
                    ))
                ));

            }

        }


        if ($this->input->post('signupType') == 0 || $this->input->post('signupType') == 2)  {// Junifer / Both

            $get_user_account_id = $this->session->userdata('login_data')['account_id'];
            $get_meterpoint_ids = $this->curl->junifer_request_usage('/rest/v1/accounts/' . $get_user_account_id . '/agreements');
            $get_meterpoint_ids_responce = json_decode($get_meterpoint_ids);


            if (!empty($get_meterpoint_ids_responce)) {
                for ($r = 0; $r < count($get_meterpoint_ids_responce->results); $r++) {

                    if ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Electricity Supply') {

                        if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {

                            $electric_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;

                        }

                    } elseif ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Gas Supply') {

                        if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {

    }
    }
    }}

    if ( $this->session->userdata('login_data')['meterTypeElec'] === 'E7') {
   
    $parameter =  json_encode(array(
      "ignoreWarnings" => "false",
      "readingDt" => date('Y-m-d'),
      "sequenceType" => "Normal",
      "source" => "Customer",
      "quality" => "Normal",
      "registerReads" => array(array(
            "reading" => $this->input->post('elec_submit_reds'),
            "readingType"=> "Day"),
            array(
            "reading" => $this->input->post('elec_submit_reds_two'),
            "readingType"=> "Night",
            )
      )
    )
    );

   // print_r( $parameter);

  
  }

  else {
    $parameter =  json_encode(array(
      "ignoreWarnings" => "false",
      "readingDt" => date('Y-m-d'),
      "sequenceType" => "Normal",
      "source" => "Customer",
      "quality" => "Normal",
      "registerReads" => array(array(
            "reading" => $this->input->post('elec_submit_reds'),
            "readingType"=> "Standard"
      ))
    )
    );
  }




            if ($_SERVER['HTTP_HOST'] == '127.0.0.1:8000' || $_SERVER['HTTP_HOST'] == '18.191.137.119')  //local
            {

                $curl_post_readings = curl_init();
                curl_setopt($curl_post_readings, CURLOPT_POSTFIELDS, $parameter);
                curl_setopt_array($curl_post_readings, array(
                    CURLOPT_PORT => "43002",

                    //junifer local
                    CURLOPT_URL => "http://134.213.125.150:43002/rest/v1/meterPoints/" . $electric_meter_point_id . "/readingsWithoutMtds",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",

                    CURLOPT_HTTPHEADER => array(
                        "Cache-Control: no-cache",
                        "Content-Type: application/json",
                        // local junifer
                        'X-Junifer-X-apikey: 83B1ilbo',
                        'X-Junifer-X-username: APIUser',
                    ),
                ));
            }


            if ($_SERVER['HTTP_HOST'] == '52.56.76.183') //production
            {

                $curl_post_readings = curl_init();
                curl_setopt($curl_post_readings, CURLOPT_POSTFIELDS, $parameter);
                curl_setopt_array($curl_post_readings, array(
                    CURLOPT_PORT => "43002",

                    CURLOPT_URL => "http://134.213.12.122:43002/rest/v1/meterPoints/" . $electric_meter_point_id . "/readingsWithoutMtds",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",

                    CURLOPT_HTTPHEADER => array(
                        "Cache-Control: no-cache",
                        "Content-Type: application/json",
                        // production junifer
                        'X-Junifer-X-apikey: dgiZaFDb',
                        'X-Junifer-X-username: api',
                    ),
                ));
            }


            $responsey = curl_exec($curl_post_readings);
            $err = curl_error($curl_post_readings);
            $responsey = json_decode($responsey);
            curl_close($curl_post_readings);

            $db_parameter = [
                'customer_id' => $this->session->userdata('login_data')['id'],
                'meter_reading' => $this->input->post('elec_submit_reds'),
                'fuel_type_id' => 2 // Elec
            ];


            if (isset($responsey->errorDescription)) {
                echo json_encode(['error' => '1', 'errorDescription' => $responsey->errorDescription]);
            } else {
                $electric_first_update = $this->user_modal->electric_first_update($this->session->userdata('login_data')['id']);
                $this->user_modal->log_meter_reading($db_parameter);
                echo json_encode(['error' => '0', 'updated' => $electric_first_update,]);
            }

        }

    }



    function submit_reading_gas(){

        if( $this->input->post('signupType') == 3 )
        {
            $parameter = [
              'AuthKey' => $this->authkey_dyball_serve,
              'AccountNumber' => 'DYB_ELEC_'.$this->session->userdata('login_data')['id'],
              'MeterSerialNumber' => date('Y-m-dTH:i:s'),
              'MPAN' => 'Normal',
              'ReadingDate' => date('Y-m-dTH:i:s'),
              'RegisterID1' => 'Normal',
              //'Reading1' => $this->input->post('elec_meter_submit')
              'Reading1' => '1111'
            ];

            //debug($parameter);
            $response = $this->curl->curl_dyball('/api/CustomerSelfService/SubmitElectricityReading', $parameter, 'post');
            //debug($response,1);
            $response = json_decode($response,true);
            echo json_encode([ 'error' => '0' ]);
        }

        if( $this->input->post('signupType') == 0 || $this->input->post('signupType') == 2 ) {

            $get_user_account_id = $this->session->userdata('login_data')['account_id'] ;
            $get_meterpoint_ids = $this->curl->junifer_request_usage('/rest/v1/accounts/'.$get_user_account_id.'/agreements');
            $get_meterpoint_ids_responce = json_decode($get_meterpoint_ids);

            if (!empty($get_meterpoint_ids_responce)) {
                for ($r = 0; $r < count($get_meterpoint_ids_responce->results); $r++) {


                    if ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Electricity Supply') {

                        if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {

                            $electric_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;

                        }
                    } elseif ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Gas Supply') {

                        if (isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)) {

                            $gas_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id;

                        }
                    }
                }
            }

            $parameter =  json_encode(array(
            "ignoreWarnings" => "false",
            "readingDt" => date('Y-m-d'),
            "sequenceType" => "Normal",
            "source" => "Customer",
            "quality" => "Normal",
            "registerReads" => array(array(
                  "reading" => $this->input->post('gas_submit_reds'),
                  "readingType"=> "Standard"
            ))
            ));

            if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' || $_SERVER['HTTP_HOST'] == '18.191.137.119'  )  //local
            {
                $curl_post_readings = curl_init();
                curl_setopt( $curl_post_readings, CURLOPT_POSTFIELDS,  $parameter);
                curl_setopt_array($curl_post_readings, array(
                    CURLOPT_PORT => "43002",

                    //junifer local
                    CURLOPT_URL => "http://134.213.125.150:43002/rest/v1/meterPoints/" . $gas_meter_point_id . "/readingsWithoutMtds",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_HTTPHEADER => array(
                        "Cache-Control: no-cache",
                        "Content-Type: application/json",
                        // local junifer
                        'X-Junifer-X-apikey: 83B1ilbo',
                        'X-Junifer-X-username: APIUser',
                    ),
                ));
            }

            if ($_SERVER['HTTP_HOST'] == '52.56.76.183') //production
            {
                $curl_post_readings = curl_init();
                curl_setopt($curl_post_readings, CURLOPT_POSTFIELDS, $parameter);
                curl_setopt_array($curl_post_readings, array(
                    CURLOPT_PORT => "43002",

                    //junifer production
                    CURLOPT_URL => "http://134.213.12.122:43002/rest/v1/meterPoints/" . $gas_meter_point_id . "/readingsWithoutMtds",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_HTTPHEADER => array(
                        "Cache-Control: no-cache",
                        "Content-Type: application/json",
                        // production junifer
                        'X-Junifer-X-apikey: dgiZaFDb',
                        'X-Junifer-X-username: api',
                    ),
                ));
            }

            $responsey = curl_exec($curl_post_readings);
            $err = curl_error($curl_post_readings);
            $responsey = json_decode($responsey);
            curl_close($curl_post_readings);

            $db_parameter = [
                'customer_id' => $this->session->userdata('login_data')['id'],
                'meter_reading' => $this->input->post('gas_submit_reds'),
                'fuel_type_id' => 1 // Gas
            ];


            if (isset($responsey->errorDescription)) {
                echo json_encode(['error' => '1', 'errorDescription' => $responsey->errorDescription]);
            } else {
                $gas_first_update = $this->user_modal->gas_first_update($this->session->userdata('login_data')['id']);
                $this->user_modal->log_meter_reading($db_parameter);
                echo json_encode(['error' => '0', 'updated' => $gas_first_update,]);
            }

        }

    }



  function usage(){
    if(  empty($this->session->userdata('login_data')) ){
      header('location:'.base_url().'index.php/user/login');
      exit;
    }


    $current_year = date('Y-m-d');
    $the_year = date('Y');
    $last_year = date('Y-m-d',strtotime(date("Y-m-d", time()) . " - 365 day"));

    $fromdate_weekly = date( 'Y-m-d', strtotime( 'monday this week' ) );
    $todate_weekly = date( 'Y-m-d', strtotime( 'sunday this week' ) );
  //  $fromdate_weekly = '2018-07-20';
   // $todate_weekly = '2018-07-31';
    $fromdate_monthly = date('Y-m-01');        //date('Y-m-01')
    $todate_monthly = date('Y-m-01', strtotime("+1 month"));
    $fromdate_yearly = '2017-01-01';
    $todate_yearly = '2018-01-01';
    $jan_start_date = $the_year.'-01-01';
    $feb_start_date = $the_year.'-02-01';
    $march_start_date = $the_year.'-03-01';
    $april_start_date = $the_year.'-04-01';
    $may_start_date = $the_year.'-05-01';
    $june_start_date = $the_year.'-06-01';
    $july_start_date = $the_year.'-07-01';
    $august_start_date = $the_year.'-08-01';
    $september_start_date = $the_year.'-09-01';
    $october_start_date = $the_year.'-10-01';
    $november_start_date = $the_year.'-11-01';
    $december_start_date = $the_year.'-12-01';
    $december_end_date = $the_year.'-12-31';

    $get_tarrif = $this->session->userdata('login_data')['tariff_tariffName'];

    $get_electric_tarrif_rate = 0 ;
    $get_standardcharge_tarrif_electric = 0 ;

    $get_gas_tarrif_rate = 0 ;
    $get_standardcharge_tarrif_gas = 0 ;

/*
    if ( $get_electric_tarrif === 'Simply Cred' )  {
      $get_electric_tarrif_rate = 0.1275000 ;
      $get_standardcharge_tarrif_electric = 0.1000000 ;

      $get_gas_tarrif_rate = 0.1275000 ;
      $get_standardcharge_tarrif_gas = 0.1000000 ;

    }
    elseif ( $get_electric_tarrif === 'Northern Glory' )  {
      $get_electric_tarrif_rate = 0.1220000 ;
      $get_standardcharge_tarrif_electric = 0.1000000 ;

      $get_gas_tarrif_rate = 0.0250000 ;
      $get_standardcharge_tarrif_gas = 0.1000000 ;
    }
    elseif ( $get_electric_tarrif === 'Fixed Smart Special' )  {
      $get_electric_tarrif_rate = 0.1115200 ;
      $get_standardcharge_tarrif_electric = 0.2100000 ;

      $get_gas_tarrif_rate = 0.0257000 ;
      $get_standardcharge_tarrif_gas = 0.2100000 ;
       }
    elseif ( $get_electric_tarrif === 'Fixed Smart' )  {
      $get_electric_tarrif_rate = 0.1115200 ;
      $get_standardcharge_tarrif_electric = 0.2100000 ;

      $get_gas_tarrif_rate = 0.0260000 ;
      $get_standardcharge_tarrif_gas = 0.2100000 ;
    }
    elseif ( $get_electric_tarrif === 'VariSmart' )  {
      $get_electric_tarrif_rate = 0.1230500 ;
      $get_standardcharge_tarrif_electric = 0.2000000 ;

      $get_gas_tarrif_rate = 0.0270000 ;
      $get_standardcharge_tarrif_gas = 0.2000000;
    }
    elseif ( $get_electric_tarrif === 'Goodbye standing charge' )  {
      $get_electric_tarrif_rate = 0.1471000 ;
      $get_standardcharge_tarrif_electric = 0.0000000 ;

      $get_gas_tarrif_rate = 0.0379050 ;
      $get_standardcharge_tarrif_gas = 0.2400000 ;
    }
    elseif ( $get_electric_tarrif === 'Our lowest Ever payg' )  {
      $get_electric_tarrif_rate = 0.1090000 ;
      $get_standardcharge_tarrif_electric = 0.2400000 ;

      $get_gas_tarrif_rate = 0.0361000;
      $get_standardcharge_tarrif_gas = 0.2400000 ;
    }
    elseif ( $get_electric_tarrif === 'Prepay Direct' )  {
      $get_electric_tarrif_rate = 0.1230000 ;
      $get_standardcharge_tarrif_electric = 0.2400000 ;

      $get_gas_tarrif_rate = 0.0361000 ;
      $get_standardcharge_tarrif_gas = 0.2400000 ;
    }
    elseif ( $get_electric_tarrif === 'Standard Variable' )  {
      $get_electric_tarrif_rate = 0.1050000 ;
      $get_standardcharge_tarrif_electric = 0.2750000 ;

      $get_gas_tarrif_rate =0.0181000 ;
      $get_standardcharge_tarrif_gas = 0.2750000 ;
    }
*/

$parameter_find_tarif = [ 'supplierName' => 'Eversmart Energy', 'tariffName' => $get_tarrif,  'fuelType' => 'elecgas', "datesToUse" => "regulatory-dates" ];
$eneryLinx_find_tarif = $this->curl->curl_request('/v3/partner-resources/EVERSMARTENERGYSUPP/tariffs-with-price-data/', $parameter_find_tarif , 'post');
$eneryLinx_find_tarif = $this->parseHttpResponse($eneryLinx_find_tarif);


 if(
 $eneryLinx_find_tarif['body']['statusCode'] == '1035' ){
    $get_standardcharge_tarrif_gas = $eneryLinx_find_tarif['body']['data']['tariffs'][0]['prices'][0]['standingChargeGas'];
    $get_standardcharge_tarrif_electric = $eneryLinx_find_tarif['body']['data']['tariffs'][0]['prices'][0]['standingChargeElec'];
    $get_gas_tarrif_rate= $eneryLinx_find_tarif['body']['data']['tariffs'][0]['prices'][0]['unitRate1Gas'];
    $get_electric_tarrif_rate = $eneryLinx_find_tarif['body']['data']['tariffs'][0]['prices'][0]['unitRate1Elec'];
}



 if( $this->session->userdata('login_data')['signup_type'] == '0' || $this->session->userdata('login_data')['signup_type'] == '2' )
{
/*
 print_r ($electric_meter_point_id);
 $user_meterpoint_id = 542;
 $get_user_account_id = 223;
 $get_meterpoint_ids = 32323
*/


  $get_user_account_id = $this->session->userdata('login_data')['account_id'] ;
  $get_meterpoint_ids = $this->curl->junifer_request_usage('/rest/v1/accounts/'.$get_user_account_id.'/agreements');
  $get_meterpoint_ids_responce = json_decode($get_meterpoint_ids);


  //print_r($get_meterpoint_ids_responce);


		if( !empty($get_meterpoint_ids_responce->results) ){
		for( $r = 0; $r<count( $get_meterpoint_ids_responce->results ) ; $r++ ){


      if ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Electricity Supply') {

      if(isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)){

        $electric_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id ;

      }
    }

      elseif ( $get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Gas Supply') {

        if(isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id)){

          $gas_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id ;

}
}
}}


    if (isset($electric_meter_point_id)) {

    $el_response = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$fromdate_weekly.'&toDt='.$todate_weekly.'');
    $el_response_monthly_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$fromdate_monthly.'&toDt='.$todate_monthly.'');
    $el_response_jan_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$jan_start_date.'&toDt='.$feb_start_date.'');
    $el_response_feb_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$feb_start_date.'&toDt='.$march_start_date.'');
    $el_response_march_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$march_start_date.'&toDt='. $april_start_date.'');
    $el_response_april_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$april_start_date.'&toDt='.$may_start_date.'');
    $el_response_may_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$may_start_date.'&toDt='.$june_start_date.'');
    $el_response_june_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$june_start_date.'&toDt='.$july_start_date.'');
    $el_response_july_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$july_start_date.'&toDt='.$august_start_date.'');
    $el_response_august_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$august_start_date.'&toDt='.$september_start_date.'');
    $el_response_september_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$september_start_date.'&toDt='.$october_start_date.'');
    $el_response_october_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$october_start_date.'&toDt='.$november_start_date.'');
    $el_response_november_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$november_start_date.'&toDt='.$december_start_date.'');
    $el_response_december_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$december_start_date.'&toDt='. $december_end_date.'');

    $el_response = json_decode($el_response,true);

    $el_response_jan_array = json_decode($el_response_jan_array);
    $el_response_feb_array = json_decode($el_response_feb_array);
    $el_response_march_array = json_decode($el_response_march_array);
    $el_response_april_array = json_decode($el_response_april_array);
    $el_response_may_array = json_decode($el_response_may_array);
    $el_response_june_array = json_decode($el_response_june_array);
    $el_response_july_array = json_decode($el_response_july_array);
    $el_response_august_array = json_decode($el_response_august_array);
    $el_response_september_array = json_decode($el_response_september_array);
    $el_response_october_array = json_decode($el_response_october_array);
    $el_response_november_array = json_decode($el_response_november_array);
    $el_response_december_array = json_decode($el_response_december_array);
    $el_response_monthly_array = json_decode($el_response_monthly_array);

    if(isset($el_response_monthly_array )) {
    $el_monthly_split = array_chunk($el_response_monthly_array->results,7, true);
    $data['el_monthly_split'] =  $el_monthly_split;
    }

    $data['el_results'] = $el_response['results'];


    $data['el_response_jan_array'] =  $el_response_jan_array;
    $data['el_response_feb_array'] =  $el_response_feb_array;
    $data['el_response_march_array'] =  $el_response_march_array;
    $data['el_response_april_array'] =  $el_response_april_array;
    $data['el_response_may_array'] =  $el_response_may_array;
    $data['el_response_june_array'] =  $el_response_june_array;
    $data['el_response_july_array'] =  $el_response_july_array;
    $data['el_response_august_array'] =  $el_response_august_array ;
    $data['el_response_september_array'] =  $el_response_september_array;
    $data['el_response_october_array'] =  $el_response_october_array;
    $data['el_response_november_array'] =  $el_response_november_array;
    $data['el_response_december_array'] =  $el_response_december_array;



  }

 //////// gas

 if (isset($gas_meter_point_id)) {
    $gas_response = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$fromdate_weekly.'&toDt='.$todate_weekly.'');
    $gas_response_monthly_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$fromdate_monthly.'&toDt='.$todate_monthly.'');
    $gas_response_jan_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$jan_start_date.'&toDt='.$feb_start_date.'');
    $gas_response_feb_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$feb_start_date.'&toDt='.$march_start_date.'');
    $gas_response_march_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$march_start_date.'&toDt='. $april_start_date.'');
    $gas_response_april_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$april_start_date.'&toDt='.$may_start_date.'');
    $gas_response_may_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$may_start_date.'&toDt='.$june_start_date.'');
    $gas_response_june_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$june_start_date.'&toDt='.$july_start_date.'');
    $gas_response_july_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$july_start_date.'&toDt='.$august_start_date.'');
    $gas_response_august_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$august_start_date.'&toDt='.$september_start_date.'');
    $gas_response_september_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$september_start_date.'&toDt='.$october_start_date.'');
    $gas_response_october_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$october_start_date.'&toDt='.$november_start_date.'');
    $gas_response_november_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$november_start_date.'&toDt='.$december_start_date.'');
    $gas_response_december_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$december_start_date.'&toDt='. $december_end_date.'');

    $gas_response = json_decode($gas_response,true);
    $gas_response_jan_array = json_decode($gas_response_jan_array);
    $gas_response_feb_array = json_decode($gas_response_feb_array);
    $gas_response_march_array = json_decode($gas_response_march_array);
    $gas_response_april_array = json_decode($gas_response_april_array);
    $gas_response_may_array = json_decode($gas_response_may_array);
    $gas_response_june_array = json_decode($gas_response_june_array);
    $gas_response_july_array = json_decode($gas_response_july_array);
    $gas_response_august_array = json_decode($gas_response_august_array);
    $gas_response_september_array = json_decode($gas_response_september_array);
    $gas_response_october_array = json_decode($gas_response_october_array);
    $gas_response_november_array = json_decode($gas_response_november_array);
    $gas_response_december_array = json_decode($gas_response_december_array);
    $gas_response_monthly_array = json_decode($gas_response_monthly_array);

    if (isset($gas_response_monthly_array)){
    $gas_monthly_split = array_chunk($gas_response_monthly_array->results,7, true);
    }

    $data['gas_results'] = $gas_response['results'];

    if (isset($gas_monthly_split )){
    $data['gas_monthly_split'] =  $gas_monthly_split;
    }
    $data['gas_response_jan_array'] =  $gas_response_jan_array;
    $data['gas_response_feb_array'] =  $gas_response_feb_array;
    $data['gas_response_march_array'] =  $gas_response_march_array;
    $data['gas_response_april_array'] =  $gas_response_april_array;
    $data['gas_response_may_array'] =  $gas_response_may_array;
    $data['gas_response_june_array'] =  $gas_response_june_array;
    $data['gas_response_july_array'] =  $gas_response_july_array;
    $data['gas_response_august_array'] =  $gas_response_august_array ;
    $data['gas_response_september_array'] =  $gas_response_september_array;
    $data['gas_response_october_array'] =  $gas_response_october_array;
    $data['gas_response_november_array'] =  $gas_response_november_array;
    $data['gas_response_december_array'] =  $gas_response_december_array;
}
//var_dump($gas_response['results']);

}

if( $this->session->userdata('login_data')['signup_type'] == '3' )
{


 $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );
 $users_mprn =  $login_response['gasProduct_mprns']; //  '1498085706' ;  //
 $users_mpan = $login_response['elec_mpan_core']; // '1610009348896' ;

//var_dump( $users_mpan);


if (isset( $users_mprn )) {
 $parameter_gas_daily = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $fromdate_weekly, 'EndDate' =>  $todate_weekly ];
 $parameter_gas_weekly = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $fromdate_monthly, 'EndDate' =>  $todate_monthly];
 $parameter_gas_monthly = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' =>  $fromdate_monthly, 'EndDate' => $todate_monthly];
 $parameter_gas_jan = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $jan_start_date, 'EndDate' => $feb_start_date];
 $parameter_gas_feb = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $feb_start_date, 'EndDate' => $march_start_date];
 $parameter_gas_march = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $march_start_date, 'EndDate' => $april_start_date];
 $parameter_gas_april = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $april_start_date, 'EndDate' =>  $may_start_date ];
 $parameter_gas_may = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' =>  $may_start_date, 'EndDate' =>  $june_start_date];
 $parameter_gas_june = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' =>  $june_start_date, 'EndDate' =>  $july_start_date];
 $parameter_gas_july = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $july_start_date, 'EndDate' => $august_start_date];
 $parameter_gas_august = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $august_start_date, 'EndDate' => $september_start_date];
 $parameter_gas_september = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $september_start_date, 'EndDate' =>  $october_start_date];
 $parameter_gas_october = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' =>  $october_start_date, 'EndDate' => $november_start_date];
 $parameter_gas_november = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $november_start_date, 'EndDate' => $december_start_date];
 $parameter_gas_december = [ 'AuthKey' => 'ed3e6b7a-ca3d-402b-b353-cc83ca121912', 'Mprn' => $users_mprn, 'StartDate' => $december_start_date, 'EndDate' =>  $december_end_date];



 $dyball_gas_readings = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_daily , 'post');
 $dyball_gas_readings = $this->parseHttpResponse($dyball_gas_readings);

 //var_dump($dyball_gas_readings );

if( $dyball_gas_readings['headers']['http_code'] == 'HTTP/1.1 200 OK' ){

  if (isset($dyball_gas_readings['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
  $data['gas_readings_daily'] = $dyball_gas_readings['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
  }
  else {
    $data['gas_readings_daily'] = [] ; }
}


$dyball_gas_readings_weekly = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_weekly , 'post');
$dyball_gas_readings_weekly = $this->parseHttpResponse($dyball_gas_readings_weekly);

if( $dyball_gas_readings_weekly['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_gas_readings_weekly['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_weekly'] = $dyball_gas_readings_weekly['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_weekly'] = [] ; }
}

 $dyball_gas_readings_monthly = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings',  $parameter_gas_monthly , 'post');
 $dyball_gas_readings_monthly = $this->parseHttpResponse($dyball_gas_readings_monthly);

 if(
 $dyball_gas_readings_monthly['headers']['http_code'] == 'HTTP/1.1 200 OK' ){

 if (isset($dyball_gas_readings_monthly['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $dyball_gas_readings_monthly = $dyball_gas_readings_monthly['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
 $dyball_gas_readings_monthly = array_chunk($dyball_gas_readings_monthly,7, true);
 $data['gas_readings_monthly'] = $dyball_gas_readings_monthly;
}
else {
  $data['gas_readings_monthly'] = [] ; }
}

 $dyball_gas_readings_jan = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_jan , 'post');
 $dyball_gas_readings_jan = $this->parseHttpResponse($dyball_gas_readings_jan);

 if(
 $dyball_gas_readings_jan['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_gas_readings_jan['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_jan'] = $dyball_gas_readings_jan['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_jan']  = [] ; }
}

 $dyball_gas_readings_feb = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings',  $parameter_gas_feb  , 'post');
 $dyball_gas_readings_feb = $this->parseHttpResponse($dyball_gas_readings_feb);

if(
 $dyball_gas_readings_feb['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_gas_readings_feb['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_feb'] = $dyball_gas_readings_feb['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_feb']  = [] ; }
}


 $dyball_gas_readings_march = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_march , 'post');
 $dyball_gas_readings_march = $this->parseHttpResponse($dyball_gas_readings_march);

if(
 $dyball_gas_readings_march['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_gas_readings_feb['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_march'] = $dyball_gas_readings_march['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_march']  = [] ; }
}

 $dyball_gas_readings_april = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings',  $parameter_gas_april , 'post');
 $dyball_gas_readings_april = $this->parseHttpResponse($dyball_gas_readings_april);

 if(
 $dyball_gas_readings_april['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_gas_readings_april['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_april'] = $dyball_gas_readings_april['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_april']  = [] ; }
}

 $dyball_gas_readings_may = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_may , 'post');
 $dyball_gas_readings_may = $this->parseHttpResponse($dyball_gas_readings_may);

 if(
 $dyball_gas_readings_may['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_may['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_may'] = $dyball_gas_readings_may['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_may']  = [] ; }
}

 $dyball_gas_readings_june = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings',  $parameter_gas_june , 'post');
 $dyball_gas_readings_june = $this->parseHttpResponse($dyball_gas_readings_june);

 if(
 $dyball_gas_readings_june['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_june['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_june'] = $dyball_gas_readings_june['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_june']  = [] ; }
}


 $dyball_gas_readings_july = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_july, 'post');
 $dyball_gas_readings_july = $this->parseHttpResponse($dyball_gas_readings_july);

 if(
 $dyball_gas_readings_july['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_july['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_july'] = $dyball_gas_readings_july['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_july']  = [] ; }
}

 $dyball_gas_readings_august = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_august , 'post');
 $dyball_gas_readings_august = $this->parseHttpResponse($dyball_gas_readings_august);

 if(
 $dyball_gas_readings_august['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_august['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_august'] = $dyball_gas_readings_august['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_august']  = [] ; }
}


 $dyball_gas_readings_septemeber = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_september , 'post');
 $dyball_gas_readings_septemeber = $this->parseHttpResponse($dyball_gas_readings_septemeber);

 if(
 $dyball_gas_readings_septemeber['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_septemeber['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_septemeber'] = $dyball_gas_readings_septemeber['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_septemeber']  = [] ; }
}


 $dyball_gas_readings_october = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_october , 'post');
 $dyball_gas_readings_october = $this->parseHttpResponse($dyball_gas_readings_october);

 if(
 $dyball_gas_readings_october['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_october['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_october'] = $dyball_gas_readings_october['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_october']  = [] ; }
}


 $dyball_gas_readings_november = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_november , 'post');
 $dyball_gas_readings_november = $this->parseHttpResponse($dyball_gas_readings_november);

 if(
 $dyball_gas_readings_november['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_november['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_november'] = $dyball_gas_readings_november['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_november']  = [] ; }
}

 $dyball_gas_readings_december = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/gasmanager/getreadings', $parameter_gas_december , 'post');
 $dyball_gas_readings_december = $this->parseHttpResponse($dyball_gas_readings_december);

 if(
 $dyball_gas_readings_december['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_gas_readings_december['body']['Mprns'][0]['MprnMeters'][0]['Readings'])) {
 $data['gas_readings_december'] = $dyball_gas_readings_december['body']['Mprns'][0]['MprnMeters'][0]['Readings'];
}
else {
  $data['gas_readings_december']  = [] ; }
}

}


if (isset($users_mpan)){
 $parameter_electric_daily = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $fromdate_weekly, 'EndDate' =>  $todate_weekly ];
 $parameter_electric_weekly = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $fromdate_monthly, 'EndDate' =>  $todate_monthly];
 $parameter_electric_monthly = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' =>  $fromdate_monthly, 'EndDate' => $todate_monthly];
 $parameter_electric_jan = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $jan_start_date, 'EndDate' => $feb_start_date];
 $parameter_electric_feb = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $feb_start_date, 'EndDate' => $march_start_date];
 $parameter_electric_march = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan,  'StartDate' => $march_start_date, 'EndDate' => $april_start_date];
 $parameter_electric_april = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $april_start_date, 'EndDate' =>  $may_start_date ];
 $parameter_electric_may = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' =>  $may_start_date, 'EndDate' =>  $june_start_date];
 $parameter_electric_june = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' =>  $june_start_date, 'EndDate' =>  $july_start_date];
 $parameter_electric_july = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $july_start_date, 'EndDate' => $august_start_date];
 $parameter_electric_august = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan,  'StartDate' => $august_start_date, 'EndDate' => $september_start_date];
 $parameter_electric_september = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $september_start_date, 'EndDate' =>  $october_start_date];
 $parameter_electric_october = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $september_start_date, 'EndDate' =>  $october_start_date];
 $parameter_electric_november = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan,  'StartDate' => $november_start_date, 'EndDate' => $december_start_date];
 $parameter_electric_december = [ 'AuthKey' => 'b450e45e-63b9-4c68-b1d7-7b5794115314', 'MPAN' => $users_mpan, 'StartDate' => $december_start_date, 'EndDate' =>  $december_end_date];


 $dyball_electric_readings = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_daily , 'post');
 $dyball_electric_readings = $this->parseHttpResponse($dyball_electric_readings);

 if(
 $dyball_electric_readings['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_daily'] = $dyball_electric_readings['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
  }
 else {
  $data['electric_readings_daily']  = [] ; }
}


 $dyball_electric_readings_weekly = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_weekly , 'post');
 $dyball_electric_readings_weekly = $this->parseHttpResponse($dyball_electric_readings_weekly);

 if(
 $dyball_electric_readings_weekly['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_weekly['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_weekly'] = $dyball_electric_readings_weekly['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_weekly']  = [] ; }
}

$dyball_electric_readings_monthly = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_monthly, 'post');
$dyball_electric_readings_monthly = $this->parseHttpResponse($dyball_electric_readings_monthly);

if(
 $dyball_electric_readings_monthly['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_monthly['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $dyball_electric_readings_monthly = $dyball_electric_readings_monthly['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
 $dyball_electric_readings_monthly = array_chunk($dyball_electric_readings_monthly,7, true);
 $data['electric_readings_monthly'] = $dyball_electric_readings_monthly;
}
else {
 $data['electric_readings_monthly']  = [] ; }
}


 $dyball_electric_readings_jan = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_jan , 'post');
 $dyball_electric_readings_jan = $this->parseHttpResponse($dyball_electric_readings_jan);

if(
 $dyball_electric_readings_jan['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_jan['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_jan'] = $dyball_electric_readings_jan['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_jan']  = [] ; }
}

 $dyball_electric_readings_feb = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_feb , 'post');
 $dyball_electric_readings_feb = $this->parseHttpResponse($dyball_electric_readings_feb);

 if(
 $dyball_electric_readings_feb['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_electric_readings_feb['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_feb'] = $dyball_electric_readings_feb['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_feb']  = [] ; }
}

 $dyball_electric_readings_march = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_march , 'post');
 $dyball_electric_readings_march = $this->parseHttpResponse($dyball_electric_readings_march);

if(
 $dyball_electric_readings_march['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_march['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_march'] = $dyball_electric_readings_march['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_march']  = [] ; }
}

 $dyball_electric_readings_april = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_april , 'post');
 $dyball_electric_readings_april = $this->parseHttpResponse($dyball_electric_readings_april);

if(
 $dyball_electric_readings_april['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_april['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_april'] = $dyball_electric_readings_april['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_april']  = [] ; }
}

 $dyball_electric_readings_may = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_may , 'post');
 $dyball_electric_readings_may = $this->parseHttpResponse($dyball_electric_readings_may);


if(
 $dyball_electric_readings_may['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_may['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_may'] = $dyball_electric_readings_may['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_may']  = [] ; }
}

 $dyball_electric_readings_june = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_june , 'post');
 $dyball_electric_readings_june = $this->parseHttpResponse($dyball_electric_readings_june);

 if(
 $dyball_electric_readings_june['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_june['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_june'] = $dyball_electric_readings_june['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_june']  = [] ; }
}

 $dyball_electric_readings_july = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_july , 'post');
 $dyball_electric_readings_july = $this->parseHttpResponse($dyball_electric_readings_july);

 if(
 $dyball_electric_readings_july['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_electric_readings_july['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_july'] = $dyball_electric_readings_july['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_july']  = [] ; }
}

 $dyball_electric_readings_august = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_august  , 'post');
 $dyball_electric_readings_august = $this->parseHttpResponse($dyball_electric_readings_august);

 if(
 $dyball_electric_readings_august['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_august['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_august'] = $dyball_electric_readings_august['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_august']  = [] ; }
}

 $dyball_electric_readings_septemeber = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_september , 'post');
 $dyball_electric_readings_septemeber = $this->parseHttpResponse($dyball_electric_readings_septemeber);

 if(
 $dyball_electric_readings_septemeber['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_septemeber['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_septemeber'] = $dyball_electric_readings_septemeber['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_septemeber']  = [] ; }
}

 $dyball_electric_readings_october = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_october , 'post');
 $dyball_electric_readings_october = $this->parseHttpResponse($dyball_electric_readings_october);

if(
 $dyball_electric_readings_october['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset($dyball_electric_readings_october['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_october'] = $dyball_electric_readings_october['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_october']  = [] ; }
}

 $dyball_electric_readings_november = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_november, 'post');
 $dyball_electric_readings_november = $this->parseHttpResponse($dyball_electric_readings_november);

 if(
 $dyball_electric_readings_november['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_november['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_november'] = $dyball_electric_readings_november['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_november']  = [] ; }
}

 $dyball_electric_readings_december = $this->curl->curlPost('https://engq.dyballapi.co.uk/api/RegManager/GetReadings', $parameter_electric_december , 'post');
 $dyball_electric_readings_december = $this->parseHttpResponse($dyball_electric_readings_december);

if(
 $dyball_electric_readings_december['headers']['http_code'] == 'HTTP/1.1 200 OK' ){
  if (isset( $dyball_electric_readings_december['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'])) {
 $data['electric_readings_december'] = $dyball_electric_readings_december['body']['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
}
else {
 $data['electric_readings_december']  = [] ; }
}
}

}


    header('content-type: text/html');

    $data['get_electric_tarrif_rate']  = $get_electric_tarrif_rate ;
    $data['get_standardcharge_tarrif_electric']  = $get_standardcharge_tarrif_electric ;

    $data['get_gas_tarrif_rate']  =  $get_gas_tarrif_rate  ;
    $data['get_standardcharge_tarrif_gas']  = $get_standardcharge_tarrif_gas ;

    $data['session_data'] = $this->session->userdata('login_data');
    //$data['last_reading'] = end($response['results']);
    $data['content'] = 'dashboard/energy_usage';
    $this->load->view('layout/dashboard_master',$data);
  }

  function billing(){
    if(  empty($this->session->userdata('login_data')) ){
      header('location:'.base_url().'index.php/user/login');
      exit;
    }

    $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );

    if( $login_response['signup_type'] == 0 || $login_response['signup_type'] == 2 ){

      $get_user_account_id = $this->session->userdata('login_data')['account_id'] ;

    $response = $this->curl->junifer_request_usage('/rest/v1/accounts/'.$get_user_account_id.'/bills');
    //$image_download = $this->curl->junifer_request_test('/rest/v1/billFiles/7428');
    //$image_download = json_decode($image_download,true);

    //debug($image_download,1);
    if( !empty($image_download) ){
      $data['image_download'] = $image_download['links']['self'];
    }

    $response = json_decode($response,true);

   // print_r($response['results']);
  }

    header('content-type: text/html');
    if( !empty($response) ){
      if(isset($response['results'])) {
      $data['results'] = $response['results'];
      }
      else {
        $data['results'] = [];
      }
    }
    //debug($data,1);
    $data['content'] = 'dashboard/billing';
    $data['title'] = 'Billing';
    $this->load->view('layout/dashboard_master',$data);
  }

  function payments(){
    //debug($this->session->userdata('login_data'),1 );
    // for live
    //$get_payment_junifer = $this->curl->junifer_request_test('/rest/v1/accounts/'.$this->session->userdata('login_data')['customers'].'/paymentscheduleperiods');

    if(  empty($this->session->userdata('login_data')) ){
      header('location:'.base_url().'index.php/user/login');
      exit;
    }

    $data['payment_date'] = 0 ;
    $data['payment_amount'] = 0 ;
    $data['balance'] = 0;

    if( $this->session->userdata('login_data')['signup_type'] == '0' || $this->session->userdata('login_data')['signup_type'] == '2' ){


      $get_user_account_id = $this->session->userdata('login_data')['account_id'] ;



      $get_payment_junifer = $this->curl->junifer_request('/rest/v1/accounts/'.$get_user_account_id.'/paymentSchedulePeriods/');
      $get_payment_junifer =  $this->parseHttpResponse($get_payment_junifer);

     if(  $get_payment_junifer['headers']['http_code'] == 'HTTP/1.1 200 OK') {

      $data['payment_junifer'] = $get_payment_junifer['body']['results'];

      if (isset($get_payment_junifer['body']['results'][0]['nextPaymentDt']) ) {

      $payment_date = $get_payment_junifer['body']['results'][0]['nextPaymentDt'];
      $payment_amount = $get_payment_junifer['body']['results'][0]['amount'];
      $data['payment_amount'] =  $payment_amount ;

      $payment_date = date("d", strtotime($payment_date));
      $nf = new NumberFormatter('en_US', NumberFormatter::ORDINAL);
      $payment_date = $nf->format($payment_date);
      $data['payment_date'] =  $payment_date ;
      }
 }

      $get_balance_junifer = $this->curl->junifer_request('/rest/v1/accounts/'.$get_user_account_id.'');
      $get_balance_junifer = $this->parseHttpResponse($get_balance_junifer);



      if(  $get_balance_junifer['headers']['http_code'] == 'HTTP/1.1 200 OK') {
      $data['balance'] = $get_balance_junifer['body']['balance'] ;

     }

}


    $AccruedInterestData = $this->calculate_total_customer_interest($this->session->userdata('login_data')['id']);
    $data['accrued_interest_data'] = $this->get_customer_interest_data($this->session->userdata('login_data')['id']);
    $data['accrued_interest'] = $AccruedInterestData['accrued_interest'];
    $data['signup_date'] = $AccruedInterestData['signup_date'];

    if( $this->session->userdata('login_data')['signup_type'] == '3' ){
    //for test
      $parameter = [ 'AuthKey' => $this->authkey, 'AccountNumber' => '12434' ];
      $get_payment_junifer = $this->curl->junifer_request_test('/customerselfservice/getcustomerbalance', $parameter, 'post');
      $get_payment_junifer = json_decode($get_payment_junifer,true);
      $data['title'] = 'Payments';
      $data['payment_junifer'] = $get_payment_junifer;
    }
    header('content-type: text/html');
    //debug($data,1);
    $data['content'] = 'dashboard/payments';
    $this->load->view('layout/dashboard_master',$data);
  }

  function moving_home(){
    if(  empty($this->session->userdata('login_data')) ){
      header('location:'.base_url().'index.php/user/login');
      exit;
    }
    $data['content'] = 'dashboard/moving_home';
    $data['title'] = 'Moving Home';
    $this->load->view('layout/dashboard_master',$data);
  }

  function save_moving_home()
  {
    $session_data = $this->session->userdata('login_data');

    $mov_date = $this->input->get('date');
    $mov_elec_read = $this->input->get('elec_submit_reds');
    $mov_gas_read = $this->input->get('gas_submit_reds');
    $mov_address = $this->input->get('new_address');

    $conf = $mov_date . ', ' . $mov_elec_read . ', ' . $mov_gas_read . ', ' . $mov_address;

    //send mail

    if(!empty($mov_date) && !empty($mov_elec_read) && !empty($mov_gas_read) && !empty($mov_address))
    {
      $token = md5(uniqid(rand(0,9999), true));
      $email_data['email_info'] = [ 'token' => $token, 'name' => $session_data['first_name']. ' ' . $session_data['last_name'] ];

      $template = $this->load->view( 'layout/email_template', $email_data , true);

      $this->load->library('email');
      $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
      $this->email->to($session_data['email']);
      $this->email->subject('Moving Home Confirmation');
      $this->email->message($template);
      $this->email->send();

      echo json_encode([ 'success' => 'success', 'msg' => 'Moving Home request successful' ]);
    }
    else
    {
      echo json_encode([ 'success' => 'fail', 'msg' => 'Email failed to send' ]);
    }
  }

  function test_junifer()
  {
    $var = [
  "ignoreWarnings" => false,
  "readingDt" => "2018-06-10",
  "sequenceType" => "Normal",
  "source" => "Customer",
  "quality" => "Normal",
  "registerReads" => [
     [
        "reading"=> 12345,
        "readingType"=> "Day"
    ]
  ]
];
echo json_encode($var);
    //$get_account_id = $this->curl->junifer_request('/rest/v1/accounts/515/agreements');
     $get_account_id = $this->curl->junifer_request('/rest/v1/meterPoints/520/readingsWithoutMtds', json_encode($var), 'post');
     $response = $this->parseHttpResponse($get_account_id);
     debug($response,1);
  }

   function change_password()
  {
    //echo "current date time ".date('Y-m-d H:i:s') ;
    $token = $this->input->get('t');
    if( empty($token) ) {
    $data = [ 'error' => '1', 'msg' => 'Token required for reset password' ];
    }else{
      //check token in database
      $check_token = $this->user_modal->check_token($token);
      //check for token type
      if( $check_token['token_type'] == '1' ){
          //check for token expiry
          $curret_date = date( 'Y-m-d H:i:s' );
          $token_date = $check_token['expire_date'];

          //Convert them to timestamps.
          $date1Timestamp = strtotime($token_date);
          $date2Timestamp = strtotime($curret_date);

          //Calculate the difference.
          $difference = $date2Timestamp - $date1Timestamp;

          //echo '<br>'.$difference;
          if( $difference > 0 )
          {
              $data = [ 'error' => '1', 'msg' => 'Token expire' ];
          }
          else{
            $data = [ 'error' => '0', 'msg' => '', 'user_id' => $check_token['customer_id'] ];
          }
      }
      else {
          $data = [ 'error' => '1', 'msg' => 'Token expire' ];
      }
    }
    //debug($data,1);
    $this->load->view('user/reset-two',$data);
  }

  function reset_confirmation()
  {
    $this->load->view('user/reset-confirmation');
  }

  function customer_reset_password(){
    //debug( $this->input->post() );
    $info = $this->input->post();
    $change_password = $this->user_modal->customer_change_password( $info );
    if( $change_password ){
      echo json_encode( [ 'error' => '0', 'msg' => 'Password change successfull' ] );
    }else{
      echo json_encode( [ 'error' => '1', 'msg' => 'Server error while changing password' ] );
    }
  }

  function test_request()
  {
    echo "<pre>";
    print_r(array(
                'Api-Type: Website',
                'Client-IP: 13.58.101.121',
                'Transfer-Encoding:chunked',
                'Content-Type:application/json',
                'Accept: application/json',
                'Client-UA:'.$_SERVER['HTTP_USER_AGENT']));
              //  exit;

      $curl = curl_init();
     // $data_json = json_encode($data);
      curl_setopt($curl,CURLOPT_RETURNTRANSFER, 1);
      //curl_setopt($curl,CURLOPT_URL, 'http://134.213.125.150:43002/rest/v1/accounts?email=mrjaskiratsingh@gmail.com');
      curl_setopt($curl,CURLOPT_URL, 'http://134.213.125.150:43002/rest/v1/accounts/110/paymentPlans');
      //curl_setopt($curl,CURLOPT_URL, 'http://134.213.125.150:43002/rest/v1/ecoes/mpans?mpanCore=1200021746070');
      curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                  'Api-Type: Website',
                  'Client-IP: 13.58.101.121',
                  // 'Transfer-Encoding:chunked',
                  'Content-Type:application/json',
                  'Accept: application/json',
                  // 'Client-UA:'.$_SERVER['HTTP_USER_AGENT']
                ));

      //curl_setopt($curl, CURLOPT_HEADER, 1);
      curl_setopt($curl, CURLOPT_HEADER, 1);
    $result = curl_exec($curl);
    $loginResponse = $this->parseHttpResponse($result);
    debug($loginResponse,1);
  }

  function dyball_gas_submit_reading()
  {
      $reading = $this->input->post('gas_meter_submit0').$this->input->post('gas_meter_submit1').$this->input->post('gas_meter_submit2').$this->input->post('gas_meter_submit3').$this->input->post('gas_meter_submit4').$this->input->post('gas_meter_submit5');
      if( $this->input->post('signupType') == 3 )
      {
          $parameter = [
            'AuthKey' => $this->authkey,
            'AccountNumber' => $this->session->userdata('login_data')['accounts'],
            'MeterSerialNumber' => date('Y-m-dTH:i:s'),
            'MPRN' => 'Normal',
            'ReadingDate' => date('Y-m-dTH:i:s'),
            'Reading1' => $reading
          ];
          $response = $this->curl->junifer_request_test('/api/CustomerSelfService/SubmitGasReading', $parameter, 'post');
          $response = json_decode($response,true);
          //debug($response);
          if(!empty($response['success'])){
            echo json_encode([ 'error' => '0', 'msg' => $response['success']]);
          }else{
            echo json_encode([ 'error' => '1', 'msg' => 'Error! while submitting reading']);
          }
      }
  }

  function countdown()
  {
    $this->load->view('energy/countdown');
  }

  function move_home_1()
  {
    $this->load->view('dashboard/moving_home_1');
  }

  function move_home_2()
  {
    $this->load->view('dashboard/moving_home_2');
  }

  function move_home_3()
  {
    $this->load->view('dashboard/moving_home_3');
  }

  function move_home_steps()
  {
    if(  empty($this->session->userdata('login_data')) )
    {
      header('location:'.base_url().'index.php/user/login');
      exit;
    }
    if( $this->session->userdata('login_data')['signup_type'] == 0 || $this->session->userdata('login_data')['signup_type'] == 2 )
    {
      if( $this->session->has_userdata('login_data') )
      {
        $fromdate_monthly = date('Y-m-01');
        $todate_monthly = date('Y-m-01', strtotime("+1 month"));
        $get_user_account_id = $this->session->userdata('login_data')['account_id'] ;
        $get_meterpoint_ids = $this->curl->junifer_request_usage('/rest/v1/accounts/'.$get_user_account_id.'/agreements');
        $get_meterpoint_ids_responce = json_decode($get_meterpoint_ids);

        if( !empty( $get_meterpoint_ids_responce->results ) )
        {
          for( $r = 0; $r<count( $get_meterpoint_ids_responce->results ) ; $r++ )
          {
            if ($get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Electricity Supply')
            {
              if(isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id))
              {
                $electric_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id ;
              }
            }
            elseif ( $get_meterpoint_ids_responce->results[$r]->products[0]->type == 'Gas Supply')
            {
              if(isset($get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id))
              {
                $gas_meter_point_id = $get_meterpoint_ids_responce->results[$r]->products[0]->assets[0]->id ;
              }
            }
          }
        }

        if (isset($electric_meter_point_id))
        {
            $el_response_monthly_array = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$electric_meter_point_id.'/readings?fromDt='.$fromdate_monthly.'&toDt='.$todate_monthly.'');
            $response = json_decode($el_response_monthly_array,true);
            $data['results'] = $response['results'];
            $data['last_reading'] = end($response['results']);
        }

        if (isset($gas_meter_point_id))
        {
            $gas_response  = $this->curl->junifer_request_usage('/rest/v1/meterPoints/'.$gas_meter_point_id.'/readings?fromDt='.$fromdate_monthly.'&toDt='.$todate_monthly.'');
            $gas_response = json_decode($gas_response,true);
            $data['gas_reading'] = $gas_response['results'];
            $data['last_reading_gas'] = end($gas_response['results']);
        }

        header('content-type: text/html');
        $data['session_data'] = $this->session->userdata('login_data');

        $data['content'] = 'dashboard/meter_reading';
      }
    }
    if( $this->session->userdata('login_data')['signup_type'] == 3 )
    {
      $result_response = array();
      $gas_results = array();
      if( !empty($this->session->userdata('login_data')['mpancore']) )
      {
        $parameter = [ "AuthKey" => $this->authkey_dyball_serve, "AccountNumber" => "DYB_ELEC_".$this->session->userdata('login_data')['id'] ];
        $response = $this->curl->curl_dyball('/api/customerselfservice/GetElectricityReadings', $parameter, 'post');
        $response = json_decode($response,true);
        $result = $response['Mpans'][0]['MpanMeters'][0]['MpanMeterRegisters'][0]['Readings'];
        for( $i=0; $i<count($result); $i++ )
        {
          $result_response[$i]['readingDttm'] = $result[$i]['ReadDate'];
          $result_response[$i]['consumption'] = $result[$i]['Reading'];
        }
      }
      else
      {
        $result_response = '';
      }
      if( !empty($this->session->userdata('login_data')['user_mprn']) )
      {
        $parameter_gas = [ "AuthKey" => "EVERSMARTENERGYSUPP", "AccountNumber" => "EVDYB".$this->session->userdata('login_data')['account_id'] ];
        $response_gas = $this->curl->junifer_request_test('/api/CustomerSelfService/GetGasReadings', $parameter_gas, 'post');
        $response_gas = json_decode($response_gas,true);
        $result_gas = $response_gas['Mprns'][0]['MprnMeters'][0]['Readings'];
        for( $i=0; $i<count($result_gas); $i++ )
        {
          $gas_results[$i]['readingDttm'] = $result_gas[$i]['ReadDate'];
          $gas_results[$i]['consumption'] = $result_gas[$i]['Reading'];
        }
        if (isset($response_gas['Mprns'][0]['MprnMeters'][0]['Readings'])) {
          $data['last_gas_reading'] = end($response_gas['Mprns'][0]['MprnMeters'][0]['Readings']);
          }
          else
          {
            $data['last_gas_reading'] = [];
          }
      }
      else
      {
        $gas_results = '';
      }

      header('content-type: text/html');
      $data['results'] = $result_response;
      $data['gas_reading'] = $gas_results;
      $data['session_data'] = $this->session->userdata('login_data');

      $data['content'] = 'dashboard/moving_home_steps';
    }

    $this->load->view('dashboard/moving_home_steps', $data);
  }

  function check_email()
  {
      $email_check = $this->user_modal->email_check($this->input->get('email'));
      if( $email_check['id'] ){
        echo  json_encode([ 'error' => '1', 'msg'=>'email already exits' ]);
      }else{
        echo  json_encode([ 'error' => '0', 'msg'=>'email valid' ]);
      }
  }

    function check_mail_db()
    {
        $email_check = $this->user_modal->email_check($this->input->get('user_email'));
        if( $email_check['id'] ){
            //generate token
            $token = md5(uniqid(rand(0,9999), true));
            $email_data['email_info'] = [ 'token' => $token, 'name' => ucfirst($email_check['forename']) ];

            $template = $this->load->view( 'layout/reset_template', $email_data , true);

            //$this->load->library('email');
            //$this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
            //$this->email->to($email_check['email']);
            //$this->email->subject('Password Reset');
            //$this->email->message($template);
            //$this->email->send();

            $this->reset_password($email_check['id'], $token, $email_check['forename'], $email_check['email']);

            $token_in_database = $this->user_modal->token_in_database($token,$email_check['id'],'1');
            echo  json_encode([ 'error' => '0', 'msg'=>'Mail send' ]);
        }else{
            echo  json_encode([ 'error' => '1', 'msg'=>'email is not recognised by our system' ]);
        }
    }

  function changeformat(){

    //debug($this->input->post());
    $post_value = $this->input->post();

    foreach( $post_value as $key => $value ){
      echo '<input type="text" name="'.$key.'" value="'.$value.'" >';
    }

  }

  function signup_success()
  {

if(isset( $_SESSION['customer_id'])) {
    $data['fname'] = $_SESSION['fname'];
    $data['lname'] =  $_SESSION['lname'];
    $data['first_account'] =  $_SESSION['customer_id'];
    $this->load->view('layout/confirmation_signup', $data);
}
else {
  $this->load->view('layout/confirmation_signup');
}
  }


  function account(){

    if(  empty($this->session->userdata('login_data')) ){
      header('location:'.base_url().'index.php/user/login');
      exit;
    }

    //debug( $this->session->userdata('login_data'),1 );
    $data['user_info'] = $this->user_modal->get_account_detail($this->session->userdata('login_data')['id']);
    $data['content'] = 'dashboard/account';
    $this->load->view('layout/dashboard_master',$data);

  }

  function update_account(){

    $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );

    if(!empty($_POST))
    {
    //parse_str($_POST['data'], $searcharray);

    $phone = $_POST['phonenum'];
    //$password = $searcharray['password'];

    $data = [
      //'password' => base64_encode($password),
      'phone1' => $phone,
    ];

    $customer_id = $this->session->userdata('login_data')['id'];

    //$data = json_encode($data);

    $update_customer_info = $this->user_modal->update_customer_info($data,$customer_id);

    if($login_response['signup_type'] == 0 || $login_response['signup_type'] == 2)
    {

          // $parameter['forename'] = $this->input->post('first_name');
      //$parameter['surname'] = $this->input->post('last_name');
      $parameter['phoneNumber1'] = $phone;
      $update_account = $this->curl->junifer_request( '/rest/v1/customers/'.$login_response['account_id'].'/primaryContact', $parameter, 'put' );
      $header_response = $this->parseHttpResponse($update_account);

   if($header_response ['headers']['http_code'] == 'HTTP/1.1 204 No Content' )
   {
   echo  json_encode([ 'success' => 'true']);

  }
  else {
   echo  json_encode([ 'success' => 'false']);
  }
 }
else {
      echo  json_encode([ 'success' => 'false']);
  }

  }


  }


  function get_first_meter_reading_from_log($customer_id, $fuel_type_id){

      return $this->mysql->select('*')
          ->from('meter_reading_log')
          ->where('customer_id' , $customer_id)
          ->where('fuel_type_id' , $fuel_type_id)
          ->order_by('created_at','asc')
          ->limit(1)
      ->get()->first_row('array');
  }


    function account_status() {

        $login_response = $this->user_modal->get_account_detail($this->session->userdata('login_data')['id']);

        $account_id = $login_response['id'] ;
        $name = $login_response['forename'] ;
        $lastname = $login_response['surname'] ;
        $email = $login_response['email'] ;
        //print_r($account_id);

        /*---CREATE--- creates new user */
        $random = rand(0,99);
        $random = ($random <=9 ? "0" . $random : $random);
        
        $para =  [
            "id" => $account_id,
            "accountId" => $account_id,
            "firstName" => $name,
            "lastName" => $lastname,
            "email" => $email,
            "referable" => "true",
            "referralCode" => $name . $lastname . $random,    // forename . surname . random number between 00 and 99  
            "locale" => "en_UK"
        ];

        $creating_user = $this->curl->curlSaas('open/account/'.$account_id.'/user/'.$account_id.'', $para, 'post');
        $creating_user = json_decode($creating_user);
        //print_r($creating_user);


        /*---SEARCH--- search user via user and acccountId. displays share link info */

        $para =  [
            "id" => $account_id,
            "accountId" => $account_id
        ];

        $search_user = $this->curl->curlSaas('user', $para, 'post');
        $search_user = json_decode($search_user);
        //print_r($search_user);

        // Find out if we already have share link or we need to generate one
        $ESEShareLink = $this->get_ese_share_link($this->session->userdata('login_data')['id']);

        if($ESEShareLink['ese_generated_link']!=''){
            $esesharelink = $ESEShareLink['ese_generated_link'];
        }
        else {

            $esesharelink = 'http://eversmart.family/'.$name . $lastname . $random;

            $db_parameter = [
                'customer_id' => $this->session->userdata('login_data')['id'],
                'ese_generated_link' => $esesharelink,
                'saas_generated_link' => $search_user->shareLinks->shareLink
            ];

            $this->insert_ese_share_link($db_parameter);
        }

        $sharelink = $search_user->shareLinks->shareLink;
        $sharelink_fbook = $search_user->shareLinks->facebookShareLink;
        $sharelink_twitt = $search_user->shareLinks->twitterShareLink;
        $sharelink_email = $search_user->shareLinks->emailShareLink;
        $sharelink_mob = $search_user->shareLinks->mobileShareLink;
        $sharelink_fbook_mob = $search_user->shareLinks->mobileFacebookShareLink;
        $sharelink_twitt_mob = $search_user->shareLinks->mobileTwitterShareLink;
        $sharelink_email_mob = $search_user->shareLinks->mobileEmailShareLink;

        /*
        print_r($sharelink); echo '<br/>';
        print_r($sharelink_fbook); echo '<br/>';
        print_r($sharelink_twitt); echo '<br/>';
        print_r($sharelink_email); echo '<br/>';
        print_r($sharelink_mob); echo '<br/>';
        print_r($sharelink_fbook_mob); echo '<br/>';
        print_r($sharelink_twitt_mob); echo '<br/>';
        print_r($sharelink_email_mob); echo '<br/>';
        */


        /*----LIST REWARDS--- displays users current rewards using accountId */

        $list_reward = $this->curl->curlSaas('reward/balance?accountId='.$account_id.'');
        $list_reward = json_decode($list_reward);

        if($list_reward == null)
        {
            $format_bal = 0;
            $format_redeem_bal = 0;
        }
        else
        {
            $assigned_bal = $list_reward[0]->totalAssignedCredit;
            $redeemed_bal = $list_reward[0]->totalRedeemedCredit;
            $current_bal = $assigned_bal - $redeemed_bal;
            $format_bal = $current_bal / 100;
            //print_r($format_bal);
            $format_redeem_bal = $redeemed_bal / 100;
        }

        /*----NUM OF REFERRALS------ displays how many users a person has referred */

        $referrals = $this->curl->curlSaas('account/'.$account_id.'/user/'.$account_id.'/pii');
        $referrals = json_decode($referrals);

        $ref = $referrals->referrals->totalCount;
        //print_r($ref);


        /*----REWARDS EARNED------ displays the number of rewards a user has received */

        $rewards = $this->curl->curlSaas('account/'.$account_id.'/user/'.$account_id.'/pii');
        $rewards = json_decode($rewards);

        $rew = $rewards->rewards->totalCount;
        //print_r($rew);


        /*----REFERRED FRIENDS------ displays list of friends a user has referred */

        $friends_referred = $this->curl->curlSaas('open/referrals?referringAccountId='.$account_id.'&referringUserId='.$account_id.'');
        $friends_referred = json_decode($friends_referred);
        //print_r($friends_referred);

        /*----REWARDS PENDING ------ displays amount of pending rewards for user */

        $pending = $this->curl->curlSaas('open/referrals?referringAccountId='.$account_id.'&referringUserId='.$account_id.'');
        $pending = json_decode($pending);
        //print_r($pending);

        /*----------*/

        $data['format_bal'] = $format_bal;
        $data['format_redeem_bal'] = $format_redeem_bal;
        $data['esesharelink'] = $esesharelink;
        $data['sharelink'] = $sharelink;
        $data['sharelink_fbook'] = $sharelink_fbook;
        $data['sharelink_twitt'] = $sharelink_twitt;
        $data['sharelink_email'] = $sharelink_email;
        $data['sharelink_mob'] = $sharelink_mob;
        $data['sharelink_fbook_mob'] = $sharelink_fbook_mob;
        $data['sharelink_twitt_mob'] = $sharelink_twitt_mob;
        $data['sharelink_email_mob'] = $sharelink_email_mob;
        $data['ref'] = $ref;  //number of friends referred
        $data['friends_referred'] = $friends_referred;
        $data['rew'] = $rew;  //number of rewards earned
        $data['pending'] = $pending->count;  //number of rewards pending

        if (!empty($login_response)) {

            $elecMeterPointID = 'na';
            $gasMeterPointID = 'na';
            //$next_week = date('d/m/Y', strtotime($login_response['create_at'].'+1 week')); // 26/05/2014

            // Get / Set & Get intercom credentials in session
            if(isset($login_response['intercom_id']) && $login_response['intercom_id'] != '')
            {
                $IntercomData = $this->get_intercom($login_response['intercom_id']);
            }
            else
            {        
                $name = $login_response['forename'].' '.$login_response['surname'];
                $IntercomData = $this->intercom_create($login_response['id'], $login_response['email'], $name);
            } 
            // End if else intercom in session

            if ($login_response['signup_type'] == 0 || $login_response['signup_type'] == 2) {

                $response = $this->curl->junifer_request('/rest/v1/accounts/' . $login_response['account_id'] . '/agreements');
                $response = $this->parseHttpResponse($response);
                //debug($response,1);

                if ($response['headers']['http_code'] == 'HTTP/1.1 200 OK') {

                    $agreementResponse = $response['body']['results'];
                    //debug($agreementResponse,1);

                    // update meterpointid in db
                    if (!empty($agreementResponse)) {

                        for ($r = 0; $r < count($agreementResponse); $r++) {

                            if ($agreementResponse[$r]['products'][0]['type'] == 'Electricity Supply') {

                                if (isset($agreementResponse[$r]['products'][0]['assets'][0]['id'])) {

                                    $elecMeterPointID = $agreementResponse[$r]['products'][0]['assets'][0]['id'];

                                }

                            } elseif ($agreementResponse[$r]['products'][0]['type'] == 'Gas Supply') {

                                if (isset($agreementResponse[$r]['products'][0]['assets'][0]['id'])) {

                                    $gasMeterPointID = $agreementResponse[$r]['products'][0]['assets'][0]['id'];

                                }
                            }
                        }
                    }


                    $data1['elecMeterPointID'] = $elecMeterPointID;
                    $data1['gasMeterPointID'] = $gasMeterPointID;
                    //debug($data1,1);
                    $updateMeterPointID = $this->api_modal->updateMeterPointID($data1, $login_response['id']);

                } // if loop

                $elec_status = '';
                $gas_status = '';

                $check_meterpoint = $this->api_modal->get_account_detail($login_response['id']);
                if ($check_meterpoint['elecMeterPointID'] != 'na' || $check_meterpoint['gasMeterPointID'] != 'na') {


                    if ($check_meterpoint['elecMeterPointID'] != 'na') {

                        $elec_response = $this->curl->junifer_request('/rest/v1/meterPoints/' . $check_meterpoint['elecMeterPointID'] . '/supplyStatusHistory');
                        $elec_response = $this->parseHttpResponse($elec_response);

                        //debug($elec_response);
                        //get status of elec

                        if ($elec_response['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                            $elec_status = $elec_response['body']['history'][0]['supplyStatus'];
                        } else {
                            $elec_status = 'na';
                        }

                    } else {
                        $elec_status = 'na';
                    }

                    if ($check_meterpoint['gasMeterPointID'] != 'na') {

                        $gas_response = $this->curl->junifer_request('/rest/v1/meterPoints/' . $check_meterpoint['gasMeterPointID'] . '/supplyStatusHistory');
                        $gas_response = $this->parseHttpResponse($gas_response);
                        //debug($elec_response);
                        //get status of gas
                        if ($gas_response['headers']['http_code'] == 'HTTP/1.1 200 OK') {
                            $gas_status = $gas_response['body']['history'][0]['supplyStatus'];
                        } else {
                            $gas_status = 'na';
                        }
                    } else {
                        $gas_status = 'na';
                    }
                }

                if ($gas_status == 'Registered' || $elec_status == 'Registered') {
                    $junifer_account_active = 1;
                } else {
                    $junifer_account_active = 0;
                }


                //Find first reading from log
                $GasMeterReadingLog = $this->get_first_meter_reading_from_log($login_response['id'],1);
                $ElecMeterReadingLog = $this->get_first_meter_reading_from_log($login_response['id'],2);

                // Assign them to vars to use in switch status view
                $data['gas_meter_reading'] = $GasMeterReadingLog['meter_reading'];
                $data['gas_created_at'] = date('d/m/Y H:i', strtotime($GasMeterReadingLog['created_at']));
                $data['elec_meter_reading'] = $ElecMeterReadingLog['meter_reading'];
                $data['elec_created_at'] = date('d/m/Y H:i', strtotime($ElecMeterReadingLog['created_at']));


            }

            $DateSeg = explode('-', $login_response['create_at']);
            $CreatedAt = date('Y-m-d H:i:s', mktime(23, 59, 59, (int)$DateSeg[1], (int)$DateSeg[2], (int)$DateSeg[0]));

            $next_week = strtotime($CreatedAt . '+20 days');
            $noOfDay = date('Y-m-d', $next_week);  // date after 21 days


            //echo $now = date( 'Y-m-d', strtotime($login_response['create_at'])); // or your date as well
            $now = date('Y-m-d');
            $date1 = date_create($now);
            $date2 = date_create(date('Y-m-d', strtotime($login_response['create_at'])));

            //difference between two dates
            $diff = date_diff($date1, $date2);

            //count days
            $info['current_day'] = $diff->format("%a");

            // if we are after the 3 weeks set difference to 0
            if ($next_week < time()) {
                $difference = '0';
            } else {

                $difference = $next_week - time(); // next weeks date minus todays date
                $difference = date('j', $difference);
            }


            $data['cooling_off'] = $difference;

            $data['phone1'] = $login_response['phone1'];
            $data['first_name'] = $login_response['forename'];
            $data['last_name'] = $login_response['surname'];
            $data['address'] = $login_response['first_line_address'];
            $data['postcode'] = $login_response['address_postcode'];

            $info['junifer_account_active'] = $junifer_account_active;
            $info['elec_status'] = $elec_status;
            $info['gas_status'] = $gas_status;

            $info['create_at'] = $login_response['create_at'];
            $info['first_reading_gas'] = $login_response['first_reading_gas'];
            $info['first_reading_elec'] = $login_response['first_reading_elec'];
            $info['booked_meter'] = $login_response['booked_meter'];

            $info['day_left'] = $difference;

            $info['id'] = $login_response['id'];
            $info['intercom_id'] = $IntercomData['id'];
            $info['intercom_user_id'] = $IntercomData['user_id'];
            $info['intercom_name'] = $IntercomData['name'];
            $info['intercom_email'] = $IntercomData['email'];
            $info['title'] = $login_response['title'];
            $info['first_name'] = $login_response['forename'];
            $info['last_name'] = $login_response['surname'];
            $info['date_of_birth'] = $login_response['dateOfBirth'];
            $info['signup_type'] = $login_response['signup_type'];
            $info['account_status'] = $login_response['api_user_status'];
            // $info['user_mpan'] = $check_user_active['electricityProduct_mpans'];
            $info['user_mprn'] = $login_response['gasProduct_mprns'];
            $info['address'] = $login_response['first_line_address'];
            $info['town_address'] = $login_response['town_address'];
            $info['city_address'] = $login_response['city_address'];
            $info['mpancore'] = $login_response['elec_mpan_core'];

            $info['elec_meter_serial'] = $login_response['elec_meter_serial'];
            $info['gas_meter_serial'] = $login_response['gas_meter_serial'];

            $info['customer_id'] = $login_response['customer_id'];
            $info['account_id'] = $login_response['account_id'];
            $info['account_number'] = $login_response['account_id'];
            $info['dyball_account_id'] = $login_response['dyball_account_id'];

            $info['email'] = $login_response['email'];
            $info['mpancore'] = $login_response['elec_mpan_core'];
            $info['meterpoint_mpan'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPAN"];
            $info['meterpoint_mprn'] = ["id" => 314, "identifier" => "1200020346970", "type" => "MPRN"];

            $info['billingMethod'] = $login_response['billingMethod'];
            $info['tariff_newspend'] = $login_response['tariff_newspend'];
            $info['exitFeeElec'] = $login_response['exitFeeElec'];
            $info['tariff_tariffName'] = $login_response['tariff_tariffName'];
            $info['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];
            $info['meterTypeElec'] = $login_response['meterTypeElec'];
           // $info['junifer_account_active'] = 1;s

            $this->session->set_userdata('login_data', $info);

        }



        ////////////////////////////////////////////////////////////
        ////////////// START - WEB TO CASE VARIABLES ///////////////

        // External System Registration Status
        $data['MeterBookingSelected'] = 'selected="selected"';
        $data['PendingSelected'] = '';
        $data['SuccessSelected'] = '';
        $data['OtherSelected'] = '';

        // Standard vars
        $data['email'] = $login_response['email'];
        $data['dob'] = $login_response['dateOfBirth'];

        // Set up some vars depending on what account type we are
        if ( $login_response['signup_type'] == 0 ) {  // 0 = Junifer

            $data['junifer_customer_id'] = $login_response['customer_id'];
            $data['dyball_account_id'] = '';
            $data['subject'] = 'Meter Booking - Junifer Customer ID: ' . $data['junifer_customer_id'] . ' - Success';
            $data['description'] = 'Meter Booking request for ' . $login_response['forename'] . ' ' . $login_response['surname'];
        }
        else if ( $login_response['signup_type'] == 3 ) {  // 3 = Dyball

            $data['dyball_account_id'] = $login_response['dyball_account_id'];
            $data['junifer_customer_id'] = '';
            $data['subject'] = 'Meter Booking - Dyball Account Number: ' . $data['dyball_account_id'] . ' - Success';
            $data['description'] = 'Meter Booking request for ' . $login_response['forename'] . ' ' . $login_response['surname'];
        }

        //////////////  END - WEB TO CASE VARIABLES ////////////////
        ////////////////////////////////////////////////////////////



        $data['content'] = 'dashboard/switch_status';
        $data['elecMeterPointID'] = $elecMeterPointID;
        $data['gasMeterPointID'] = $gasMeterPointID;
        $this->load->view('layout/dashboard_master', $data);
    }

 function pay_dashboard()
  {
     if(  empty($this->session->userdata('login_data')) ){
      header('location:'.base_url().'index.php/user/login');
      exit;
    }

    $data['balance'] = 0;

    $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );

    if( $this->session->userdata('login_data')['signup_type'] == '0' || $this->session->userdata('login_data')['signup_type'] == '2' ){

      $get_user_account_id = $this->session->userdata('login_data')['account_id'] ;

      $get_balance_junifer = $this->curl->junifer_request('/rest/v1/accounts/'.$get_user_account_id.'');
      $get_balance_junifer = $this->parseHttpResponse($get_balance_junifer);

      if(  $get_balance_junifer['headers']['http_code'] == 'HTTP/1.1 200 OK') {

        $data['balance'] = $get_balance_junifer['body']['balance'] ;

     }


   }


    $data['content'] = 'dashboard/pay-dashboard';
    $this->load->view('layout/dashboard_master',$data);
     //$this->load->view('dashboard/pay-dashboard');
  }

    function booked_meter(){

        $this->user_modal->book_meter($this->input->post('user_id'),$this->input->post('meter'));

        // Get the customer info
        $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );

        // Set the variables for email
        $token = md5(uniqid(rand(0,9999), true));
        $account_id = $login_response['account_id'] ;
        $user_phone = $login_response['phone1'] ;
        $post_code =  $login_response['address_postcode'] ;
        $name = $login_response['forename'] ;
        $lastname = $login_response['surname'] ;
        $email = $login_response['email'] ;

        // Send email
        $this->agent_calling_customer_email($login_response['id'], $token, $name, $email);

        // Log token
        $token_in_database = $this->user_modal->token_in_database($token,$login_response['id'],'1');

        // Response
        echo  json_encode([ 'error' => '0', 'msg'=>'Mail send', 'Post code' => $post_code, 'Phone' =>  $user_phone , 'name'=> $name, 'last name' => $lastname]);

    }



  function admin_page()
  {
    $data['booked_detail'] = $this->user_modal->booking_meter();
    $data['confirmed_detail'] = $this->user_modal->confirmed_meter();
    $data['content'] = 'dashboard/admin_page';
  //debug($data);
    $data['title'] = 'Admin Panel';
    $this->load->view('layout/dashboard_master',$data);

  }

  function testDyball(){

      $url = '/api/CustomerSelfService/GetCustomerDetails';
      echo "<br>REQUEST URL: ". $url."<br>";

      $parameter = [
          'AuthKey' => $this->authkey_dyball_serve,
          'AccountNumber' => 'DYB_ELEC_000328',
          //'PostCode' => 'PR6 7UX'
          // 'ContactTelephone' => '918968163577',
          // 'ContactMobile' => '918968163577',
          // 'ContactEmail' => 'ajay11@iivo.io'
      ];
      echo "<br>REQUEST: ";
      debug($parameter);
      $response = $this->curl->curl_dyball($url, $parameter, 'post');
      echo "<br>RESPONSE:";
      debug($this->parseHttpResponse($response));
  }

  function status_active(){
      $change_user_status = $this->user_modal->change_user_status( $this->input->post('user_id') );
      if( $change_user_status )
      {
        $login_response = $this->user_modal->get_account_detail( $this->input->post('user_id') );

        if( !empty($login_response) ){

            //$next_week = date('d/m/Y', strtotime($login_response['create_at'].'+1 week')); // 26/05/2014

            $DateSeg = explode('-', $login_response['create_at']);
            $CreatedAt = date('Y-m-d H:i:s', mktime(23,59,59,(int)$DateSeg[1],(int)$DateSeg[2],(int)$DateSeg[0]));

            $next_week = strtotime($CreatedAt.'+21 days');
            $noOfDay = date( 'Y-m-d', $next_week );  // date after 21 days

            //echo $now = date( 'Y-m-d', strtotime($login_response['create_at'])); // or your date as well
            $now = date('Y-m-d');
            $date1 = date_create($now);
            $date2 = date_create(date( 'Y-m-d', strtotime($login_response['create_at'])));

            //difference between two dates
            $diff = date_diff($date1,$date2);

            //count days
            $info[ 'current_day' ] = $diff->format("%a");

            //$difference = $next_week - time(); // next weeks date minus todays date
            //$difference = date('j', $difference);

            // if we are after the 3 weeks set difference to 0
            if ( $next_week < time() ) {
                $difference = '0';
            }
            else {

                $difference = $next_week - time(); // next weeks date minus todays date
                $difference = date('j', $difference);
            }

            //if( $difference >= 21  )
            //{
            //  $difference = '0';
            //}

            $info['create_at'] = $login_response['create_at'];
            $info['booked_meter'] = $login_response['booked_meter'];

            $info['day_left'] = $difference;

            $info['id'] = $login_response['id'];
            $info['title'] = $login_response['title'];
            $info['first_name'] = $login_response['forename'];
            $info['last_name'] = $login_response['surname'];
            $info['signup_type'] = $login_response['signup_type'];
            $info['account_status'] = $login_response['api_user_status'];
            // $info['user_mpan'] = $check_user_active['electricityProduct_mpans'];
            $info['user_mprn'] = $login_response['gasProduct_mprns'];
            $info['address'] = $login_response['first_line_address'];
            $info['town_address'] = $login_response['town_address'];
            $info['city_address'] = $login_response['city_address'];
            $info['mpancore'] = $login_response['elec_mpan_core'];

            $info['elec_meter_serial'] = $login_response['elec_meter_serial'];
            $info['gas_meter_serial'] = $login_response['gas_meter_serial'];

            $info['customer_id'] = $login_response['customer_id'];
            $info['account_id'] = $login_response['account_id'];
            $info['account_number'] = $login_response['account_id'];

            $info['email'] = $login_response['email'];
            $info['mpancore'] = $login_response['elec_mpan_core'];
            $info['meterpoint_mpan'] = ["id"=>314,"identifier"=>"1200020346970","type"=>"MPAN"];
            $info['meterpoint_mprn'] = ["id"=>314,"identifier"=>"1200020346970","type"=>"MPRN"];

            $info['billingMethod'] = $login_response['billingMethod'];
            $info['tariff_newspend'] = $login_response['tariff_newspend'];
            $info['exitFeeElec'] = $login_response['exitFeeElec'];
            $info['tariff_tariffName'] = $login_response['tariff_tariffName'];
            $info['tariff_unitRate1Elec'] = $login_response['tariff_unitRate1Elec'];

            $info['junifer_account_active'] = 1;

            $this->session->set_userdata('login_data',$info);
        }

          $info['junifer_account_active'] = 1;
          $info['current_day'] = 0;

        $this->session->set_userdata('login_data',$info);
        echo json_encode(['error' => 0, 'msg' => 'account update']);
      }else{
        echo json_encode(['error' => 1, 'msg' => 'account update fail']);
      }
  }

  function get_ese_share_link($customer_id){
      $ESECustomerShare = $this->mysql->select('*')
          ->from('referral_link')
          ->where('customer_id', $customer_id)
          ->get()->first_row('array');
      return $ESECustomerShare;
  }

  function insert_ese_share_link($data){
      $this->mysql->insert('referral_link',$data);
      return $this->mysql->insert_id();
  }

  function referral()
  {
      if(  empty($this->session->userdata('login_data')) ){
        header('location:'.base_url().'index.php/user/login');
        exit;
      }
      $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );

      $account_id = $login_response['id'] ;
      $name = $login_response['forename'] ;
      $lastname = $login_response['surname'] ;
      $email = $login_response['email'] ;
      //print_r($account_id);
      
      /*---CREATE--- creates new user */
      
      $random = rand(0,99);
      $random = ($random <=9 ? "0" . $random : $random);
      
      $para =  [
          "id" => $account_id,
          "accountId" => $account_id,
          "firstName" => $name,
          "lastName" => $lastname,
          "email" => $email,
          "referable" => "true",
          "referralCode" => $name . $lastname . $random,    // forename . surname . random number between 00 and 99  
          "locale" => "en_UK"
      ]; 
      
      $creating_user = $this->curl->curlSaas('open/account/'.$account_id.'/user/'.$account_id.'', $para, 'post');
      $creating_user = json_decode($creating_user);
      //print_r($creating_user);
      
      
      /*---SEARCH--- search user via user and acccountId. displays share link info */
      
      $para =  [
          "id" => $account_id,
          "accountId" => $account_id
      ]; 



      $search_user = $this->curl->curlSaas('user', $para, 'post');
      $search_user = json_decode($search_user);
      //print_r($search_user);


      // Find out if we already have share link or we need to generate one
      $ESEShareLink = $this->get_ese_share_link($this->session->userdata('login_data')['id']);

      if($ESEShareLink['ese_generated_link']!=''){
          $esesharelink = $ESEShareLink['ese_generated_link'];
      }
      else {

          $esesharelink = 'http://eversmart.family/'.$name . $lastname . $random;

          $db_parameter = [
              'customer_id' => $this->session->userdata('login_data')['id'],
              'ese_generated_link' => $esesharelink,
              'saas_generated_link' => $search_user->shareLinks->shareLink
          ];

          $this->insert_ese_share_link($db_parameter);
      }


      $sharelink = $search_user->shareLinks->shareLink;
      $sharelink_fbook = $search_user->shareLinks->facebookShareLink;
      $sharelink_twitt = $search_user->shareLinks->twitterShareLink;
      $sharelink_email = $search_user->shareLinks->emailShareLink;
      $sharelink_mob = $search_user->shareLinks->mobileShareLink;
      $sharelink_fbook_mob = $search_user->shareLinks->mobileFacebookShareLink;
      $sharelink_twitt_mob = $search_user->shareLinks->mobileTwitterShareLink;
      $sharelink_email_mob = $search_user->shareLinks->mobileEmailShareLink;
      
      /*
      print_r($sharelink); echo '<br/>';
      print_r($sharelink_fbook); echo '<br/>';
      print_r($sharelink_twitt); echo '<br/>';
      print_r($sharelink_email); echo '<br/>';
      print_r($sharelink_mob); echo '<br/>';
      print_r($sharelink_fbook_mob); echo '<br/>';
      print_r($sharelink_twitt_mob); echo '<br/>';
      print_r($sharelink_email_mob); echo '<br/>';
      */
      
    
      /*----LIST REWARDS--- displays users current rewards using accountId */

      $list_reward = $this->curl->curlSaas('reward/balance?accountId='.$account_id.'');
      $list_reward = json_decode($list_reward);
      
      if($list_reward == null)
      {
          $format_bal = 0;
          $format_redeem_bal = 0;
      }
      else
      {
          $assigned_bal = $list_reward[0]->totalAssignedCredit;
          $redeemed_bal = $list_reward[0]->totalRedeemedCredit;
          $current_bal = $assigned_bal - $redeemed_bal;
          $format_bal = $current_bal / 100;
          //print_r($format_bal);
          $format_redeem_bal = $redeemed_bal / 100;
      }

      /*----NUM OF REFERRALS------ displays how many users a person has referred */
      
      $referrals = $this->curl->curlSaas('account/'.$account_id.'/user/'.$account_id.'/pii');
      $referrals = json_decode($referrals);
      
      $ref = $referrals->referrals->totalCount;
      //print_r($ref);
      
      
      /*----REWARDS EARNED------ displays the number of rewards a user has received */
      
      $rewards = $this->curl->curlSaas('account/'.$account_id.'/user/'.$account_id.'/pii');
      $rewards = json_decode($rewards);
      
      $rew = $rewards->rewards->totalCount;
      //print_r($rew);
      
      
      /*----REFERRED FRIENDS------ displays list of friends a user has referred */
      
      $friends_referred = $this->curl->curlSaas('open/referrals?referringAccountId='.$account_id.'&referringUserId='.$account_id.'');
      $friends_referred = json_decode($friends_referred);
      //print_r($friends_referred);

      /*----REWARDS PENDING ------ displays amount of pending rewards for user */

      $pending = $this->curl->curlSaas('open/referrals?referringAccountId='.$account_id.'&referringUserId='.$account_id.'');
      $pending = json_decode($pending);
      //print_r($pending);
      
      /*----------*/ 
      
      $data['format_bal'] = $format_bal;
      $data['format_redeem_bal'] = $format_redeem_bal;
      $data['esesharelink'] = $esesharelink;
      $data['sharelink'] = $sharelink;
      $data['sharelink_fbook'] = $sharelink_fbook;
      $data['sharelink_twitt'] = $sharelink_twitt;
      $data['sharelink_email'] = $sharelink_email;
      $data['sharelink_mob'] = $sharelink_mob;
      $data['sharelink_fbook_mob'] = $sharelink_fbook_mob;
      $data['sharelink_twitt_mob'] = $sharelink_twitt_mob;
      $data['sharelink_email_mob'] = $sharelink_email_mob;
      $data['ref'] = $ref;  //number of friends referred
      $data['friends_referred'] = $friends_referred;
      $data['rew'] = $rew;  //number of rewards earned
      $data['pending'] = $pending;  //number of rewards pending
      $data['content'] = 'dashboard/referral';
      $this->load->view('layout/dashboard_master',$data);
      
  }
   
  function saasDebit()
  {
      $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );
      
      $table_id =  $this->session->userdata('login_data')['id'];
      $junifer_id =  $this->session->userdata('login_data')['account_id'];
      $email = $login_response['email'];

      
      $para =  [
        "accountId" => $table_id,
        "unit" => "cents",
        "amount" => "5000"
      ];

      $post = [
          "grossAmount" => "50.00",
          "salesTaxName" => "Standard VAT",
          "accountCreditReasonName" => "Saasquatch Referral"
      ];

      $list_reward = $this->curl->curlSaas('reward/balance?accountId='.$table_id.'');
      $list_reward = json_decode($list_reward);

      if($list_reward == null)
      {
          $format_bal = 0;
          $format_redeem_bal = 0;

          echo json_encode([ 'status' => 'fail']);
      }
      else  
      {
          $assigned_bal = $list_reward[0]->totalAssignedCredit;
          $redeemed_bal = $list_reward[0]->totalRedeemedCredit;
          $current_bal = $assigned_bal - $redeemed_bal;
          $format_bal = $current_bal / 100;
          $format_redeem_bal = $redeemed_bal / 100;
          
          if($format_bal >= "50")
          {
              $junifer_credit = $this->curl->junifer_request('/rest/v1/accounts/'.$junifer_id.'/accountCredits', $post, 'post');

              $get_head = $this->parseHttpResponse($junifer_credit);

              //print_r($get_head['headers']['http_code']);

              if( $get_head['headers']['http_code'] == 'HTTP/1.1 204 No Content')
              {
                  $debit_user = $this->curl->curlSaas('credit/bulkredeem', $para, 'post');
                  $debit_user = json_decode($debit_user);

                  echo json_encode([ 'status' => 'success']);
              }
              else
              {
                  echo json_encode([ 'status' => 'fail']);
              } 
             
              if($login_response['signup_type'] == '3' )
              {
                  //dyball   
                
              }

            }
          
          else
          {
            
          }
      } 
    }

    function saascode() 
    {
      $code =  $this->input->post('code');

      $ref_code = $this->curl->curlSaas('code/'.$code.'');
      $ref_code = json_decode($ref_code);

      $ref_name = $ref_code->referrerName;
      $ref_name_seg = explode(" ", $ref_name);

      echo json_encode([ 'error' => '0','ref_name' => $ref_name_seg[0]]);
    }

    function messages() {

      if(  empty($this->session->userdata('login_data')) ){
        header('location:'.base_url().'index.php/user/login');
        exit;
      }
      $login_response = $this->user_modal->get_account_detail( $this->session->userdata('login_data')['id'] );

      
      $account_id = $login_response['account_id'] ;
      $name = $login_response['forename'] ;
      $lastname = $login_response['surname'] ;
      $email = $login_response['email'] ;

      if($login_response['signup_type'] == 0 || $login_response['signup_type'] == 2)
      {

      $junifer_msgs = $this->curl->junifer_request('/rest/v1/accounts/'.$account_id.'/communications');

      $junifer_msgs = $this->parseHttpResponse($junifer_msgs);

      if(  $junifer_msgs['headers']['http_code'] == 'HTTP/1.1 200 OK')
      {
        $junifer_msgs = $junifer_msgs['body'];
      }
      else
      {
        $junifer_msgs = [];
      } 
    }
    else
    {
      $junifer_msgs = [];
    } 

      $data['junifer_msgs'] =  $junifer_msgs ;
      $data['content'] = 'dashboard/messages';
      $this->load->view('layout/dashboard_master',$data);

    }

    function downloadmessage($msgid)
    {
 
      $curl = curl_init();

      if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' || $_SERVER['HTTP_HOST'] == '18.191.137.119'  )  //local
      {


      curl_setopt_array($curl, array(
        CURLOPT_PORT => "43002",
        CURLOPT_URL => "http://134.213.125.150:43002/rest/v1/communicationsFiles/".$msgid."/image",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "X-Junifer-X-apikey: 83B1ilbo",
          "X-Junifer-X-username: APIUser"
        ),
      ));

    }

    if( $_SERVER['HTTP_HOST'] == '52.56.76.183' ) //dev
    {  
      curl_setopt_array($curl, array(
        CURLOPT_PORT => "43002",
        CURLOPT_URL => "http://134.213.12.122:43002:43002/rest/v1/communicationsFiles/".$msgid."/image",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          'X-Junifer-X-apikey: dgiZaFDb',
        'X-Junifer-X-username: api',
        ),
      ));

    }
      
      $response = curl_exec($curl);
      $err = curl_error($curl);
      
     

      curl_close($curl);
      
      if ($err) {
        header('Content-type: application/pdf');
        echo "Error #:" . $err;
      } 
      else {
        header('Content-type: application/pdf');
        echo $response;
      }
      
  
    }
  

    function downloadbill($billid)
    {
 
      $curl = curl_init();
      if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' || $_SERVER['HTTP_HOST'] == '18.191.137.119'  )  //local
      {


      curl_setopt_array($curl, array(
        CURLOPT_PORT => "43002",
        CURLOPT_URL => "http://134.213.125.150:43002/rest/v1/billFiles/".$billid."/image",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "X-Junifer-X-apikey: 83B1ilbo",
          "X-Junifer-X-username: APIUser"
        ),
      ));
    
    }

    if( $_SERVER['HTTP_HOST'] == '52.56.76.183' ) //dev
    { 
      
      curl_setopt_array($curl, array(
      CURLOPT_PORT => "43002",
      CURLOPT_URL => "http://134.213.12.122:43002/rest/v1/billFiles/".$billid."/image",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "GET",
      CURLOPT_HTTPHEADER => array(
        'X-Junifer-X-apikey: dgiZaFDb',
        'X-Junifer-X-username: api',
      ),
    ));
  
  }


      $response = curl_exec($curl);
      $err = curl_error($curl);
    


      curl_close($curl);
      
      if ($err) {
        header('Content-type: application/pdf');
        echo "Error #:" . $err;
      } 
      else {
        header('Content-type: application/pdf');
        echo $response;
      }
      
  
      
  
    }

    // add the email log to the database
    function insert_email_log($data){
        $this->mysql->insert('email_log',$data);
        return $this->mysql->insert_id();
    }

    function all_email_templates() {
        $this->load->view('layout/all_email_templates');
    }

    function activation_email($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'thumb_header.jpg';
        $email_data['content'] = 'layout/activation_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Signup Confirmation');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 1;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Activation email sent to: '.$recipient_email]);

    }

    function provide_meter_reading($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'meter_header.jpg';
        $email_data['content'] = 'layout/provide_meter_reading_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Please provide a meter reading');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 5;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Provide meter reading email sent to: '.$recipient_email]);

    }

    function first_meter_reading($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'meter_header.jpg';
        $email_data['content'] = 'layout/first_meter_reading_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Please provide a meter reading');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 4;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'First meter reading email sent to: '.$recipient_email]);

    }

    function payment_plan_cancelled($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/payment_plan_cancelled_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Payment plan cancelled');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 2;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Payment plan cancelled email sent to: '.$recipient_email]);

    }

    function latest_energy_bill($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/latest_energy_bill_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Latest energy bill');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 3;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Latest energy bill email sent to: '.$recipient_email]);

    }

    function direct_debit_confirmation($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/direct_debit_confirmation_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Direct debit confirmation');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 10;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Direct debit confirmation email sent to: '.$recipient_email]);

    }

    function direct_debit_changes($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/direct_debit_change_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Direct debit changes');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 11;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Direct debit confirmation email sent to: '.$recipient_email]);

    }

    function direct_debit_problem($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/direct_debit_problem_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Direct debit problem');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 12;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Direct debit problem email sent to: '.$recipient_email]);

    }

    function leaving($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/leaving_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Sorry to see you go');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 6;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Sorry to see you go email sent to: '.$recipient_email]);

    }

    function balance_overdue_1($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/balance_overdue_1_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Your balance is overdue');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 7;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Balance overdue 1 email sent to: '.$recipient_email]);

    }

    function balance_overdue_2($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/balance_overdue_2_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Your balance is still overdue');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 8;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Balance overdue 2 email sent to: '.$recipient_email]);

    }

    function balance_overdue_3($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/balance_overdue_3_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Your overdue balance');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 9;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Balance overdue 3 email sent to: '.$recipient_email]);

    }

    function new_payment_plan($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/new_payment_plan_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('New payment plan');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 13;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'New payment plan email sent to: '.$recipient_email]);

    }

    function new_payment_schedule($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'wallet_header.jpg';
        $email_data['content'] = 'layout/new_payment_schedule_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('New payment schedule');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 14;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'New payment schedule email sent to: '.$recipient_email]);

    }

    function objection($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/objection_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('We have objected to your switch');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 15;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Objection email sent to: '.$recipient_email]);

    }

    function previous_supplier_objection($customer_info_id, $token, $forename, $recipient_email, $bill_number) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$bill_number = '[bill_number]';


        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename , 'customer_number' => $customer_number , 'bill_number' => $bill_number ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/previous_supplier_objection_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Your current supplier has stopped your switch');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] =16;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Previous supplier objection email sent to: '.$recipient_email]);

    }

    function registration_withdrawal($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_info_id = 000299;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/registration_withdrawal_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('We weren\'t able to switch you');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] =17;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Registration withdrawal email sent to: '.$recipient_email]);

    }

    function reset_password($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_id = 528;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename, 'customer_number' => $customer_number ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/reset_password_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Reset password');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 18;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Reset password email sent to: '.$recipient_email]);

    }

    function book_meter($customer_info_id, $token, $forename, $recipient_email, $user_phone, $post_code) {

        //$customer_id = 528;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$user_phone = '[user_phone]';
        //$post_code = '[post_code]';

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename, 'customer_number' => $customer_number, 'user_phone' => $user_phone, 'post_code' => $post_code ];
        $email_data['email_header_img'] = 'meter_header.jpg';
        $email_data['content'] = 'layout/book_meter_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Book meter');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 19;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Book meter email sent to: '.$recipient_email]);

    }

    function moving_home_email($customer_info_id, $token, $forename, $recipient_email, $new_address) {

        //$customer_id = 528;
        //$forename = '[customer_name]';
       // $recipient_email = $this->input->post('email_address');
        $customer_number = $customer_info_id;
        //$new_address = '[new_address_1, new_address_1, new_address_3, postcode]';

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename, 'customer_number' => $customer_number, 'new_address' => $new_address ];
        $email_data['email_header_img'] = 'switch_header.jpg';
        $email_data['content'] = 'layout/moving_home_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Moving home');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 20;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Moving home email sent to: '.$recipient_email]);

    }

    function agent_calling_customer_email($customer_info_id, $token, $forename, $recipient_email) {

        //$customer_id = 528;
        //$forename = '[customer_name]';
        //$recipient_email = $this->input->post('email_address');

        //$token = md5(uniqid(rand(0,9999), true));
        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/agent_calling_customer_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('An agent will be calling you soon');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 22;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'Agent calling you soon email sent to: '.$recipient_email]);

    }



    function generate_pdf($data){

        // Lets send some data from controller to view file
        $pdf_data['customer_name'] = $data['customer_name'];
        $pdf_data['customer_number'] = $data['account_number'];
        $pdf_data['email'] = $data['email'];
        $pdf_data['address_line_1'] = $data['contact_address_1'];
        $pdf_data['address_line_2'] = $data['contact_address_2'];
        $pdf_data['address_line_3'] = $data['contact_address_3'];
        $pdf_data['postcode'] = $data['contact_post_code'];

        $pdf_data['current_elec_sc'] = $data['current_elec_sc'];
        $pdf_data['current_gas_sc'] = $data['current_gas_sc'];
        $pdf_data['new_elec_sc'] = $data['new_elec_sc'];
        $pdf_data['new_gas_sc'] = $data['new_gas_sc'];

        $pdf_data['current_elec_dur'] = $data['current_elec_dur'];
        $pdf_data['current_gas_ur'] = $data['current_gas_ur'];
        $pdf_data['new_elec_dur'] = $data['new_elec_dur'];
        $pdf_data['new_gas_ur'] = $data['new_gas_ur'];

        $pdf_data['rate_type'] = $data['rate_type'];
        $pdf_data['current_elec_nur'] = $data['current_elec_nur'];
        $pdf_data['new_elec_nur'] = $data['new_elec_nr'];

        $pdf_data['tariff_change_date'] = '24th November 2018';
        $pdf_data['tariff_date_to'] = '24/11/18';
        $pdf_data['tariff_date_from'] = '25/11/18';
        $pdf_data['filename'] = 'assets/temp_pdf/tariff_change_'.date('dmY').'_'.$pdf_data['customer_number'].'.pdf';

        $this->load->view('tariff_change_pdf_template', $pdf_data);

        return $pdf_data['filename'];

    }


    function variable_tariff_changing($data) {

        // Returns the pdf filename
        $Attachment = $this->generate_pdf($data);

        //print_r($CustomerData);
        $forename = $data['customer_name'];
        $recipient_email = $data['email'];
        $customer_number = $data['account_number'];

        $token = md5(uniqid(rand(0, 9999), true));

        $EncodedHash = trim(base64_encode(mktime(0,0,0,11,25,18).'|'.$customer_number),'=');
        $EncodedHash = str_replace('/', '_', $EncodedHash);
        $EncodedHash = str_replace('+', '-', $EncodedHash);

        $email_data['email_info'] = ['token' => $token, 'name' => $forename, 'customer_number' => $customer_number, 'encoded_hash' => $EncodedHash];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/variable_price_change_email_content';

        $template = $this->load->view('layout/email_template', $email_data, true);

        $this->load->library('email');
        $this->email->clear(true);
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Our variable tariff is changing');
        $this->email->message($template);
        if($Attachment) {
            $this->email->attach($Attachment);
        }
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_number;
        $email_log_db_parameter['email_type_id'] = 21;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

        //echo json_encode(['success' => 'variable tariff changing email sent to: '.$recipient_email]);

    }


    function sendTariffChangeNotification(){

        // Load library
        $this->load->library('myfpdf');

        $Customers = $this->mysql->select('account_number, customer_name, email, contact_address_1, contact_address_2, contact_address_3, contact_post_code, current_elec_sc, current_gas_sc,  new_elec_sc, new_gas_sc, current_elec_dur, current_gas_ur, new_elec_dur, new_gas_ur, rate_type, current_elec_nur, new_elec_nr')->from('tariff_change_notification')->where('email != \'\'', NULL, FALSE)->order_by("account_number", "ASC")->get()->result_array();

        // loop through each one
        foreach($Customers as $CustomerData) {
            $this->variable_tariff_changing($CustomerData);
        }

    }





    function calculate_total_customer_interest($customer_id){

        $AccruedInterest = $this->mysql->select('SUM(cmi.monthly_interest) AS `accrued_interest`, ci.monthly_interest_customer_signup_date AS signup_date ')
            ->from('customer_monthly_interest cmi')
            ->join('customer_info ci',  'ci.id = cmi.customer_id' )
            ->where('cmi.customer_id',$customer_id)
            //->where('cmi.interest_redemption_type_id',NULL)
            //->where('cmi.interest_redemption_date',NULL)
            ->get()->first_row('array');
        return $AccruedInterest;

    }

    function get_customer_interest_data($customer_id){

        $AccruedInterest = $this->mysql->select('*')
            ->from('customer_monthly_interest cmi')
            ->where('cmi.customer_id',$customer_id)
            ->get()->result_array();
        return $AccruedInterest;

    }

    function web_to_case_log(){

        $data = $this->input->post();
        $this->mysql->insert('web_to_case_log',$data);
        return $this->mysql->insert_id();
    }

    function get_intercom($intercom_id)
    {
        $get_com_user = $this->curl->curlIntercom('users/'. $intercom_id . '');
        return json_decode($get_com_user, true);
    }

    function intercom_create($insert_customer_info, $email, $name)
    {
        $para_com = [
            "user_id" => $insert_customer_info,
            "email" => $email,
            "name" => $name
        ];

        //create intercom user
        $creating_com_user = $this->curl->curlIntercom('users', $para_com, 'post');
        
        //get user
        $get_com_user = $this->curl->curlIntercom('users?user_id='. $insert_customer_info . '');
        $get_com_user = json_decode($get_com_user, true);

        $db_parameter = ["intercom_id" => $get_com_user['id']];
        
        $this->user_modal->update_customer_info($db_parameter, $insert_customer_info);
        
        return $get_com_user;
    }

} //class end


