<?php
use \vendor\stripe;
require_once('./vendor/autoload.php');
defined('BASEPATH') OR exit('No direct script access allowed');

class Notfound extends CI_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->model('tarrif_change');
        $this->load->model('user_modal');
        $this->load->model('error_modal');
        $this->load->model('api_modal');
        $this->mysql = $this->load->database('mysql', true);
        $this->load->helper('url');

    }

    public function index()
    {

        // Get the url
        $url = uri_string();

        // Put characters that cause url issues back in
        $url = str_replace('_', '/', $url);
        $url = str_replace('-', '+', $url);

        // Decode and explode
        $DecodedHash = explode('|',base64_decode($url.'='));

        // Set some vars
        if(count($DecodedHash)==2){
            
            $ExpiryDate = $DecodedHash[0];
            $AccountNumber = $DecodedHash[1];


            if($AccountNumber!='' && $ExpiryDate >= time()){ // Do we have an account number and are we within the expiry date?

                // search database
                $Link = $this->tarrif_change->get_customer_data($AccountNumber);


                // if match found, redirect to saas link
                if(isset($Link)) {

                    if ($Link['elec_status'] === 'Registered') {

                        $yearly_tariff_lookup = $this->tarrif_change->yearly_tariff_lookup($AccountNumber);

                        //Print_r($yearly_tariff_lookup);
                        //Print_r($Link);

                        $this->session->set_userdata('tarrif_change', $Link);
                        $this->session->set_userdata('yearly_tariff_lookup', $yearly_tariff_lookup);


                        if (!empty( $Link['estimated_annual_consumption']) &&  $Link['estimated_annual_consumption'] > 0  && !empty( $Link['annual_quantity']) && $Link['annual_quantity'] > 0 ) {

                            $eac = $Link['estimated_annual_consumption'] ;
                            $sc = $yearly_tariff_lookup[0]['electricity_sc'];
                            $electricity_dur = $yearly_tariff_lookup[0]['electricity_dur'];
                            $aq = $Link['annual_quantity'];

                            $gas_sc = $yearly_tariff_lookup[0]['gas_sc'];
                            $gas_ur = $yearly_tariff_lookup[0]['gas_ur'];

                            $year_gas_price = $gas_ur * $aq + $gas_sc;
                            $year_elec_price = 	$electricity_dur * $eac + $sc;

                            $year_price = $year_gas_price + $year_elec_price;
                            $year_price = number_format($year_price, 0, '.', '') ;

                            //print_r($year_gas_price);
                            //print_r($year_price);

                            $data['aq'] =  $aq ;
                            $data['eac'] =  $eac ;


                            $this->session->set_userdata('electricity_dur', $electricity_dur);
                            $this->session->set_userdata('year_price', $year_price);
                            $data['year_price'] = $year_price;

                        }



                        if (!empty( $Link['estimated_annual_consumption']) && !empty(( $Link['annual_quantity']) && $Link['annual_quantity'] > 0 )) {

                            //	$eac = $Link['estimated_annual_consumption'] ;
                            //	$sc = $yearly_tariff_lookup[0]['electricity_sc'];
                            //	$electricity_dur = $yearly_tariff_lookup[0]['electricity_dur'];
                            $aq = $Link['annual_quantity'];

                            $gas_sc = $yearly_tariff_lookup[0]['gas_sc'];
                            $gas_ur = $yearly_tariff_lookup[0]['gas_ur'];

                            $year_gas_price = $gas_ur * $aq + $gas_sc;
                            //$year_elec_price = 	$electricity_dur * $eac + $sc;
                            $year_price = $year_gas_price;
                            $year_price = number_format($year_price, 2, '.', '') ;

                            //print_r($year_gas_price);
                            //print_r($year_price);

                            $data['aq'] =  $aq ;
                            //$data['eac'] =  $eac ;

                            $this->session->set_userdata('year_price', $year_price);
                            //$this->session->set_userdata('electricity_dur', $electricity_dur);
                            $data['year_price'] = $year_price;

                        }



                        if (!empty( $Link['estimated_annual_consumption']) && $Link['estimated_annual_consumption'] > 0  && !empty( $Link['annual_quantity'])) {

                            $eac = $Link['estimated_annual_consumption'] ;
                            $sc = $yearly_tariff_lookup[0]['electricity_sc'];
                            $electricity_dur = $yearly_tariff_lookup[0]['electricity_dur'];
                            $aq = $Link['annual_quantity'];

                            //	$gas_sc = $yearly_tariff_lookup[0]['gas_sc'];
                            //	$gas_ur = $yearly_tariff_lookup[0]['gas_ur'];

                            //$year_gas_price = $gas_ur * $aq + $gas_sc;
                            $year_elec_price = 	$electricity_dur * $eac + $sc;

                            $year_price = $year_elec_price;
                            $year_price = number_format($year_price, 2, '.', '') ;

                            //print_r($year_gas_price);
                            //print_r($year_price);

                            //$data['aq'] =  $aq ;
                            $data['eac'] =  $eac ;

                            $this->session->set_userdata('year_price', $year_price);
                            //$this->session->set_userdata('aq', $aq);
                            $data['year_price'] = $year_price;

                        }



                        $data['yearly_tariff_lookup'] = $this->session->userdata('yearly_tariff_lookup');
                        $data['signup_info'] = $this->session->userdata('tarrif_change');
                        $data['content'] = 'tarrif_year';


                        ////////////////////////////////////////////////////////////
                        ////////////// START - WEB TO CASE VARIABLES ///////////////

                        $Name = explode(' ', $data['signup_info']['customer_name']);
                        $Forename = $Name[1];
                        unset($Name[0]);
                        unset($Name[1]);

                        $data['first_name'] = $Forename;
                        $data['last_name'] = $str = implode (" ", $Name);;
                        $data['email'] = $data['signup_info']['email'];
                        $data['phone'] = $data['signup_info']['telephone'];
                        $data['dyball_account_id'] = '';
                        $data['address'] = $data['signup_info']['contact_address_1'];
                        $data['postcode'] = $data['signup_info']['contact_post_code'];

                        $data['elec_supply_end_date'] = date('d-m-Y', strtotime("+30 days"));
                        $data['gas_supply_end_date'] = date('d-m-Y', strtotime("+30 days"));
                        $data['elec_tariff_comparison_rate'] = '';
                        $data['elec_comparison_rate'] = '';
                        $data['gas_expected_supply_start_date'] = date('d-m-Y', strtotime("+31 days"));
                        $data['elec_expected_supply_start_date'] = date('d-m-Y', strtotime("+31 days"));
                        $data['elec_estimated_annual_cost'] = $year_elec_price;
                        $data['gas_estimated_annual_cost'] = $year_gas_price;
                        $data['gas_unit_rate'] = $gas_ur;
                        $data['elec_unit_rate'] = $electricity_dur;
                        $data['elec_daily_standing_charge'] = $sc;
                        $data['gas_daily_standing_charge'] = $gas_sc;
                        $data['elec_annual_consumption'] = $eac;
                        $data['gas_annual_consumption'] = $aq;
                        $data['NewJuniferAccount'] = ' selected="selected"' ;

                        $data['meter_supply_number_elec'] = $data['signup_info']['mpan'];
                        $data['meter_supply_number_gas'] = $data['signup_info']['mprn'];
                        $data['product_name_gas'] = $data['yearly_tariff_lookup'][0]['productname_gas'];
                        $data['product_name_elec'] = $data['yearly_tariff_lookup'][0]['productname_elec'];
                        $data['meter_serial_number_elec'] = $data['signup_info']['meterid'];
                        $data['meter_serial_number_gas'] = $data['signup_info']['meter_serial_number'];

                        //////////////  END - WEB TO CASE VARIABLES ////////////////

                        //echo '<pre>'.print_r($data,1).'</pre>'; exit;

                        $this->load->view('tarrif_shell',$data);


                    }
                    else {

                        $this->load->view('404');
                    }

                }
                else {
                    // show 404
                    $this->load->view('404');
                }

            }
            else {
                // show 404
                $this->load->view('404');
            }
        }
        else {
            // show 404
            $this->load->view('404');
        }
    } // End index function




    // add the email log to the database
    function insert_email_log($data){
        $this->mysql->insert('email_log',$data);
        return $this->mysql->insert_id();
    }

    function all_email_templates() {
        $this->load->view('layout/all_email_templates');
    }

    function activation_email($customer_info_id, $token, $forename, $recipient_email) {

        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename ];
        $email_data['email_header_img'] = 'thumb_header.jpg';
        $email_data['content'] = 'layout/activation_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Signup Confirmation');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 1;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

    }

    function reset_password($customer_info_id, $token, $forename, $recipient_email) {

        $customer_number = $customer_info_id;

        $email_data['email_info'] = [ 'token' => $token, 'name' => $forename, 'customer_number' => $customer_number ];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/reset_password_email_content';

        $template = $this->load->view('layout/email_template', $email_data , true);

        $this->load->library('email');
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->subject('Reset password');
        $this->email->message($template);
        $this->email->send();

        // Log email
        $email_log_db_parameter['customer_id'] = $customer_info_id;
        $email_log_db_parameter['email_type_id'] = 18;

        // Do the insert
        $this->insert_email_log($email_log_db_parameter);

    }

    function update_outcome_type($account_number, $outcome_type_id){
        $sql = "UPDATE tariff_change_notification SET outcome_type_id=? WHERE account_number=?";
        $this->mysql->query($sql, array($outcome_type_id, $account_number));
    }

    public static function logMessage(String $errLevel, $msg, $depth=1)
    {
        $btStack = debug_backtrace($depth);
        $callerFrame = $btStack[$depth-1];

        $sid = substr(session_id(),0,8);
        $method = $callerFrame['class'].'.'.$callerFrame['function'];
        $lineNo = $callerFrame['line'];
        $fullMessage = 'SID:'.$sid.' '.$method.'('.$lineNo.'): '.$msg;

        log_message($errLevel, $fullMessage);
    }

    function parseHttpResponse($response)
    {
        // Parse the headers
        $headers = array();

        $body = null;

        // Split up the httpResponse
        $responseParts = explode("\r\n\r\n", $response);
        foreach ($responseParts as $i => $responsePart) {
            $lines = explode("\r\n", $responsePart);

            // If the part has 200 response Code, parse the rest of the lines as headers.
            //if($lines[0] == "HTTP/1.1 " )
            if (strpos($lines[0], 'HTTP/1.1') !== false) {
                if (preg_match('/^HTTP\/1.1 [4,5]/', $lines[0])) {
                    // 4xx or 5xx error
                    // so log the error
                    $this->logMessage('error', 'Line 0=' . $lines[0], 2);
                }

                foreach ($lines as $j => $line) {
                    if ($j === 0) {
                        $headers['http_code'] = $line;
                    } else {
                        list ($key, $value) = explode(': ', $line);

                        $headers[$key] = $value;
                    }
                }
            } // If last element, probably body
            else if ($i === sizeof($responseParts) - 1) {
                $body = json_decode($responsePart, true);
            }
        }

        return array(
            'headers' => $headers,
            'body' => $body
        );
    }

    public function junifer_enrol() {

        // Setup some initial vars


        $signup_info = $this->session->userdata('tarrif_change');
        $electricity_dur = $this->session->userdata('electricity_dur');
        $year_price = $this->session->userdata('year_price');
        $directdebit = 'directdebit';
        $TariffCode = 'WH-VAR' ;
        $explode = explode(' ', $signup_info['contact_post_code']);


        $email_check = $this->user_modal->email_check( $signup_info['email']);

        //echo '<pre>'.print_r($email_check,1).'</pre>';

        // Do we already have the customer in the database?
        if ($email_check['account_id']>0) {
            $first_account = $email_check['account_id'];
            $insert_customer_info =  $email_check['id'];
        }


        // Make the name vars
        $names = explode(' ',  $signup_info['customer_name'], 3);
        $title = $names[0];
        $first_name = $names[1];
        $last_name = $names[2];

        $signup_type = '0';
        $billingMethod = 'Both';

        $elec_reference = 'elec_' . rand(0, 9999);
        $gas_reference = 'gas_' . rand(0, 9999);

        $dob = date('Y-m-d', strtotime($this->input->post('customer_dob')));


        $parameter = [
            'senderReference' => 'Eversmart',
            //'reference' => 'Big Dans Bonanza',
            'reference' => 'Eversmart',
            'billingEntityCode' => 'Eversmart',
            'marketingOptOutFl' => false,
            'submittedSource' => 'Tele',
            'changeOfTenancyFl' => false,
            'contacts' => [
                [
                    'title' =>  ucfirst($title) ,
                    'forename' =>  ucfirst($first_name),
                    'surname' =>  ucfirst($last_name),
                    'email' =>   $signup_info['email'],
                    'phone1' =>  $signup_info['telephone'],
                    'phone2' =>  $signup_info['telephone'],
                    'dateOfBirth' => $dob,
                    'billingMethod' => $billingMethod,
                    'primaryContact' => true,
                    'address' => [
                        'careOf' => $signup_info['customer_name'],
                        // 'address1' => $this->input->post('customer_address'),
                        'address1' =>  $signup_info['contact_address_1'],
                        //'address2' =>  $signup_info['contact_address_1'],
                        'town' =>  $signup_info['contact_address_2'],
                        'county' =>  $signup_info['contact_address_3'],
                        'postcode' =>  $signup_info['contact_post_code'],
                        'countryCode' => 'GB'
                    ],
                ]
            ],
            'supplyAddress' => [
                'careOf' =>  $signup_info['customer_name'],
                'address1' =>  $signup_info['contact_address_1'],
                //'address2' =>  $signup_info['contact_address_2'],
                'town' =>  $signup_info['contact_address_2'],
                'county' =>  $signup_info['contact_address_3'],
                'postcode' =>  $signup_info['contact_post_code'],
                'countryCode' => 'GB'
            ],

        ];


        // Electricity
        if ( ($signup_info['elec_status'] == 'Registered') && ($signup_info['gas_status'] != 'Registered')) {
            $parameter['electricityProduct']['reference'] = $elec_reference;
            $parameter['electricityProduct']['previousSupplier'] =  $signup_info['electricity_tariff_name'];
            $parameter['electricityProduct']['previousTariff'] =  $signup_info['current_elec_tariff_lookup'];
            $parameter['electricityProduct']['productCode'] = $TariffCode . '-Elec';
            $parameter['electricityProduct']['mpans'] = array(['mpanCore' =>  $signup_info['mpan']]);
        }

        // Gas
        if ( ($signup_info['elec_status'] != 'Registered') && ($signup_info['gas_status'] == 'Registered')) {
            $parameter['gasProduct']['reference'] = $gas_reference;
            $parameter['gasProduct']['productCode'] = $TariffCode . '-Gas';
            $parameter['gasProduct']['mprns'] = array(['mprn' =>  $signup_info['mprn']]);
        }

        // Dual
        if ( ($signup_info['elec_status'] == 'Registered') && ($signup_info['gas_status'] == 'Registered')) {
            $parameter['gasProduct']['reference'] = $gas_reference;
            $parameter['gasProduct']['productCode'] = $TariffCode . '-Gas';
            $parameter['gasProduct']['mprns'] = array(['mprn' => $signup_info['mprn']]);
            $parameter['electricityProduct']['reference'] = $elec_reference;
            $parameter['electricityProduct']['previousSupplier'] = $signup_info['electricity_tariff_name'];
            $parameter['electricityProduct']['previousTariff'] = $signup_info['current_elec_tariff_lookup'];
            $parameter['electricityProduct']['productCode'] = $TariffCode . '-Elec';
            $parameter['electricityProduct']['mpans'] = array(['mpanCore' => $signup_info['mpan']]);
        }


        // Sign up customer
        if ( $directdebit == 'directdebit'){


            $tariff_detail['exitFeeElec'] = '0';

            $dplo = NULL;

            if ($dplo == NULL) {
                $dplo = 'Area';
            }

            // Do we already have the person set up and in junifer? If not, add them!
            if (!isset($first_account)) {

                // Enrol customer
                $response = $this->curl->junifer_request('/rest/v1/customers/enrolCustomer', $parameter, 'post');
                $loginResponse = $this->parseHttpResponse($response);


                if ($loginResponse['headers']['http_code'] == 'HTTP/1.1 200 OK' || $loginResponse['headers']['http_code'] == 'HTTP/1.1 200 ok' || $loginResponse['headers']['http_code'] == 'HTTP/1.1 200 Ok') {

                    //insert data in database

                    if (empty($tariff_detail['exitFeeElec'])) {
                        $tariff_detail['exitFeeElec'] = '0';
                    }

                    $dplo = $this->input->post('quotation_dplo_address');

                    if ($dplo == NULL) {
                        $dplo = 'Area';
                    }

                    $db_parameter = [
                        'customer_id' => $loginResponse['body']['customerId'],
                        'title' => ucfirst($title) ,
                        'forename' => ucfirst($first_name),
                        'surname' =>  ucfirst($last_name),
                        'billingMethod' => $directdebit,
                        'email' =>  $signup_info['email'],
                        //'password' => base64_encode($this->input->post('customer_confirm_password')),
                        'phone1' =>  $signup_info['telephone'],
                        'phone2' =>  $signup_info['telephone'],
                        'dateOfBirth' => $dob,
                        'address_careOf' => $signup_info['customer_name'],

                        //'address_address1' => $this->input->post('customer_address'),

                        'first_line_address' =>  $signup_info['contact_address_1'],

                        'dplo_address' => $dplo,
                        'town_address' =>  $signup_info['contact_address_2'],
                        'city_address' =>  $signup_info['contact_address_3'],

                        'address_postcode' => urlencode($signup_info['contact_post_code']),
                        'address_countryCode' => 'GB',

                        'supplyAddress_careOf' => $signup_info['customer_name'],
                        'supplyAddress_address1' =>  $signup_info['contact_address_1'],
                        //'supplyAddress_address2' =>  $this->input->post('quotation_dplo_address'),
                        'supplyAddress_town_address' =>  $signup_info['contact_address_2'],
                        'supplyAddress_city_address' => $signup_info['contact_address_3'],
                        'supplyAddress_postcode' => urlencode($signup_info['contact_post_code']),
                        'supplyAddress_countryCode' => 'GB',


                        //'bankAccountSortCode' => $this->input->post('sort_code'),
                        //'bankAccountNumber' => $this->input->post('account_number'),
                        //'bankAccountName' => $this->input->post('account_name'),

                        // "electricityProduct_previousSupplier"=> $session_detail['quotation_supplier'],
                        // "electricityProduct_previousTariff"=> $session_detail['existingTariffNameElec'],
                        // "electricityProduct_productCode"=>"Big Dans Bonanza",
                        // "electricityProduct_mpans"  => $session_detail['quotation_mpan'],



                        // "gasProduct_reference" =>  $gas_reference,
                        // "gasProduct_productCode"=>"BDBG",
                        // "gasProduct_mprns" => $session_detail['quotation_mprn'] ,


                        "signup_type" => '0',

                        //'plan_price' => $this->input->post('plan_price'),
                        //'original_price' => $this->input->post('original_price'),
                        //'complete_price' => $this->input->post('complete_price'),
                        //'plan_id' => $this->input->post('plan_id'),
                        'tariff_newspend' => $year_price ,

                        'tariff_tariffName' => 'LOYAL FAMILY SAVER',
                        'tariff_unitRate1Elec' => $electricity_dur ,
                        'exitFeeElec' => $tariff_detail['exitFeeElec'],
                        'elec_mpan_core' => $signup_info['mpan']
                    ];

                    if ( ($signup_info['elec_status'] == 'Registered') && ($signup_info['gas_status'] != 'Registered')) {
                        // $db_parameter['electricityProduct_previousSupplier'] = $elec_reference;
                        $db_parameter['electricityProduct_previousSupplier'] =  $signup_info['electricity_tariff_name'];
                        $db_parameter['electricityProduct_previousTariff'] = $signup_info['current_elec_tariff_lookup'];
                        $db_parameter['electricityProduct_productCode'] = $TariffCode . '-Elec';
                        $db_parameter['electricityProduct_mpans'] = $signup_info['mpan'];
                    }

                    if ( ($signup_info['elec_status'] != 'Registered') && ($signup_info['gas_status'] == 'Registered')) {
                        $db_parameter['gasProduct_reference'] = $gas_reference;
                        $db_parameter['gasProduct_productCode'] = $TariffCode . '-Gas';
                        $db_parameter['gasProduct_mprns'] = $signup_info['quotation_mprn'];
                    }

                    if ( ($signup_info['elec_status'] == 'Registered') && ($signup_info['gas_status'] == 'Registered')) {
                        $db_parameter['electricityProduct_previousSupplier'] = $signup_info['electricity_tariff_name'];
                        $db_parameter['electricityProduct_previousTariff'] =  $signup_info['current_elec_tariff_lookup'];
                        $db_parameter['electricityProduct_productCode'] = $TariffCode . '-Elec';
                        $db_parameter['electricityProduct_mpans'] = $signup_info['mpan'];
                        $db_parameter['gasProduct_reference'] = $gas_reference;
                        $db_parameter['gasProduct_productCode'] = $TariffCode . '-Gas';
                        $db_parameter['gasProduct_mprns'] = $signup_info['mprn'];
                    }


                    $db_parameter['saasref'] = '0';

                    $insert_customer_info = $this->user_modal->insert_customer_info($db_parameter);

                }
                else {

                    // Update call list
                    $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                    $this->error_modal->log('signup error', $loginResponse['body']['errorDescription']);
                    header('content-type:application/json');
                    echo json_encode(['error' => '1', 'token' => null, 'msg' => $loginResponse['body']['errorDescription']]);
                    exit;

                }


                $parameter_account = ['email' => $this->input->post('email')];
                $get_account_id = $this->curl->junifer_request('/rest/v1/accounts/?email=' . $this->input->post('email'));
                $get_account = $this->parseHttpResponse($get_account_id);


                if ($get_account['headers']['http_code'] == 'HTTP/1.1 200 OK' || $get_account['headers']['http_code'] == 'HTTP/1.1 200 ok' || $get_account['headers']['http_code'] == 'HTTP/1.1 200 Ok') {

                    $first_account = '';

                    for ($var = 0; $var < count($get_account['body']); $var++) {
                        if ($var == '0') {
                            //echo $get_account['body']['results'][$var]['id'];
                            $first_account = $get_account['body']['results'][$var]['id'];
                            $data = [
                                "username" =>  $signup_info['email'],
                                "password" =>  'pass' . rand(0, 9999),
                                "customers" => [
                                    ["id" => $loginResponse['body']['customerId']]
                                ],
                                "expiryDttm" => date('Y-m-d', strtotime('+1 year')) . 'T20:00:00.0000'
                            ];
                        }
                    }
                    $this->user_modal->update_account_id($insert_customer_info, $first_account);

                }
                else {

                    // Update call list
                    $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                    $this->error_modal->log('customer id created but account id creating issue', $get_account['body']['errorDescription']);
                    header('content-type:application/json');
                    echo json_encode(['error' => '1', 'token' => null, 'msg' => $get_account['body']['errorDescription']]);
                    exit;
                }


                // register web user
                $request_for_register_user = $this->curl->junifer_request('/rest/v1/webUsers/', $data, 'post');
                $request_for_register_user = $this->parseHttpResponse($request_for_register_user);

                if ($request_for_register_user['headers']['http_code'] == 'HTTP/1.1 200 OK' || $request_for_register_user['headers']['http_code'] == 'HTTP/1.1 200 ok' || $request_for_register_user['headers']['http_code'] == 'HTTP/1.1 200 Ok' || $request_for_register_user['headers']['http_code'] == 'HTTP/1.1 201 Created') {

                    $this->activation_email($insert_customer_info, $request_for_register_user['body']['token'], $first_name, $this->input->post('email'));
                    $this->user_modal->token_in_database($request_for_register_user['body']['token'], $insert_customer_info);

                    $token = md5(uniqid(rand(0,9999), true));
                    $this->reset_password($insert_customer_info, $token, $first_name, $this->input->post('email'));
                    $this->user_modal->token_in_database($token, $insert_customer_info, '1');

                    $random = rand(0, 99);
                    $random = ($random <= 9 ? "0" . $random : $random);

                    $para = [
                        "id" => $insert_customer_info,
                        "accountId" => $insert_customer_info,
                        "firstName" => $first_name,
                        "email" =>  $signup_info['email'],
                        "referable" => "true",
                        "referralCode" => $first_name . $last_name . $random,    // forename . surname . random number between 00 and 99
                        "locale" => "en_UK"
                    ];

                    $creating_ref_user = $this->curl->curlSaas('open/account/' . $insert_customer_info . '/user/' . $insert_customer_info . '', $para, 'post');

                    ///saasquatch

                }
                else {

                    // Update call list
                    $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                    $this->error_modal->log('register webuser fail', $request_for_register_user['body']['errorDescription']);
                    header('content-type:application/json');
                    echo json_encode(['error' => '1', 'token' => null, 'msg' => $request_for_register_user['body']['errorDescription']]);
                    exit;
                }


            } // End

        } // End if direct debit




        // OK, we have either just added the customer to Junifer, or they have been added previously
        // so try and take the payment now
        if($first_account>0) {


            $stripe_amount = $this->input->post('amount') * 100;  // A positive integer in the smallest currency unit (e.g., 100 pence to charge £1.00)
            $amount = $this->input->post('amount');
            $account_id = $insert_customer_info;
            $token = $this->input->post('token');
            $junifer_account_id = $first_account;
            $email = $this->input->post('email');
            $billing_address_id = $this->input->post('billing_address_id');
            //$line1 = $this->input->post('existing_line1');
            //$postcode = preg_replace('/\s+/', '', $this->input->post('existing_postcode'));
            $currency = 'gbp';

            // Have we been passed an existing billing address?
            if($billing_address_id > 0 ) {

                $ExistingBillingAddress = $this->mysql->select('*')->from('billing_address')->where('billing_address_id', $billing_address_id)->get()->result_array();
                //$line1 = $ExistingBillingAddress['address_line_1'];
                //$postcode = preg_replace('/\s+/', '', $ExistingBillingAddress['postcode']);

            }
            // Have we been passed a new billing address?
            else if(
                $this->input->post('ba_line1') !='' && $this->input->post('ba_line2') !='' &&
                $this->input->post('ba_postcode') !='' && $this->input->post('customer_id') !=''
            ) {

                // Set the db parameters in an array
                $ba_db_parameter['address_line_1'] = $this->input->post('ba_line1');
                $ba_db_parameter['address_line_2'] = $this->input->post('ba_line2');
                if($this->input->post('ba_line3') != '') { $ba_db_parameter['address_line_3'] = $this->input->post('ba_line3'); }
                if($this->input->post('ba_line4') != '') { $ba_db_parameter['address_line_4'] = $this->input->post('ba_line4'); }
                $ba_db_parameter['postcode'] = $this->input->post('ba_postcode');

                // Do the insert
                $BillingAddressID = $this->insert_billing_address($ba_db_parameter);

                // Now tie the new address to the customer
                $cba_db_parameter['customer_id'] = $this->input->post('customer_id');
                $cba_db_parameter['billing_address_id'] = $BillingAddressID;
                $CustomerBillingAddressID = $this->insert_customer_billing_address($cba_db_parameter);

                // Overwrite the variables with the new billing address details
                //$line1 = $this->input->post('ba_line1');
                //$postcode = preg_replace('/\s+/', '', $this->input->post('ba_postcode'));

            }


            if(!isset($amount) || $amount=='' ) {
                //$this->jres->failure('amount required');

                // Update call list
                $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                header('content-type:application/json');
                echo json_encode(['api_status'=>'0','junifer_id'=>$junifer_account_id,'status_message'=>'amount required']); exit;
            }elseif(!isset($account_id) || $account_id=='' ) {
                //$this->jres->failure('account_id required');

                // Update call list
                $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                header('content-type:application/json');
                echo json_encode(['api_status'=>'0','junifer_id'=>$junifer_account_id,'status_message'=>'account_id required']); exit;
            }else{

                $stripe = array(
                    "secret_key"      => $this->config->item('stripe')['sk_test'],
                    "publishable_key" => $this->config->item('stripe')['pk_test']
                );

                try{

                    \Stripe\Stripe::setApiKey($stripe['secret_key']);

                    // Does the customer already exist?
                    $customer = \Stripe\Customer::all(array("email" => $email, "limit" => 1));

                    if(empty($customer['data'])){ // If the customer doesn't exist, create them

                        $customer = \Stripe\Customer::create(array(
                                'email' => $email,
                                'source'  => $token)
                        );

                        // And catch the id to create the charge
                        $stripe_customer_id = $customer['id'];
                        $stripe_customer_token = $customer['default_source'];

                    } else {

                        // Get customer id
                        $stripe_customer_id = $customer['data'][0]['id'];
                        $stripe_customer_token = $customer['data'][0]['default_source'];
                    }


                    $charge = \Stripe\Charge::create(array(
                        'customer'   => $stripe_customer_id,
                        'amount' => $stripe_amount,
                        'source' =>$stripe_customer_token,
                        'currency' => $currency,
                    ));




                    if($charge['status'] == 'succeeded' && isset($stripe_customer_id)){

                        //var_dump($charge);

                        //$response['transaction_id'] = $charge['id'];
                        //$response['account_id'] = $account_id;
                        //$response['amount'] = $amount;

                        $response  = [
                            'transaction_id' => $charge['id'],
                            'amount' => $amount,
                            'account_id' => $account_id,
                            'junifer_id' => $junifer_account_id
                        ];

                        $row = [
                            'transaction_id' => $charge['id'],
                            'amount' => $amount,
                            'currency' => $currency,
                            'status' => $charge['status'],
                            'account_id' => $account_id
                        ];

                        $post = [
                            "grossAmount" => $amount,
                            "salesTaxName" => "Standard VAT",
                            "accountCreditReasonName" => "Stripe Payment"
                        ];


                        $junifer_credit = $this->curl->junifer_request('/rest/v1/accounts/'.$first_account.'/accountCredits', $post, 'post');

                        $get_head = $this->parseHttpResponse($junifer_credit);

                        //print_r($amount);
                        //print_r($post);
                        //print_r($first_account);

                        $this->api_modal->save_transaction($row);


                        if( $get_head['headers']['http_code'] == 'HTTP/1.1 204 No Content')
                        {
                            // Update call list
                            $this->update_outcome_type($signup_info['account_number'], '1'); // signed up

                            $this->jres->success_stripe($response,$charge['status']);
                        }
                        else
                        {

                            // Update call list
                            $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                            //$this->jres->failure('Error while payment in stripe');
                            header('content-type:application/json');
                            echo json_encode(['api_status'=>'0','junifer_id'=>$junifer_account_id,'status_message'=>'Error while payment in stripe']); exit;
                        }

                    }

                }
                catch( Stripe_Error $e )
                {

                    // Update call list
                    $this->update_outcome_type($signup_info['account_number'], '3'); // failed

                    //$this->jres->failure($e->getMessage());
                    header('content-type:application/json');
                    echo json_encode(['api_status'=>'0','junifer_id'=>$junifer_account_id,'status_message'=>$e->getMessage()]); exit;
                }
            }

        }



    } // End junifer_enrol
}