package com.orbisalert;

import android.content.Intent;
import android.support.multidex.MultiDexApplication;

import com.mapbox.mapboxsdk.Mapbox;
import com.orbisalert.net.OnClearFromRecentService;
import com.orbisalert.notifications.WakeLocker;

import static com.mapbox.mapboxsdk.Mapbox.getApplicationContext;

/**
 * Created by nancy on 14/8/17.
 */

public class OrbisRedAlert extends MultiDexApplication {
    private int lastInteractionTime;
    private Boolean isScreenOff = false;
    public final static int INTERVAL = 40000;
    boolean isInForeGrnd;

    public void onCreate() {
        super.onCreate();
        // Mapbox Access token
        Mapbox.getInstance(getApplicationContext(), "pk.eyJ1IjoibmVlcnV0aGFrdXIiLCJhIjoiY2o2ZXpjMWNiMjY1NTJ6bHM1eDVpZXFqYyJ9.BtNVOQJ0iQ-W5jjMe-W68Q");

        startUserInactivityDetectThread();



    }

    public void startUserInactivityDetectThread() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000); // checks every 15sec for inactivity

                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    if (isScreenOff || getLastInteractionTime() > INTERVAL || !isInForeGrnd) {

                       // showNotification();
                        WakeLocker.acquire(getApplicationContext());
                        // do something
                        WakeLocker.release();
                    }
                }
            }
        }).start();
    }

    public long getLastInteractionTime() {
        return lastInteractionTime;
    }



    public long setLastInteractionTime(int lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
        return lastInteractionTime;
    }



}

