package com.orbisalert.BluetoothDevices;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;

import com.orbisalert.Activity.GlobalConstants;
import com.orbisalert.Activity.RedAlertActivate;


/**
 * Created by Admin on 25-09-2017.
 */

public class BluetoothBroadcast extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
        if (intent.getAction().contains("BluetoothDetected")) {
            checkAndCreateAlert(context);
            Log.e("@@@@@@@@@@@", "@@@@@@@@@@@");
        }
    }

    private void checkAndCreateAlert(Context context) {
        //triggerCounter=triggerCounter+1;
        //new logic
        SharedPreferences preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editorr = preferences.edit();
        editorr.putString("redalert", "2");
        editorr.putString("Triggerfrom", "Bluetooth");
        editorr.commit();
        Intent intent = new Intent(context, RedAlertActivate.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("BluetoothDetected", true);
        context.startActivity(intent);
    }
}