package com.orbisalert.Activity;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;

import com.orbisalert.R;
import com.orbisalert.Util.CounterClass;
import com.orbisalert.Util.MyService;
import com.orbisalert.Util.NoMovementService;
import com.orbisalert.Util.SOSService;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.FallHandler;
import com.orbisalert.net.PwonSignal;
import com.orbisalert.net.Test;
import com.orbisalert.net.TriggerSignal;
import com.orbisalert.net.UpdateLocationIntentService;
import com.orbisalert.notifications.FallDetectCounter;

import java.util.jar.Attributes;


public class SettingScreen extends OrbisActivity implements View.OnClickListener {

    TextView et_name, et_address, et_email, et_contactno,tv_device_pair;
    TextView tv_terms, tv_privacy, tv_logout, tv_version, tv_esclation;
    ImageView iv_back_setting;
    private String fullname = "", emailadd = "", pronumber = "", address = "";
    CounterClass counterClass;
    FallDetectCounter fallCounter;
    private String timerrunning = "", falltimerRunning = "";
    Button btn_SOS;
    public static String SOSDetected = "";
    private int flag = 0;
    String SOSDetect="",cityName="",UserName="",email="",useremail;
    Spinner  sp_press_status;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_setting_screen);
        this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
        Utility.status_bar_color_change(this);

        address = preferences.getString("address", "");
        email = preferences.getString("email", "");
        useremail=preferences.getString("useremail","");
        emailadd = preferences.getString("emailaddress", "");
        pronumber = preferences.getString("number", "");
        cityName = preferences.getString("City", "");
        UserName = preferences.getString("Name", "");
        SOSDetect = preferences.getString("SOSDetected", "");
        timerrunning = preferences.getString("timerrunning", "");
        falltimerRunning = preferences.getString("falltimerrunning", "");

        intialize_ID();



        if (SOSDetect.equalsIgnoreCase("1")) {
            flag = 1;
            btn_SOS.setBackgroundResource(R.drawable.trigger_on);
            Intent intentss = new Intent(SettingScreen.this, SOSService.class);
            startService(intentss);
            Log.e("@@@@@@","Start Service");

        }
        else if (SOSDetect.equalsIgnoreCase("0")) {
            flag = 0;
            btn_SOS.setBackgroundResource(R.drawable.trigger_off);
            Intent intent2 = new Intent(SettingScreen.this, SOSService.class);
            stopService(intent2);
            Log.e("@@@@@@","Stop Service");

        }
        else {
            flag = 1;
            btn_SOS.setBackgroundResource(R.drawable.trigger_on);
            Intent intentss = new Intent(SettingScreen.this, SOSService.class);
            startService(intentss);
            SOSDetected = "Activated";
            SharedPreferences.Editor editorr = preferences.edit();
            editorr.putString("SOSDetection", "Activated");
            editorr.putString("SOSDetected", "1");
            editorr.commit();
            Log.e("@@@@@@","Start Service");
        }





    }

    private void intialize_ID() {
        sp_press_status = (Spinner) findViewById(R.id.sp_press_status);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
                R.array.array_press_status, R.layout.spinner_item_fall);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        sp_press_status.setAdapter(adapter);

        sp_press_status.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {

                Log.e("SELECTED", String.valueOf(position));

                int selectedPosition = sp_press_status.getSelectedItemPosition();
                SharedPreferences.Editor editor = preferences.edit();
                editor.putInt("spinnerSelection1", position);
                Log.e("====POSTION", String.valueOf(position));
                editor.putString("pressdetectedlevel", String.valueOf(position));
                editor.commit();

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });


       sp_press_status.setSelection(preferences.getInt("spinnerSelection1", 1));
        et_name = (TextView) findViewById(R.id.et_name);
        et_address = (TextView) findViewById(R.id.et_address);
        et_email = (TextView) findViewById(R.id.et_email);
        et_contactno = (TextView) findViewById(R.id.et_contactno);
        btn_SOS=(Button)findViewById(R.id.btn_SOS);

       // btn_SOS.setBackgroundResource(R.drawable.trigger_on);
        //Intent intentss = new Intent(SettingScreen.this, SOSService.class);
       // startService(intentss);
        //flag=0;



        btn_SOS.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // if (fallDetect.equalsIgnoreCase("0"))
                if (flag == 1) {
                    Log.e("%%%%%%%%", "SOS ");
                    flag = 0;
                    btn_SOS.setBackgroundResource(R.drawable.trigger_off);
                    SOSDetected = "Deactivated";
                    SharedPreferences.Editor editorr = preferences.edit();
                    editorr.putString("SOSDetection", "Deactivated");
                    editorr.putString("SOSDetected", "0");
                    editorr.commit();
                    Intent intentss = new Intent(SettingScreen.this, SOSService.class);
                    stopService(intentss);

                } else {

                    Log.e("%%%%%%%%%", "SOS");
                    flag = 1;
                    btn_SOS.setBackgroundResource(R.drawable.trigger_on);

                    SOSDetected = "Activated";
                    SharedPreferences.Editor editorr = preferences.edit();
                    editorr.putString("SOSDetection", "Activated");
                    editorr.putString("SOSDetected", "1");
                    editorr.commit();


                   String  receivedstate = preferences.getString("receivedstate", "");

                    if(receivedstate.equalsIgnoreCase("1")){
                        Log.e("IF CONDITION ","Recieved Status******");
                    }
                    else{
                        Intent intent = new Intent(SettingScreen.this, SOSService.class);
                        startService(intent);
                    }

                }
            }
        });


        try {

            et_name.setText(UserName);
            et_address.setText(address);
            et_email.setText(useremail);
            et_contactno.setText(pronumber);
        } catch (Exception e) {
            e.printStackTrace();
        }
        tv_terms = (TextView) findViewById(R.id.tv_terms);
        tv_privacy = (TextView) findViewById(R.id.tv_privacy);
        tv_logout = (TextView) findViewById(R.id.tv_logout);
        tv_esclation = (TextView) findViewById(R.id.tv_esclation);
        tv_device_pair=(TextView)findViewById(R.id.tv_device_pair);
        tv_esclation.setOnClickListener(this);
        tv_logout.setOnClickListener(this);
        tv_device_pair.setOnClickListener(this);

        iv_back_setting = (ImageView) findViewById(R.id.iv_back_setting);
        tv_version = (TextView) findViewById(R.id.tv_version);

        //get gradle version name
        try {
            String versionName = getPackageManager().getPackageInfo(SettingScreen.this.getPackageName(), 0).versionName;
            Log.e("versionName", versionName);
            //tv_version.setText("Version: v" + versionName);
           tv_version.setText("Version: v" + "4.2.2");
            //v4.1
        } catch (Exception e) {
            e.printStackTrace();
        }

        iv_back_setting.setOnClickListener(this);
        tv_terms.setOnClickListener(this);
        tv_privacy.setOnClickListener(this);

        iv_back_setting = (ImageView) findViewById(R.id.iv_back_setting);
        iv_back_setting.setOnClickListener(this);
        tv_terms.setOnClickListener(this);
        tv_privacy.setOnClickListener(this);
        if (UserName != null) {
            et_name.setText(UserName);
        }

        if (address != null) {
            et_address.setText(address);
        }
        if (useremail != null) {
            et_email.setText(useremail);
        }

        if (pronumber != null) {
            et_contactno.setText(pronumber);
        }


        // iv_esclation_next.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {

            case R.id.iv_back_setting:
                Intent intent = new Intent(SettingScreen.this, TabHostActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();

                break;
            case R.id.tv_logout:
                String ref = "ref";
                if (isNetworkAvailable()) {
                    logout(ref);
                } else {
                    showBuilder(SettingScreen.this, "Network Error", "Please Connect to the Internet");
                }
                break;
            case R.id.tv_esclation:
                Intent intent1 = new Intent(SettingScreen.this, EscalationScreen.class);
                intent1.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent1);
                finish();
                break;
            case R.id.tv_device_pair:
                Intent intentd = new Intent(SettingScreen.this, DeviceListActivity.class);
                intentd.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intentd);
                finish();
                break;
            case R.id.tv_terms:
                String url = "http://redalert.orbisprotect.com/android/hs2/terms/";
                Intent i = new Intent(Intent.ACTION_VIEW);
                i.setData(Uri.parse(url));
                startActivity(i);
                break;

            case R.id.tv_privacy:
               String privacyurl = "http://redalert.orbisprotect.com/android/hs2/privacy/";
                Intent ii = new Intent(Intent.ACTION_VIEW);
                ii.setData(Uri.parse(privacyurl));
                startActivity(ii);
                break;


            default:
        }
    }

    private void logout(String ref) {
        try {
            SharedPreferences.Editor editor3 = preferences.edit();
            editor3.putString("Triggerfrom", "PWOFF");
            editor3.commit();

            TriggerSignal.sendTriggerSignal(SettingScreen.this, "", "");

            if (timerrunning.equalsIgnoreCase("1")) {

                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("timerrunning", "0");
                editor.commit();
                Test.clearInstance();
                // counterClass = CounterClass.logoutinitInstance(0,0);
                counterClass = CounterClass.getInstance();
                counterClass.setFormatedTime();
                counterClass.clear();
                counterClass.cancel();
                counterClass = null;

            } else {
                Log.e("This is timer not running", "====");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (falltimerRunning.equalsIgnoreCase("1")) {

            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("falltimerrunning", "0");
            editor.commit();
            Test.clearInstance();
            // counterClass = CounterClass.logoutinitInstance(0,0);
            try {

                FallHandler.clearInstance();
                fallCounter = FallDetectCounter.getInstance();
                fallCounter.setFallFormatedTime();
                fallCounter.clear();
                fallCounter.cancel();
                fallCounter = null;
            } catch (Exception e) {
                e.printStackTrace();
            }


        } else {
            Log.e("This is timer not running", "====");
        }


        SharedPreferences.Editor editor = preferences.edit();
        editor.remove("STATUS");
        editor.remove("selectedminute");
        editor.remove("selectedsecond");
        editor.remove("FallDetection");
        editor.remove("fallDetected");
        editor.remove("MoveDetection");
        editor.remove("moveChecked");
        editor.remove("selectedHours");
        editor.remove("selectedMinutes");
        editor.apply();

        preferences.getBoolean("dashfirstRun", false);

        editor.commit();
        PwonSignal.sendPWONSignal(getApplicationContext(), "PWOFF");

        //Stop SOS SERVICE
        Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
        stopService(intent_service);

        // STop fall detect
        Intent intentss = new Intent(getApplicationContext(), MyService.class);
        stopService(intentss);

        // Stop getting device movement
        Intent mmoveintent = new Intent(getApplicationContext(), NoMovementService.class);
        stopService(mmoveintent);


         /*delete cache*/
        deleteCache(SettingScreen.this);


        try {

            AlarmManager alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
            Intent alarm = new Intent(SettingScreen.this, UpdateLocationIntentService.class);
            PendingIntent pendingIntent = PendingIntent.getService(SettingScreen.this, 0, alarm, 0);
            alarmManager.cancel(pendingIntent);
            Log.e("==========", "STop Alarm");
        } catch (Exception e) {
            e.printStackTrace();
        }
        Intent intent = new Intent(SettingScreen.this, LoginScreen.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        finish();

    }
}