package com.orbis.Activity;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.orbis.Model.SignalBeans;
import com.orbis.R;
import com.orbis.Util.Utility;
import com.orbis.net.GPSTracker;
import com.orbis.net.TriggerSignal;
import com.orbis.net.WebRequest;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class MessageScreen extends OrbisActivity implements View.OnClickListener, View.OnTouchListener {
    TextView tv_message, tv_Title;
    ImageView iv_send_message, iv_back;
    EditText et_message1;
    Spinner sp_status;
    RelativeLayout rl;
    WebRequest mWebrequest;
    Call<SignalBeans> signal_ResponseCall;
    SignalBeans signal_otpresponse;
    private String datetime, imei, number, messageType, currentLat, currentLong, posdatatime, postype, status, interval, speed;
    private String date, time;
    TelephonyManager tManager;
    private String phoneNumber = "07786200129";
    private String checksum = "";
    String fcmstatus = "", fcmmessage = "";
    GPSTracker gps;
    String dremove_comma_message="";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_message__screen);

        mWebrequest = WebRequest.getSingleton(MessageScreen.this);
        //change status bar color
        Utility.status_bar_color_change(MessageScreen.this);

        date = get_current_date();
        time = get_current_time();
        tManager = (TelephonyManager) getBaseContext()
                .getSystemService(Context.TELEPHONY_SERVICE);
        datetime = date + time;
        imei = tManager.getDeviceId();
        number = preferences.getString("number", "");

        posdatatime = preferences.getString("posdatatime", "");
        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");
        speed =GlobalConstants.SPEED;

        try {
            gps = new GPSTracker(MessageScreen.this);
            currentLat = String.valueOf(gps.getLatitude());
            currentLong = String.valueOf(gps.getLongitude());
            Log.e("MessageLAT", currentLat);
            Log.e("MessageLong", currentLong);
            if (currentLat.equalsIgnoreCase("0.0")) {
                currentLat = preferences.getString("currentLATTITUDE", "");
            } else {
                Log.e("*****", "lat");
            }
            if (currentLong.equalsIgnoreCase("0.0")) {
                currentLong = preferences.getString("currentLONGITUDE", "");
            } else {
                Log.e("*****", "long");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        //find view by id
        intialize_ID();
    }

    private void intialize_ID() {
        rl = (RelativeLayout) findViewById(R.id.rl);
        tv_Title = (TextView) findViewById(R.id.tv_Title);
        Utility.text_font_helvetica(this, tv_Title);
        tv_message = (TextView) findViewById(R.id.tv_message);
        Utility.text_font_helvetica(this, tv_message);
        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
        sp_status = (Spinner) findViewById(R.id.sp_status);
        iv_send_message = (ImageView) findViewById(R.id.iv_send_message);
        iv_send_message.setOnClickListener(this);
        et_message1 = (EditText) findViewById(R.id.et_message1);
        rl.setOnTouchListener(this);

        //set spinner value
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
                R.array.array_current_status, R.layout.spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        sp_status.setAdapter(adapter);

        Log.e("SElected status", String.valueOf(sp_status.getSelectedItem()));


        Log.e("sp_status**", String.valueOf(sp_status.getSelectedItem()));
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_back:
                onBackPressed();
                break;

            case R.id.iv_send_message:
                if (et_message1.getText().toString().equalsIgnoreCase("")) {
                    showToast("Please enter message");
                    et_message1.requestFocus();
                } else {
                    dremove_comma_message=et_message1.getText().toString().replace(",", "");
                    status = String.valueOf(sp_status.getSelectedItem()) + ":" + dremove_comma_message;

                    Log.e("Message  STATUS",status);

                    SharedPreferences.Editor editor = preferences.edit();
                    editor.putString("messageStatus",String.valueOf(sp_status.getSelectedItem()));
                    editor.putString("Triggerfrom", "Message");
                    editor.commit();

                    TriggerSignal.sendTriggerSignal(MessageScreen.this, status, "","");

                    SharedPreferences.Editor editor1 = preferences.edit();
                   // editor1.putString("messageStatus", String.valueOf(sp_status.getSelectedItem()) + ":" + et_message1.getText().toString());
                    editor1.putString("messageStatus", String.valueOf(sp_status.getSelectedItem()));
                    editor1.commit();

                    if (isNetworkAvailable()) {
                        date = get_current_date();
                        time = get_current_time();
                        interval = "";
                        speed =GlobalConstants.SPEED;
                        messageType = "STA";
                        postype = "GPS";
                        /*Remove comma from message...*/
                         dremove_comma_message=et_message1.getText().toString().replace(",", "");
                        Log.e("REPLACE MESSAGE>>>>> ",dremove_comma_message);
                        status = String.valueOf(sp_status.getSelectedItem()) + ":" + dremove_comma_message;


                    /*if (posdatatime==""){
                        posdatatime=date+time;
                    }*/
                        if (fcmstatus.equalsIgnoreCase("0")) {

                        } else {
                            signal_Send(date + time, imei, number, messageType, currentLat, currentLong, date + time, postype, status, interval, speed);
                        }
                        sp_status.setSelection(0);
                        et_message1.setText("");
                    } else {
                        date = get_current_date();
                        time = get_current_time();
                        messageType = "STA";
                        postype = "GPS";
                        interval = "";
                        dremove_comma_message=et_message1.getText().toString().replace(",", "");
                        status = String.valueOf(sp_status.getSelectedItem()) + ":" + dremove_comma_message;
                        String messagechck = "PRT" + "," + date + time + "," + imei + "," + number + "," + messageType + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed;
                        checksum = md5(messagechck);

                        date = get_current_date();
                        time = get_current_time();
                    /*if (posdatatime==""){
                        posdatatime=date+time;
                    }*/
                        String messagesend = "PRT" + "," + date + time + "," + imei + "," + number + "," + "STA" + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;


                        if (fcmstatus.equalsIgnoreCase("0")) {


                        } else {

                            SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                        }
                        sp_status.setSelection(0);
                        showToast("Message sent");
                        et_message1.setText("");
                    }
                }

                break;
            default:
        }
    }

    private void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private void getSignalResponse(final Call<SignalBeans> signalResp) {
        //showProgressDialog(MessageScreen.this, "Message Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                // dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();


                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        String message = response.body().getMessage().toString();
                        showToast("Message sent");
                    } else {
                        Log.e("In condition", "Failed");
                        showToast("Message Sending Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                //  dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.
                INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
        return true;
    }

}
